/*
 * Autogenerated by $Id: IEMAllIntprA64Tables-armv8.h $
 * from the open source v9Ap6-A specs, build 406 (5e0a212688c6bd7aee92394b6f5e491b4d0fee1d)
 * dated Sun Dec 15 22:18:44 2024 UTC.
 *
 * Do not edit!
 */

/*
 * Copyright (C) 2025 Oracle and/or its affiliates.
 *
 * This file is part of VirtualBox base platform packages, as
 * available from https://www.virtualbox.org.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation, in version 3 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <https://www.gnu.org/licenses>.
 *
 * SPDX-License-Identifier: GPL-3.0-only
 */


#ifndef VMM_INCLUDED_SRC_VMMAll_target_armv8_IEMAllIntprA64Tables_armv8_h
#define VMM_INCLUDED_SRC_VMMAll_target_armv8_IEMAllIntprA64Tables_armv8_h
#ifndef RT_WITHOUT_PRAGMA_ONCE
# pragma once
#endif

/** The top-level A64 decoder table for the IEM interpreter. */
extern PFIEMOPU32 const g_apfnIemInterpretOnlyA64[0x1000];

/**
 * Calculates the index for @a uOpcode in g_apfnIemInterpretOnlyA64.
 */
DECL_FORCE_INLINE(uintptr_t) iemInterpretOnlyA64CalcIndex(uint32_t uOpcode)
{
    /* fMask=0x07e0fc00 -> 0x00000fff */
    uintptr_t const idx = ((uOpcode >> 10) & UINT32_C(0x0000003f)) /* bit 10 L 6 -> 0 */
                        | ((uOpcode >> 15) & UINT32_C(0x00000fc0)) /* bit 21 L 6 -> 6 */;
    return idx;
}

#endif /* !VMM_INCLUDED_SRC_VMMAll_target_armv8_IEMAllIntprA64Tables_armv8_h */
