#define XERR "memorybridge"
#include "memorybridge.ih"

// dataUnit: all shared data blocks have the same multiple of dataUnit 
//              byte size

// x kB specifications: x / 4 -> #pages ; # pages / 16 = #pages per
//          segment, minimum 10 pages per segment

// x MB specifications: 256 pages per MB. Prepare for 
//      nSeg = x / 10 segments (rounded up, >= 1), each segment having
//      room for 256 * nSeg pages bytes

// x GB specifications. Prepare for segments having room for about 
//      0.5 GB = 131'072 pages

    //  by memorybuf/memorybuf3.cc, memoryaccess/create.cc
    
MemoryBridge::MemoryBridge(string const &bufSize, bool erase, size_t access)
:   
    d_erase(erase),
    d_offset(0)
{
//xerr("Creating MemoryAccess");
                                                // get the MemoryAccess
    d_accessPtr = MemoryAccess::create(bufSize, access);

    d_access = &MemoryBridge::available;    // requireAccess() now returns a
                                            // reference to the shared memory
}
