% <OKUNO>BNCH2.PL.2,  7-Jul-84 11:36:03, Edit by OKUNO

% [8] **** Clause Indexing ****
/*
The following clauses are part of places database.
   country(moscow,ussr). ===>220 clauses.
*/

:- public country/2.
:- public q81/1, q82/1, q83/1, q84/1, q85/1, q86/1.

/*
To optimize the compiled code, add the next declarations:

:- mode q81(-), q82(-), q83(-), q84(-), q85(-), q86(-).
:- fastcode.
:- compactcode.
*/

country(moscow,ussr).
country(novaya_zemlya,ussr).
country(sverdlovsk,ussr).
country(vladivostok,ussr).
country(gorki,ussr).
country(novosibirsk,ussr).
country(syracuse,usa).
country(new_york_city,usa).
country(ithaca,usa).
country(albany,usa).
country(san_francisco,usa).
country(san_diego,usa).
country(washington,usa).
country(boston,usa).
country(rome_ny,usa).
country(rome,italy).
country(paris,france).
country(london,uk).
country(dublin,ireland).
country(stockholm,sweden).
country(copenhagen,denmark).
country(amsterdam,netherlands).
country(brussels,belgium).
country(madrid,spain).
country(athens,greece).
country(ankara,turkey).
country(istanbul,turkey).
country(tirane,albania).
country(sofia,bulgaria).
country(belgrade,yugoslavia).
country(warsaw,poland).
country(prague,czechoslovakia).
country(lisbon,portugal).
country(tehran,iran).
country(delhi,india).
country(islamabad,pakistan).
country(tokyo,japan).
country(brisbane,australia).
country(canberra,australia).
country(wellington,new_zealand).
country(djakarta,indonesia).
country(singapore,singapore).
country(peking,china).
country(hanoi,vietnam).
country(seoul,south_korea).
country(pyong_yang,north_korea).
country(recife,brazil).
country(brasilia,brazil).
country(santiago,chile).
country(oslo,norway).
country(vancouver,canada).
country(ottawa,canada).
country(montreal,canada).
country(toronto,canada).
country(havana,cuba).
country(rio_de_janeiro,brazil).
country(san_paolo,brazil).
country(buenos_aires,argentina).
country(tierra_del_fuego,argentina).
country(punta_arenas,chile).
country(caracas,venezuela).
country(san_juan,usa).
country(tampa,usa).
country(rangoon,burma).
country(bonn,west_germany).
country(frankfurt,east_germany).
country(rotterdam,netherlands).
country(tashkent,ussr).
country(pretoria,south_africa).
country(bucharest,romania).
country(budapest,hungary).
country(vienna,austria).
country(bern,switzerland).
country(geneva,switzerland).
country(zurich,switzerland).
country(bangkok,thailand).
country(seattle,usa).
country(tahiti,unknown).
country(saigon,vietnam).
country(yokohama,japan).
country(pnom_penh,cambodia).
country(panama_canal,panama).
country(naples,italy).
country(honolulu,usa).
country(berlin,east_germany).
country(helsinki,finland).
country(reykjavik,iceland).
country(thule,greenland).
country(godthab,greenland).
country(kabul,afghanistan).
country(wigan,uk).
country(damascus,syria).
country(jerusalem,israel).
country(beirut,lebanon).
country(amman,jordan).
country(kuala_lumpur,malaysia).
country(lima,peru).
country(quito,ecuador).
country(la_paz,bolivia).
country(asuncion,paraguay).
country(montevideo,uruguay).
country(suez_canal,egypt).
country(cairo,egypt).
country(tripoli,libya).
country(tunis,tunisia).
country(algiers,algeria).
country(rabat,morocco).
country(nicosia,cyprus).
country(riyadh,saudi_arabia).
country(baghdad,iraq).
country(manila,philippines).
country(taipei,taiwan).
country(vientiane,laos).
country(shanghai,china).
country(chunking,china).
country(canton,china).
country(mukden,china).
country(bombay,india).
country(madras,india).
country(calcutta,india).
country(dacca,bangladesh).
country(kuwait,kuwait).
country(doha,qatar).
country(samarkand,ussr).
country(addis_ababa,ethiopia).
country(mogadiscio,somalia).
country(kampala,uganda).
country(khartoum,sudan).
country(sana,yemen_arab_republic).
country(nairobi,kenya).
country(tananarive,madagascar).
country(durban,south_africa).
country(cape_town,south_africa).
country(windhoek,namibia).
country(luanda,angola).
country(kinshasa,zaire).
country(brazzaville,congo).
country(usambura,burundi).
country(kigali,rwanda).
country(libreville,gabon).
country(yaounde,cameroon).
country(fort_lamy,chad).
country(bangui,central_african_empire).
country(lagos,nigeria).
country(porto_novo,benin).
country(lome,togo).
country(accra,ghana).
country(ouagadougou,upper_volta).
country(niamey,niger).
country(bamako,mali).
country(monrovia,liberia).
country(freetown,sierra_leone).
country(conakry,guinea).
country(bathurst,gambia).
country(dakar,senegal).
country(nouakchott,mauritania).
country(salisbury,zimbabwe_rhodesia).
country(lourenco_marques,mozambique).
country(darwin,australia).
country(lusaka,zambia).
country(timbuktu,mali).
country(mexico_city,mexico).
country(guatemala_city,guatemala).
country(tegucigalpa,honduras).
country(managua,nicaragua).
country(guantanamo,cuba).
country(kingston,jamaica).
country(port_au_prince,haiti).
country(santo_domingo,dominican_republic).
country(san_jose,costa_rica).
country(panama_city,panama).
country(san_salvador,el_salvador).
country(greenwich,uk).
country(omaha,usa).
country(denver,usa).
country(nassau,bahamas).
country(manama,bahrain).
country(bridgetown,barbados).
country(thimphu,bhutan).
country(gaborone,botswana).
country(bujumbura,burundi).
country(praia,cape_verde).
country(bogota,colombia).
country(moroni,comoro_islands).
country(djibouti,djibouti).
country(suva,fiji).
country(saint_georges,grenada).
country(bissau,guinea_bissau).
country(georgetown,guyana).
country(abidjan,ivory_coast).
country(maseru,lesotho).
country(vaduz,liechtenstein).
country(luxembourg,luxembourg).
country(blantyre,malawi).
country(male,maldives).
country(valetta,malta).
country(port_louis,mauritius).
country(monte_carlo,monaco).
country(ulan_bator,mongolia).
country(yaren,nauru).
country(katmandu,nepal).
country(muscat,oman).
country(port_moresby,papua_new_guinea).
country(san_marino,san_marino).
country(sao_tome,sao_tome_and_principe).
country(victoria,seychelles).
country(honiara,solomon_islands).
country(colombo,sri_lanka).
country(paramaribo,surinam).
country(mbabane,swaziland).
country(dar_es_salaam,tanzania).
country(nuku_alofa,tonga).
country(port_of_spain,trinidad_and_tobago).
country(abu_dhabi,united_arab_emirates).
country(apia,western_samoa).
country(aden,yemen).
country(andorra_la_vella,andorra).
country(cayenne,french_guiana).
country(pisa,italy).
country(gangtok,sikkim).

/*
[8-1:] Get the first clause with primary key.
	do "q81(1000)." for one thousand iterations.
*/

q81(N) :- 
     statistics(garbage_collection,[_,_|G1]),!,
     statistics(runtime,[_,_]),!,
     loop_q81(0,N),
     statistics(runtime,[_,T1]),!,
     statistics(garbage_collection,[_,_|G2]),!,
     statistics(runtime,[_,_]),!,
     loop_dummy(0,N),
     statistics(runtime,[_,T2]),
     statistics(garbage_collection,[_,_|G3]),!,
     G1 = [Gt1], G2 = [Gt2], G3 = [Gt3],
     G4 is Gt2 + Gt2 - Gt1 - Gt3,
     T3 is T1-T2-G4, Total is T1-T2,
     write('Total = '), write(Total),
     write('ms,  runtime = '), write(T3),
     write('ms,  gctime = '), write(G4),
     write('ms,   for '), write(N), write(' iterations.'), nl.

loop_q81(N,N) :- !.
loop_q81(I,N) :-
     I1 is I+1, country(moscow,X), !, loop_q81(I1,N).

loop_dummy(N,N) :- !.
loop_dummy(I,N) :-
     I1 is I+1, !, loop_dummy(I1,N).

/*
[8-2:] Get the first clause.
	do "q82(1000)." for one thousand iterations.
*/

q82(N) :- 
     statistics(garbage_collection,[_,_|G1]),!,
     statistics(runtime,[_,_]),!,
     loop_q82(0,N),
     statistics(runtime,[_,T1]),!,
     statistics(garbage_collection,[_,_|G2]),!,
     statistics(runtime,[_,_]),!,
     loop_dummy(0,N),
     statistics(runtime,[_,T2]),
     statistics(garbage_collection,[_,_|G3]),!,
     G1 = [Gt1], G2 = [Gt2], G3 = [Gt3],
     G4 is Gt2 + Gt2 - Gt1 - Gt3,
     T3 is T1-T2-G4, Total is T1-T2,
     write('Total = '), write(Total),
     write('ms,  runtime = '), write(T3),
     write('ms,  gctime = '), write(G4),
     write('ms,   for '), write(N), write(' iterations.'), nl.

loop_q82(N,N) :- !.
loop_q82(I,N) :-
     I1 is I+1, country(X,ussr), !, loop_q82(I1,N).

/*
[8-3:] Get the last clause with primary key.
	do "q83(1000)." for one thousand iterations.
*/

q83(N) :- 
     statistics(garbage_collection,[_,_|G1]),!,
     statistics(runtime,[_,_]),!,
     loop_q83(0,N),
     statistics(runtime,[_,T1]),!,
     statistics(garbage_collection,[_,_|G2]),!,
     statistics(runtime,[_,_]),!,
     loop_dummy(0,N),
     statistics(runtime,[_,T2]),
     statistics(garbage_collection,[_,_|G3]),!,
     G1 = [Gt1], G2 = [Gt2], G3 = [Gt3],
     G4 is Gt2 + Gt2 - Gt1 - Gt3,
     T3 is T1-T2-G4, Total is T1-T2,
     write('Total = '), write(Total),
     write('ms,  runtime = '), write(T3),
     write('ms,  gctime = '), write(G4),
     write('ms,   for '), write(N), write(' iterations.'), nl.

loop_q83(N,N) :- !.
loop_q83(I,N) :-
     I1 is I+1, country(gangtok,X), !, loop_q83(I1,N).

/*
[8-4:] Get the last clause.
	do "q84(1000)." for one thousand iterations.
*/

q84(N) :- 
     statistics(garbage_collection,[_,_|G1]),!,
     statistics(runtime,[_,_]),!,
     loop_q84(0,N),
     statistics(runtime,[_,T1]),!,
     statistics(garbage_collection,[_,_|G2]),!,
     statistics(runtime,[_,_]),!,
     loop_dummy(0,N),
     statistics(runtime,[_,T2]),
     statistics(garbage_collection,[_,_|G3]),!,
     G1 = [Gt1], G2 = [Gt2], G3 = [Gt3],
     G4 is Gt2 + Gt2 - Gt1 - Gt3,
     T3 is T1-T2-G4, Total is T1-T2,
     write('Total = '), write(Total),
     write('ms,  runtime = '), write(T3),
     write('ms,  gctime = '), write(G4),
     write('ms,   for '), write(N), write(' iterations.'), nl.

loop_q84(N,N) :- !.
loop_q84(I,N) :-
     I1 is I+1, country(X,sikkim), !, loop_q84(I1,N).

/*
[8-5:] Get the middle clause with primary key.
	do "q85(1000)." for one thousand iterations.
*/

q85(N) :- 
     statistics(garbage_collection,[_,_|G1]),!,
     statistics(runtime,[_,_]),!,
     loop_q85(0,N),
     statistics(runtime,[_,T1]),!,
     statistics(garbage_collection,[_,_|G2]),!,
     statistics(runtime,[_,_]),!,
     loop_dummy(0,N),
     statistics(runtime,[_,T2]),
     statistics(garbage_collection,[_,_|G3]),!,
     G1 = [Gt1], G2 = [Gt2], G3 = [Gt3],
     G4 is Gt2 + Gt2 - Gt1 - Gt3,
     T3 is T1-T2-G4, Total is T1-T2,
     write('Total = '), write(Total),
     write('ms,  runtime = '), write(T3),
     write('ms,  gctime = '), write(G4),
     write('ms,   for '), write(N), write(' iterations.'), nl.

loop_q85(N,N) :- !.
loop_q85(I,N) :-
     I1 is I+1, country(manila,X), !, loop_q85(I1,N).

/*
[8-6:] Get the middle clause.
	do "q86(1000)." for one thousand iterations.
*/

q86(N) :- 
     statistics(garbage_collection,[_,_|G1]),!,
     statistics(runtime,[_,_]),!,
     loop_q86(0,N),
     statistics(runtime,[_,T1]),!,
     statistics(garbage_collection,[_,_|G2]),!,
     statistics(runtime,[_,_]),!,
     loop_dummy(0,N),
     statistics(runtime,[_,T2]),
     statistics(garbage_collection,[_,_|G3]),!,
     G1 = [Gt1], G2 = [Gt2], G3 = [Gt3],
     G4 is Gt2 + Gt2 - Gt1 - Gt3,
     T3 is T1-T2-G4, Total is T1-T2,
     write('Total = '), write(Total),
     write('ms,  runtime = '), write(T3),
     write('ms,  gctime = '), write(G4),
     write('ms,   for '), write(N), write(' iterations.'), nl.

loop_q86(N,N) :- !.
loop_q86(I,N) :-
     I1 is I+1, country(X,philippines), !, loop_q86(I1,N).

