"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RMoveToHVMoveW = exports.RMoveToHVMove = void 0;
const operator_1 = require("../../../interp/operator");
const draw_call_1 = require("../draw-call");
const general_1 = require("./general");
class RMoveToHVMove extends general_1.DrawCallOptimizationPass {
    *doFlush(st) {
        yield st;
    }
    tryUpdateState(st, dc) {
        return null;
    }
    tryInitState(dc) {
        if (dc.operator !== operator_1.CharStringOperator.RMoveTo)
            return null;
        if (dc.args.length !== 2)
            return null;
        const [dx, dy] = dc.args;
        if ((0, general_1.argIsZero)(dx)) {
            return new draw_call_1.CffDrawCall(dc.ivd, [dy], operator_1.CharStringOperator.VMoveTo);
        }
        else if ((0, general_1.argIsZero)(dy)) {
            return new draw_call_1.CffDrawCall(dc.ivd, [dx], operator_1.CharStringOperator.HMoveTo);
        }
        else {
            return null;
        }
    }
}
exports.RMoveToHVMove = RMoveToHVMove;
class RMoveToHVMoveW extends general_1.DrawCallOptimizationPass {
    *doFlush(st) {
        yield st;
    }
    tryUpdateState(st, dc) {
        return null;
    }
    tryInitState(dc) {
        if (dc.operator !== operator_1.CharStringOperator.RMoveTo)
            return null;
        if (dc.args.length !== 3)
            return null;
        const [w, dx, dy] = dc.args;
        if ((0, general_1.argIsZero)(dx)) {
            return new draw_call_1.CffDrawCall(dc.ivd, [w, dy], operator_1.CharStringOperator.VMoveTo);
        }
        else if ((0, general_1.argIsZero)(dy)) {
            return new draw_call_1.CffDrawCall(dc.ivd, [w, dx], operator_1.CharStringOperator.HMoveTo);
        }
        else {
            return null;
        }
    }
}
exports.RMoveToHVMoveW = RMoveToHVMoveW;
//# sourceMappingURL=hv-moveto.js.map