"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Ptr16MathVariantsNullable = exports.MathVariants = void 0;
const bin_composite_types_1 = require("@ot-builder/bin-composite-types");
const ot_layout_1 = require("@ot-builder/ot-layout");
const variance_1 = require("@ot-builder/variance");
const coverage_1 = require("../shared/coverage");
const glyph_construction_1 = require("./glyph-construction");
exports.MathVariants = {
    read(bv, gOrd) {
        const minConnectorOverlap = bv.uint16();
        const covVertical = bv.next(coverage_1.Ptr16GidCoverage);
        const covHorizontal = bv.next(coverage_1.Ptr16GidCoverage);
        const vGlyphCount = bv.uint16();
        const hGlyphCount = bv.uint16();
        const vGlyphConstructions = bv.array(vGlyphCount, glyph_construction_1.Ptr16MathGlyphConstruction, gOrd);
        const hGlyphConstructions = bv.array(hGlyphCount, glyph_construction_1.Ptr16MathGlyphConstruction, gOrd);
        return new ot_layout_1.Math.Variants(minConnectorOverlap, new Map(coverage_1.CovUtils.mapFromNumbers(covVertical, vGlyphConstructions, gOrd)), new Map(coverage_1.CovUtils.mapFromNumbers(covHorizontal, hGlyphConstructions, gOrd)));
    },
    write(fr, mv, gOrd) {
        const auxVertical = coverage_1.CovUtils.auxMapFromMap(mv.vertical || new Map(), gOrd);
        const auxHorizontal = coverage_1.CovUtils.auxMapFromMap(mv.horizontal || new Map(), gOrd);
        fr.uint16(variance_1.OtVar.Ops.originOf(mv.minConnectorOverlap));
        fr.push(coverage_1.Ptr16GidCoverage, coverage_1.CovUtils.gidListFromAuxMap(auxVertical));
        fr.push(coverage_1.Ptr16GidCoverage, coverage_1.CovUtils.gidListFromAuxMap(auxHorizontal));
        fr.uint16(auxVertical.length);
        fr.uint16(auxHorizontal.length);
        fr.arrayN(glyph_construction_1.Ptr16MathGlyphConstruction, auxVertical.length, coverage_1.CovUtils.valueListFromAuxMap(auxVertical), gOrd);
        fr.arrayN(glyph_construction_1.Ptr16MathGlyphConstruction, auxHorizontal.length, coverage_1.CovUtils.valueListFromAuxMap(auxHorizontal), gOrd);
    }
};
exports.Ptr16MathVariantsNullable = (0, bin_composite_types_1.NullablePtr16)(exports.MathVariants);
//# sourceMappingURL=variants.js.map