"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CvtIo = void 0;
const ot_glyphs_1 = require("@ot-builder/ot-glyphs");
const primitive_1 = require("@ot-builder/primitive");
const variance_1 = require("@ot-builder/variance");
exports.CvtIo = {
    read(view) {
        const count = view.sourceBufferSize / primitive_1.Int16.size;
        const entries = view.array(count, primitive_1.Int16);
        return new ot_glyphs_1.Cvt.Table(entries);
    },
    write(frag, table) {
        frag.array(primitive_1.Int16, table.items.map(x => variance_1.OtVar.Ops.originOf(x)));
    }
};
//# sourceMappingURL=index.js.map