import { IBezierContext, KnotCallback, IArcContext } from "./context";
import { SpiroArc } from "./spiro-arc";
import { Point } from "./base";
export * from "./base";
export * from "./context";
export { SpiroArc, SpiroK } from "./spiro-arc";
export declare type PointType = "corner" | "open" | "open_end" | "left" | "right" | "g2" | "g4";
export declare type Knot<C> = Point & {
    type: PointType;
    af?: KnotCallback<C>;
};
export declare function spiroToArcs(spiros: Knot<IArcContext>[], isClosed: boolean): SpiroArc[];
export declare function spiroToArcsOnContext<C extends IArcContext>(spiros: Knot<C>[], isClosed: boolean, context: C): void;
export declare function spiroToBezierOnContext<C extends IBezierContext>(spiros: Knot<C>[], isClosed: boolean, bc: C, delta?: number): void;
export declare function spiroToBezier(spiros: Knot<IBezierContext>[], isClosed: boolean): import("./context").Arc[];
