import { BinaryView } from "@ot-builder/bin-util";
import { OtGlyph } from "@ot-builder/ot-glyphs";
import { Gpos } from "@ot-builder/ot-layout";
import { LookupReader, SubtableReadingContext } from "../gsub-gpos-shared/general";
declare class GposMarkReaderBase {
    protected getStartClass(marks: Iterable<[OtGlyph, Gpos.MarkRecord]>): number;
    protected readMarkToBaseSubtable(view: BinaryView, marks: Map<OtGlyph, Gpos.MarkRecord>, bases: Map<OtGlyph, Gpos.BaseRecord>, ctx: SubtableReadingContext<Gpos.Lookup>): void;
    protected readMarkToLigatureSubtable(view: BinaryView, marks: Map<OtGlyph, Gpos.MarkRecord>, bases: Map<OtGlyph, Gpos.LigatureBaseRecord>, ctx: SubtableReadingContext<Gpos.Lookup>): void;
}
export declare class GposMarkToBaseReader extends GposMarkReaderBase implements LookupReader<Gpos.Lookup, Gpos.MarkToBase> {
    createLookup(): import("@ot-builder/prelude").CaseType<typeof Gpos.LookupType.MarkToBase, Gpos.MarkToBaseProp>;
    parseSubtable(view: BinaryView, lookup: Gpos.MarkToBase, ctx: SubtableReadingContext<Gpos.Lookup>): void;
}
export declare class GposMarkToLigatureReader extends GposMarkReaderBase implements LookupReader<Gpos.Lookup, Gpos.MarkToLigature> {
    createLookup(): import("@ot-builder/prelude").CaseType<typeof Gpos.LookupType.MarkToLigature, Gpos.MarkToLigatureProp>;
    parseSubtable(view: BinaryView, lookup: Gpos.MarkToLigature, ctx: SubtableReadingContext<Gpos.Lookup>): void;
}
export declare class GposMarkToMarkReader extends GposMarkReaderBase implements LookupReader<Gpos.Lookup, Gpos.MarkToMark> {
    createLookup(): import("@ot-builder/prelude").CaseType<typeof Gpos.LookupType.MarkToMark, Gpos.MarkToMarkProp>;
    parseSubtable(view: BinaryView, lookup: Gpos.MarkToMark, ctx: SubtableReadingContext<Gpos.Lookup>): void;
}
export {};
//# sourceMappingURL=gpos-mark-read.d.ts.map