//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armapimanagement_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/apimanagement/armapimanagement/v2"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4cd95123fb961c68740565a1efcaa5e43bd35802/specification/apimanagement/resource-manager/Microsoft.ApiManagement/stable/2022-08-01/examples/ApiManagementListOperations.json
func ExampleOperationsClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armapimanagement.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewOperationsClient().NewListPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.OperationListResult = armapimanagement.OperationListResult{
		// 	Value: []*armapimanagement.Operation{
		// 		{
		// 			Name: to.Ptr("Microsoft.ApiManagement/service/write"),
		// 			Display: &armapimanagement.OperationDisplay{
		// 				Description: to.Ptr("Create a new instance of API Management Service"),
		// 				Operation: to.Ptr("Create a new instance of API Management Service"),
		// 				Provider: to.Ptr("Microsoft API Management"),
		// 				Resource: to.Ptr("Service"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ApiManagement/service/read"),
		// 			Display: &armapimanagement.OperationDisplay{
		// 				Description: to.Ptr("Read metadata for an API Management Service instance"),
		// 				Operation: to.Ptr("Read metadata for an API Management Service instance"),
		// 				Provider: to.Ptr("Microsoft API Management"),
		// 				Resource: to.Ptr("Service"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ApiManagement/service/delete"),
		// 			Display: &armapimanagement.OperationDisplay{
		// 				Description: to.Ptr("Delete API Management Service instance"),
		// 				Operation: to.Ptr("Delete API Management Service instance"),
		// 				Provider: to.Ptr("Microsoft API Management"),
		// 				Resource: to.Ptr("Service"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ApiManagement/service/providers/Microsoft.Insights/diagnosticSettings/write"),
		// 			Display: &armapimanagement.OperationDisplay{
		// 				Description: to.Ptr("Creates or updates the diagnostic setting for API Management service"),
		// 				Operation: to.Ptr("Write diagnostic setting"),
		// 				Provider: to.Ptr("Microsoft API Management"),
		// 				Resource: to.Ptr("Service"),
		// 			},
		// 			Origin: to.Ptr("system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.ApiManagement/service/tenant/operationResults/read"),
		// 			Display: &armapimanagement.OperationDisplay{
		// 				Description: to.Ptr("Get list of operation results or Get result of a specific operation"),
		// 				Operation: to.Ptr("Get operation results or Get operation result"),
		// 				Provider: to.Ptr("Microsoft API Management"),
		// 				Resource: to.Ptr("Results of async operations"),
		// 			},
		// 	}},
		// }
	}
}
