//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armauthorization

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// RoleEligibilitySchedulesClient contains the methods for the RoleEligibilitySchedules group.
// Don't use this type directly, use NewRoleEligibilitySchedulesClient() instead.
type RoleEligibilitySchedulesClient struct {
	internal *arm.Client
}

// NewRoleEligibilitySchedulesClient creates a new instance of RoleEligibilitySchedulesClient with the specified values.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewRoleEligibilitySchedulesClient(credential azcore.TokenCredential, options *arm.ClientOptions) (*RoleEligibilitySchedulesClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &RoleEligibilitySchedulesClient{
		internal: cl,
	}
	return client, nil
}

// Get - Get the specified role eligibility schedule for a resource scope
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2020-10-01-preview
//   - scope - The scope of the role eligibility schedule.
//   - roleEligibilityScheduleName - The name (guid) of the role eligibility schedule to get.
//   - options - RoleEligibilitySchedulesClientGetOptions contains the optional parameters for the RoleEligibilitySchedulesClient.Get
//     method.
func (client *RoleEligibilitySchedulesClient) Get(ctx context.Context, scope string, roleEligibilityScheduleName string, options *RoleEligibilitySchedulesClientGetOptions) (RoleEligibilitySchedulesClientGetResponse, error) {
	var err error
	const operationName = "RoleEligibilitySchedulesClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, scope, roleEligibilityScheduleName, options)
	if err != nil {
		return RoleEligibilitySchedulesClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return RoleEligibilitySchedulesClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return RoleEligibilitySchedulesClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *RoleEligibilitySchedulesClient) getCreateRequest(ctx context.Context, scope string, roleEligibilityScheduleName string, options *RoleEligibilitySchedulesClientGetOptions) (*policy.Request, error) {
	urlPath := "/{scope}/providers/Microsoft.Authorization/roleEligibilitySchedules/{roleEligibilityScheduleName}"
	urlPath = strings.ReplaceAll(urlPath, "{scope}", scope)
	if roleEligibilityScheduleName == "" {
		return nil, errors.New("parameter roleEligibilityScheduleName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{roleEligibilityScheduleName}", url.PathEscape(roleEligibilityScheduleName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2020-10-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *RoleEligibilitySchedulesClient) getHandleResponse(resp *http.Response) (RoleEligibilitySchedulesClientGetResponse, error) {
	result := RoleEligibilitySchedulesClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.RoleEligibilitySchedule); err != nil {
		return RoleEligibilitySchedulesClientGetResponse{}, err
	}
	return result, nil
}

// NewListForScopePager - Gets role eligibility schedules for a resource scope.
//
// Generated from API version 2020-10-01-preview
//   - scope - The scope of the role eligibility schedules.
//   - options - RoleEligibilitySchedulesClientListForScopeOptions contains the optional parameters for the RoleEligibilitySchedulesClient.NewListForScopePager
//     method.
func (client *RoleEligibilitySchedulesClient) NewListForScopePager(scope string, options *RoleEligibilitySchedulesClientListForScopeOptions) *runtime.Pager[RoleEligibilitySchedulesClientListForScopeResponse] {
	return runtime.NewPager(runtime.PagingHandler[RoleEligibilitySchedulesClientListForScopeResponse]{
		More: func(page RoleEligibilitySchedulesClientListForScopeResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *RoleEligibilitySchedulesClientListForScopeResponse) (RoleEligibilitySchedulesClientListForScopeResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "RoleEligibilitySchedulesClient.NewListForScopePager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listForScopeCreateRequest(ctx, scope, options)
			}, nil)
			if err != nil {
				return RoleEligibilitySchedulesClientListForScopeResponse{}, err
			}
			return client.listForScopeHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listForScopeCreateRequest creates the ListForScope request.
func (client *RoleEligibilitySchedulesClient) listForScopeCreateRequest(ctx context.Context, scope string, options *RoleEligibilitySchedulesClientListForScopeOptions) (*policy.Request, error) {
	urlPath := "/{scope}/providers/Microsoft.Authorization/roleEligibilitySchedules"
	urlPath = strings.ReplaceAll(urlPath, "{scope}", scope)
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.Filter != nil {
		reqQP.Set("$filter", *options.Filter)
	}
	reqQP.Set("api-version", "2020-10-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listForScopeHandleResponse handles the ListForScope response.
func (client *RoleEligibilitySchedulesClient) listForScopeHandleResponse(resp *http.Response) (RoleEligibilitySchedulesClientListForScopeResponse, error) {
	result := RoleEligibilitySchedulesClientListForScopeResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.RoleEligibilityScheduleListResult); err != nil {
		return RoleEligibilitySchedulesClientListForScopeResponse{}, err
	}
	return result, nil
}
