//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/containerregistry/armcontainerregistry"
	"net/http"
	"net/url"
	"regexp"
)

// RegistriesServer is a fake server for instances of the armcontainerregistry.RegistriesClient type.
type RegistriesServer struct {
	// CheckNameAvailability is the fake for method RegistriesClient.CheckNameAvailability
	// HTTP status codes to indicate success: http.StatusOK
	CheckNameAvailability func(ctx context.Context, registryNameCheckRequest armcontainerregistry.RegistryNameCheckRequest, options *armcontainerregistry.RegistriesClientCheckNameAvailabilityOptions) (resp azfake.Responder[armcontainerregistry.RegistriesClientCheckNameAvailabilityResponse], errResp azfake.ErrorResponder)

	// BeginCreate is the fake for method RegistriesClient.BeginCreate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreate func(ctx context.Context, resourceGroupName string, registryName string, registry armcontainerregistry.Registry, options *armcontainerregistry.RegistriesClientBeginCreateOptions) (resp azfake.PollerResponder[armcontainerregistry.RegistriesClientCreateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method RegistriesClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceGroupName string, registryName string, options *armcontainerregistry.RegistriesClientBeginDeleteOptions) (resp azfake.PollerResponder[armcontainerregistry.RegistriesClientDeleteResponse], errResp azfake.ErrorResponder)

	// BeginGenerateCredentials is the fake for method RegistriesClient.BeginGenerateCredentials
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginGenerateCredentials func(ctx context.Context, resourceGroupName string, registryName string, generateCredentialsParameters armcontainerregistry.GenerateCredentialsParameters, options *armcontainerregistry.RegistriesClientBeginGenerateCredentialsOptions) (resp azfake.PollerResponder[armcontainerregistry.RegistriesClientGenerateCredentialsResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method RegistriesClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, registryName string, options *armcontainerregistry.RegistriesClientGetOptions) (resp azfake.Responder[armcontainerregistry.RegistriesClientGetResponse], errResp azfake.ErrorResponder)

	// GetBuildSourceUploadURL is the fake for method RegistriesClient.GetBuildSourceUploadURL
	// HTTP status codes to indicate success: http.StatusOK
	GetBuildSourceUploadURL func(ctx context.Context, resourceGroupName string, registryName string, options *armcontainerregistry.RegistriesClientGetBuildSourceUploadURLOptions) (resp azfake.Responder[armcontainerregistry.RegistriesClientGetBuildSourceUploadURLResponse], errResp azfake.ErrorResponder)

	// GetPrivateLinkResource is the fake for method RegistriesClient.GetPrivateLinkResource
	// HTTP status codes to indicate success: http.StatusOK
	GetPrivateLinkResource func(ctx context.Context, resourceGroupName string, registryName string, groupName string, options *armcontainerregistry.RegistriesClientGetPrivateLinkResourceOptions) (resp azfake.Responder[armcontainerregistry.RegistriesClientGetPrivateLinkResourceResponse], errResp azfake.ErrorResponder)

	// BeginImportImage is the fake for method RegistriesClient.BeginImportImage
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginImportImage func(ctx context.Context, resourceGroupName string, registryName string, parameters armcontainerregistry.ImportImageParameters, options *armcontainerregistry.RegistriesClientBeginImportImageOptions) (resp azfake.PollerResponder[armcontainerregistry.RegistriesClientImportImageResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method RegistriesClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(options *armcontainerregistry.RegistriesClientListOptions) (resp azfake.PagerResponder[armcontainerregistry.RegistriesClientListResponse])

	// NewListByResourceGroupPager is the fake for method RegistriesClient.NewListByResourceGroupPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByResourceGroupPager func(resourceGroupName string, options *armcontainerregistry.RegistriesClientListByResourceGroupOptions) (resp azfake.PagerResponder[armcontainerregistry.RegistriesClientListByResourceGroupResponse])

	// ListCredentials is the fake for method RegistriesClient.ListCredentials
	// HTTP status codes to indicate success: http.StatusOK
	ListCredentials func(ctx context.Context, resourceGroupName string, registryName string, options *armcontainerregistry.RegistriesClientListCredentialsOptions) (resp azfake.Responder[armcontainerregistry.RegistriesClientListCredentialsResponse], errResp azfake.ErrorResponder)

	// NewListPrivateLinkResourcesPager is the fake for method RegistriesClient.NewListPrivateLinkResourcesPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPrivateLinkResourcesPager func(resourceGroupName string, registryName string, options *armcontainerregistry.RegistriesClientListPrivateLinkResourcesOptions) (resp azfake.PagerResponder[armcontainerregistry.RegistriesClientListPrivateLinkResourcesResponse])

	// ListUsages is the fake for method RegistriesClient.ListUsages
	// HTTP status codes to indicate success: http.StatusOK
	ListUsages func(ctx context.Context, resourceGroupName string, registryName string, options *armcontainerregistry.RegistriesClientListUsagesOptions) (resp azfake.Responder[armcontainerregistry.RegistriesClientListUsagesResponse], errResp azfake.ErrorResponder)

	// RegenerateCredential is the fake for method RegistriesClient.RegenerateCredential
	// HTTP status codes to indicate success: http.StatusOK
	RegenerateCredential func(ctx context.Context, resourceGroupName string, registryName string, regenerateCredentialParameters armcontainerregistry.RegenerateCredentialParameters, options *armcontainerregistry.RegistriesClientRegenerateCredentialOptions) (resp azfake.Responder[armcontainerregistry.RegistriesClientRegenerateCredentialResponse], errResp azfake.ErrorResponder)

	// BeginScheduleRun is the fake for method RegistriesClient.BeginScheduleRun
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginScheduleRun func(ctx context.Context, resourceGroupName string, registryName string, runRequest armcontainerregistry.RunRequestClassification, options *armcontainerregistry.RegistriesClientBeginScheduleRunOptions) (resp azfake.PollerResponder[armcontainerregistry.RegistriesClientScheduleRunResponse], errResp azfake.ErrorResponder)

	// BeginUpdate is the fake for method RegistriesClient.BeginUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginUpdate func(ctx context.Context, resourceGroupName string, registryName string, registryUpdateParameters armcontainerregistry.RegistryUpdateParameters, options *armcontainerregistry.RegistriesClientBeginUpdateOptions) (resp azfake.PollerResponder[armcontainerregistry.RegistriesClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewRegistriesServerTransport creates a new instance of RegistriesServerTransport with the provided implementation.
// The returned RegistriesServerTransport instance is connected to an instance of armcontainerregistry.RegistriesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewRegistriesServerTransport(srv *RegistriesServer) *RegistriesServerTransport {
	return &RegistriesServerTransport{
		srv:                              srv,
		beginCreate:                      newTracker[azfake.PollerResponder[armcontainerregistry.RegistriesClientCreateResponse]](),
		beginDelete:                      newTracker[azfake.PollerResponder[armcontainerregistry.RegistriesClientDeleteResponse]](),
		beginGenerateCredentials:         newTracker[azfake.PollerResponder[armcontainerregistry.RegistriesClientGenerateCredentialsResponse]](),
		beginImportImage:                 newTracker[azfake.PollerResponder[armcontainerregistry.RegistriesClientImportImageResponse]](),
		newListPager:                     newTracker[azfake.PagerResponder[armcontainerregistry.RegistriesClientListResponse]](),
		newListByResourceGroupPager:      newTracker[azfake.PagerResponder[armcontainerregistry.RegistriesClientListByResourceGroupResponse]](),
		newListPrivateLinkResourcesPager: newTracker[azfake.PagerResponder[armcontainerregistry.RegistriesClientListPrivateLinkResourcesResponse]](),
		beginScheduleRun:                 newTracker[azfake.PollerResponder[armcontainerregistry.RegistriesClientScheduleRunResponse]](),
		beginUpdate:                      newTracker[azfake.PollerResponder[armcontainerregistry.RegistriesClientUpdateResponse]](),
	}
}

// RegistriesServerTransport connects instances of armcontainerregistry.RegistriesClient to instances of RegistriesServer.
// Don't use this type directly, use NewRegistriesServerTransport instead.
type RegistriesServerTransport struct {
	srv                              *RegistriesServer
	beginCreate                      *tracker[azfake.PollerResponder[armcontainerregistry.RegistriesClientCreateResponse]]
	beginDelete                      *tracker[azfake.PollerResponder[armcontainerregistry.RegistriesClientDeleteResponse]]
	beginGenerateCredentials         *tracker[azfake.PollerResponder[armcontainerregistry.RegistriesClientGenerateCredentialsResponse]]
	beginImportImage                 *tracker[azfake.PollerResponder[armcontainerregistry.RegistriesClientImportImageResponse]]
	newListPager                     *tracker[azfake.PagerResponder[armcontainerregistry.RegistriesClientListResponse]]
	newListByResourceGroupPager      *tracker[azfake.PagerResponder[armcontainerregistry.RegistriesClientListByResourceGroupResponse]]
	newListPrivateLinkResourcesPager *tracker[azfake.PagerResponder[armcontainerregistry.RegistriesClientListPrivateLinkResourcesResponse]]
	beginScheduleRun                 *tracker[azfake.PollerResponder[armcontainerregistry.RegistriesClientScheduleRunResponse]]
	beginUpdate                      *tracker[azfake.PollerResponder[armcontainerregistry.RegistriesClientUpdateResponse]]
}

// Do implements the policy.Transporter interface for RegistriesServerTransport.
func (r *RegistriesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "RegistriesClient.CheckNameAvailability":
		resp, err = r.dispatchCheckNameAvailability(req)
	case "RegistriesClient.BeginCreate":
		resp, err = r.dispatchBeginCreate(req)
	case "RegistriesClient.BeginDelete":
		resp, err = r.dispatchBeginDelete(req)
	case "RegistriesClient.BeginGenerateCredentials":
		resp, err = r.dispatchBeginGenerateCredentials(req)
	case "RegistriesClient.Get":
		resp, err = r.dispatchGet(req)
	case "RegistriesClient.GetBuildSourceUploadURL":
		resp, err = r.dispatchGetBuildSourceUploadURL(req)
	case "RegistriesClient.GetPrivateLinkResource":
		resp, err = r.dispatchGetPrivateLinkResource(req)
	case "RegistriesClient.BeginImportImage":
		resp, err = r.dispatchBeginImportImage(req)
	case "RegistriesClient.NewListPager":
		resp, err = r.dispatchNewListPager(req)
	case "RegistriesClient.NewListByResourceGroupPager":
		resp, err = r.dispatchNewListByResourceGroupPager(req)
	case "RegistriesClient.ListCredentials":
		resp, err = r.dispatchListCredentials(req)
	case "RegistriesClient.NewListPrivateLinkResourcesPager":
		resp, err = r.dispatchNewListPrivateLinkResourcesPager(req)
	case "RegistriesClient.ListUsages":
		resp, err = r.dispatchListUsages(req)
	case "RegistriesClient.RegenerateCredential":
		resp, err = r.dispatchRegenerateCredential(req)
	case "RegistriesClient.BeginScheduleRun":
		resp, err = r.dispatchBeginScheduleRun(req)
	case "RegistriesClient.BeginUpdate":
		resp, err = r.dispatchBeginUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (r *RegistriesServerTransport) dispatchCheckNameAvailability(req *http.Request) (*http.Response, error) {
	if r.srv.CheckNameAvailability == nil {
		return nil, &nonRetriableError{errors.New("fake for method CheckNameAvailability not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ContainerRegistry/checkNameAvailability`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armcontainerregistry.RegistryNameCheckRequest](req)
	if err != nil {
		return nil, err
	}
	respr, errRespr := r.srv.CheckNameAvailability(req.Context(), body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).RegistryNameStatus, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (r *RegistriesServerTransport) dispatchBeginCreate(req *http.Request) (*http.Response, error) {
	if r.srv.BeginCreate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreate not implemented")}
	}
	beginCreate := r.beginCreate.get(req)
	if beginCreate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ContainerRegistry/registries/(?P<registryName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armcontainerregistry.Registry](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		registryNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("registryName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := r.srv.BeginCreate(req.Context(), resourceGroupNameParam, registryNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreate = &respr
		r.beginCreate.add(req, beginCreate)
	}

	resp, err := server.PollerResponderNext(beginCreate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		r.beginCreate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreate) {
		r.beginCreate.remove(req)
	}

	return resp, nil
}

func (r *RegistriesServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if r.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := r.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ContainerRegistry/registries/(?P<registryName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		registryNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("registryName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := r.srv.BeginDelete(req.Context(), resourceGroupNameParam, registryNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		r.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		r.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		r.beginDelete.remove(req)
	}

	return resp, nil
}

func (r *RegistriesServerTransport) dispatchBeginGenerateCredentials(req *http.Request) (*http.Response, error) {
	if r.srv.BeginGenerateCredentials == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginGenerateCredentials not implemented")}
	}
	beginGenerateCredentials := r.beginGenerateCredentials.get(req)
	if beginGenerateCredentials == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ContainerRegistry/registries/(?P<registryName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/generateCredentials`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armcontainerregistry.GenerateCredentialsParameters](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		registryNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("registryName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := r.srv.BeginGenerateCredentials(req.Context(), resourceGroupNameParam, registryNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginGenerateCredentials = &respr
		r.beginGenerateCredentials.add(req, beginGenerateCredentials)
	}

	resp, err := server.PollerResponderNext(beginGenerateCredentials, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		r.beginGenerateCredentials.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginGenerateCredentials) {
		r.beginGenerateCredentials.remove(req)
	}

	return resp, nil
}

func (r *RegistriesServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if r.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ContainerRegistry/registries/(?P<registryName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	registryNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("registryName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := r.srv.Get(req.Context(), resourceGroupNameParam, registryNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Registry, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (r *RegistriesServerTransport) dispatchGetBuildSourceUploadURL(req *http.Request) (*http.Response, error) {
	if r.srv.GetBuildSourceUploadURL == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetBuildSourceUploadURL not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ContainerRegistry/registries/(?P<registryName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/listBuildSourceUploadUrl`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	registryNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("registryName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := r.srv.GetBuildSourceUploadURL(req.Context(), resourceGroupNameParam, registryNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SourceUploadDefinition, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (r *RegistriesServerTransport) dispatchGetPrivateLinkResource(req *http.Request) (*http.Response, error) {
	if r.srv.GetPrivateLinkResource == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetPrivateLinkResource not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ContainerRegistry/registries/(?P<registryName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/privateLinkResources/(?P<groupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	registryNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("registryName")])
	if err != nil {
		return nil, err
	}
	groupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("groupName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := r.srv.GetPrivateLinkResource(req.Context(), resourceGroupNameParam, registryNameParam, groupNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).PrivateLinkResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (r *RegistriesServerTransport) dispatchBeginImportImage(req *http.Request) (*http.Response, error) {
	if r.srv.BeginImportImage == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginImportImage not implemented")}
	}
	beginImportImage := r.beginImportImage.get(req)
	if beginImportImage == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ContainerRegistry/registries/(?P<registryName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/importImage`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armcontainerregistry.ImportImageParameters](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		registryNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("registryName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := r.srv.BeginImportImage(req.Context(), resourceGroupNameParam, registryNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginImportImage = &respr
		r.beginImportImage.add(req, beginImportImage)
	}

	resp, err := server.PollerResponderNext(beginImportImage, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		r.beginImportImage.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginImportImage) {
		r.beginImportImage.remove(req)
	}

	return resp, nil
}

func (r *RegistriesServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if r.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := r.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ContainerRegistry/registries`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resp := r.srv.NewListPager(nil)
		newListPager = &resp
		r.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armcontainerregistry.RegistriesClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		r.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		r.newListPager.remove(req)
	}
	return resp, nil
}

func (r *RegistriesServerTransport) dispatchNewListByResourceGroupPager(req *http.Request) (*http.Response, error) {
	if r.srv.NewListByResourceGroupPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByResourceGroupPager not implemented")}
	}
	newListByResourceGroupPager := r.newListByResourceGroupPager.get(req)
	if newListByResourceGroupPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ContainerRegistry/registries`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resp := r.srv.NewListByResourceGroupPager(resourceGroupNameParam, nil)
		newListByResourceGroupPager = &resp
		r.newListByResourceGroupPager.add(req, newListByResourceGroupPager)
		server.PagerResponderInjectNextLinks(newListByResourceGroupPager, req, func(page *armcontainerregistry.RegistriesClientListByResourceGroupResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByResourceGroupPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		r.newListByResourceGroupPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByResourceGroupPager) {
		r.newListByResourceGroupPager.remove(req)
	}
	return resp, nil
}

func (r *RegistriesServerTransport) dispatchListCredentials(req *http.Request) (*http.Response, error) {
	if r.srv.ListCredentials == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListCredentials not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ContainerRegistry/registries/(?P<registryName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/listCredentials`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	registryNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("registryName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := r.srv.ListCredentials(req.Context(), resourceGroupNameParam, registryNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).RegistryListCredentialsResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (r *RegistriesServerTransport) dispatchNewListPrivateLinkResourcesPager(req *http.Request) (*http.Response, error) {
	if r.srv.NewListPrivateLinkResourcesPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPrivateLinkResourcesPager not implemented")}
	}
	newListPrivateLinkResourcesPager := r.newListPrivateLinkResourcesPager.get(req)
	if newListPrivateLinkResourcesPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ContainerRegistry/registries/(?P<registryName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/privateLinkResources`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		registryNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("registryName")])
		if err != nil {
			return nil, err
		}
		resp := r.srv.NewListPrivateLinkResourcesPager(resourceGroupNameParam, registryNameParam, nil)
		newListPrivateLinkResourcesPager = &resp
		r.newListPrivateLinkResourcesPager.add(req, newListPrivateLinkResourcesPager)
		server.PagerResponderInjectNextLinks(newListPrivateLinkResourcesPager, req, func(page *armcontainerregistry.RegistriesClientListPrivateLinkResourcesResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPrivateLinkResourcesPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		r.newListPrivateLinkResourcesPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPrivateLinkResourcesPager) {
		r.newListPrivateLinkResourcesPager.remove(req)
	}
	return resp, nil
}

func (r *RegistriesServerTransport) dispatchListUsages(req *http.Request) (*http.Response, error) {
	if r.srv.ListUsages == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListUsages not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ContainerRegistry/registries/(?P<registryName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/listUsages`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	registryNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("registryName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := r.srv.ListUsages(req.Context(), resourceGroupNameParam, registryNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).RegistryUsageListResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (r *RegistriesServerTransport) dispatchRegenerateCredential(req *http.Request) (*http.Response, error) {
	if r.srv.RegenerateCredential == nil {
		return nil, &nonRetriableError{errors.New("fake for method RegenerateCredential not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ContainerRegistry/registries/(?P<registryName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/regenerateCredential`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armcontainerregistry.RegenerateCredentialParameters](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	registryNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("registryName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := r.srv.RegenerateCredential(req.Context(), resourceGroupNameParam, registryNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).RegistryListCredentialsResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (r *RegistriesServerTransport) dispatchBeginScheduleRun(req *http.Request) (*http.Response, error) {
	if r.srv.BeginScheduleRun == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginScheduleRun not implemented")}
	}
	beginScheduleRun := r.beginScheduleRun.get(req)
	if beginScheduleRun == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ContainerRegistry/registries/(?P<registryName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/scheduleRun`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		raw, err := readRequestBody(req)
		if err != nil {
			return nil, err
		}
		body, err := unmarshalRunRequestClassification(raw)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		registryNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("registryName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := r.srv.BeginScheduleRun(req.Context(), resourceGroupNameParam, registryNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginScheduleRun = &respr
		r.beginScheduleRun.add(req, beginScheduleRun)
	}

	resp, err := server.PollerResponderNext(beginScheduleRun, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		r.beginScheduleRun.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginScheduleRun) {
		r.beginScheduleRun.remove(req)
	}

	return resp, nil
}

func (r *RegistriesServerTransport) dispatchBeginUpdate(req *http.Request) (*http.Response, error) {
	if r.srv.BeginUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdate not implemented")}
	}
	beginUpdate := r.beginUpdate.get(req)
	if beginUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ContainerRegistry/registries/(?P<registryName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armcontainerregistry.RegistryUpdateParameters](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		registryNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("registryName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := r.srv.BeginUpdate(req.Context(), resourceGroupNameParam, registryNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdate = &respr
		r.beginUpdate.add(req, beginUpdate)
	}

	resp, err := server.PollerResponderNext(beginUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		r.beginUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdate) {
		r.beginUpdate.remove(req)
	}

	return resp, nil
}
