//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/mediaservices/armmediaservices/v3"
	"net/http"
	"net/url"
	"regexp"
	"strconv"
)

// StreamingLocatorsServer is a fake server for instances of the armmediaservices.StreamingLocatorsClient type.
type StreamingLocatorsServer struct {
	// Create is the fake for method StreamingLocatorsClient.Create
	// HTTP status codes to indicate success: http.StatusCreated
	Create func(ctx context.Context, resourceGroupName string, accountName string, streamingLocatorName string, parameters armmediaservices.StreamingLocator, options *armmediaservices.StreamingLocatorsClientCreateOptions) (resp azfake.Responder[armmediaservices.StreamingLocatorsClientCreateResponse], errResp azfake.ErrorResponder)

	// Delete is the fake for method StreamingLocatorsClient.Delete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	Delete func(ctx context.Context, resourceGroupName string, accountName string, streamingLocatorName string, options *armmediaservices.StreamingLocatorsClientDeleteOptions) (resp azfake.Responder[armmediaservices.StreamingLocatorsClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method StreamingLocatorsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, accountName string, streamingLocatorName string, options *armmediaservices.StreamingLocatorsClientGetOptions) (resp azfake.Responder[armmediaservices.StreamingLocatorsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method StreamingLocatorsClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(resourceGroupName string, accountName string, options *armmediaservices.StreamingLocatorsClientListOptions) (resp azfake.PagerResponder[armmediaservices.StreamingLocatorsClientListResponse])

	// ListContentKeys is the fake for method StreamingLocatorsClient.ListContentKeys
	// HTTP status codes to indicate success: http.StatusOK
	ListContentKeys func(ctx context.Context, resourceGroupName string, accountName string, streamingLocatorName string, options *armmediaservices.StreamingLocatorsClientListContentKeysOptions) (resp azfake.Responder[armmediaservices.StreamingLocatorsClientListContentKeysResponse], errResp azfake.ErrorResponder)

	// ListPaths is the fake for method StreamingLocatorsClient.ListPaths
	// HTTP status codes to indicate success: http.StatusOK
	ListPaths func(ctx context.Context, resourceGroupName string, accountName string, streamingLocatorName string, options *armmediaservices.StreamingLocatorsClientListPathsOptions) (resp azfake.Responder[armmediaservices.StreamingLocatorsClientListPathsResponse], errResp azfake.ErrorResponder)
}

// NewStreamingLocatorsServerTransport creates a new instance of StreamingLocatorsServerTransport with the provided implementation.
// The returned StreamingLocatorsServerTransport instance is connected to an instance of armmediaservices.StreamingLocatorsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewStreamingLocatorsServerTransport(srv *StreamingLocatorsServer) *StreamingLocatorsServerTransport {
	return &StreamingLocatorsServerTransport{
		srv:          srv,
		newListPager: newTracker[azfake.PagerResponder[armmediaservices.StreamingLocatorsClientListResponse]](),
	}
}

// StreamingLocatorsServerTransport connects instances of armmediaservices.StreamingLocatorsClient to instances of StreamingLocatorsServer.
// Don't use this type directly, use NewStreamingLocatorsServerTransport instead.
type StreamingLocatorsServerTransport struct {
	srv          *StreamingLocatorsServer
	newListPager *tracker[azfake.PagerResponder[armmediaservices.StreamingLocatorsClientListResponse]]
}

// Do implements the policy.Transporter interface for StreamingLocatorsServerTransport.
func (s *StreamingLocatorsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "StreamingLocatorsClient.Create":
		resp, err = s.dispatchCreate(req)
	case "StreamingLocatorsClient.Delete":
		resp, err = s.dispatchDelete(req)
	case "StreamingLocatorsClient.Get":
		resp, err = s.dispatchGet(req)
	case "StreamingLocatorsClient.NewListPager":
		resp, err = s.dispatchNewListPager(req)
	case "StreamingLocatorsClient.ListContentKeys":
		resp, err = s.dispatchListContentKeys(req)
	case "StreamingLocatorsClient.ListPaths":
		resp, err = s.dispatchListPaths(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (s *StreamingLocatorsServerTransport) dispatchCreate(req *http.Request) (*http.Response, error) {
	if s.srv.Create == nil {
		return nil, &nonRetriableError{errors.New("fake for method Create not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Media/mediaServices/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/streamingLocators/(?P<streamingLocatorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armmediaservices.StreamingLocator](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	streamingLocatorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("streamingLocatorName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.Create(req.Context(), resourceGroupNameParam, accountNameParam, streamingLocatorNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusCreated}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusCreated", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).StreamingLocator, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *StreamingLocatorsServerTransport) dispatchDelete(req *http.Request) (*http.Response, error) {
	if s.srv.Delete == nil {
		return nil, &nonRetriableError{errors.New("fake for method Delete not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Media/mediaServices/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/streamingLocators/(?P<streamingLocatorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	streamingLocatorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("streamingLocatorName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.Delete(req.Context(), resourceGroupNameParam, accountNameParam, streamingLocatorNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *StreamingLocatorsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if s.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Media/mediaServices/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/streamingLocators/(?P<streamingLocatorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	streamingLocatorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("streamingLocatorName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.Get(req.Context(), resourceGroupNameParam, accountNameParam, streamingLocatorNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).StreamingLocator, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *StreamingLocatorsServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if s.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := s.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Media/mediaServices/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/streamingLocators`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
		if err != nil {
			return nil, err
		}
		topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		orderbyUnescaped, err := url.QueryUnescape(qp.Get("$orderby"))
		if err != nil {
			return nil, err
		}
		orderbyParam := getOptional(orderbyUnescaped)
		var options *armmediaservices.StreamingLocatorsClientListOptions
		if filterParam != nil || topParam != nil || orderbyParam != nil {
			options = &armmediaservices.StreamingLocatorsClientListOptions{
				Filter:  filterParam,
				Top:     topParam,
				Orderby: orderbyParam,
			}
		}
		resp := s.srv.NewListPager(resourceGroupNameParam, accountNameParam, options)
		newListPager = &resp
		s.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armmediaservices.StreamingLocatorsClientListResponse, createLink func() string) {
			page.ODataNextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		s.newListPager.remove(req)
	}
	return resp, nil
}

func (s *StreamingLocatorsServerTransport) dispatchListContentKeys(req *http.Request) (*http.Response, error) {
	if s.srv.ListContentKeys == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListContentKeys not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Media/mediaServices/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/streamingLocators/(?P<streamingLocatorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/listContentKeys`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	streamingLocatorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("streamingLocatorName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.ListContentKeys(req.Context(), resourceGroupNameParam, accountNameParam, streamingLocatorNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ListContentKeysResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *StreamingLocatorsServerTransport) dispatchListPaths(req *http.Request) (*http.Response, error) {
	if s.srv.ListPaths == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListPaths not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Media/mediaServices/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/streamingLocators/(?P<streamingLocatorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/listPaths`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	streamingLocatorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("streamingLocatorName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.ListPaths(req.Context(), resourceGroupNameParam, accountNameParam, streamingLocatorNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ListPathsResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
