//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/resources/armpolicy"
	"net/http"
	"net/url"
	"regexp"
	"strconv"
)

// AssignmentsServer is a fake server for instances of the armpolicy.AssignmentsClient type.
type AssignmentsServer struct {
	// Create is the fake for method AssignmentsClient.Create
	// HTTP status codes to indicate success: http.StatusCreated
	Create func(ctx context.Context, scope string, policyAssignmentName string, parameters armpolicy.Assignment, options *armpolicy.AssignmentsClientCreateOptions) (resp azfake.Responder[armpolicy.AssignmentsClientCreateResponse], errResp azfake.ErrorResponder)

	// CreateByID is the fake for method AssignmentsClient.CreateByID
	// HTTP status codes to indicate success: http.StatusCreated
	CreateByID func(ctx context.Context, policyAssignmentID string, parameters armpolicy.Assignment, options *armpolicy.AssignmentsClientCreateByIDOptions) (resp azfake.Responder[armpolicy.AssignmentsClientCreateByIDResponse], errResp azfake.ErrorResponder)

	// Delete is the fake for method AssignmentsClient.Delete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	Delete func(ctx context.Context, scope string, policyAssignmentName string, options *armpolicy.AssignmentsClientDeleteOptions) (resp azfake.Responder[armpolicy.AssignmentsClientDeleteResponse], errResp azfake.ErrorResponder)

	// DeleteByID is the fake for method AssignmentsClient.DeleteByID
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	DeleteByID func(ctx context.Context, policyAssignmentID string, options *armpolicy.AssignmentsClientDeleteByIDOptions) (resp azfake.Responder[armpolicy.AssignmentsClientDeleteByIDResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method AssignmentsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, scope string, policyAssignmentName string, options *armpolicy.AssignmentsClientGetOptions) (resp azfake.Responder[armpolicy.AssignmentsClientGetResponse], errResp azfake.ErrorResponder)

	// GetByID is the fake for method AssignmentsClient.GetByID
	// HTTP status codes to indicate success: http.StatusOK
	GetByID func(ctx context.Context, policyAssignmentID string, options *armpolicy.AssignmentsClientGetByIDOptions) (resp azfake.Responder[armpolicy.AssignmentsClientGetByIDResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method AssignmentsClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(options *armpolicy.AssignmentsClientListOptions) (resp azfake.PagerResponder[armpolicy.AssignmentsClientListResponse])

	// NewListForManagementGroupPager is the fake for method AssignmentsClient.NewListForManagementGroupPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListForManagementGroupPager func(managementGroupID string, options *armpolicy.AssignmentsClientListForManagementGroupOptions) (resp azfake.PagerResponder[armpolicy.AssignmentsClientListForManagementGroupResponse])

	// NewListForResourcePager is the fake for method AssignmentsClient.NewListForResourcePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListForResourcePager func(resourceGroupName string, resourceProviderNamespace string, parentResourcePath string, resourceType string, resourceName string, options *armpolicy.AssignmentsClientListForResourceOptions) (resp azfake.PagerResponder[armpolicy.AssignmentsClientListForResourceResponse])

	// NewListForResourceGroupPager is the fake for method AssignmentsClient.NewListForResourceGroupPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListForResourceGroupPager func(resourceGroupName string, options *armpolicy.AssignmentsClientListForResourceGroupOptions) (resp azfake.PagerResponder[armpolicy.AssignmentsClientListForResourceGroupResponse])

	// Update is the fake for method AssignmentsClient.Update
	// HTTP status codes to indicate success: http.StatusOK
	Update func(ctx context.Context, scope string, policyAssignmentName string, parameters armpolicy.AssignmentUpdate, options *armpolicy.AssignmentsClientUpdateOptions) (resp azfake.Responder[armpolicy.AssignmentsClientUpdateResponse], errResp azfake.ErrorResponder)

	// UpdateByID is the fake for method AssignmentsClient.UpdateByID
	// HTTP status codes to indicate success: http.StatusOK
	UpdateByID func(ctx context.Context, policyAssignmentID string, parameters armpolicy.AssignmentUpdate, options *armpolicy.AssignmentsClientUpdateByIDOptions) (resp azfake.Responder[armpolicy.AssignmentsClientUpdateByIDResponse], errResp azfake.ErrorResponder)
}

// NewAssignmentsServerTransport creates a new instance of AssignmentsServerTransport with the provided implementation.
// The returned AssignmentsServerTransport instance is connected to an instance of armpolicy.AssignmentsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewAssignmentsServerTransport(srv *AssignmentsServer) *AssignmentsServerTransport {
	return &AssignmentsServerTransport{
		srv:                            srv,
		newListPager:                   newTracker[azfake.PagerResponder[armpolicy.AssignmentsClientListResponse]](),
		newListForManagementGroupPager: newTracker[azfake.PagerResponder[armpolicy.AssignmentsClientListForManagementGroupResponse]](),
		newListForResourcePager:        newTracker[azfake.PagerResponder[armpolicy.AssignmentsClientListForResourceResponse]](),
		newListForResourceGroupPager:   newTracker[azfake.PagerResponder[armpolicy.AssignmentsClientListForResourceGroupResponse]](),
	}
}

// AssignmentsServerTransport connects instances of armpolicy.AssignmentsClient to instances of AssignmentsServer.
// Don't use this type directly, use NewAssignmentsServerTransport instead.
type AssignmentsServerTransport struct {
	srv                            *AssignmentsServer
	newListPager                   *tracker[azfake.PagerResponder[armpolicy.AssignmentsClientListResponse]]
	newListForManagementGroupPager *tracker[azfake.PagerResponder[armpolicy.AssignmentsClientListForManagementGroupResponse]]
	newListForResourcePager        *tracker[azfake.PagerResponder[armpolicy.AssignmentsClientListForResourceResponse]]
	newListForResourceGroupPager   *tracker[azfake.PagerResponder[armpolicy.AssignmentsClientListForResourceGroupResponse]]
}

// Do implements the policy.Transporter interface for AssignmentsServerTransport.
func (a *AssignmentsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "AssignmentsClient.Create":
		resp, err = a.dispatchCreate(req)
	case "AssignmentsClient.CreateByID":
		resp, err = a.dispatchCreateByID(req)
	case "AssignmentsClient.Delete":
		resp, err = a.dispatchDelete(req)
	case "AssignmentsClient.DeleteByID":
		resp, err = a.dispatchDeleteByID(req)
	case "AssignmentsClient.Get":
		resp, err = a.dispatchGet(req)
	case "AssignmentsClient.GetByID":
		resp, err = a.dispatchGetByID(req)
	case "AssignmentsClient.NewListPager":
		resp, err = a.dispatchNewListPager(req)
	case "AssignmentsClient.NewListForManagementGroupPager":
		resp, err = a.dispatchNewListForManagementGroupPager(req)
	case "AssignmentsClient.NewListForResourcePager":
		resp, err = a.dispatchNewListForResourcePager(req)
	case "AssignmentsClient.NewListForResourceGroupPager":
		resp, err = a.dispatchNewListForResourceGroupPager(req)
	case "AssignmentsClient.Update":
		resp, err = a.dispatchUpdate(req)
	case "AssignmentsClient.UpdateByID":
		resp, err = a.dispatchUpdateByID(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (a *AssignmentsServerTransport) dispatchCreate(req *http.Request) (*http.Response, error) {
	if a.srv.Create == nil {
		return nil, &nonRetriableError{errors.New("fake for method Create not implemented")}
	}
	const regexStr = `/(?P<scope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Authorization/policyAssignments/(?P<policyAssignmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armpolicy.Assignment](req)
	if err != nil {
		return nil, err
	}
	scopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("scope")])
	if err != nil {
		return nil, err
	}
	policyAssignmentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("policyAssignmentName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.Create(req.Context(), scopeParam, policyAssignmentNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusCreated}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusCreated", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Assignment, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *AssignmentsServerTransport) dispatchCreateByID(req *http.Request) (*http.Response, error) {
	if a.srv.CreateByID == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateByID not implemented")}
	}
	const regexStr = `/(?P<policyAssignmentId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armpolicy.Assignment](req)
	if err != nil {
		return nil, err
	}
	policyAssignmentIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("policyAssignmentId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.CreateByID(req.Context(), policyAssignmentIDParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusCreated}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusCreated", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Assignment, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *AssignmentsServerTransport) dispatchDelete(req *http.Request) (*http.Response, error) {
	if a.srv.Delete == nil {
		return nil, &nonRetriableError{errors.New("fake for method Delete not implemented")}
	}
	const regexStr = `/(?P<scope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Authorization/policyAssignments/(?P<policyAssignmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	scopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("scope")])
	if err != nil {
		return nil, err
	}
	policyAssignmentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("policyAssignmentName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.Delete(req.Context(), scopeParam, policyAssignmentNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Assignment, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *AssignmentsServerTransport) dispatchDeleteByID(req *http.Request) (*http.Response, error) {
	if a.srv.DeleteByID == nil {
		return nil, &nonRetriableError{errors.New("fake for method DeleteByID not implemented")}
	}
	const regexStr = `/(?P<policyAssignmentId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	policyAssignmentIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("policyAssignmentId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.DeleteByID(req.Context(), policyAssignmentIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Assignment, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *AssignmentsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if a.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/(?P<scope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Authorization/policyAssignments/(?P<policyAssignmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	scopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("scope")])
	if err != nil {
		return nil, err
	}
	policyAssignmentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("policyAssignmentName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.Get(req.Context(), scopeParam, policyAssignmentNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Assignment, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *AssignmentsServerTransport) dispatchGetByID(req *http.Request) (*http.Response, error) {
	if a.srv.GetByID == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetByID not implemented")}
	}
	const regexStr = `/(?P<policyAssignmentId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	policyAssignmentIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("policyAssignmentId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.GetByID(req.Context(), policyAssignmentIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Assignment, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *AssignmentsServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if a.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := a.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Authorization/policyAssignments`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
		if err != nil {
			return nil, err
		}
		topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		var options *armpolicy.AssignmentsClientListOptions
		if filterParam != nil || topParam != nil {
			options = &armpolicy.AssignmentsClientListOptions{
				Filter: filterParam,
				Top:    topParam,
			}
		}
		resp := a.srv.NewListPager(options)
		newListPager = &resp
		a.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armpolicy.AssignmentsClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		a.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		a.newListPager.remove(req)
	}
	return resp, nil
}

func (a *AssignmentsServerTransport) dispatchNewListForManagementGroupPager(req *http.Request) (*http.Response, error) {
	if a.srv.NewListForManagementGroupPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListForManagementGroupPager not implemented")}
	}
	newListForManagementGroupPager := a.newListForManagementGroupPager.get(req)
	if newListForManagementGroupPager == nil {
		const regexStr = `/providers/Microsoft\.Management/managementGroups/(?P<managementGroupId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Authorization/policyAssignments`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		managementGroupIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("managementGroupId")])
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
		if err != nil {
			return nil, err
		}
		topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		var options *armpolicy.AssignmentsClientListForManagementGroupOptions
		if filterParam != nil || topParam != nil {
			options = &armpolicy.AssignmentsClientListForManagementGroupOptions{
				Filter: filterParam,
				Top:    topParam,
			}
		}
		resp := a.srv.NewListForManagementGroupPager(managementGroupIDParam, options)
		newListForManagementGroupPager = &resp
		a.newListForManagementGroupPager.add(req, newListForManagementGroupPager)
		server.PagerResponderInjectNextLinks(newListForManagementGroupPager, req, func(page *armpolicy.AssignmentsClientListForManagementGroupResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListForManagementGroupPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		a.newListForManagementGroupPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListForManagementGroupPager) {
		a.newListForManagementGroupPager.remove(req)
	}
	return resp, nil
}

func (a *AssignmentsServerTransport) dispatchNewListForResourcePager(req *http.Request) (*http.Response, error) {
	if a.srv.NewListForResourcePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListForResourcePager not implemented")}
	}
	newListForResourcePager := a.newListForResourcePager.get(req)
	if newListForResourcePager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/(?P<resourceProviderNamespace>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/(?P<parentResourcePath>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/(?P<resourceType>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Authorization/policyAssignments`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 6 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resourceProviderNamespaceParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceProviderNamespace")])
		if err != nil {
			return nil, err
		}
		parentResourcePathParam, err := url.PathUnescape(matches[regex.SubexpIndex("parentResourcePath")])
		if err != nil {
			return nil, err
		}
		resourceTypeParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceType")])
		if err != nil {
			return nil, err
		}
		resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
		if err != nil {
			return nil, err
		}
		topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		var options *armpolicy.AssignmentsClientListForResourceOptions
		if filterParam != nil || topParam != nil {
			options = &armpolicy.AssignmentsClientListForResourceOptions{
				Filter: filterParam,
				Top:    topParam,
			}
		}
		resp := a.srv.NewListForResourcePager(resourceGroupNameParam, resourceProviderNamespaceParam, parentResourcePathParam, resourceTypeParam, resourceNameParam, options)
		newListForResourcePager = &resp
		a.newListForResourcePager.add(req, newListForResourcePager)
		server.PagerResponderInjectNextLinks(newListForResourcePager, req, func(page *armpolicy.AssignmentsClientListForResourceResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListForResourcePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		a.newListForResourcePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListForResourcePager) {
		a.newListForResourcePager.remove(req)
	}
	return resp, nil
}

func (a *AssignmentsServerTransport) dispatchNewListForResourceGroupPager(req *http.Request) (*http.Response, error) {
	if a.srv.NewListForResourceGroupPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListForResourceGroupPager not implemented")}
	}
	newListForResourceGroupPager := a.newListForResourceGroupPager.get(req)
	if newListForResourceGroupPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Authorization/policyAssignments`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
		if err != nil {
			return nil, err
		}
		topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		var options *armpolicy.AssignmentsClientListForResourceGroupOptions
		if filterParam != nil || topParam != nil {
			options = &armpolicy.AssignmentsClientListForResourceGroupOptions{
				Filter: filterParam,
				Top:    topParam,
			}
		}
		resp := a.srv.NewListForResourceGroupPager(resourceGroupNameParam, options)
		newListForResourceGroupPager = &resp
		a.newListForResourceGroupPager.add(req, newListForResourceGroupPager)
		server.PagerResponderInjectNextLinks(newListForResourceGroupPager, req, func(page *armpolicy.AssignmentsClientListForResourceGroupResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListForResourceGroupPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		a.newListForResourceGroupPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListForResourceGroupPager) {
		a.newListForResourceGroupPager.remove(req)
	}
	return resp, nil
}

func (a *AssignmentsServerTransport) dispatchUpdate(req *http.Request) (*http.Response, error) {
	if a.srv.Update == nil {
		return nil, &nonRetriableError{errors.New("fake for method Update not implemented")}
	}
	const regexStr = `/(?P<scope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Authorization/policyAssignments/(?P<policyAssignmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armpolicy.AssignmentUpdate](req)
	if err != nil {
		return nil, err
	}
	scopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("scope")])
	if err != nil {
		return nil, err
	}
	policyAssignmentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("policyAssignmentName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.Update(req.Context(), scopeParam, policyAssignmentNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Assignment, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *AssignmentsServerTransport) dispatchUpdateByID(req *http.Request) (*http.Response, error) {
	if a.srv.UpdateByID == nil {
		return nil, &nonRetriableError{errors.New("fake for method UpdateByID not implemented")}
	}
	const regexStr = `/(?P<policyAssignmentId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armpolicy.AssignmentUpdate](req)
	if err != nil {
		return nil, err
	}
	policyAssignmentIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("policyAssignmentId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.UpdateByID(req.Context(), policyAssignmentIDParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Assignment, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
