#pragma once
/*
 *  $Id: gradient-editor.h 28234 2025-07-16 10:47:20Z yeti-dn $
 *  Copyright (C) 2025 David Necas (Yeti).
 *  E-mail: yeti@gwyddion.net.
 *
 *  This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any
 *  later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 *  details.
 *
 *  You should have received a copy of the GNU General Public License along with this program; if not, write to the
 *  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __GWYAPP_GRADIENT_EDITOR_H__
#define __GWYAPP_GRADIENT_EDITOR_H__

#include <gtk/gtk.h>
#include <libgwyapp/resource-editor.h>
#include <libgwyddion/gradient.h>

G_BEGIN_DECLS

#define GWY_TYPE_GRADIENT_EDITOR            (gwy_gradient_editor_get_type())
#define GWY_GRADIENT_EDITOR(obj)            (G_TYPE_CHECK_INSTANCE_CAST((obj), GWY_TYPE_GRADIENT_EDITOR, GwyGradientEditor))
#define GWY_GRADIENT_EDITOR_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass), GWY_TYPE_GRADIENT_EDITOR, GwyGradientEditorClass))
#define GWY_IS_GRADIENT_EDITOR(obj)         (G_TYPE_CHECK_INSTANCE_TYPE((obj), GWY_TYPE_GRADIENT_EDITOR))
#define GWY_IS_GRADIENT_EDITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), GWY_TYPE_GRADIENT_EDITOR))
#define GWY_GRADIENT_EDITOR_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS((obj), GWY_TYPE_GRADIENT_EDITOR, GwyGradientEditorClass))

typedef struct _GwyGradientEditor        GwyGradientEditor;
typedef struct _GwyGradientEditorClass   GwyGradientEditorClass;
typedef struct _GwyGradientEditorPrivate GwyGradientEditorPrivate;

struct _GwyGradientEditor {
    GwyResourceEditor parent_instance;
    struct _GwyGradientEditorPrivate *priv;
};

struct _GwyGradientEditorClass {
    GwyResourceEditorClass parent_class;
};

GType gwy_gradient_editor_get_type(void)  G_GNUC_CONST;
void  gwy_app_gradient_editor     (void);

G_END_DECLS

#endif

/* vim: set cin columns=120 tw=118 et ts=4 sw=4 cino=>1s,e0,n0,f0,{0,}0,^0,\:1s,=0,g1s,h0,t0,+1s,c3,(0,u0 : */
