# Trace test data

## Trace golden tests

Trace tests can be generated by running

```
go generate .
```

with the relevant toolchain in this directory.

This will put the tests into a `tests` directory where the trace reader
tests will find them.

A subset of tests can be regenerated by specifying a regexp pattern for
the names of tests to generate in the `GOTRACETEST` environment
variable.
Test names are defined as the name of the `.go` file that generates the
trace, but with the `.go` extension removed.

## Trace test programs

The trace test programs in the `testprog` directory generate traces to
stdout.
Otherwise they're just normal programs.

## Trace debug commands

The `cmd` directory contains helpful tools for debugging traces.

* `gotraceraw` parses traces without validation.
  It can produce a text version of the trace wire format, or convert
  the text format back into bytes.
* `gotracevalidate` parses traces and validates them.
  It performs more rigorous checks than the parser does on its own,
  which helps for debugging the parser as well.
  In fact, it performs the exact same checks that the tests do.
