ITK Release 4.12
================

New Features

------------------------------------------------------------------------

-   Wrapping Improvements

` - Enable BridgeNumPy by default with Python wrapping`\
` - Build support for Microsoft Visual C++ Compiler for Python 2.7`\
` - BridgeNumpy integrates new pairs of functions. GetArrayViewFromImage() and GetImageViewFromArray() return views on the source object given as a parameter to the function. Memory is shared among input and output objects and the source object still manages pixel buffer memory. The existing functions GetArrayFromImage() and GetImageFromArray() perform a deep copy of the source object.`\
` - Similar NumPy bridge functions have been created for VNL matrices and VNL vectors.`\
` - Convenience functions imread() and imwrite() have been added to the Python itk namespace. These functions facilitate respectively reading and writing images using ITK without having to specify the input or output image component type. The naming of these functions follows the convention used in several other Python project such as scikit-learn and scipy.`\
` - Better integration in Jupyter Notebook: addressed tab completion bug for IPython >= 5.0.0, replaced underscore with ‘x’ to name attributes that start with a digit to show attributes when trying to autocomplete in IPython.`\
` - Wrap itkN4BiasFieldCorrectionImageFilter, NormalVariateGenerator, and PathToImageFilter.`\
` - Allows calling ImageFileWriter in Python with an ITK filter as input image argument.`\
` - Build Python wrapping with hidden visibility`

-   New Remote Modules

` - Strain`\
`   - Filters to estimate a strain tensor field from a displacement field or a spatial transformation`\
`   - `[`https://hdl.handle.net/10380/3573`](https://hdl.handle.net/10380/3573)

-   Core Improvements

` - Enable hidden visibility property with NIFTI and GIFTI static libraries`\
` - Fix clearing build tree error`\
` - Add examples and doc build flag support for external modules`\
` - Support for recent Clang in FreeBSD`\
` - Improved support for Visual Studio 2017`\
` - Prefer std::atomic over compiler specific implementation`

-   Filtering Improvements

` - Add OrientedBoudingBox attributes to ShapeLabelMap`\
` - Prefer std::atomic over compiler specific implementation`\
` - Skip generating export headers if module does not contain a target`\
` - Introduce ITK_WRAP_PYTHON_LEGACY to exclude older Python package layout`\
` - Move morphological watersheds out of ITKReview`\
` - Add SetReferenceImage to GenerateImageSource`\
` - Reduce memory usage of itkImagePCAShapeModelEstimator`\
` - Improvement of itkHistogram in order to make it faster`\
` - Better compatibility with OpenCVImageBridge`

-   IO Improvements

` - Improvement of palette image support for PNG, TIFF and BMP`

-   Documentation Improvements

` - Updates to the Software Guide, Doxygen, Wiki and Sphinx Examples`

-   Remote Module Updates

` - BridgeNumPy updated to latest upstream (04.28.2017)`

-   Third Party Library Updates

` - Update SWIG version to 3.0.12`\
` - Update PCRE version to 8.40`\
` - MetaIO updated to latest upstream (04.08.2017)`\
` - KWSys updated to latest upstream (04.20.2017)`\
` - KWIML updated to latest upstream (02.27.2017)`\
` - VNL updated to latest upstream (02.01.2017)`

-   Improved Code Coverage -- we are at 85.7%

` - Jon Haitz-Legarreta's extensive code coverage improvements`

Changes from v4.12rc03 to v4.12.0

------------------------------------------------------------------------

Bradley Lowekamp (1):

`     COMP: Inform Doxygen of ITK_FORCE_EXPORT_MACRO`

Francois Budin (2):

`     BUG: Remove weak symbol warnings on MacOS in VNL template classes`\
`     BUG: Replace class forward declaration attributes with ITK_FORWARD_EXPORT`

Hans Johnson (2):

`     COMP: Remove unused boiler plate constants`\
`     COMP:  Incorrect scope resolution for typename`

Jared Vicory (1):

`     BUG: Fix LBFGS crash when minimum is starting point.`

Matthew McCormick (6):

`     COMP: Use ITK_TEMPLATE_EXPORT in explicit export forward declarations`\
`     COMP: Suppress global weak symbol warnings for std::vector`\
`     COMP: Linux explicitly instantiated build errors`\
`     BUG: ITKIONIFTI DEPENDS on ITKNIFTI`\
`     BUG: Remove duplicate VectorContainer integer wrapping`\
`     BUG: Remove duplicate ImageSource Covariant Vector wrapping`

Vladimir S. FONOV (1):

`     MINC 2017-05-28 (002d510c)`

Changes from v4.12rc02 to v4.12rc03

------------------------------------------------------------------------

Bradley Lowekamp (4):

`     BUG: include HDF5 config in ITK config`\
`     BUG: Add fixed seed to registration tests`\
`     ENH: Use scikit-ci-addons for CiricleCI CMake installation and junit`\
`     BUG: Initialized the sampling seed for v3 registration test`

Francois Budin (1):

`     ENH: Remove 'weak symbol' warning on MacOS`

Matthew McCormick (5):

`     BUG: itk.ctype does not understand ints without signed`\
`     BUG: Rename WrapITKBuildOptionsPython.py to itkBuildOptions.py`\
`     DOC: Remove Doxygen note about GDCM version`\
`     BUG: Bump Bridge NumPy to address Windows long sizes`\
`     COMP: Suppress macOS std::string linker visibility warnings`

Vladimir S. FONOV (1):

`     MINC 2017-05-19 (f6853a70)`

Changes from v4.12rc01 to v4.12rc02

------------------------------------------------------------------------

Christina Rossmanith (1):

`     BUG: calculate levelSetValue for IsoContourFilter with float precision`

David T. Chen (1):

`     DOC: Fix Pysical Typo`

Francois Budin (3):

`     BUG: Remove doxygen warnings 'Found unknown command \epsilon'`\
`     ENH: Remove warning messages in GCC 5.1 due to ITK_TEMPLATE_EXPORT`\
`     BUG: GCC 5.1 warnings 'type attributes ignored after type is already defined'`

Jon Haitz Legarreta Gorroño (1):

`     DOC: Add use note to itkGridForwardWarpImageFilter.`

Matthew McCormick (1):

`     BUG: Update the Strain remote module to 2017-05-05`

Vladimir S. FONOV (3):

`     MINC 2017-04-28 (3d79acf3)`\
`     MINC 2017-05-01 (4caf8f4c)`\
`     MINC 2017-05-05 (cc682b52)`

Changes from v4.11.0 to v4.12rc01

------------------------------------------------------------------------

Ben Boeckel (1):

`     ENH: Add a script to help update third-party sources`

Brad King (5):

`     ENH: Update KWIML import script for new upstream URL`\
`     ENH: Teach update-third-party.bash to add a Change-Id`\
`     ENH: Port KWSys update script to update-third-party.bash`\
`     ENH: KWSys: Filter out unused attributes during import`\
`     ENH: KWSys: Apply attribute changes made upstream`

Bradley Lowekamp (19):

`     COMP: Enable hidden visibility property with NIFTI static libraries`\
`     COMP: Enable hidden visibility property with GIFTI static libraries`\
`     BUG: Correct variable name used to check CXX version`\
`     BUG: Correct variable name used to check CXX version`\
`     COMP: Enable hidden visibility property with NIFTI static libraries`\
`     COMP: Enable hidden visibility property with GIFTI static libraries`\
`     BUG: Initialize ConvergenceValue in constructor`\
`     BUG: Initialize ConvergenceValue in constructor`\
`     ENH: Update CircleCi script to download latest binary tar-ball`\
`     BUG: Use CMAKE_DL_LIBS instead of explict `“`dl`”` library`\
`     COMP: Fix CircleCI ITK data download file name`\
`     ENH: Update CircleCI yaml file`\
`     BUG: Apply changes from MetaIO upstream to remove static variables`\
`     ENH: Update SWIG version to 3.0.12`\
`     ENH: Update PCRE version to 8.40`\
`     ENH: Add OrientedBoudingBox attributes to ShapeLabelMap`\
`     COMP: Use std::abs over vnl_math_abs`\
`     BUG: Initialize image data to 0`\
`     ENH: Fix clearing build tree error`

David T. Chen (1):

`     BUG: Fixed quote style`

Dženan Zukić (3):

`     STYLE: Simplify code by using TestingMacros`\
`     BUG: fixing wrong check for argument count`\
`     ENH: Add Strain as a remote module`

Floris Berendsen (2):

`     COMP: Added missing png_get_uint_31 name mangling`\
`     COMP: Added missing png_get_uint_31 name mangling`

Francois Budin (58):

`     STYLE: Typo corrections in itk*TopHatImageFilter.h`\
`     ENH: Prefer std::atomic over compiler specific implementation`\
`     BUG: Addresses 'ordered comparison between pointer and zero' error (clang-4)`\
`     BUG: Addresses InDoxygenGroup Test with Python 3.6 failures`\
`     BUG: BSplineScatteredDataPointSetToImageFilter output image is not generated`\
`     BUG: itk::RGBPixel`<unsigned short>` needs to be wrapped for itkTIFFImageIO`\
`     BUG: Usage of std::atomic was incorrectly used in itk::Detail::AtomicOps`\
`     ENH: Exposing functions to set real and imaginary part of complex numbers`\
`     BUG: ITK_OVERRIDE  keyword for non-overriden funtion`\
`     BUG: 'typename' cannot be used outside of template declaration`\
`     BUG: Missing ITK_OVERRIDE`\
`     BUG: ITK_OVERRIDE  keyword for non-overriden funtion`\
`     BUG: ITK_OVERRIDE  keyword for non-overriden funtion`\
`     BUG: ITK_OVERRIDE  keyword for non-overriden funtion`\
`     BUG: Missing ITK_OVERRIDE`\
`     ENH: Improving usability in IPython`\
`     ENH: Update BridgeNumPy to most recent version (2017.02.24)`\
`     BUG: 3523 Even padding most value representations with space instead of '\0'`\
`     BUG: Remove extra space in chronometer command`\
`     DOC: Make it more explicit that 'push' authorization is not for everybody`\
`     BUG: 3523 Even padding most value representations with space instead of '\0'`\
`     BUG: 3519 KernelTransform WMatrix initialization`\
`     BUG: KWSys symbols should not be exported with WINDOWS_EXPORT_ALL_SYMBOLS`\
`     COMP: Do not expose functions to set real and img part of complex numbers`\
`     BUG: KWSys symbols should not be exported with WINDOWS_EXPORT_ALL_SYMBOLS`\
`     BUG: 3519 KernelTransform WMatrix initialization`\
`     DOC: Typo in itkNumberToString.h`\
`     BUG: Attribute names cannot start with a digit`\
`     BUG: Do not define deprecated function if ITK_LEGACY_REMOVE is selected`\
`     BUG: Wrap EllipseSpatialObject std::list in Python`\
`     ENH: Wrap itkN4BiasFieldCorrectionImageFilter in Python`\
`     BUG: itkStatisticsAlgorithmTest throwing exception on VS2015Update3 and VS2017`\
`     ENH: Skip generating export headers if module does not contain a target`\
`     BUG: Wrapping of itkHessianToObjectnessMeasureImageFilter moved out of Review`\
`     ENH: Update BridgeNumPy to most recent version (2017.03.27)`\
`     BUG: Wrapping of itkHessianToObjectnessMeasureImageFilter moved out of Review`\
`     BUG: Wrap EllipseSpatialObject std::list in Python`\
`     ENH: Improving usability in IPython`\
`     BUG: Attribute names cannot start with a digit`\
`     BUG: Do not export GDCM and Expat symbols with WINDOWS_EXPORT_ALL_SYMBOLS`\
`     BUG: Do not export all symbols from third party libraries on Windows`\
`     ENH: Allows to call ImageFileWriter in Python with Input=Filter`\
`     BUG: Certain third party libraries need to export their symbols on Windows`\
`     BUG: Test if 'issubclass' only if 'isclass' is True`\
`     ENH: Add Python convenience function to read images`\
`     BUG: 3475 AccumulateImageFilter not setting direction cosines of output image`\
`     DOC: Removing typos in itkExtractImageFilter comments`\
`     BUG: ProjectionImageFilter did not copy direction cosine information to output`\
`     BUG: Test if 'issubclass' only if 'isclass' is True`\
`     BUG: 3475 AccumulateImageFilter not setting direction cosines of output image`\
`     BUG: Do not export GDCM and Expat symbols with WINDOWS_EXPORT_ALL_SYMBOLS`\
`     BUG: Do not export all symbols from third party libraries on Windows`\
`     BUG: Certain third party libraries need to export their symbols on Windows`\
`     BUG: ProjectionImageFilter did not copy direction cosine information to output`\
`     ENH: Update BridgeNumPy (2016.04.28) and update itkExtras.py accordingly`\
`     BUG: Template type based input function parameter needs to be deterministic`\
`     ENH: Bump CMakeLists.txt version to 4.11.1`\
`     BUG: Problems due to ComputeOrientedBoundingBox in itkShapeLabelMapFilter`

Jean-Baptiste VIMORT (1):

`     PERF: Improvement of the itkHistogram class in order to make it faster`

Jean-Christophe Fillion-Robin (2):

`     ENH: Introduce ITK_WRAP_PYTHON_LEGACY to exclude older Python package layout`\
`     BUG: ITKPython: Do not install *.mdx files required only at generation time`

Johan Andruejol (1):

`     ENH: Add wrapping for PathToImageFilter`

Jon Haitz Legarreta (131):

`     ENH: Improve the itkFileListVideoIO coverage.`\
`     STYLE: Improve the BSplineScatteredDataPointSetToImageFilter style,`\
`     ENH: Improve the itkBSplineScatteredDataPointSetToImageFilter coverage.`\
`     ENH: Add missing ivars in function PrintSelf.`\
`     STYLE: Improve ImageNoise filters' style.`\
`     STYLE: Improve the ImageNoise filters tests' style.`\
`     STYLE: Improve ITKImageSources module filters' style.`\
`     STYLE: Improve the itkLinearInterpolateImageFunction style.`\
`     ENH: Improve the itkLabelOverlapMeasuresImageFilter coverage.`\
`     STYLE: Improve itkAdaptiveHistogramEqualizationImageFilter style.`\
`     ENH: Improve itkAdaptiveHistogramEqualizationImageFilter coverage.`\
`     STYLE: Improve itkKappaStatisticImageToImageMetric style.`\
`     ENH: Improve the itkKappaStatisticImageToImageMetric coverage.`\
`     STYLE: Improve itkBinaryGrindPeakImageFilter style.`\
`     STYLE: Improve the itkCannyEdgeDetectionImageFilter style.`\
`     ENH: Improve itkCannyEdgeDetectionImageFilter coverage.`\
`     ENH: Improve itkBarrier class coverage.`\
`     STYLE: Improve itkFlipImageFilterStyle.`\
`     STYLE: Improve itkSpatialObjectToPointSetFilter style.`\
`     STYLE: Improve itkStretchIntensityImageFilter style.`\
`     ENH: Print all ivars for itkStretchIntensityImageFilter.`\
`     ENH: Improve itkPhysicalPointImageSource class coverage.`\
`     ENH: Add missing ivars to LabelMapMaskImageFilter PrintSelf.`\
`     ENH: Improve itkRealTimeClock coverage.`\
`     STYLE: Improve the itkRealTimeClock style.`\
`     ENH: Improve itkBsplineDecompositionImageFilter coverage.`\
`     ENH: Improve itkTestingStretchIntensityImageFilter coverage.`\
`     STYLE: Improve itkPathToChainCodePathFilter style.`\
`     ENH: Add a Get method for itkPathToChainCodePathFilter ivar.`\
`     ENH: Add specific testing macro for boolean members.`\
`     STYLE: Improve itkLabelMapMaskImageFilter style.`\
`     STYLE: Improve BSplineDecompositionImageFilter style.`\
`     ENH: Finish itkAdaptiveHistogramEqualizationImageFilter PrintSelf.`\
`     COMP: Fix ImageGrid tests compiler warnings.`\
`     ENH: Finish BSplineDecompositionImageFilter PrintSelf.`\
`     BUG: Fix Uninitialized Memory errors reported by Valgrind.`\
`     ENH: Improve itkLabelMapMaskImageFilter coverage.`\
`     ENH: Improve itkBinaryGrindPeakImageFilter coverage.`\
`     ENH: Improve itkPathToChainCodePathFilter coverage.`\
`     ENH: Move LabelMap module test baselines.`\
`     ENH: Move BinaryMathMorphology test baselines out of review.`\
`     ENH: Move ImageFusion test baselines out of review.`\
`     ENH: Improve itkAutoCropLabelMapFilter tests.`\
`     ENH: Improve itkSpatialObjectToPointSetFilter coverage.`\
`     ENH: Move ImageLabel test baselines out of Review.`\
`     ENH: Move ImageGrid test baselines out of review.`\
`     STYLE: Improve itkGaussianSpatialFunction class' style.`\
`     ENH: Improve the ITKPath module classes coverage.`\
`     BUG: Fix BSplineDecompositionImageFilter Valgrind defects.`\
`     STYLE: Improve itkColorTable style.`\
`     ENH: Improve itkHoughTransform2DLinesImageFilter coverage.`\
`     ENH: Improve itkHoughTransform2DCirclesImageFilter coverage.`\
`     BUG: Address uninitialized variable defects.`\
`     STYLE: Improve itk::HistogramThresholdImageFilter style.`\
`     DOC: Fix a typo in the term `“`threshold`”`.`\
`     STYLE: Imporve itkContourSpatialObjectPoint style.`\
`     ENH: Print all HoughTransform2DLinesImageFilter ivars.`\
`     STYLE: Fix type in Optimizersv4 and Metricsv4 modules.`\
`     ENH: Add PhiLattice regression baseline.`\
`     ENH: Print all itkVoronoiDiagram2DGenerator ivars.`\
`     ENH: Improve itkColorTable coverage.`\
`     ENH: Improve the itk::GradientDescentOptimizerv4 style.`\
`     ENH: Improve the itkImageSources module's filters' coverage.`\
`     ENH: Add PhiLattice regression baseline.`\
`     ENH: Add a new test for itk::ContourSpatialObjectPoint.`\
`     BUG: Fix bug in itkContourSpatialObjectPointTest test.`\
`     STYLE: Improve the itkGaussianSpatialFunctionTest style.`\
`     ENH: Improve itkVotingBinaryHoleFillingImageFilter coverage.`\
`     BUG: Fix precision issues in itkGaborKernelFunctionTest.`\
`     BUG: Relax tolerance in itkGaborKernelFunctionTest.`\
`     DOC: Fix minor typo in itkHistogramThresholdImageFilter doc.`\
`     ENH: Print all ivars in GradientDescentOptimizer base classes.`\
`     STYLE: Improve TIFFImageIO tests.`\
`     ENH: Add Get methods for itk::BSplineDecompositionImageFilter ivars.`\
`     BUG: Fix TimeProbes name in itkLargeTIFFImageWriteReadTest.`\
`     BUG: Fix memory leaks in BMP and PNG tests.`\
`     COMP: Fix signed/unsigned mismatch warning.`\
`     COMP: Fix signed/unsigned mismatch warning.`\
`     BUG: Fix Superclass for ITKThresholding calculators.`\
`     BUG: Make the number of filters be an integer.`\
`     ENH: Honor the itkBooleanMacro for boolean class members.`\
`     ENH: Improve the Watershed module code coverage.`\
`     COMP: Fix double to unsigned int cast warning.`\
`     ENH: Improve coverage for MorphologicalWatersheds filters.`\
`     STYLE: Improve the Denoising module style.`\
`     BUG: Fix the itkPatchBasedDenoisingImageFilter RTTI Superclass name.`\
`     COMP: Fix unsigned char from double conversion warning.`\
`     ENH: Improve itkWatershedMiniPipelineProgressCommand coverage.`\
`     ENH: Improve the itkRegionalMin/Max filters member print types.`\
`     ENH: Improve the itkMorphologicalWatershedFromMarkers coverage.`\
`     ENH: Improve the itkIsolatedWatershedImageFilter coverage.`\
`     STYLE: Improve the Denoisinig module style.`\
`     STYLE: Improve the FEMRegistration module files style.`\
`     DOC: Fix itkOrientImageFilter UseImageDirection method doc typo.`\
`     STYLE: Improve the ITKThresholding module classes style.`\
`     BUG: Fix itkIsolatedWatershedImageFilterTest valgrind errors.`\
`     STYLE: Improve the itkApproximateSignedDistanceMapImageFilter style.`\
`     ENH: Improve Denoising module filters' coverage.`\
`     ENH: Improve the FEMRegistration module coverage.`\
`     STYLE: Improve the itkDisplacementFieldTransform class style.`\
`     STYLE: Limit itkFlipImageFilter methods' loops variables' scope.`\
`     ENH: Improve itkFlipImageFilter coverage.`\
`     COMP: Fix itkPhysicsBasedNonRigidRegistrationMethodTest cast warning.`\
`     STYLE: Improve the HessianToObjectnessMeasureImageFilter style.`\
`     ENH: Improve coverage for HessianToObjectnessMeasureImageFilter.`\
`     ENH: Improve DiscreteGaussianImage operators review classes' coverage.`\
`     ENH: Add test for itk::ConicShellInteriorExteriorSpatialFunction.`\
`     ENH: Print all itkHoughTransform2DCirclesImageFilter ivars.`\
`     ENH: Improve coverage for itk::DisplacementFieldTransform.`\
`     STYLE: Make itkPatchBasedDenoisingBaseImageFilter ivars private.`\
`     STYLE: Improve the itkRobustAutomaticThreshold classes style.`\
`     COMP: Fix itkDisplacementFieldTransformTest compiler warning.`\
`     STYLE: Improve the itkGridForwardWarpImageFilter style.`\
`     ENH: Improve coverage for itkGridForwardWarpImageFilter.`\
`     ENH: Improve coverage for itkRobustAutomaticThreshold classes.`\
`     ENH: Remove duplicate test files in Review.`\
`     DOC: Fix itkDivideByConstantImageFilter doc error.`\
`     STYLE: Improve exception message.`\
`     STYLE: Improve ImageIntensity module image arithm op tests' style.`\
`     STYLE: Improve HConc/Conv HMaxima/HMinima image filters' style.`\
`     ENH: Improve the HConc/HConv HMaxima/HMinima filters' coverage.`\
`     ENH: Improve DiscreteGaussianImage operators review classes' coverage.`\
`     ENH: Change the URL for the PCA remote module repo.`\
`     STYLE: Make flow control variables have a local scope.`\
`     ENH: Add examples and doc build flag support for external modules.`\
`     DOC: Remove wrong group tag for itk::QuadEdgeMeshExtendedTraits.`\
`     BUG: Fix itk::FastMarchingImageFilter RTTI superclass name.`\
`     STYLE: Improve the itk::NodePair class style.`\
`     STYLE: Use the ITK_MANUAL_INSTANTIATION macro consistently.`\
`     STYLE: Delete FastMarching module classes methods consistently.`\
`     DOC: Fix typo in the `“`implementation`”` word across the code.`

Jon Haitz Legarreta Gorroño (2):

`     STYLE: Improve itkWarpHarmonicEnergyCalculator style.`\
`     DOC: Add a notice to let users know about related implementations.`

KWIML Upstream (1):

`     KWIML 2017-02-27 (aa3a7733)`

KWSys Upstream (3):

`     KWSys 2016-11-21 (cb55cf5a)`\
`     KWSys 2017-03-28 (34999b6a)`\
`     KWSys 2017-04-20 (8785f84f)`

Matthew McCormick (40):

`     COMP: Add missing headers in OpenCVImageBridge`\
`     COMP: Use double for gradient calculations in MinMaxCurvatureFlow`\
`     ENH: Bump ITK version to 4.12.0.`\
`     COMP: Add VCL support for GCC 7`\
`     COMP: Define ITK_FALLTHROUGH for GCC 7`\
`     COMP: Add missing ITK_FALLTHROUGH in TiffImageIO`\
`     COMP: Avoid -Warray-bounds in FixedArray with GCC 7`\
`     COMP: Add ProcessObject include in itkLevelSetBase.hxx`\
`     ENH: Exclude Kitware Robot from third party update commit messages`\
`     BUG: Address tab completion with IPython >= 5.0.0`\
`     BUG: Do not use terminal_progress with the Jupyter Notebook`\
`     ENH: Enable BridgeNumPy with Python wrapping`\
`     COMP: Do not require numeric_traits::has_infinity`\
`     BUG: Fix passing _NO_TR1 definition with VS9 and Python`\
`     BUG: Do not tests that require NumPy when it is not available`\
`     ENH: Build Python wrapping with hidden visibility`\
`     ENH: Move morphological watersheds out of ITKReview`\
`     BUG: Do not upload top level folder in ArchiveTestingDataOnGirder.py`\
`     BUG: Remove unused content links from PNG test additions`\
`     ENH: Add .sha512 content links for IO pallette test data`\
`     BUG: Add missing export macros for SpatialObject forward declarations`\
`     BUG: Always wrap basic type RGBUC`\
`     COMP: Do not add Visual Studio numeric_traits workarounds with MinGWPy`\
`     COMP: Increase gold linker requirement to GCC 4.9.0`\
`     COMP: Detect Windows with _WIN32 in socket++/fork.cpp`\
`     BUG: Revert `“`BUG:`` ``Include`` ``installed`` ``modules`` ``in`` ``ITK_MODULES_ENABLED`”\
`     BUG: Set ${itk-module}_ENABLE_SHARED in ITKModuleExternal`\
`     BUG: PolyLineParametricPath must be loaded before PathToImageFilter`\
`     COMP: Address Python 2.7 Windows _hypot build errors`\
`     COMP: Undefine Py_hash_t when wrapping VtkGlue`\
`     ENH: Update BridgeNumPy to most recent version (2017.03.05)`\
`     BUG: Improve itkTemplate New compatibility with Python 3`\
`     ENH: Bump CastXML to 2017-04-18`\
`     STYLE: Remove empty or erroreous comments in ImageToImageFilter`\
`     ENH: Use itk.imread and itk.imwrite as standard function names`\
`     BUG: Correct size specification in ImportImageFilter::SetImportPointer`\
`     BUG: Improve large file support in MetaIO`\
`     ENH: Wrap itk::IdentifierType for ScalarToRGBColormapImageFilter`\
`     BUG: LevelSetNeighborhoodExtractor uses spacing`\
`     BUG: Fix PCRE 8.40 download URL`

MetaIO Maintainers (1):

`     MetaIO 2017-04-08 (dead6687)`

Olivier Commowick (1):

`     BUG: Correct ITK eigen system (was producing NaN or different values than VNL)`

Pablo Hernandez-Cerdan (4):

`     ENH: Add SetReferenceImage to GenerateImageSource.`\
`     ENH: Change the metadata of all outputs in GenerateImageSource.`\
`     BUG: Fix Normalization kernel step of ConvolutionImageFilter.`\
`     BUG: Remove call to Superclass::GenerateOutputInformation.`

Richard Beare (1):

`     DOC: PrincipleComponent flag incorrectly reported by PrintSelf`

Sam Horvath (1):

`     PERF: reduce memory usage of itkImagePCAShapeModelEstimator`

Samuel Gerber (2):

`     DOC: Added description to itkLBFGSOptimizerv4.h`\
`     DOC: LBFGSOptimizer doc update`

Shusil Dangi (2):

`     ENH: Ignores MacOS .DS_Store file`\
`     ENH: Wrap NormalVariateGenerator in the Statistics Module`

Simon Rit (2):

`     BUG: memory leak in ITK_USE_THREADPOOL`\
`     BUG: Join threads when using thread pool (ITK_USE_THREADPOOL)`

Taylor Braun-Jones (1):

`     COMP: Only include the headers for required OpenCV modules (fixup)`

VXL Maintainers (2):

`     VNL 2017-02-01 (ae6eff5e)`\
`     VNL 2017-02-08 (ae8eef13)`

Yann Le Poul (4):

`     ENH: improvement of palette image support for PNG TIFF and BMP.`\
`     STYLE: Misleading IsReadAsScalarPlusPalette Printing string`\
`     STYLE: ReadAsScalarPlusPalette info already printed in itkImageIOBase`\
`     BUG: ExpandRGBPalette used instead of IsReadAsScalarPlusPalette`

ITK Sphinx Examples Changes

------------------------------------------------------------------------

Beatriz Paniagua (1):

`     ENH: Add FlipImageFilter`

Dženan Zukić (3):

`     BUG: fixing misspelled directory name`\
`     ENH: translating ImageReadExtractFilterInsertWrite into Python`\
`     ENH: updating TODO list with recent patches`

Francois Budin (4):

`     BUG: Reducing Windows path length was not consistent`\
`     ENH: Import data into an ITK Image`\
`     BUG: Move FlipImageFilter from src/Core/Common to src/Filtering/ImageGrid`

Maeliss Jallais (1):

`     ENH: Add ReadWriteVectorImage`

Matt McCormick (32):

`     BUG: Clean up ObserveAnEvent`\
`     ENH: Add .sha512 content links`\
`     ENH: Remove .md5 content links`\
`     ENH: Update ExternalData_URL_TEMPLATES for sha512 resources`\
`     ENH: Update the ITKExamples scripts to use the .sha512 content links`\
`     ENH: Update CMake/ExternalData.cmake`\
`     ENH: Remove Utilities/UploadBinaryData.py.in`\
`     ENH: Remove Utilities/ArchiveBinaryData.py.in`\
`     ENH: Remove pydas and related submodules`\
`     ENH: Bump ITK to 2017-03-06 master`\
`     ENH: Use GitHub for faster ITK repository downloads`\
`     DOC: Update UploadBinaryData.rst`\
`     DOC: Tweak content link usage with girder-cli`\
`     DOC: Remove ContributeWithWebInterface.rst`\
`     DOC: Swap WriteANewExample / ContributeWithGit order`\
`     ENH: Do not build the Python wrapping in the Superbuild`\
`     ENH: Enable ITKExamples_USE_WRAP_PYTHON by default`\
`     ENH: Create itkpython virtualenv on Mac and Linux`\
`     STYLE: Do not uses spaces after/before brackets in CMakeLists.txt`\
`     ENH: Add the superbuild itkpython binary folder to FindSphinx`\
`     BUG: CreateNewExample.py outputs template Code.py`\
`     ENH: Download itkpython in the Windows superbuild`\
`     DOC: Recommend cloning into a short directory on Windows`\
`     ENH: Reduce Windows superbuild path length requirements`\
`     BUG: Fix BoundingBoxOfAPointSetTestPython on Windows`\
`     ENH: Add example image filenames in template figure directive`\
`     ENH: Add Create An Image example`\
`     BUG: CreateAImageRegion -> CreateAnImageRegion`\
`     BUG: Fix CreateAnImageRegion output regex matching`\
`     STYLE: Address spacing in CreateAnImage`\
`     BUG: Update the Python package URL, nightly to latest`\
`     DOC: How to run a Python example`

Max Smolens (5):

`     BUG: Fix errors in generated Code.py`\
`     ENH: Remove CannyEdgeDetectionImageFilter TODO items`\
`     ENH: Add itk.RGBToLuminanceImageFilter Python example`\
`     DOC: Fix typo in contribution documentation`\
`     ENH: Add WarpImageFilter example`

Neal Siekierski (1):

`     ENH: Add example of itk::Statistics::Histogram creation and access`

Sam Horvath (2):

`     ENH: Add CreateAnImageOfVectors`\
`     ENH: Add BlurringAnImageUsingABinomialKernel`

ITK Software Guide Changes

------------------------------------------------------------------------

Jon Haitz Legarreta (1):

`     DOC: Add testing section to SW guide.`

Matt McCormick (6):

`     DOC: Document itk_module_add_library`\
`     DOC: Modules without a src/ directory should not set ENABLE_SHARED`\
`     Merge `“`DOC:`` ``Add`` ``testing`` ``section`` ``to`` ``SW`` ``guide.`”\
`     DOC: Update the Kitware BrainWeb data link`\
`     BUG: Escape hash in Girder URL`\
`     DOC: Add Python package installation instructions`
