#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations
#    under the License.

"""add bios settings

Revision ID: 82c315d60161
Revises: e918ff30eb42
Create Date: 2017-10-11 14:56:47.813290

"""

from alembic import op
import sqlalchemy as sa

# revision identifiers, used by Alembic.
revision = '82c315d60161'
down_revision = 'e918ff30eb42'


def upgrade():
    op.create_table(
        'bios_settings',
        sa.Column('node_id', sa.Integer(), nullable=False),
        sa.Column('created_at', sa.DateTime(), nullable=True),
        sa.Column('updated_at', sa.DateTime(), nullable=True),
        sa.Column('name', sa.String(length=255), nullable=False),
        sa.Column('value', sa.Text(), nullable=True),
        sa.Column('version', sa.String(length=15), nullable=True),
        sa.ForeignKeyConstraint(['node_id'], ['nodes.id'], ),
        sa.PrimaryKeyConstraint('node_id', 'name'),
        mysql_engine='InnoDB',
        mysql_charset='UTF8MB3'
    )
