; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -asm-verbose=false < %s -mattr=+vfp3,+fp16 | FileCheck %s --check-prefixes=CHECK-ALL,CHECK-VFP,CHECK-FP16
; RUN: llc -asm-verbose=false < %s | FileCheck %s --check-prefixes=CHECK-ALL,CHECK-LIBCALL,CHECK-VFP,CHECK-LIBCALL-VFP
; RUN: llc -asm-verbose=false < %s -mattr=-fpregs | FileCheck %s --check-prefixes=CHECK-ALL,CHECK-LIBCALL,CHECK-NOVFP

target datalayout = "e-p:32:32:32-i1:8:8-i8:8:8-i16:16:16-i32:32:32-i64:64:64-f32:32:32-f64:64:64-v64:64:64-v128:128:128-a0:0:64-n32"
target triple = "armv7---eabihf"

define void @test_fadd(ptr %p, ptr %q) #0 {
; CHECK-FP16-LABEL: test_fadd:
; CHECK-FP16:         ldrh r2, [r0]
; CHECK-FP16-NEXT:    ldrh r1, [r1]
; CHECK-FP16-NEXT:    vmov s0, r2
; CHECK-FP16-NEXT:    vmov s2, r1
; CHECK-FP16-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-FP16-NEXT:    vcvtb.f32.f16 s2, s2
; CHECK-FP16-NEXT:    vadd.f32 s0, s0, s2
; CHECK-FP16-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-FP16-NEXT:    vmov r1, s0
; CHECK-FP16-NEXT:    strh r1, [r0]
; CHECK-FP16-NEXT:    bx lr
;
; CHECK-LIBCALL-VFP-LABEL: test_fadd:
; CHECK-LIBCALL-VFP:         .save {r4, lr}
; CHECK-LIBCALL-VFP-NEXT:    push {r4, lr}
; CHECK-LIBCALL-VFP-NEXT:    .vsave {d8}
; CHECK-LIBCALL-VFP-NEXT:    vpush {d8}
; CHECK-LIBCALL-VFP-NEXT:    mov r4, r0
; CHECK-LIBCALL-VFP-NEXT:    ldrh r0, [r1]
; CHECK-LIBCALL-VFP-NEXT:    bl __aeabi_h2f
; CHECK-LIBCALL-VFP-NEXT:    ldrh r1, [r4]
; CHECK-LIBCALL-VFP-NEXT:    vmov s16, r0
; CHECK-LIBCALL-VFP-NEXT:    mov r0, r1
; CHECK-LIBCALL-VFP-NEXT:    bl __aeabi_h2f
; CHECK-LIBCALL-VFP-NEXT:    vmov s0, r0
; CHECK-LIBCALL-VFP-NEXT:    vadd.f32 s0, s0, s16
; CHECK-LIBCALL-VFP-NEXT:    vmov r0, s0
; CHECK-LIBCALL-VFP-NEXT:    bl __aeabi_f2h
; CHECK-LIBCALL-VFP-NEXT:    strh r0, [r4]
; CHECK-LIBCALL-VFP-NEXT:    vpop {d8}
; CHECK-LIBCALL-VFP-NEXT:    pop {r4, pc}
;
; CHECK-NOVFP-LABEL: test_fadd:
; CHECK-NOVFP:         .save {r4, r5, r11, lr}
; CHECK-NOVFP-NEXT:    push {r4, r5, r11, lr}
; CHECK-NOVFP-NEXT:    mov r4, r0
; CHECK-NOVFP-NEXT:    ldrh r0, [r1]
; CHECK-NOVFP-NEXT:    bl __aeabi_h2f
; CHECK-NOVFP-NEXT:    mov r5, r0
; CHECK-NOVFP-NEXT:    ldrh r0, [r4]
; CHECK-NOVFP-NEXT:    bl __aeabi_h2f
; CHECK-NOVFP-NEXT:    mov r1, r5
; CHECK-NOVFP-NEXT:    bl __aeabi_fadd
; CHECK-NOVFP-NEXT:    bl __aeabi_f2h
; CHECK-NOVFP-NEXT:    strh r0, [r4]
; CHECK-NOVFP-NEXT:    pop {r4, r5, r11, pc}
  %a = load half, ptr %p, align 2
  %b = load half, ptr %q, align 2
  %r = fadd half %a, %b
  store half %r, ptr %p
  ret void
}

define void @test_fsub(ptr %p, ptr %q) #0 {
; CHECK-FP16-LABEL: test_fsub:
; CHECK-FP16:         ldrh r2, [r0]
; CHECK-FP16-NEXT:    ldrh r1, [r1]
; CHECK-FP16-NEXT:    vmov s0, r2
; CHECK-FP16-NEXT:    vmov s2, r1
; CHECK-FP16-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-FP16-NEXT:    vcvtb.f32.f16 s2, s2
; CHECK-FP16-NEXT:    vsub.f32 s0, s0, s2
; CHECK-FP16-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-FP16-NEXT:    vmov r1, s0
; CHECK-FP16-NEXT:    strh r1, [r0]
; CHECK-FP16-NEXT:    bx lr
;
; CHECK-LIBCALL-VFP-LABEL: test_fsub:
; CHECK-LIBCALL-VFP:         .save {r4, lr}
; CHECK-LIBCALL-VFP-NEXT:    push {r4, lr}
; CHECK-LIBCALL-VFP-NEXT:    .vsave {d8}
; CHECK-LIBCALL-VFP-NEXT:    vpush {d8}
; CHECK-LIBCALL-VFP-NEXT:    mov r4, r0
; CHECK-LIBCALL-VFP-NEXT:    ldrh r0, [r1]
; CHECK-LIBCALL-VFP-NEXT:    bl __aeabi_h2f
; CHECK-LIBCALL-VFP-NEXT:    ldrh r1, [r4]
; CHECK-LIBCALL-VFP-NEXT:    vmov s16, r0
; CHECK-LIBCALL-VFP-NEXT:    mov r0, r1
; CHECK-LIBCALL-VFP-NEXT:    bl __aeabi_h2f
; CHECK-LIBCALL-VFP-NEXT:    vmov s0, r0
; CHECK-LIBCALL-VFP-NEXT:    vsub.f32 s0, s0, s16
; CHECK-LIBCALL-VFP-NEXT:    vmov r0, s0
; CHECK-LIBCALL-VFP-NEXT:    bl __aeabi_f2h
; CHECK-LIBCALL-VFP-NEXT:    strh r0, [r4]
; CHECK-LIBCALL-VFP-NEXT:    vpop {d8}
; CHECK-LIBCALL-VFP-NEXT:    pop {r4, pc}
;
; CHECK-NOVFP-LABEL: test_fsub:
; CHECK-NOVFP:         .save {r4, r5, r11, lr}
; CHECK-NOVFP-NEXT:    push {r4, r5, r11, lr}
; CHECK-NOVFP-NEXT:    mov r4, r0
; CHECK-NOVFP-NEXT:    ldrh r0, [r1]
; CHECK-NOVFP-NEXT:    bl __aeabi_h2f
; CHECK-NOVFP-NEXT:    mov r5, r0
; CHECK-NOVFP-NEXT:    ldrh r0, [r4]
; CHECK-NOVFP-NEXT:    bl __aeabi_h2f
; CHECK-NOVFP-NEXT:    mov r1, r5
; CHECK-NOVFP-NEXT:    bl __aeabi_fsub
; CHECK-NOVFP-NEXT:    bl __aeabi_f2h
; CHECK-NOVFP-NEXT:    strh r0, [r4]
; CHECK-NOVFP-NEXT:    pop {r4, r5, r11, pc}
  %a = load half, ptr %p, align 2
  %b = load half, ptr %q, align 2
  %r = fsub half %a, %b
  store half %r, ptr %p
  ret void
}

define void @test_fmul(ptr %p, ptr %q) #0 {
; CHECK-FP16-LABEL: test_fmul:
; CHECK-FP16:         ldrh r2, [r0]
; CHECK-FP16-NEXT:    ldrh r1, [r1]
; CHECK-FP16-NEXT:    vmov s0, r2
; CHECK-FP16-NEXT:    vmov s2, r1
; CHECK-FP16-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-FP16-NEXT:    vcvtb.f32.f16 s2, s2
; CHECK-FP16-NEXT:    vmul.f32 s0, s0, s2
; CHECK-FP16-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-FP16-NEXT:    vmov r1, s0
; CHECK-FP16-NEXT:    strh r1, [r0]
; CHECK-FP16-NEXT:    bx lr
;
; CHECK-LIBCALL-VFP-LABEL: test_fmul:
; CHECK-LIBCALL-VFP:         .save {r4, lr}
; CHECK-LIBCALL-VFP-NEXT:    push {r4, lr}
; CHECK-LIBCALL-VFP-NEXT:    .vsave {d8}
; CHECK-LIBCALL-VFP-NEXT:    vpush {d8}
; CHECK-LIBCALL-VFP-NEXT:    mov r4, r0
; CHECK-LIBCALL-VFP-NEXT:    ldrh r0, [r1]
; CHECK-LIBCALL-VFP-NEXT:    bl __aeabi_h2f
; CHECK-LIBCALL-VFP-NEXT:    ldrh r1, [r4]
; CHECK-LIBCALL-VFP-NEXT:    vmov s16, r0
; CHECK-LIBCALL-VFP-NEXT:    mov r0, r1
; CHECK-LIBCALL-VFP-NEXT:    bl __aeabi_h2f
; CHECK-LIBCALL-VFP-NEXT:    vmov s0, r0
; CHECK-LIBCALL-VFP-NEXT:    vmul.f32 s0, s0, s16
; CHECK-LIBCALL-VFP-NEXT:    vmov r0, s0
; CHECK-LIBCALL-VFP-NEXT:    bl __aeabi_f2h
; CHECK-LIBCALL-VFP-NEXT:    strh r0, [r4]
; CHECK-LIBCALL-VFP-NEXT:    vpop {d8}
; CHECK-LIBCALL-VFP-NEXT:    pop {r4, pc}
;
; CHECK-NOVFP-LABEL: test_fmul:
; CHECK-NOVFP:         .save {r4, r5, r11, lr}
; CHECK-NOVFP-NEXT:    push {r4, r5, r11, lr}
; CHECK-NOVFP-NEXT:    mov r4, r0
; CHECK-NOVFP-NEXT:    ldrh r0, [r1]
; CHECK-NOVFP-NEXT:    bl __aeabi_h2f
; CHECK-NOVFP-NEXT:    mov r5, r0
; CHECK-NOVFP-NEXT:    ldrh r0, [r4]
; CHECK-NOVFP-NEXT:    bl __aeabi_h2f
; CHECK-NOVFP-NEXT:    mov r1, r5
; CHECK-NOVFP-NEXT:    bl __aeabi_fmul
; CHECK-NOVFP-NEXT:    bl __aeabi_f2h
; CHECK-NOVFP-NEXT:    strh r0, [r4]
; CHECK-NOVFP-NEXT:    pop {r4, r5, r11, pc}
  %a = load half, ptr %p, align 2
  %b = load half, ptr %q, align 2
  %r = fmul half %a, %b
  store half %r, ptr %p
  ret void
}

define void @test_fdiv(ptr %p, ptr %q) #0 {
; CHECK-FP16-LABEL: test_fdiv:
; CHECK-FP16:         ldrh r2, [r0]
; CHECK-FP16-NEXT:    ldrh r1, [r1]
; CHECK-FP16-NEXT:    vmov s0, r2
; CHECK-FP16-NEXT:    vmov s2, r1
; CHECK-FP16-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-FP16-NEXT:    vcvtb.f32.f16 s2, s2
; CHECK-FP16-NEXT:    vdiv.f32 s0, s0, s2
; CHECK-FP16-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-FP16-NEXT:    vmov r1, s0
; CHECK-FP16-NEXT:    strh r1, [r0]
; CHECK-FP16-NEXT:    bx lr
;
; CHECK-LIBCALL-VFP-LABEL: test_fdiv:
; CHECK-LIBCALL-VFP:         .save {r4, lr}
; CHECK-LIBCALL-VFP-NEXT:    push {r4, lr}
; CHECK-LIBCALL-VFP-NEXT:    .vsave {d8}
; CHECK-LIBCALL-VFP-NEXT:    vpush {d8}
; CHECK-LIBCALL-VFP-NEXT:    mov r4, r0
; CHECK-LIBCALL-VFP-NEXT:    ldrh r0, [r1]
; CHECK-LIBCALL-VFP-NEXT:    bl __aeabi_h2f
; CHECK-LIBCALL-VFP-NEXT:    ldrh r1, [r4]
; CHECK-LIBCALL-VFP-NEXT:    vmov s16, r0
; CHECK-LIBCALL-VFP-NEXT:    mov r0, r1
; CHECK-LIBCALL-VFP-NEXT:    bl __aeabi_h2f
; CHECK-LIBCALL-VFP-NEXT:    vmov s0, r0
; CHECK-LIBCALL-VFP-NEXT:    vdiv.f32 s0, s0, s16
; CHECK-LIBCALL-VFP-NEXT:    vmov r0, s0
; CHECK-LIBCALL-VFP-NEXT:    bl __aeabi_f2h
; CHECK-LIBCALL-VFP-NEXT:    strh r0, [r4]
; CHECK-LIBCALL-VFP-NEXT:    vpop {d8}
; CHECK-LIBCALL-VFP-NEXT:    pop {r4, pc}
;
; CHECK-NOVFP-LABEL: test_fdiv:
; CHECK-NOVFP:         .save {r4, r5, r11, lr}
; CHECK-NOVFP-NEXT:    push {r4, r5, r11, lr}
; CHECK-NOVFP-NEXT:    mov r4, r0
; CHECK-NOVFP-NEXT:    ldrh r0, [r1]
; CHECK-NOVFP-NEXT:    bl __aeabi_h2f
; CHECK-NOVFP-NEXT:    mov r5, r0
; CHECK-NOVFP-NEXT:    ldrh r0, [r4]
; CHECK-NOVFP-NEXT:    bl __aeabi_h2f
; CHECK-NOVFP-NEXT:    mov r1, r5
; CHECK-NOVFP-NEXT:    bl __aeabi_fdiv
; CHECK-NOVFP-NEXT:    bl __aeabi_f2h
; CHECK-NOVFP-NEXT:    strh r0, [r4]
; CHECK-NOVFP-NEXT:    pop {r4, r5, r11, pc}
  %a = load half, ptr %p, align 2
  %b = load half, ptr %q, align 2
  %r = fdiv half %a, %b
  store half %r, ptr %p
  ret void
}

define void @test_frem(ptr %p, ptr %q) #0 {
; CHECK-FP16-LABEL: test_frem:
; CHECK-FP16:         .save {r4, lr}
; CHECK-FP16-NEXT:    push {r4, lr}
; CHECK-FP16-NEXT:    mov r4, r0
; CHECK-FP16-NEXT:    ldrh r0, [r0]
; CHECK-FP16-NEXT:    ldrh r1, [r1]
; CHECK-FP16-NEXT:    vmov s0, r0
; CHECK-FP16-NEXT:    vmov s2, r1
; CHECK-FP16-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-FP16-NEXT:    vcvtb.f32.f16 s1, s2
; CHECK-FP16-NEXT:    bl fmodf
; CHECK-FP16-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-FP16-NEXT:    vmov r0, s0
; CHECK-FP16-NEXT:    strh r0, [r4]
; CHECK-FP16-NEXT:    pop {r4, pc}
;
; CHECK-LIBCALL-VFP-LABEL: test_frem:
; CHECK-LIBCALL-VFP:         .save {r4, r5, r11, lr}
; CHECK-LIBCALL-VFP-NEXT:    push {r4, r5, r11, lr}
; CHECK-LIBCALL-VFP-NEXT:    mov r4, r0
; CHECK-LIBCALL-VFP-NEXT:    ldrh r0, [r1]
; CHECK-LIBCALL-VFP-NEXT:    bl __aeabi_h2f
; CHECK-LIBCALL-VFP-NEXT:    mov r5, r0
; CHECK-LIBCALL-VFP-NEXT:    ldrh r0, [r4]
; CHECK-LIBCALL-VFP-NEXT:    bl __aeabi_h2f
; CHECK-LIBCALL-VFP-NEXT:    vmov s0, r0
; CHECK-LIBCALL-VFP-NEXT:    vmov s1, r5
; CHECK-LIBCALL-VFP-NEXT:    bl fmodf
; CHECK-LIBCALL-VFP-NEXT:    vmov r0, s0
; CHECK-LIBCALL-VFP-NEXT:    bl __aeabi_f2h
; CHECK-LIBCALL-VFP-NEXT:    strh r0, [r4]
; CHECK-LIBCALL-VFP-NEXT:    pop {r4, r5, r11, pc}
;
; CHECK-NOVFP-LABEL: test_frem:
; CHECK-NOVFP:         .save {r4, r5, r11, lr}
; CHECK-NOVFP-NEXT:    push {r4, r5, r11, lr}
; CHECK-NOVFP-NEXT:    mov r4, r0
; CHECK-NOVFP-NEXT:    ldrh r0, [r1]
; CHECK-NOVFP-NEXT:    bl __aeabi_h2f
; CHECK-NOVFP-NEXT:    mov r5, r0
; CHECK-NOVFP-NEXT:    ldrh r0, [r4]
; CHECK-NOVFP-NEXT:    bl __aeabi_h2f
; CHECK-NOVFP-NEXT:    mov r1, r5
; CHECK-NOVFP-NEXT:    bl fmodf
; CHECK-NOVFP-NEXT:    bl __aeabi_f2h
; CHECK-NOVFP-NEXT:    strh r0, [r4]
; CHECK-NOVFP-NEXT:    pop {r4, r5, r11, pc}
  %a = load half, ptr %p, align 2
  %b = load half, ptr %q, align 2
  %r = frem half %a, %b
  store half %r, ptr %p
  ret void
}

define void @test_load_store(ptr %p, ptr %q) #0 {
; CHECK-ALL-LABEL: test_load_store:
; CHECK-ALL:         ldrh r0, [r0]
; CHECK-ALL-NEXT:    strh r0, [r1]
; CHECK-ALL-NEXT:    bx lr
  %a = load half, ptr %p, align 2
  store half %a, ptr %q
  ret void
}

; Testing only successfull compilation of function calls.  In ARM ABI, half
; args and returns are handled as f32.

declare half @test_callee(half %a, half %b) #0

define half @test_call(half %a, half %b) #0 {
; CHECK-ALL-LABEL: test_call:
; CHECK-ALL:         .save {r11, lr}
; CHECK-ALL-NEXT:    push {r11, lr}
; CHECK-ALL-NEXT:    bl test_callee
; CHECK-ALL-NEXT:    pop {r11, pc}
  %r = call half @test_callee(half %a, half %b)
  ret half %r
}

define half @test_call_flipped(half %a, half %b) #0 {
; CHECK-VFP-LABEL: test_call_flipped:
; CHECK-VFP:         .save {r11, lr}
; CHECK-VFP-NEXT:    push {r11, lr}
; CHECK-VFP-NEXT:    vmov.f32 s2, s0
; CHECK-VFP-NEXT:    vmov.f32 s0, s1
; CHECK-VFP-NEXT:    vmov.f32 s1, s2
; CHECK-VFP-NEXT:    bl test_callee
; CHECK-VFP-NEXT:    pop {r11, pc}
;
; CHECK-NOVFP-LABEL: test_call_flipped:
; CHECK-NOVFP:         .save {r11, lr}
; CHECK-NOVFP-NEXT:    push {r11, lr}
; CHECK-NOVFP-NEXT:    mov r2, r0
; CHECK-NOVFP-NEXT:    mov r0, r1
; CHECK-NOVFP-NEXT:    mov r1, r2
; CHECK-NOVFP-NEXT:    bl test_callee
; CHECK-NOVFP-NEXT:    pop {r11, pc}
  %r = call half @test_callee(half %b, half %a)
  ret half %r
}

define half @test_tailcall_flipped(half %a, half %b) #0 {
; CHECK-VFP-LABEL: test_tailcall_flipped:
; CHECK-VFP:         vmov.f32 s2, s0
; CHECK-VFP-NEXT:    vmov.f32 s0, s1
; CHECK-VFP-NEXT:    vmov.f32 s1, s2
; CHECK-VFP-NEXT:    b test_callee
;
; CHECK-NOVFP-LABEL: test_tailcall_flipped:
; CHECK-NOVFP:         mov r2, r0
; CHECK-NOVFP-NEXT:    mov r0, r1
; CHECK-NOVFP-NEXT:    mov r1, r2
; CHECK-NOVFP-NEXT:    b test_callee
  %r = tail call half @test_callee(half %b, half %a)
  ret half %r
}

; Optimizer picks %p or %q based on %c and only loads that value
; No conversion is needed
define void @test_select(ptr %p, ptr %q, i1 zeroext %c) #0 {
; CHECK-ALL-LABEL: test_select:
; CHECK-ALL:         cmp r2, #0
; CHECK-ALL-NEXT:    movne r1, r0
; CHECK-ALL-NEXT:    ldrh r1, [r1]
; CHECK-ALL-NEXT:    strh r1, [r0]
; CHECK-ALL-NEXT:    bx lr
  %a = load half, ptr %p, align 2
  %b = load half, ptr %q, align 2
  %r = select i1 %c, half %a, half %b
  store half %r, ptr %p
  ret void
}

; Test only two variants of fcmp.  These get translated to f32 vcmp
; instructions anyway.
define i1 @test_fcmp_une(ptr %p, ptr %q) #0 {
; CHECK-FP16-LABEL: test_fcmp_une:
; CHECK-FP16:         ldrh r2, [r0]
; CHECK-FP16-NEXT:    mov r0, #0
; CHECK-FP16-NEXT:    ldrh r1, [r1]
; CHECK-FP16-NEXT:    vmov s0, r2
; CHECK-FP16-NEXT:    vmov s2, r1
; CHECK-FP16-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-FP16-NEXT:    vcvtb.f32.f16 s2, s2
; CHECK-FP16-NEXT:    vcmp.f32 s0, s2
; CHECK-FP16-NEXT:    vmrs APSR_nzcv, fpscr
; CHECK-FP16-NEXT:    movwne r0, #1
; CHECK-FP16-NEXT:    bx lr
;
; CHECK-LIBCALL-VFP-LABEL: test_fcmp_une:
; CHECK-LIBCALL-VFP:         .save {r4, lr}
; CHECK-LIBCALL-VFP-NEXT:    push {r4, lr}
; CHECK-LIBCALL-VFP-NEXT:    .vsave {d8}
; CHECK-LIBCALL-VFP-NEXT:    vpush {d8}
; CHECK-LIBCALL-VFP-NEXT:    mov r4, r0
; CHECK-LIBCALL-VFP-NEXT:    ldrh r0, [r1]
; CHECK-LIBCALL-VFP-NEXT:    bl __aeabi_h2f
; CHECK-LIBCALL-VFP-NEXT:    ldrh r1, [r4]
; CHECK-LIBCALL-VFP-NEXT:    vmov s16, r0
; CHECK-LIBCALL-VFP-NEXT:    mov r0, r1
; CHECK-LIBCALL-VFP-NEXT:    bl __aeabi_h2f
; CHECK-LIBCALL-VFP-NEXT:    vmov s0, r0
; CHECK-LIBCALL-VFP-NEXT:    mov r0, #0
; CHECK-LIBCALL-VFP-NEXT:    vcmp.f32 s0, s16
; CHECK-LIBCALL-VFP-NEXT:    vmrs APSR_nzcv, fpscr
; CHECK-LIBCALL-VFP-NEXT:    movwne r0, #1
; CHECK-LIBCALL-VFP-NEXT:    vpop {d8}
; CHECK-LIBCALL-VFP-NEXT:    pop {r4, pc}
;
; CHECK-NOVFP-LABEL: test_fcmp_une:
; CHECK-NOVFP:         .save {r4, r5, r11, lr}
; CHECK-NOVFP-NEXT:    push {r4, r5, r11, lr}
; CHECK-NOVFP-NEXT:    mov r4, r0
; CHECK-NOVFP-NEXT:    ldrh r0, [r1]
; CHECK-NOVFP-NEXT:    bl __aeabi_h2f
; CHECK-NOVFP-NEXT:    mov r5, r0
; CHECK-NOVFP-NEXT:    ldrh r0, [r4]
; CHECK-NOVFP-NEXT:    bl __aeabi_h2f
; CHECK-NOVFP-NEXT:    mov r1, r5
; CHECK-NOVFP-NEXT:    bl __aeabi_fcmpeq
; CHECK-NOVFP-NEXT:    clz r0, r0
; CHECK-NOVFP-NEXT:    lsr r0, r0, #5
; CHECK-NOVFP-NEXT:    pop {r4, r5, r11, pc}
  %a = load half, ptr %p, align 2
  %b = load half, ptr %q, align 2
  %r = fcmp une half %a, %b
  ret i1 %r
}

define i1 @test_fcmp_ueq(ptr %p, ptr %q) #0 {
; CHECK-FP16-LABEL: test_fcmp_ueq:
; CHECK-FP16:         ldrh r2, [r0]
; CHECK-FP16-NEXT:    mov r0, #0
; CHECK-FP16-NEXT:    ldrh r1, [r1]
; CHECK-FP16-NEXT:    vmov s0, r2
; CHECK-FP16-NEXT:    vmov s2, r1
; CHECK-FP16-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-FP16-NEXT:    vcvtb.f32.f16 s2, s2
; CHECK-FP16-NEXT:    vcmp.f32 s0, s2
; CHECK-FP16-NEXT:    vmrs APSR_nzcv, fpscr
; CHECK-FP16-NEXT:    movweq r0, #1
; CHECK-FP16-NEXT:    movwvs r0, #1
; CHECK-FP16-NEXT:    bx lr
;
; CHECK-LIBCALL-VFP-LABEL: test_fcmp_ueq:
; CHECK-LIBCALL-VFP:         .save {r4, lr}
; CHECK-LIBCALL-VFP-NEXT:    push {r4, lr}
; CHECK-LIBCALL-VFP-NEXT:    .vsave {d8}
; CHECK-LIBCALL-VFP-NEXT:    vpush {d8}
; CHECK-LIBCALL-VFP-NEXT:    mov r4, r0
; CHECK-LIBCALL-VFP-NEXT:    ldrh r0, [r1]
; CHECK-LIBCALL-VFP-NEXT:    bl __aeabi_h2f
; CHECK-LIBCALL-VFP-NEXT:    ldrh r1, [r4]
; CHECK-LIBCALL-VFP-NEXT:    vmov s16, r0
; CHECK-LIBCALL-VFP-NEXT:    mov r0, r1
; CHECK-LIBCALL-VFP-NEXT:    bl __aeabi_h2f
; CHECK-LIBCALL-VFP-NEXT:    vmov s0, r0
; CHECK-LIBCALL-VFP-NEXT:    mov r0, #0
; CHECK-LIBCALL-VFP-NEXT:    vcmp.f32 s0, s16
; CHECK-LIBCALL-VFP-NEXT:    vmrs APSR_nzcv, fpscr
; CHECK-LIBCALL-VFP-NEXT:    movweq r0, #1
; CHECK-LIBCALL-VFP-NEXT:    movwvs r0, #1
; CHECK-LIBCALL-VFP-NEXT:    vpop {d8}
; CHECK-LIBCALL-VFP-NEXT:    pop {r4, pc}
;
; CHECK-NOVFP-LABEL: test_fcmp_ueq:
; CHECK-NOVFP:         .save {r4, r5, r6, lr}
; CHECK-NOVFP-NEXT:    push {r4, r5, r6, lr}
; CHECK-NOVFP-NEXT:    mov r4, r0
; CHECK-NOVFP-NEXT:    ldrh r0, [r1]
; CHECK-NOVFP-NEXT:    bl __aeabi_h2f
; CHECK-NOVFP-NEXT:    mov r5, r0
; CHECK-NOVFP-NEXT:    ldrh r0, [r4]
; CHECK-NOVFP-NEXT:    bl __aeabi_h2f
; CHECK-NOVFP-NEXT:    mov r1, r5
; CHECK-NOVFP-NEXT:    mov r4, r0
; CHECK-NOVFP-NEXT:    bl __aeabi_fcmpeq
; CHECK-NOVFP-NEXT:    mov r6, r0
; CHECK-NOVFP-NEXT:    mov r0, r4
; CHECK-NOVFP-NEXT:    mov r1, r5
; CHECK-NOVFP-NEXT:    bl __aeabi_fcmpun
; CHECK-NOVFP-NEXT:    orrs r0, r0, r6
; CHECK-NOVFP-NEXT:    movwne r0, #1
; CHECK-NOVFP-NEXT:    pop {r4, r5, r6, pc}
  %a = load half, ptr %p, align 2
  %b = load half, ptr %q, align 2
  %r = fcmp ueq half %a, %b
  ret i1 %r
}

define void @test_br_cc(ptr %p, ptr %q, ptr %p1, ptr %p2) #0 {
; CHECK-FP16-LABEL: test_br_cc:
; CHECK-FP16:         ldrh r0, [r0]
; CHECK-FP16-NEXT:    ldrh r1, [r1]
; CHECK-FP16-NEXT:    vmov s0, r0
; CHECK-FP16-NEXT:    mov r0, #0
; CHECK-FP16-NEXT:    vmov s2, r1
; CHECK-FP16-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-FP16-NEXT:    vcvtb.f32.f16 s2, s2
; CHECK-FP16-NEXT:    vcmp.f32 s0, s2
; CHECK-FP16-NEXT:    vmrs APSR_nzcv, fpscr
; CHECK-FP16-NEXT:    movmi r2, r3
; CHECK-FP16-NEXT:    str r0, [r2]
; CHECK-FP16-NEXT:    bx lr
;
; CHECK-LIBCALL-VFP-LABEL: test_br_cc:
; CHECK-LIBCALL-VFP:         .save {r4, r5, r6, lr}
; CHECK-LIBCALL-VFP-NEXT:    push {r4, r5, r6, lr}
; CHECK-LIBCALL-VFP-NEXT:    .vsave {d8}
; CHECK-LIBCALL-VFP-NEXT:    vpush {d8}
; CHECK-LIBCALL-VFP-NEXT:    mov r6, r0
; CHECK-LIBCALL-VFP-NEXT:    ldrh r0, [r1]
; CHECK-LIBCALL-VFP-NEXT:    mov r4, r3
; CHECK-LIBCALL-VFP-NEXT:    mov r5, r2
; CHECK-LIBCALL-VFP-NEXT:    bl __aeabi_h2f
; CHECK-LIBCALL-VFP-NEXT:    ldrh r1, [r6]
; CHECK-LIBCALL-VFP-NEXT:    vmov s16, r0
; CHECK-LIBCALL-VFP-NEXT:    mov r0, r1
; CHECK-LIBCALL-VFP-NEXT:    bl __aeabi_h2f
; CHECK-LIBCALL-VFP-NEXT:    vmov s0, r0
; CHECK-LIBCALL-VFP-NEXT:    mov r0, #0
; CHECK-LIBCALL-VFP-NEXT:    vcmp.f32 s0, s16
; CHECK-LIBCALL-VFP-NEXT:    vmrs APSR_nzcv, fpscr
; CHECK-LIBCALL-VFP-NEXT:    movmi r5, r4
; CHECK-LIBCALL-VFP-NEXT:    str r0, [r5]
; CHECK-LIBCALL-VFP-NEXT:    vpop {d8}
; CHECK-LIBCALL-VFP-NEXT:    pop {r4, r5, r6, pc}
;
; CHECK-NOVFP-LABEL: test_br_cc:
; CHECK-NOVFP:         .save {r4, r5, r6, r7, r11, lr}
; CHECK-NOVFP-NEXT:    push {r4, r5, r6, r7, r11, lr}
; CHECK-NOVFP-NEXT:    mov r6, r0
; CHECK-NOVFP-NEXT:    ldrh r0, [r1]
; CHECK-NOVFP-NEXT:    mov r4, r3
; CHECK-NOVFP-NEXT:    mov r5, r2
; CHECK-NOVFP-NEXT:    bl __aeabi_h2f
; CHECK-NOVFP-NEXT:    mov r7, r0
; CHECK-NOVFP-NEXT:    ldrh r0, [r6]
; CHECK-NOVFP-NEXT:    bl __aeabi_h2f
; CHECK-NOVFP-NEXT:    mov r1, r7
; CHECK-NOVFP-NEXT:    bl __aeabi_fcmplt
; CHECK-NOVFP-NEXT:    cmp r0, #0
; CHECK-NOVFP-NEXT:    mov r0, #0
; CHECK-NOVFP-NEXT:    movne r5, r4
; CHECK-NOVFP-NEXT:    str r0, [r5]
; CHECK-NOVFP-NEXT:    pop {r4, r5, r6, r7, r11, pc}
  %a = load half, ptr %p, align 2
  %b = load half, ptr %q, align 2
  %c = fcmp uge half %a, %b
  br i1 %c, label %then, label %else
then:
  store i32 0, ptr %p1
  ret void
else:
  store i32 0, ptr %p2
  ret void
}

declare i1 @test_dummy(ptr %p) #0

define void @test_phi(ptr %p) #0 {
; CHECK-VFP-LABEL: test_phi:
; CHECK-VFP:         .save {r4, r5, r6, lr}
; CHECK-VFP-NEXT:    push {r4, r5, r6, lr}
; CHECK-VFP-NEXT:    ldrh r6, [r0]
; CHECK-VFP-NEXT:    mov r4, r0
; CHECK-VFP-NEXT:  .LBB13_1:
; CHECK-VFP-NEXT:    mov r0, r4
; CHECK-VFP-NEXT:    mov r5, r6
; CHECK-VFP-NEXT:    ldrh r6, [r4]
; CHECK-VFP-NEXT:    bl test_dummy
; CHECK-VFP-NEXT:    tst r0, #1
; CHECK-VFP-NEXT:    bne .LBB13_1
; CHECK-VFP-NEXT:    strh r5, [r4]
; CHECK-VFP-NEXT:    pop {r4, r5, r6, pc}
;
; CHECK-NOVFP-LABEL: test_phi:
; CHECK-NOVFP:         .save {r4, r5, r6, lr}
; CHECK-NOVFP-NEXT:    push {r4, r5, r6, lr}
; CHECK-NOVFP-NEXT:    ldrh r5, [r0]
; CHECK-NOVFP-NEXT:    mov r4, r0
; CHECK-NOVFP-NEXT:  .LBB13_1:
; CHECK-NOVFP-NEXT:    mov r0, r4
; CHECK-NOVFP-NEXT:    mov r6, r5
; CHECK-NOVFP-NEXT:    ldrh r5, [r4]
; CHECK-NOVFP-NEXT:    bl test_dummy
; CHECK-NOVFP-NEXT:    tst r0, #1
; CHECK-NOVFP-NEXT:    bne .LBB13_1
; CHECK-NOVFP-NEXT:    strh r6, [r4]
; CHECK-NOVFP-NEXT:    pop {r4, r5, r6, pc}
entry:
  %a = load half, ptr %p
  br label %loop
loop:
  %r = phi half [%a, %entry], [%b, %loop]
  %b = load half, ptr %p
  %c = call i1 @test_dummy(ptr %p)
  br i1 %c, label %loop, label %return
return:
  store half %r, ptr %p
  ret void
}

define i32 @test_fptosi_i32(ptr %p) #0 {
; CHECK-FP16-LABEL: test_fptosi_i32:
; CHECK-FP16:         ldrh r0, [r0]
; CHECK-FP16-NEXT:    vmov s0, r0
; CHECK-FP16-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-FP16-NEXT:    vcvt.s32.f32 s0, s0
; CHECK-FP16-NEXT:    vmov r0, s0
; CHECK-FP16-NEXT:    bx lr
;
; CHECK-LIBCALL-VFP-LABEL: test_fptosi_i32:
; CHECK-LIBCALL-VFP:         .save {r11, lr}
; CHECK-LIBCALL-VFP-NEXT:    push {r11, lr}
; CHECK-LIBCALL-VFP-NEXT:    ldrh r0, [r0]
; CHECK-LIBCALL-VFP-NEXT:    bl __aeabi_h2f
; CHECK-LIBCALL-VFP-NEXT:    vmov s0, r0
; CHECK-LIBCALL-VFP-NEXT:    vcvt.s32.f32 s0, s0
; CHECK-LIBCALL-VFP-NEXT:    vmov r0, s0
; CHECK-LIBCALL-VFP-NEXT:    pop {r11, pc}
;
; CHECK-NOVFP-LABEL: test_fptosi_i32:
; CHECK-NOVFP:         .save {r11, lr}
; CHECK-NOVFP-NEXT:    push {r11, lr}
; CHECK-NOVFP-NEXT:    ldrh r0, [r0]
; CHECK-NOVFP-NEXT:    bl __aeabi_h2f
; CHECK-NOVFP-NEXT:    bl __aeabi_f2iz
; CHECK-NOVFP-NEXT:    pop {r11, pc}
  %a = load half, ptr %p, align 2
  %r = fptosi half %a to i32
  ret i32 %r
}

define i64 @test_fptosi_i64(ptr %p) #0 {
; CHECK-FP16-LABEL: test_fptosi_i64:
; CHECK-FP16:         .save {r11, lr}
; CHECK-FP16-NEXT:    push {r11, lr}
; CHECK-FP16-NEXT:    ldrh r0, [r0]
; CHECK-FP16-NEXT:    vmov s0, r0
; CHECK-FP16-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-FP16-NEXT:    vmov r0, s0
; CHECK-FP16-NEXT:    bl __aeabi_f2lz
; CHECK-FP16-NEXT:    pop {r11, pc}
;
; CHECK-LIBCALL-LABEL: test_fptosi_i64:
; CHECK-LIBCALL:         .save {r11, lr}
; CHECK-LIBCALL-NEXT:    push {r11, lr}
; CHECK-LIBCALL-NEXT:    ldrh r0, [r0]
; CHECK-LIBCALL-NEXT:    bl __aeabi_h2f
; CHECK-LIBCALL-NEXT:    bl __aeabi_f2lz
; CHECK-LIBCALL-NEXT:    pop {r11, pc}
  %a = load half, ptr %p, align 2
  %r = fptosi half %a to i64
  ret i64 %r
}

define i32 @test_fptoui_i32(ptr %p) #0 {
; CHECK-FP16-LABEL: test_fptoui_i32:
; CHECK-FP16:         ldrh r0, [r0]
; CHECK-FP16-NEXT:    vmov s0, r0
; CHECK-FP16-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-FP16-NEXT:    vcvt.u32.f32 s0, s0
; CHECK-FP16-NEXT:    vmov r0, s0
; CHECK-FP16-NEXT:    bx lr
;
; CHECK-LIBCALL-VFP-LABEL: test_fptoui_i32:
; CHECK-LIBCALL-VFP:         .save {r11, lr}
; CHECK-LIBCALL-VFP-NEXT:    push {r11, lr}
; CHECK-LIBCALL-VFP-NEXT:    ldrh r0, [r0]
; CHECK-LIBCALL-VFP-NEXT:    bl __aeabi_h2f
; CHECK-LIBCALL-VFP-NEXT:    vmov s0, r0
; CHECK-LIBCALL-VFP-NEXT:    vcvt.u32.f32 s0, s0
; CHECK-LIBCALL-VFP-NEXT:    vmov r0, s0
; CHECK-LIBCALL-VFP-NEXT:    pop {r11, pc}
;
; CHECK-NOVFP-LABEL: test_fptoui_i32:
; CHECK-NOVFP:         .save {r11, lr}
; CHECK-NOVFP-NEXT:    push {r11, lr}
; CHECK-NOVFP-NEXT:    ldrh r0, [r0]
; CHECK-NOVFP-NEXT:    bl __aeabi_h2f
; CHECK-NOVFP-NEXT:    bl __aeabi_f2uiz
; CHECK-NOVFP-NEXT:    pop {r11, pc}
  %a = load half, ptr %p, align 2
  %r = fptoui half %a to i32
  ret i32 %r
}

define i64 @test_fptoui_i64(ptr %p) #0 {
; CHECK-FP16-LABEL: test_fptoui_i64:
; CHECK-FP16:         .save {r11, lr}
; CHECK-FP16-NEXT:    push {r11, lr}
; CHECK-FP16-NEXT:    ldrh r0, [r0]
; CHECK-FP16-NEXT:    vmov s0, r0
; CHECK-FP16-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-FP16-NEXT:    vmov r0, s0
; CHECK-FP16-NEXT:    bl __aeabi_f2ulz
; CHECK-FP16-NEXT:    pop {r11, pc}
;
; CHECK-LIBCALL-LABEL: test_fptoui_i64:
; CHECK-LIBCALL:         .save {r11, lr}
; CHECK-LIBCALL-NEXT:    push {r11, lr}
; CHECK-LIBCALL-NEXT:    ldrh r0, [r0]
; CHECK-LIBCALL-NEXT:    bl __aeabi_h2f
; CHECK-LIBCALL-NEXT:    bl __aeabi_f2ulz
; CHECK-LIBCALL-NEXT:    pop {r11, pc}
  %a = load half, ptr %p, align 2
  %r = fptoui half %a to i64
  ret i64 %r
}

define void @test_sitofp_i32(i32 %a, ptr %p) #0 {
; CHECK-FP16-LABEL: test_sitofp_i32:
; CHECK-FP16:         vmov s0, r0
; CHECK-FP16-NEXT:    vcvt.f32.s32 s0, s0
; CHECK-FP16-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-FP16-NEXT:    vmov r0, s0
; CHECK-FP16-NEXT:    strh r0, [r1]
; CHECK-FP16-NEXT:    bx lr
;
; CHECK-LIBCALL-VFP-LABEL: test_sitofp_i32:
; CHECK-LIBCALL-VFP:         .save {r4, lr}
; CHECK-LIBCALL-VFP-NEXT:    push {r4, lr}
; CHECK-LIBCALL-VFP-NEXT:    vmov s0, r0
; CHECK-LIBCALL-VFP-NEXT:    mov r4, r1
; CHECK-LIBCALL-VFP-NEXT:    vcvt.f32.s32 s0, s0
; CHECK-LIBCALL-VFP-NEXT:    vmov r0, s0
; CHECK-LIBCALL-VFP-NEXT:    bl __aeabi_f2h
; CHECK-LIBCALL-VFP-NEXT:    strh r0, [r4]
; CHECK-LIBCALL-VFP-NEXT:    pop {r4, pc}
;
; CHECK-NOVFP-LABEL: test_sitofp_i32:
; CHECK-NOVFP:         .save {r4, lr}
; CHECK-NOVFP-NEXT:    push {r4, lr}
; CHECK-NOVFP-NEXT:    mov r4, r1
; CHECK-NOVFP-NEXT:    bl __aeabi_i2f
; CHECK-NOVFP-NEXT:    bl __aeabi_f2h
; CHECK-NOVFP-NEXT:    strh r0, [r4]
; CHECK-NOVFP-NEXT:    pop {r4, pc}
  %r = sitofp i32 %a to half
  store half %r, ptr %p
  ret void
}

define void @test_uitofp_i32(i32 %a, ptr %p) #0 {
; CHECK-FP16-LABEL: test_uitofp_i32:
; CHECK-FP16:         vmov s0, r0
; CHECK-FP16-NEXT:    vcvt.f32.u32 s0, s0
; CHECK-FP16-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-FP16-NEXT:    vmov r0, s0
; CHECK-FP16-NEXT:    strh r0, [r1]
; CHECK-FP16-NEXT:    bx lr
;
; CHECK-LIBCALL-VFP-LABEL: test_uitofp_i32:
; CHECK-LIBCALL-VFP:         .save {r4, lr}
; CHECK-LIBCALL-VFP-NEXT:    push {r4, lr}
; CHECK-LIBCALL-VFP-NEXT:    vmov s0, r0
; CHECK-LIBCALL-VFP-NEXT:    mov r4, r1
; CHECK-LIBCALL-VFP-NEXT:    vcvt.f32.u32 s0, s0
; CHECK-LIBCALL-VFP-NEXT:    vmov r0, s0
; CHECK-LIBCALL-VFP-NEXT:    bl __aeabi_f2h
; CHECK-LIBCALL-VFP-NEXT:    strh r0, [r4]
; CHECK-LIBCALL-VFP-NEXT:    pop {r4, pc}
;
; CHECK-NOVFP-LABEL: test_uitofp_i32:
; CHECK-NOVFP:         .save {r4, lr}
; CHECK-NOVFP-NEXT:    push {r4, lr}
; CHECK-NOVFP-NEXT:    mov r4, r1
; CHECK-NOVFP-NEXT:    bl __aeabi_ui2f
; CHECK-NOVFP-NEXT:    bl __aeabi_f2h
; CHECK-NOVFP-NEXT:    strh r0, [r4]
; CHECK-NOVFP-NEXT:    pop {r4, pc}
  %r = uitofp i32 %a to half
  store half %r, ptr %p
  ret void
}

define void @test_sitofp_i64(i64 %a, ptr %p) #0 {
; CHECK-FP16-LABEL: test_sitofp_i64:
; CHECK-FP16:         .save {r4, lr}
; CHECK-FP16-NEXT:    push {r4, lr}
; CHECK-FP16-NEXT:    mov r4, r2
; CHECK-FP16-NEXT:    bl __aeabi_l2f
; CHECK-FP16-NEXT:    vmov s0, r0
; CHECK-FP16-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-FP16-NEXT:    vmov r0, s0
; CHECK-FP16-NEXT:    strh r0, [r4]
; CHECK-FP16-NEXT:    pop {r4, pc}
;
; CHECK-LIBCALL-LABEL: test_sitofp_i64:
; CHECK-LIBCALL:         .save {r4, lr}
; CHECK-LIBCALL-NEXT:    push {r4, lr}
; CHECK-LIBCALL-NEXT:    mov r4, r2
; CHECK-LIBCALL-NEXT:    bl __aeabi_l2f
; CHECK-LIBCALL-NEXT:    bl __aeabi_f2h
; CHECK-LIBCALL-NEXT:    strh r0, [r4]
; CHECK-LIBCALL-NEXT:    pop {r4, pc}
  %r = sitofp i64 %a to half
  store half %r, ptr %p
  ret void
}

define void @test_uitofp_i64(i64 %a, ptr %p) #0 {
; CHECK-FP16-LABEL: test_uitofp_i64:
; CHECK-FP16:         .save {r4, lr}
; CHECK-FP16-NEXT:    push {r4, lr}
; CHECK-FP16-NEXT:    mov r4, r2
; CHECK-FP16-NEXT:    bl __aeabi_ul2f
; CHECK-FP16-NEXT:    vmov s0, r0
; CHECK-FP16-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-FP16-NEXT:    vmov r0, s0
; CHECK-FP16-NEXT:    strh r0, [r4]
; CHECK-FP16-NEXT:    pop {r4, pc}
;
; CHECK-LIBCALL-LABEL: test_uitofp_i64:
; CHECK-LIBCALL:         .save {r4, lr}
; CHECK-LIBCALL-NEXT:    push {r4, lr}
; CHECK-LIBCALL-NEXT:    mov r4, r2
; CHECK-LIBCALL-NEXT:    bl __aeabi_ul2f
; CHECK-LIBCALL-NEXT:    bl __aeabi_f2h
; CHECK-LIBCALL-NEXT:    strh r0, [r4]
; CHECK-LIBCALL-NEXT:    pop {r4, pc}
  %r = uitofp i64 %a to half
  store half %r, ptr %p
  ret void
}

define void @test_fptrunc_float(float %f, ptr %p) #0 {
; CHECK-FP16-LABEL: test_fptrunc_float:
; CHECK-FP16:         vcvtb.f16.f32 s0, s0
; CHECK-FP16-NEXT:    vmov r1, s0
; CHECK-FP16-NEXT:    strh r1, [r0]
; CHECK-FP16-NEXT:    bx lr
;
; CHECK-LIBCALL-VFP-LABEL: test_fptrunc_float:
; CHECK-LIBCALL-VFP:         .save {r4, lr}
; CHECK-LIBCALL-VFP-NEXT:    push {r4, lr}
; CHECK-LIBCALL-VFP-NEXT:    mov r4, r0
; CHECK-LIBCALL-VFP-NEXT:    vmov r0, s0
; CHECK-LIBCALL-VFP-NEXT:    bl __aeabi_f2h
; CHECK-LIBCALL-VFP-NEXT:    strh r0, [r4]
; CHECK-LIBCALL-VFP-NEXT:    pop {r4, pc}
;
; CHECK-NOVFP-LABEL: test_fptrunc_float:
; CHECK-NOVFP:         .save {r4, lr}
; CHECK-NOVFP-NEXT:    push {r4, lr}
; CHECK-NOVFP-NEXT:    mov r4, r1
; CHECK-NOVFP-NEXT:    bl __aeabi_f2h
; CHECK-NOVFP-NEXT:    strh r0, [r4]
; CHECK-NOVFP-NEXT:    pop {r4, pc}
  %a = fptrunc float %f to half
  store half %a, ptr %p
  ret void
}

define void @test_fptrunc_double(double %d, ptr %p) #0 {
; CHECK-VFP-LABEL: test_fptrunc_double:
; CHECK-VFP:         .save {r4, lr}
; CHECK-VFP-NEXT:    push {r4, lr}
; CHECK-VFP-NEXT:    mov r4, r0
; CHECK-VFP-NEXT:    vmov r0, r1, d0
; CHECK-VFP-NEXT:    bl __aeabi_d2h
; CHECK-VFP-NEXT:    strh r0, [r4]
; CHECK-VFP-NEXT:    pop {r4, pc}
;
; CHECK-NOVFP-LABEL: test_fptrunc_double:
; CHECK-NOVFP:         .save {r4, lr}
; CHECK-NOVFP-NEXT:    push {r4, lr}
; CHECK-NOVFP-NEXT:    mov r4, r2
; CHECK-NOVFP-NEXT:    bl __aeabi_d2h
; CHECK-NOVFP-NEXT:    strh r0, [r4]
; CHECK-NOVFP-NEXT:    pop {r4, pc}
  %a = fptrunc double %d to half
  store half %a, ptr %p
  ret void
}

define float @test_fpextend_float(ptr %p) {
; CHECK-FP16-LABEL: test_fpextend_float:
; CHECK-FP16:         ldrh r0, [r0]
; CHECK-FP16-NEXT:    vmov s0, r0
; CHECK-FP16-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-FP16-NEXT:    bx lr
;
; CHECK-LIBCALL-VFP-LABEL: test_fpextend_float:
; CHECK-LIBCALL-VFP:         .save {r11, lr}
; CHECK-LIBCALL-VFP-NEXT:    push {r11, lr}
; CHECK-LIBCALL-VFP-NEXT:    ldrh r0, [r0]
; CHECK-LIBCALL-VFP-NEXT:    bl __aeabi_h2f
; CHECK-LIBCALL-VFP-NEXT:    vmov s0, r0
; CHECK-LIBCALL-VFP-NEXT:    pop {r11, pc}
;
; CHECK-NOVFP-LABEL: test_fpextend_float:
; CHECK-NOVFP:         .save {r11, lr}
; CHECK-NOVFP-NEXT:    push {r11, lr}
; CHECK-NOVFP-NEXT:    ldrh r0, [r0]
; CHECK-NOVFP-NEXT:    bl __aeabi_h2f
; CHECK-NOVFP-NEXT:    pop {r11, pc}
  %a = load half, ptr %p, align 2
  %r = fpext half %a to float
  ret float %r
}

define double @test_fpextend_double(ptr %p) {
; CHECK-FP16-LABEL: test_fpextend_double:
; CHECK-FP16:         ldrh r0, [r0]
; CHECK-FP16-NEXT:    vmov s0, r0
; CHECK-FP16-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-FP16-NEXT:    vcvt.f64.f32 d0, s0
; CHECK-FP16-NEXT:    bx lr
;
; CHECK-LIBCALL-VFP-LABEL: test_fpextend_double:
; CHECK-LIBCALL-VFP:         .save {r11, lr}
; CHECK-LIBCALL-VFP-NEXT:    push {r11, lr}
; CHECK-LIBCALL-VFP-NEXT:    ldrh r0, [r0]
; CHECK-LIBCALL-VFP-NEXT:    bl __aeabi_h2f
; CHECK-LIBCALL-VFP-NEXT:    vmov s0, r0
; CHECK-LIBCALL-VFP-NEXT:    vcvt.f64.f32 d0, s0
; CHECK-LIBCALL-VFP-NEXT:    pop {r11, pc}
;
; CHECK-NOVFP-LABEL: test_fpextend_double:
; CHECK-NOVFP:         .save {r11, lr}
; CHECK-NOVFP-NEXT:    push {r11, lr}
; CHECK-NOVFP-NEXT:    ldrh r0, [r0]
; CHECK-NOVFP-NEXT:    bl __aeabi_h2f
; CHECK-NOVFP-NEXT:    bl __aeabi_f2d
; CHECK-NOVFP-NEXT:    pop {r11, pc}
  %a = load half, ptr %p, align 2
  %r = fpext half %a to double
  ret double %r
}

define i16 @test_bitcast_halftoi16(ptr %p) #0 {
; CHECK-ALL-LABEL: test_bitcast_halftoi16:
; CHECK-ALL:         ldrh r0, [r0]
; CHECK-ALL-NEXT:    bx lr
  %a = load half, ptr %p, align 2
  %r = bitcast half %a to i16
  ret i16 %r
}

define void @test_bitcast_i16tohalf(i16 %a, ptr %p) #0 {
; CHECK-ALL-LABEL: test_bitcast_i16tohalf:
; CHECK-ALL:         strh r0, [r1]
; CHECK-ALL-NEXT:    bx lr
  %r = bitcast i16 %a to half
  store half %r, ptr %p
  ret void
}

declare half @llvm.sqrt.f16(half %a) #0
declare half @llvm.powi.f16.i32(half %a, i32 %b) #0
declare half @llvm.sin.f16(half %a) #0
declare half @llvm.cos.f16(half %a) #0
declare half @llvm.tan.f16(half %a) #0
declare half @llvm.pow.f16(half %a, half %b) #0
declare half @llvm.exp.f16(half %a) #0
declare half @llvm.exp2.f16(half %a) #0
declare half @llvm.log.f16(half %a) #0
declare half @llvm.log10.f16(half %a) #0
declare half @llvm.log2.f16(half %a) #0
declare half @llvm.fma.f16(half %a, half %b, half %c) #0
declare half @llvm.fabs.f16(half %a) #0
declare half @llvm.minnum.f16(half %a, half %b) #0
declare half @llvm.maxnum.f16(half %a, half %b) #0
declare half @llvm.copysign.f16(half %a, half %b) #0
declare half @llvm.floor.f16(half %a) #0
declare half @llvm.ceil.f16(half %a) #0
declare half @llvm.trunc.f16(half %a) #0
declare half @llvm.rint.f16(half %a) #0
declare half @llvm.nearbyint.f16(half %a) #0
declare half @llvm.round.f16(half %a) #0
declare half @llvm.roundeven.f16(half %a) #0
declare half @llvm.fmuladd.f16(half %a, half %b, half %c) #0

define void @test_sqrt(ptr %p) #0 {
; CHECK-FP16-LABEL: test_sqrt:
; CHECK-FP16:         ldrh r1, [r0]
; CHECK-FP16-NEXT:    vmov s0, r1
; CHECK-FP16-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-FP16-NEXT:    vsqrt.f32 s0, s0
; CHECK-FP16-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-FP16-NEXT:    vmov r1, s0
; CHECK-FP16-NEXT:    strh r1, [r0]
; CHECK-FP16-NEXT:    bx lr
;
; CHECK-LIBCALL-VFP-LABEL: test_sqrt:
; CHECK-LIBCALL-VFP:         .save {r4, lr}
; CHECK-LIBCALL-VFP-NEXT:    push {r4, lr}
; CHECK-LIBCALL-VFP-NEXT:    mov r4, r0
; CHECK-LIBCALL-VFP-NEXT:    ldrh r0, [r0]
; CHECK-LIBCALL-VFP-NEXT:    bl __aeabi_h2f
; CHECK-LIBCALL-VFP-NEXT:    vmov s0, r0
; CHECK-LIBCALL-VFP-NEXT:    vsqrt.f32 s0, s0
; CHECK-LIBCALL-VFP-NEXT:    vmov r0, s0
; CHECK-LIBCALL-VFP-NEXT:    bl __aeabi_f2h
; CHECK-LIBCALL-VFP-NEXT:    strh r0, [r4]
; CHECK-LIBCALL-VFP-NEXT:    pop {r4, pc}
;
; CHECK-NOVFP-LABEL: test_sqrt:
; CHECK-NOVFP:         .save {r4, lr}
; CHECK-NOVFP-NEXT:    push {r4, lr}
; CHECK-NOVFP-NEXT:    mov r4, r0
; CHECK-NOVFP-NEXT:    ldrh r0, [r0]
; CHECK-NOVFP-NEXT:    bl __aeabi_h2f
; CHECK-NOVFP-NEXT:    bl sqrtf
; CHECK-NOVFP-NEXT:    bl __aeabi_f2h
; CHECK-NOVFP-NEXT:    strh r0, [r4]
; CHECK-NOVFP-NEXT:    pop {r4, pc}
  %a = load half, ptr %p, align 2
  %r = call half @llvm.sqrt.f16(half %a)
  store half %r, ptr %p
  ret void
}

define void @test_fpowi(ptr %p, i32 %b) #0 {
; CHECK-FP16-LABEL: test_fpowi:
; CHECK-FP16:         .save {r4, lr}
; CHECK-FP16-NEXT:    push {r4, lr}
; CHECK-FP16-NEXT:    mov r4, r0
; CHECK-FP16-NEXT:    ldrh r0, [r0]
; CHECK-FP16-NEXT:    vmov s0, r0
; CHECK-FP16-NEXT:    mov r0, r1
; CHECK-FP16-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-FP16-NEXT:    bl __powisf2
; CHECK-FP16-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-FP16-NEXT:    vmov r0, s0
; CHECK-FP16-NEXT:    strh r0, [r4]
; CHECK-FP16-NEXT:    pop {r4, pc}
;
; CHECK-LIBCALL-VFP-LABEL: test_fpowi:
; CHECK-LIBCALL-VFP:         .save {r4, r5, r11, lr}
; CHECK-LIBCALL-VFP-NEXT:    push {r4, r5, r11, lr}
; CHECK-LIBCALL-VFP-NEXT:    mov r5, r0
; CHECK-LIBCALL-VFP-NEXT:    ldrh r0, [r0]
; CHECK-LIBCALL-VFP-NEXT:    mov r4, r1
; CHECK-LIBCALL-VFP-NEXT:    bl __aeabi_h2f
; CHECK-LIBCALL-VFP-NEXT:    vmov s0, r0
; CHECK-LIBCALL-VFP-NEXT:    mov r0, r4
; CHECK-LIBCALL-VFP-NEXT:    bl __powisf2
; CHECK-LIBCALL-VFP-NEXT:    vmov r0, s0
; CHECK-LIBCALL-VFP-NEXT:    bl __aeabi_f2h
; CHECK-LIBCALL-VFP-NEXT:    strh r0, [r5]
; CHECK-LIBCALL-VFP-NEXT:    pop {r4, r5, r11, pc}
;
; CHECK-NOVFP-LABEL: test_fpowi:
; CHECK-NOVFP:         .save {r4, r5, r11, lr}
; CHECK-NOVFP-NEXT:    push {r4, r5, r11, lr}
; CHECK-NOVFP-NEXT:    mov r5, r0
; CHECK-NOVFP-NEXT:    ldrh r0, [r0]
; CHECK-NOVFP-NEXT:    mov r4, r1
; CHECK-NOVFP-NEXT:    bl __aeabi_h2f
; CHECK-NOVFP-NEXT:    mov r1, r4
; CHECK-NOVFP-NEXT:    bl __powisf2
; CHECK-NOVFP-NEXT:    bl __aeabi_f2h
; CHECK-NOVFP-NEXT:    strh r0, [r5]
; CHECK-NOVFP-NEXT:    pop {r4, r5, r11, pc}
  %a = load half, ptr %p, align 2
  %r = call half @llvm.powi.f16.i32(half %a, i32 %b)
  store half %r, ptr %p
  ret void
}

define void @test_sin(ptr %p) #0 {
; CHECK-FP16-LABEL: test_sin:
; CHECK-FP16:         .save {r4, lr}
; CHECK-FP16-NEXT:    push {r4, lr}
; CHECK-FP16-NEXT:    mov r4, r0
; CHECK-FP16-NEXT:    ldrh r0, [r0]
; CHECK-FP16-NEXT:    vmov s0, r0
; CHECK-FP16-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-FP16-NEXT:    bl sinf
; CHECK-FP16-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-FP16-NEXT:    vmov r0, s0
; CHECK-FP16-NEXT:    strh r0, [r4]
; CHECK-FP16-NEXT:    pop {r4, pc}
;
; CHECK-LIBCALL-VFP-LABEL: test_sin:
; CHECK-LIBCALL-VFP:         .save {r4, lr}
; CHECK-LIBCALL-VFP-NEXT:    push {r4, lr}
; CHECK-LIBCALL-VFP-NEXT:    mov r4, r0
; CHECK-LIBCALL-VFP-NEXT:    ldrh r0, [r0]
; CHECK-LIBCALL-VFP-NEXT:    bl __aeabi_h2f
; CHECK-LIBCALL-VFP-NEXT:    vmov s0, r0
; CHECK-LIBCALL-VFP-NEXT:    bl sinf
; CHECK-LIBCALL-VFP-NEXT:    vmov r0, s0
; CHECK-LIBCALL-VFP-NEXT:    bl __aeabi_f2h
; CHECK-LIBCALL-VFP-NEXT:    strh r0, [r4]
; CHECK-LIBCALL-VFP-NEXT:    pop {r4, pc}
;
; CHECK-NOVFP-LABEL: test_sin:
; CHECK-NOVFP:         .save {r4, lr}
; CHECK-NOVFP-NEXT:    push {r4, lr}
; CHECK-NOVFP-NEXT:    mov r4, r0
; CHECK-NOVFP-NEXT:    ldrh r0, [r0]
; CHECK-NOVFP-NEXT:    bl __aeabi_h2f
; CHECK-NOVFP-NEXT:    bl sinf
; CHECK-NOVFP-NEXT:    bl __aeabi_f2h
; CHECK-NOVFP-NEXT:    strh r0, [r4]
; CHECK-NOVFP-NEXT:    pop {r4, pc}
  %a = load half, ptr %p, align 2
  %r = call half @llvm.sin.f16(half %a)
  store half %r, ptr %p
  ret void
}

define void @test_cos(ptr %p) #0 {
; CHECK-FP16-LABEL: test_cos:
; CHECK-FP16:         .save {r4, lr}
; CHECK-FP16-NEXT:    push {r4, lr}
; CHECK-FP16-NEXT:    mov r4, r0
; CHECK-FP16-NEXT:    ldrh r0, [r0]
; CHECK-FP16-NEXT:    vmov s0, r0
; CHECK-FP16-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-FP16-NEXT:    bl cosf
; CHECK-FP16-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-FP16-NEXT:    vmov r0, s0
; CHECK-FP16-NEXT:    strh r0, [r4]
; CHECK-FP16-NEXT:    pop {r4, pc}
;
; CHECK-LIBCALL-VFP-LABEL: test_cos:
; CHECK-LIBCALL-VFP:         .save {r4, lr}
; CHECK-LIBCALL-VFP-NEXT:    push {r4, lr}
; CHECK-LIBCALL-VFP-NEXT:    mov r4, r0
; CHECK-LIBCALL-VFP-NEXT:    ldrh r0, [r0]
; CHECK-LIBCALL-VFP-NEXT:    bl __aeabi_h2f
; CHECK-LIBCALL-VFP-NEXT:    vmov s0, r0
; CHECK-LIBCALL-VFP-NEXT:    bl cosf
; CHECK-LIBCALL-VFP-NEXT:    vmov r0, s0
; CHECK-LIBCALL-VFP-NEXT:    bl __aeabi_f2h
; CHECK-LIBCALL-VFP-NEXT:    strh r0, [r4]
; CHECK-LIBCALL-VFP-NEXT:    pop {r4, pc}
;
; CHECK-NOVFP-LABEL: test_cos:
; CHECK-NOVFP:         .save {r4, lr}
; CHECK-NOVFP-NEXT:    push {r4, lr}
; CHECK-NOVFP-NEXT:    mov r4, r0
; CHECK-NOVFP-NEXT:    ldrh r0, [r0]
; CHECK-NOVFP-NEXT:    bl __aeabi_h2f
; CHECK-NOVFP-NEXT:    bl cosf
; CHECK-NOVFP-NEXT:    bl __aeabi_f2h
; CHECK-NOVFP-NEXT:    strh r0, [r4]
; CHECK-NOVFP-NEXT:    pop {r4, pc}
  %a = load half, ptr %p, align 2
  %r = call half @llvm.cos.f16(half %a)
  store half %r, ptr %p
  ret void
}

define void @test_tan(ptr %p) #0 {
; CHECK-FP16-LABEL: test_tan:
; CHECK-FP16:         .save {r4, lr}
; CHECK-FP16-NEXT:    push {r4, lr}
; CHECK-FP16-NEXT:    mov r4, r0
; CHECK-FP16-NEXT:    ldrh r0, [r0]
; CHECK-FP16-NEXT:    vmov s0, r0
; CHECK-FP16-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-FP16-NEXT:    bl tanf
; CHECK-FP16-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-FP16-NEXT:    vmov r0, s0
; CHECK-FP16-NEXT:    strh r0, [r4]
; CHECK-FP16-NEXT:    pop {r4, pc}
;
; CHECK-LIBCALL-VFP-LABEL: test_tan:
; CHECK-LIBCALL-VFP:         .save {r4, lr}
; CHECK-LIBCALL-VFP-NEXT:    push {r4, lr}
; CHECK-LIBCALL-VFP-NEXT:    mov r4, r0
; CHECK-LIBCALL-VFP-NEXT:    ldrh r0, [r0]
; CHECK-LIBCALL-VFP-NEXT:    bl __aeabi_h2f
; CHECK-LIBCALL-VFP-NEXT:    vmov s0, r0
; CHECK-LIBCALL-VFP-NEXT:    bl tanf
; CHECK-LIBCALL-VFP-NEXT:    vmov r0, s0
; CHECK-LIBCALL-VFP-NEXT:    bl __aeabi_f2h
; CHECK-LIBCALL-VFP-NEXT:    strh r0, [r4]
; CHECK-LIBCALL-VFP-NEXT:    pop {r4, pc}
;
; CHECK-NOVFP-LABEL: test_tan:
; CHECK-NOVFP:         .save {r4, lr}
; CHECK-NOVFP-NEXT:    push {r4, lr}
; CHECK-NOVFP-NEXT:    mov r4, r0
; CHECK-NOVFP-NEXT:    ldrh r0, [r0]
; CHECK-NOVFP-NEXT:    bl __aeabi_h2f
; CHECK-NOVFP-NEXT:    bl tanf
; CHECK-NOVFP-NEXT:    bl __aeabi_f2h
; CHECK-NOVFP-NEXT:    strh r0, [r4]
; CHECK-NOVFP-NEXT:    pop {r4, pc}
  %a = load half, ptr %p, align 2
  %r = call half @llvm.tan.f16(half %a)
  store half %r, ptr %p
  ret void
}

define void @test_pow(ptr %p, ptr %q) #0 {
; CHECK-FP16-LABEL: test_pow:
; CHECK-FP16:         .save {r4, lr}
; CHECK-FP16-NEXT:    push {r4, lr}
; CHECK-FP16-NEXT:    mov r4, r0
; CHECK-FP16-NEXT:    ldrh r0, [r0]
; CHECK-FP16-NEXT:    ldrh r1, [r1]
; CHECK-FP16-NEXT:    vmov s0, r0
; CHECK-FP16-NEXT:    vmov s2, r1
; CHECK-FP16-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-FP16-NEXT:    vcvtb.f32.f16 s1, s2
; CHECK-FP16-NEXT:    bl powf
; CHECK-FP16-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-FP16-NEXT:    vmov r0, s0
; CHECK-FP16-NEXT:    strh r0, [r4]
; CHECK-FP16-NEXT:    pop {r4, pc}
;
; CHECK-LIBCALL-VFP-LABEL: test_pow:
; CHECK-LIBCALL-VFP:         .save {r4, r5, r11, lr}
; CHECK-LIBCALL-VFP-NEXT:    push {r4, r5, r11, lr}
; CHECK-LIBCALL-VFP-NEXT:    mov r4, r0
; CHECK-LIBCALL-VFP-NEXT:    ldrh r0, [r1]
; CHECK-LIBCALL-VFP-NEXT:    bl __aeabi_h2f
; CHECK-LIBCALL-VFP-NEXT:    mov r5, r0
; CHECK-LIBCALL-VFP-NEXT:    ldrh r0, [r4]
; CHECK-LIBCALL-VFP-NEXT:    bl __aeabi_h2f
; CHECK-LIBCALL-VFP-NEXT:    vmov s0, r0
; CHECK-LIBCALL-VFP-NEXT:    vmov s1, r5
; CHECK-LIBCALL-VFP-NEXT:    bl powf
; CHECK-LIBCALL-VFP-NEXT:    vmov r0, s0
; CHECK-LIBCALL-VFP-NEXT:    bl __aeabi_f2h
; CHECK-LIBCALL-VFP-NEXT:    strh r0, [r4]
; CHECK-LIBCALL-VFP-NEXT:    pop {r4, r5, r11, pc}
;
; CHECK-NOVFP-LABEL: test_pow:
; CHECK-NOVFP:         .save {r4, r5, r11, lr}
; CHECK-NOVFP-NEXT:    push {r4, r5, r11, lr}
; CHECK-NOVFP-NEXT:    mov r4, r0
; CHECK-NOVFP-NEXT:    ldrh r0, [r1]
; CHECK-NOVFP-NEXT:    bl __aeabi_h2f
; CHECK-NOVFP-NEXT:    mov r5, r0
; CHECK-NOVFP-NEXT:    ldrh r0, [r4]
; CHECK-NOVFP-NEXT:    bl __aeabi_h2f
; CHECK-NOVFP-NEXT:    mov r1, r5
; CHECK-NOVFP-NEXT:    bl powf
; CHECK-NOVFP-NEXT:    bl __aeabi_f2h
; CHECK-NOVFP-NEXT:    strh r0, [r4]
; CHECK-NOVFP-NEXT:    pop {r4, r5, r11, pc}
  %a = load half, ptr %p, align 2
  %b = load half, ptr %q, align 2
  %r = call half @llvm.pow.f16(half %a, half %b)
  store half %r, ptr %p
  ret void
}

define void @test_cbrt(ptr %p) #0 {
; CHECK-FP16-LABEL: test_cbrt:
; CHECK-FP16:         .save {r4, lr}
; CHECK-FP16-NEXT:    push {r4, lr}
; CHECK-FP16-NEXT:    mov r4, r0
; CHECK-FP16-NEXT:    ldrh r0, [r0]
; CHECK-FP16-NEXT:    vldr s1, .LCPI34_0
; CHECK-FP16-NEXT:    vmov s0, r0
; CHECK-FP16-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-FP16-NEXT:    bl powf
; CHECK-FP16-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-FP16-NEXT:    vmov r0, s0
; CHECK-FP16-NEXT:    strh r0, [r4]
; CHECK-FP16-NEXT:    pop {r4, pc}
; CHECK-FP16-NEXT:    .p2align 2
; CHECK-FP16-NEXT:  .LCPI34_0:
; CHECK-FP16-NEXT:    .long 0x3eaaa000
;
; CHECK-LIBCALL-VFP-LABEL: test_cbrt:
; CHECK-LIBCALL-VFP:         .save {r4, lr}
; CHECK-LIBCALL-VFP-NEXT:    push {r4, lr}
; CHECK-LIBCALL-VFP-NEXT:    mov r4, r0
; CHECK-LIBCALL-VFP-NEXT:    ldrh r0, [r0]
; CHECK-LIBCALL-VFP-NEXT:    bl __aeabi_h2f
; CHECK-LIBCALL-VFP-NEXT:    vldr s1, .LCPI34_0
; CHECK-LIBCALL-VFP-NEXT:    vmov s0, r0
; CHECK-LIBCALL-VFP-NEXT:    bl powf
; CHECK-LIBCALL-VFP-NEXT:    vmov r0, s0
; CHECK-LIBCALL-VFP-NEXT:    bl __aeabi_f2h
; CHECK-LIBCALL-VFP-NEXT:    strh r0, [r4]
; CHECK-LIBCALL-VFP-NEXT:    pop {r4, pc}
; CHECK-LIBCALL-VFP-NEXT:    .p2align 2
; CHECK-LIBCALL-VFP-NEXT:  .LCPI34_0:
; CHECK-LIBCALL-VFP-NEXT:    .long 0x3eaaa000
;
; CHECK-NOVFP-LABEL: test_cbrt:
; CHECK-NOVFP:         .save {r4, lr}
; CHECK-NOVFP-NEXT:    push {r4, lr}
; CHECK-NOVFP-NEXT:    mov r4, r0
; CHECK-NOVFP-NEXT:    ldrh r0, [r0]
; CHECK-NOVFP-NEXT:    bl __aeabi_h2f
; CHECK-NOVFP-NEXT:    movw r1, #40960
; CHECK-NOVFP-NEXT:    movt r1, #16042
; CHECK-NOVFP-NEXT:    bl powf
; CHECK-NOVFP-NEXT:    bl __aeabi_f2h
; CHECK-NOVFP-NEXT:    strh r0, [r4]
; CHECK-NOVFP-NEXT:    pop {r4, pc}
  %a = load half, ptr %p, align 2
  %r = call half @llvm.pow.f16(half %a, half 0x3FD5540000000000)
  store half %r, ptr %p
  ret void
}

define void @test_exp(ptr %p) #0 {
; CHECK-FP16-LABEL: test_exp:
; CHECK-FP16:         .save {r4, lr}
; CHECK-FP16-NEXT:    push {r4, lr}
; CHECK-FP16-NEXT:    mov r4, r0
; CHECK-FP16-NEXT:    ldrh r0, [r0]
; CHECK-FP16-NEXT:    vmov s0, r0
; CHECK-FP16-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-FP16-NEXT:    bl expf
; CHECK-FP16-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-FP16-NEXT:    vmov r0, s0
; CHECK-FP16-NEXT:    strh r0, [r4]
; CHECK-FP16-NEXT:    pop {r4, pc}
;
; CHECK-LIBCALL-VFP-LABEL: test_exp:
; CHECK-LIBCALL-VFP:         .save {r4, lr}
; CHECK-LIBCALL-VFP-NEXT:    push {r4, lr}
; CHECK-LIBCALL-VFP-NEXT:    mov r4, r0
; CHECK-LIBCALL-VFP-NEXT:    ldrh r0, [r0]
; CHECK-LIBCALL-VFP-NEXT:    bl __aeabi_h2f
; CHECK-LIBCALL-VFP-NEXT:    vmov s0, r0
; CHECK-LIBCALL-VFP-NEXT:    bl expf
; CHECK-LIBCALL-VFP-NEXT:    vmov r0, s0
; CHECK-LIBCALL-VFP-NEXT:    bl __aeabi_f2h
; CHECK-LIBCALL-VFP-NEXT:    strh r0, [r4]
; CHECK-LIBCALL-VFP-NEXT:    pop {r4, pc}
;
; CHECK-NOVFP-LABEL: test_exp:
; CHECK-NOVFP:         .save {r4, lr}
; CHECK-NOVFP-NEXT:    push {r4, lr}
; CHECK-NOVFP-NEXT:    mov r4, r0
; CHECK-NOVFP-NEXT:    ldrh r0, [r0]
; CHECK-NOVFP-NEXT:    bl __aeabi_h2f
; CHECK-NOVFP-NEXT:    bl expf
; CHECK-NOVFP-NEXT:    bl __aeabi_f2h
; CHECK-NOVFP-NEXT:    strh r0, [r4]
; CHECK-NOVFP-NEXT:    pop {r4, pc}
  %a = load half, ptr %p, align 2
  %r = call half @llvm.exp.f16(half %a)
  store half %r, ptr %p
  ret void
}

define void @test_exp2(ptr %p) #0 {
; CHECK-FP16-LABEL: test_exp2:
; CHECK-FP16:         .save {r4, lr}
; CHECK-FP16-NEXT:    push {r4, lr}
; CHECK-FP16-NEXT:    mov r4, r0
; CHECK-FP16-NEXT:    ldrh r0, [r0]
; CHECK-FP16-NEXT:    vmov s0, r0
; CHECK-FP16-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-FP16-NEXT:    bl exp2f
; CHECK-FP16-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-FP16-NEXT:    vmov r0, s0
; CHECK-FP16-NEXT:    strh r0, [r4]
; CHECK-FP16-NEXT:    pop {r4, pc}
;
; CHECK-LIBCALL-VFP-LABEL: test_exp2:
; CHECK-LIBCALL-VFP:         .save {r4, lr}
; CHECK-LIBCALL-VFP-NEXT:    push {r4, lr}
; CHECK-LIBCALL-VFP-NEXT:    mov r4, r0
; CHECK-LIBCALL-VFP-NEXT:    ldrh r0, [r0]
; CHECK-LIBCALL-VFP-NEXT:    bl __aeabi_h2f
; CHECK-LIBCALL-VFP-NEXT:    vmov s0, r0
; CHECK-LIBCALL-VFP-NEXT:    bl exp2f
; CHECK-LIBCALL-VFP-NEXT:    vmov r0, s0
; CHECK-LIBCALL-VFP-NEXT:    bl __aeabi_f2h
; CHECK-LIBCALL-VFP-NEXT:    strh r0, [r4]
; CHECK-LIBCALL-VFP-NEXT:    pop {r4, pc}
;
; CHECK-NOVFP-LABEL: test_exp2:
; CHECK-NOVFP:         .save {r4, lr}
; CHECK-NOVFP-NEXT:    push {r4, lr}
; CHECK-NOVFP-NEXT:    mov r4, r0
; CHECK-NOVFP-NEXT:    ldrh r0, [r0]
; CHECK-NOVFP-NEXT:    bl __aeabi_h2f
; CHECK-NOVFP-NEXT:    bl exp2f
; CHECK-NOVFP-NEXT:    bl __aeabi_f2h
; CHECK-NOVFP-NEXT:    strh r0, [r4]
; CHECK-NOVFP-NEXT:    pop {r4, pc}
  %a = load half, ptr %p, align 2
  %r = call half @llvm.exp2.f16(half %a)
  store half %r, ptr %p
  ret void
}

define void @test_log(ptr %p) #0 {
; CHECK-FP16-LABEL: test_log:
; CHECK-FP16:         .save {r4, lr}
; CHECK-FP16-NEXT:    push {r4, lr}
; CHECK-FP16-NEXT:    mov r4, r0
; CHECK-FP16-NEXT:    ldrh r0, [r0]
; CHECK-FP16-NEXT:    vmov s0, r0
; CHECK-FP16-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-FP16-NEXT:    bl logf
; CHECK-FP16-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-FP16-NEXT:    vmov r0, s0
; CHECK-FP16-NEXT:    strh r0, [r4]
; CHECK-FP16-NEXT:    pop {r4, pc}
;
; CHECK-LIBCALL-VFP-LABEL: test_log:
; CHECK-LIBCALL-VFP:         .save {r4, lr}
; CHECK-LIBCALL-VFP-NEXT:    push {r4, lr}
; CHECK-LIBCALL-VFP-NEXT:    mov r4, r0
; CHECK-LIBCALL-VFP-NEXT:    ldrh r0, [r0]
; CHECK-LIBCALL-VFP-NEXT:    bl __aeabi_h2f
; CHECK-LIBCALL-VFP-NEXT:    vmov s0, r0
; CHECK-LIBCALL-VFP-NEXT:    bl logf
; CHECK-LIBCALL-VFP-NEXT:    vmov r0, s0
; CHECK-LIBCALL-VFP-NEXT:    bl __aeabi_f2h
; CHECK-LIBCALL-VFP-NEXT:    strh r0, [r4]
; CHECK-LIBCALL-VFP-NEXT:    pop {r4, pc}
;
; CHECK-NOVFP-LABEL: test_log:
; CHECK-NOVFP:         .save {r4, lr}
; CHECK-NOVFP-NEXT:    push {r4, lr}
; CHECK-NOVFP-NEXT:    mov r4, r0
; CHECK-NOVFP-NEXT:    ldrh r0, [r0]
; CHECK-NOVFP-NEXT:    bl __aeabi_h2f
; CHECK-NOVFP-NEXT:    bl logf
; CHECK-NOVFP-NEXT:    bl __aeabi_f2h
; CHECK-NOVFP-NEXT:    strh r0, [r4]
; CHECK-NOVFP-NEXT:    pop {r4, pc}
  %a = load half, ptr %p, align 2
  %r = call half @llvm.log.f16(half %a)
  store half %r, ptr %p
  ret void
}

define void @test_log10(ptr %p) #0 {
; CHECK-FP16-LABEL: test_log10:
; CHECK-FP16:         .save {r4, lr}
; CHECK-FP16-NEXT:    push {r4, lr}
; CHECK-FP16-NEXT:    mov r4, r0
; CHECK-FP16-NEXT:    ldrh r0, [r0]
; CHECK-FP16-NEXT:    vmov s0, r0
; CHECK-FP16-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-FP16-NEXT:    bl log10f
; CHECK-FP16-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-FP16-NEXT:    vmov r0, s0
; CHECK-FP16-NEXT:    strh r0, [r4]
; CHECK-FP16-NEXT:    pop {r4, pc}
;
; CHECK-LIBCALL-VFP-LABEL: test_log10:
; CHECK-LIBCALL-VFP:         .save {r4, lr}
; CHECK-LIBCALL-VFP-NEXT:    push {r4, lr}
; CHECK-LIBCALL-VFP-NEXT:    mov r4, r0
; CHECK-LIBCALL-VFP-NEXT:    ldrh r0, [r0]
; CHECK-LIBCALL-VFP-NEXT:    bl __aeabi_h2f
; CHECK-LIBCALL-VFP-NEXT:    vmov s0, r0
; CHECK-LIBCALL-VFP-NEXT:    bl log10f
; CHECK-LIBCALL-VFP-NEXT:    vmov r0, s0
; CHECK-LIBCALL-VFP-NEXT:    bl __aeabi_f2h
; CHECK-LIBCALL-VFP-NEXT:    strh r0, [r4]
; CHECK-LIBCALL-VFP-NEXT:    pop {r4, pc}
;
; CHECK-NOVFP-LABEL: test_log10:
; CHECK-NOVFP:         .save {r4, lr}
; CHECK-NOVFP-NEXT:    push {r4, lr}
; CHECK-NOVFP-NEXT:    mov r4, r0
; CHECK-NOVFP-NEXT:    ldrh r0, [r0]
; CHECK-NOVFP-NEXT:    bl __aeabi_h2f
; CHECK-NOVFP-NEXT:    bl log10f
; CHECK-NOVFP-NEXT:    bl __aeabi_f2h
; CHECK-NOVFP-NEXT:    strh r0, [r4]
; CHECK-NOVFP-NEXT:    pop {r4, pc}
  %a = load half, ptr %p, align 2
  %r = call half @llvm.log10.f16(half %a)
  store half %r, ptr %p
  ret void
}

define void @test_log2(ptr %p) #0 {
; CHECK-FP16-LABEL: test_log2:
; CHECK-FP16:         .save {r4, lr}
; CHECK-FP16-NEXT:    push {r4, lr}
; CHECK-FP16-NEXT:    mov r4, r0
; CHECK-FP16-NEXT:    ldrh r0, [r0]
; CHECK-FP16-NEXT:    vmov s0, r0
; CHECK-FP16-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-FP16-NEXT:    bl log2f
; CHECK-FP16-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-FP16-NEXT:    vmov r0, s0
; CHECK-FP16-NEXT:    strh r0, [r4]
; CHECK-FP16-NEXT:    pop {r4, pc}
;
; CHECK-LIBCALL-VFP-LABEL: test_log2:
; CHECK-LIBCALL-VFP:         .save {r4, lr}
; CHECK-LIBCALL-VFP-NEXT:    push {r4, lr}
; CHECK-LIBCALL-VFP-NEXT:    mov r4, r0
; CHECK-LIBCALL-VFP-NEXT:    ldrh r0, [r0]
; CHECK-LIBCALL-VFP-NEXT:    bl __aeabi_h2f
; CHECK-LIBCALL-VFP-NEXT:    vmov s0, r0
; CHECK-LIBCALL-VFP-NEXT:    bl log2f
; CHECK-LIBCALL-VFP-NEXT:    vmov r0, s0
; CHECK-LIBCALL-VFP-NEXT:    bl __aeabi_f2h
; CHECK-LIBCALL-VFP-NEXT:    strh r0, [r4]
; CHECK-LIBCALL-VFP-NEXT:    pop {r4, pc}
;
; CHECK-NOVFP-LABEL: test_log2:
; CHECK-NOVFP:         .save {r4, lr}
; CHECK-NOVFP-NEXT:    push {r4, lr}
; CHECK-NOVFP-NEXT:    mov r4, r0
; CHECK-NOVFP-NEXT:    ldrh r0, [r0]
; CHECK-NOVFP-NEXT:    bl __aeabi_h2f
; CHECK-NOVFP-NEXT:    bl log2f
; CHECK-NOVFP-NEXT:    bl __aeabi_f2h
; CHECK-NOVFP-NEXT:    strh r0, [r4]
; CHECK-NOVFP-NEXT:    pop {r4, pc}
  %a = load half, ptr %p, align 2
  %r = call half @llvm.log2.f16(half %a)
  store half %r, ptr %p
  ret void
}

define void @test_fma(ptr %p, ptr %q, ptr %r) #0 {
; CHECK-FP16-LABEL: test_fma:
; CHECK-FP16:         .save {r4, lr}
; CHECK-FP16-NEXT:    push {r4, lr}
; CHECK-FP16-NEXT:    mov r4, r0
; CHECK-FP16-NEXT:    ldrh r0, [r1]
; CHECK-FP16-NEXT:    ldrh r1, [r2]
; CHECK-FP16-NEXT:    vmov s0, r0
; CHECK-FP16-NEXT:    ldrh r0, [r4]
; CHECK-FP16-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-FP16-NEXT:    vcvt.f64.f32 d16, s0
; CHECK-FP16-NEXT:    vmov s0, r0
; CHECK-FP16-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-FP16-NEXT:    vcvt.f64.f32 d17, s0
; CHECK-FP16-NEXT:    vmov s0, r1
; CHECK-FP16-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-FP16-NEXT:    vcvt.f64.f32 d18, s0
; CHECK-FP16-NEXT:    vmla.f64 d18, d17, d16
; CHECK-FP16-NEXT:    vmov r0, r1, d18
; CHECK-FP16-NEXT:    bl __aeabi_d2h
; CHECK-FP16-NEXT:    strh r0, [r4]
; CHECK-FP16-NEXT:    pop {r4, pc}
;
; CHECK-LIBCALL-VFP-LABEL: test_fma:
; CHECK-LIBCALL-VFP:         .save {r4, r5, r6, lr}
; CHECK-LIBCALL-VFP-NEXT:    push {r4, r5, r6, lr}
; CHECK-LIBCALL-VFP-NEXT:    .vsave {d8, d9}
; CHECK-LIBCALL-VFP-NEXT:    vpush {d8, d9}
; CHECK-LIBCALL-VFP-NEXT:    mov r4, r0
; CHECK-LIBCALL-VFP-NEXT:    ldrh r0, [r0]
; CHECK-LIBCALL-VFP-NEXT:    mov r5, r2
; CHECK-LIBCALL-VFP-NEXT:    mov r6, r1
; CHECK-LIBCALL-VFP-NEXT:    bl __aeabi_h2f
; CHECK-LIBCALL-VFP-NEXT:    ldrh r1, [r6]
; CHECK-LIBCALL-VFP-NEXT:    vmov s16, r0
; CHECK-LIBCALL-VFP-NEXT:    ldrh r5, [r5]
; CHECK-LIBCALL-VFP-NEXT:    mov r0, r1
; CHECK-LIBCALL-VFP-NEXT:    bl __aeabi_h2f
; CHECK-LIBCALL-VFP-NEXT:    vmov s18, r0
; CHECK-LIBCALL-VFP-NEXT:    mov r0, r5
; CHECK-LIBCALL-VFP-NEXT:    bl __aeabi_h2f
; CHECK-LIBCALL-VFP-NEXT:    vmov s0, r0
; CHECK-LIBCALL-VFP-NEXT:    vcvt.f64.f32 d16, s18
; CHECK-LIBCALL-VFP-NEXT:    vcvt.f64.f32 d17, s16
; CHECK-LIBCALL-VFP-NEXT:    vcvt.f64.f32 d18, s0
; CHECK-LIBCALL-VFP-NEXT:    vmla.f64 d18, d17, d16
; CHECK-LIBCALL-VFP-NEXT:    vmov r0, r1, d18
; CHECK-LIBCALL-VFP-NEXT:    bl __aeabi_d2h
; CHECK-LIBCALL-VFP-NEXT:    strh r0, [r4]
; CHECK-LIBCALL-VFP-NEXT:    vpop {d8, d9}
; CHECK-LIBCALL-VFP-NEXT:    pop {r4, r5, r6, pc}
;
; CHECK-NOVFP-LABEL: test_fma:
; CHECK-NOVFP:         .save {r4, r5, r6, r7, r11, lr}
; CHECK-NOVFP-NEXT:    push {r4, r5, r6, r7, r11, lr}
; CHECK-NOVFP-NEXT:    mov r4, r0
; CHECK-NOVFP-NEXT:    ldrh r0, [r1]
; CHECK-NOVFP-NEXT:    mov r5, r2
; CHECK-NOVFP-NEXT:    bl __aeabi_h2f
; CHECK-NOVFP-NEXT:    bl __aeabi_f2d
; CHECK-NOVFP-NEXT:    mov r6, r0
; CHECK-NOVFP-NEXT:    ldrh r0, [r4]
; CHECK-NOVFP-NEXT:    mov r7, r1
; CHECK-NOVFP-NEXT:    bl __aeabi_h2f
; CHECK-NOVFP-NEXT:    bl __aeabi_f2d
; CHECK-NOVFP-NEXT:    mov r2, r6
; CHECK-NOVFP-NEXT:    mov r3, r7
; CHECK-NOVFP-NEXT:    bl __aeabi_dmul
; CHECK-NOVFP-NEXT:    mov r6, r0
; CHECK-NOVFP-NEXT:    ldrh r0, [r5]
; CHECK-NOVFP-NEXT:    mov r7, r1
; CHECK-NOVFP-NEXT:    bl __aeabi_h2f
; CHECK-NOVFP-NEXT:    bl __aeabi_f2d
; CHECK-NOVFP-NEXT:    mov r2, r0
; CHECK-NOVFP-NEXT:    mov r3, r1
; CHECK-NOVFP-NEXT:    mov r0, r6
; CHECK-NOVFP-NEXT:    mov r1, r7
; CHECK-NOVFP-NEXT:    bl __aeabi_dadd
; CHECK-NOVFP-NEXT:    bl __aeabi_d2h
; CHECK-NOVFP-NEXT:    strh r0, [r4]
; CHECK-NOVFP-NEXT:    pop {r4, r5, r6, r7, r11, pc}
  %a = load half, ptr %p, align 2
  %b = load half, ptr %q, align 2
  %c = load half, ptr %r, align 2
  %v = call half @llvm.fma.f16(half %a, half %b, half %c)
  store half %v, ptr %p
  ret void
}

define void @test_fabs(ptr %p) {
; CHECK-ALL-LABEL: test_fabs:
; CHECK-ALL:         ldrh r1, [r0]
; CHECK-ALL-NEXT:    bfc r1, #15, #17
; CHECK-ALL-NEXT:    strh r1, [r0]
; CHECK-ALL-NEXT:    bx lr
  %a = load half, ptr %p, align 2
  %r = call half @llvm.fabs.f16(half %a)
  store half %r, ptr %p
  ret void
}

define void @test_minnum(ptr %p, ptr %q) #0 {
; CHECK-FP16-LABEL: test_minnum:
; CHECK-FP16:         .save {r4, lr}
; CHECK-FP16-NEXT:    push {r4, lr}
; CHECK-FP16-NEXT:    mov r4, r0
; CHECK-FP16-NEXT:    ldrh r0, [r0]
; CHECK-FP16-NEXT:    ldrh r1, [r1]
; CHECK-FP16-NEXT:    vmov s0, r0
; CHECK-FP16-NEXT:    vmov s2, r1
; CHECK-FP16-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-FP16-NEXT:    vcvtb.f32.f16 s1, s2
; CHECK-FP16-NEXT:    bl fminf
; CHECK-FP16-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-FP16-NEXT:    vmov r0, s0
; CHECK-FP16-NEXT:    strh r0, [r4]
; CHECK-FP16-NEXT:    pop {r4, pc}
;
; CHECK-LIBCALL-VFP-LABEL: test_minnum:
; CHECK-LIBCALL-VFP:         .save {r4, r5, r11, lr}
; CHECK-LIBCALL-VFP-NEXT:    push {r4, r5, r11, lr}
; CHECK-LIBCALL-VFP-NEXT:    mov r4, r0
; CHECK-LIBCALL-VFP-NEXT:    ldrh r0, [r1]
; CHECK-LIBCALL-VFP-NEXT:    bl __aeabi_h2f
; CHECK-LIBCALL-VFP-NEXT:    mov r5, r0
; CHECK-LIBCALL-VFP-NEXT:    ldrh r0, [r4]
; CHECK-LIBCALL-VFP-NEXT:    bl __aeabi_h2f
; CHECK-LIBCALL-VFP-NEXT:    vmov s0, r0
; CHECK-LIBCALL-VFP-NEXT:    vmov s1, r5
; CHECK-LIBCALL-VFP-NEXT:    bl fminf
; CHECK-LIBCALL-VFP-NEXT:    vmov r0, s0
; CHECK-LIBCALL-VFP-NEXT:    bl __aeabi_f2h
; CHECK-LIBCALL-VFP-NEXT:    strh r0, [r4]
; CHECK-LIBCALL-VFP-NEXT:    pop {r4, r5, r11, pc}
;
; CHECK-NOVFP-LABEL: test_minnum:
; CHECK-NOVFP:         .save {r4, r5, r11, lr}
; CHECK-NOVFP-NEXT:    push {r4, r5, r11, lr}
; CHECK-NOVFP-NEXT:    mov r4, r0
; CHECK-NOVFP-NEXT:    ldrh r0, [r1]
; CHECK-NOVFP-NEXT:    bl __aeabi_h2f
; CHECK-NOVFP-NEXT:    mov r5, r0
; CHECK-NOVFP-NEXT:    ldrh r0, [r4]
; CHECK-NOVFP-NEXT:    bl __aeabi_h2f
; CHECK-NOVFP-NEXT:    mov r1, r5
; CHECK-NOVFP-NEXT:    bl fminf
; CHECK-NOVFP-NEXT:    bl __aeabi_f2h
; CHECK-NOVFP-NEXT:    strh r0, [r4]
; CHECK-NOVFP-NEXT:    pop {r4, r5, r11, pc}
  %a = load half, ptr %p, align 2
  %b = load half, ptr %q, align 2
  %r = call half @llvm.minnum.f16(half %a, half %b)
  store half %r, ptr %p
  ret void
}

define void @test_maxnum(ptr %p, ptr %q) #0 {
; CHECK-FP16-LABEL: test_maxnum:
; CHECK-FP16:         .save {r4, lr}
; CHECK-FP16-NEXT:    push {r4, lr}
; CHECK-FP16-NEXT:    mov r4, r0
; CHECK-FP16-NEXT:    ldrh r0, [r0]
; CHECK-FP16-NEXT:    ldrh r1, [r1]
; CHECK-FP16-NEXT:    vmov s0, r0
; CHECK-FP16-NEXT:    vmov s2, r1
; CHECK-FP16-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-FP16-NEXT:    vcvtb.f32.f16 s1, s2
; CHECK-FP16-NEXT:    bl fmaxf
; CHECK-FP16-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-FP16-NEXT:    vmov r0, s0
; CHECK-FP16-NEXT:    strh r0, [r4]
; CHECK-FP16-NEXT:    pop {r4, pc}
;
; CHECK-LIBCALL-VFP-LABEL: test_maxnum:
; CHECK-LIBCALL-VFP:         .save {r4, r5, r11, lr}
; CHECK-LIBCALL-VFP-NEXT:    push {r4, r5, r11, lr}
; CHECK-LIBCALL-VFP-NEXT:    mov r4, r0
; CHECK-LIBCALL-VFP-NEXT:    ldrh r0, [r1]
; CHECK-LIBCALL-VFP-NEXT:    bl __aeabi_h2f
; CHECK-LIBCALL-VFP-NEXT:    mov r5, r0
; CHECK-LIBCALL-VFP-NEXT:    ldrh r0, [r4]
; CHECK-LIBCALL-VFP-NEXT:    bl __aeabi_h2f
; CHECK-LIBCALL-VFP-NEXT:    vmov s0, r0
; CHECK-LIBCALL-VFP-NEXT:    vmov s1, r5
; CHECK-LIBCALL-VFP-NEXT:    bl fmaxf
; CHECK-LIBCALL-VFP-NEXT:    vmov r0, s0
; CHECK-LIBCALL-VFP-NEXT:    bl __aeabi_f2h
; CHECK-LIBCALL-VFP-NEXT:    strh r0, [r4]
; CHECK-LIBCALL-VFP-NEXT:    pop {r4, r5, r11, pc}
;
; CHECK-NOVFP-LABEL: test_maxnum:
; CHECK-NOVFP:         .save {r4, r5, r11, lr}
; CHECK-NOVFP-NEXT:    push {r4, r5, r11, lr}
; CHECK-NOVFP-NEXT:    mov r4, r0
; CHECK-NOVFP-NEXT:    ldrh r0, [r1]
; CHECK-NOVFP-NEXT:    bl __aeabi_h2f
; CHECK-NOVFP-NEXT:    mov r5, r0
; CHECK-NOVFP-NEXT:    ldrh r0, [r4]
; CHECK-NOVFP-NEXT:    bl __aeabi_h2f
; CHECK-NOVFP-NEXT:    mov r1, r5
; CHECK-NOVFP-NEXT:    bl fmaxf
; CHECK-NOVFP-NEXT:    bl __aeabi_f2h
; CHECK-NOVFP-NEXT:    strh r0, [r4]
; CHECK-NOVFP-NEXT:    pop {r4, r5, r11, pc}
  %a = load half, ptr %p, align 2
  %b = load half, ptr %q, align 2
  %r = call half @llvm.maxnum.f16(half %a, half %b)
  store half %r, ptr %p
  ret void
}

define void @test_minimum(ptr %p) #0 {
; CHECK-FP16-LABEL: test_minimum:
; CHECK-FP16:         vmov.f32 s0, #1.000000e+00
; CHECK-FP16-NEXT:    ldrh r1, [r0]
; CHECK-FP16-NEXT:    vmov s2, r1
; CHECK-FP16-NEXT:    vcvtb.f32.f16 s2, s2
; CHECK-FP16-NEXT:    vcmp.f32 s2, s0
; CHECK-FP16-NEXT:    vmrs APSR_nzcv, fpscr
; CHECK-FP16-NEXT:    movge r1, #15360
; CHECK-FP16-NEXT:    strh r1, [r0]
; CHECK-FP16-NEXT:    bx lr
;
; CHECK-LIBCALL-VFP-LABEL: test_minimum:
; CHECK-LIBCALL-VFP:         .save {r4, r5, r11, lr}
; CHECK-LIBCALL-VFP-NEXT:    push {r4, r5, r11, lr}
; CHECK-LIBCALL-VFP-NEXT:    ldrh r5, [r0]
; CHECK-LIBCALL-VFP-NEXT:    mov r4, r0
; CHECK-LIBCALL-VFP-NEXT:    mov r0, r5
; CHECK-LIBCALL-VFP-NEXT:    bl __aeabi_h2f
; CHECK-LIBCALL-VFP-NEXT:    vmov.f32 s0, #1.000000e+00
; CHECK-LIBCALL-VFP-NEXT:    vmov s2, r0
; CHECK-LIBCALL-VFP-NEXT:    vcmp.f32 s2, s0
; CHECK-LIBCALL-VFP-NEXT:    vmrs APSR_nzcv, fpscr
; CHECK-LIBCALL-VFP-NEXT:    movge r5, #15360
; CHECK-LIBCALL-VFP-NEXT:    strh r5, [r4]
; CHECK-LIBCALL-VFP-NEXT:    pop {r4, r5, r11, pc}
;
; CHECK-NOVFP-LABEL: test_minimum:
; CHECK-NOVFP:         .save {r4, r5, r11, lr}
; CHECK-NOVFP-NEXT:    push {r4, r5, r11, lr}
; CHECK-NOVFP-NEXT:    ldrh r5, [r0]
; CHECK-NOVFP-NEXT:    mov r4, r0
; CHECK-NOVFP-NEXT:    mov r0, r5
; CHECK-NOVFP-NEXT:    bl __aeabi_h2f
; CHECK-NOVFP-NEXT:    mov r1, #1065353216
; CHECK-NOVFP-NEXT:    bl __aeabi_fcmpge
; CHECK-NOVFP-NEXT:    cmp r0, #0
; CHECK-NOVFP-NEXT:    movne r5, #15360
; CHECK-NOVFP-NEXT:    strh r5, [r4]
; CHECK-NOVFP-NEXT:    pop {r4, r5, r11, pc}
  %a = load half, ptr %p, align 2
  %c = fcmp ult half %a, 1.0
  %r = select i1 %c, half %a, half 1.0
  store half %r, ptr %p
  ret void
}

define void @test_maximum(ptr %p) #0 {
; CHECK-FP16-LABEL: test_maximum:
; CHECK-FP16:         vmov.f32 s0, #1.000000e+00
; CHECK-FP16-NEXT:    ldrh r1, [r0]
; CHECK-FP16-NEXT:    vmov s2, r1
; CHECK-FP16-NEXT:    vcvtb.f32.f16 s2, s2
; CHECK-FP16-NEXT:    vcmp.f32 s2, s0
; CHECK-FP16-NEXT:    vmrs APSR_nzcv, fpscr
; CHECK-FP16-NEXT:    movls r1, #15360
; CHECK-FP16-NEXT:    strh r1, [r0]
; CHECK-FP16-NEXT:    bx lr
;
; CHECK-LIBCALL-VFP-LABEL: test_maximum:
; CHECK-LIBCALL-VFP:         .save {r4, r5, r11, lr}
; CHECK-LIBCALL-VFP-NEXT:    push {r4, r5, r11, lr}
; CHECK-LIBCALL-VFP-NEXT:    ldrh r5, [r0]
; CHECK-LIBCALL-VFP-NEXT:    mov r4, r0
; CHECK-LIBCALL-VFP-NEXT:    mov r0, r5
; CHECK-LIBCALL-VFP-NEXT:    bl __aeabi_h2f
; CHECK-LIBCALL-VFP-NEXT:    vmov.f32 s0, #1.000000e+00
; CHECK-LIBCALL-VFP-NEXT:    vmov s2, r0
; CHECK-LIBCALL-VFP-NEXT:    vcmp.f32 s2, s0
; CHECK-LIBCALL-VFP-NEXT:    vmrs APSR_nzcv, fpscr
; CHECK-LIBCALL-VFP-NEXT:    movls r5, #15360
; CHECK-LIBCALL-VFP-NEXT:    strh r5, [r4]
; CHECK-LIBCALL-VFP-NEXT:    pop {r4, r5, r11, pc}
;
; CHECK-NOVFP-LABEL: test_maximum:
; CHECK-NOVFP:         .save {r4, r5, r11, lr}
; CHECK-NOVFP-NEXT:    push {r4, r5, r11, lr}
; CHECK-NOVFP-NEXT:    ldrh r5, [r0]
; CHECK-NOVFP-NEXT:    mov r4, r0
; CHECK-NOVFP-NEXT:    mov r0, r5
; CHECK-NOVFP-NEXT:    bl __aeabi_h2f
; CHECK-NOVFP-NEXT:    mov r1, #1065353216
; CHECK-NOVFP-NEXT:    bl __aeabi_fcmple
; CHECK-NOVFP-NEXT:    cmp r0, #0
; CHECK-NOVFP-NEXT:    movne r5, #15360
; CHECK-NOVFP-NEXT:    strh r5, [r4]
; CHECK-NOVFP-NEXT:    pop {r4, r5, r11, pc}
  %a = load half, ptr %p, align 2
  %c = fcmp ugt half %a, 1.0
  %r = select i1 %c, half %a, half 1.0
  store half %r, ptr %p
  ret void
}

define void @test_copysign(ptr %p, ptr %q) #0 {
; CHECK-ALL-LABEL: test_copysign:
; CHECK-ALL:         ldrh r2, [r0]
; CHECK-ALL-NEXT:    ldrh r1, [r1]
; CHECK-ALL-NEXT:    and r1, r1, #32768
; CHECK-ALL-NEXT:    bfc r2, #15, #17
; CHECK-ALL-NEXT:    orr r1, r2, r1
; CHECK-ALL-NEXT:    strh r1, [r0]
; CHECK-ALL-NEXT:    bx lr
  %a = load half, ptr %p, align 2
  %b = load half, ptr %q, align 2
  %r = call half @llvm.copysign.f16(half %a, half %b)
  store half %r, ptr %p
  ret void
}

define void @test_floor(ptr %p) {
; CHECK-FP16-LABEL: test_floor:
; CHECK-FP16:         .save {r4, lr}
; CHECK-FP16-NEXT:    push {r4, lr}
; CHECK-FP16-NEXT:    mov r4, r0
; CHECK-FP16-NEXT:    ldrh r0, [r0]
; CHECK-FP16-NEXT:    vmov s0, r0
; CHECK-FP16-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-FP16-NEXT:    bl floorf
; CHECK-FP16-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-FP16-NEXT:    vmov r0, s0
; CHECK-FP16-NEXT:    strh r0, [r4]
; CHECK-FP16-NEXT:    pop {r4, pc}
;
; CHECK-LIBCALL-VFP-LABEL: test_floor:
; CHECK-LIBCALL-VFP:         .save {r4, lr}
; CHECK-LIBCALL-VFP-NEXT:    push {r4, lr}
; CHECK-LIBCALL-VFP-NEXT:    mov r4, r0
; CHECK-LIBCALL-VFP-NEXT:    ldrh r0, [r0]
; CHECK-LIBCALL-VFP-NEXT:    bl __aeabi_h2f
; CHECK-LIBCALL-VFP-NEXT:    vmov s0, r0
; CHECK-LIBCALL-VFP-NEXT:    bl floorf
; CHECK-LIBCALL-VFP-NEXT:    vmov r0, s0
; CHECK-LIBCALL-VFP-NEXT:    bl __aeabi_f2h
; CHECK-LIBCALL-VFP-NEXT:    strh r0, [r4]
; CHECK-LIBCALL-VFP-NEXT:    pop {r4, pc}
;
; CHECK-NOVFP-LABEL: test_floor:
; CHECK-NOVFP:         .save {r4, lr}
; CHECK-NOVFP-NEXT:    push {r4, lr}
; CHECK-NOVFP-NEXT:    mov r4, r0
; CHECK-NOVFP-NEXT:    ldrh r0, [r0]
; CHECK-NOVFP-NEXT:    bl __aeabi_h2f
; CHECK-NOVFP-NEXT:    bl floorf
; CHECK-NOVFP-NEXT:    bl __aeabi_f2h
; CHECK-NOVFP-NEXT:    strh r0, [r4]
; CHECK-NOVFP-NEXT:    pop {r4, pc}
  %a = load half, ptr %p, align 2
  %r = call half @llvm.floor.f16(half %a)
  store half %r, ptr %p
  ret void
}

define void @test_ceil(ptr %p) {
; CHECK-FP16-LABEL: test_ceil:
; CHECK-FP16:         .save {r4, lr}
; CHECK-FP16-NEXT:    push {r4, lr}
; CHECK-FP16-NEXT:    mov r4, r0
; CHECK-FP16-NEXT:    ldrh r0, [r0]
; CHECK-FP16-NEXT:    vmov s0, r0
; CHECK-FP16-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-FP16-NEXT:    bl ceilf
; CHECK-FP16-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-FP16-NEXT:    vmov r0, s0
; CHECK-FP16-NEXT:    strh r0, [r4]
; CHECK-FP16-NEXT:    pop {r4, pc}
;
; CHECK-LIBCALL-VFP-LABEL: test_ceil:
; CHECK-LIBCALL-VFP:         .save {r4, lr}
; CHECK-LIBCALL-VFP-NEXT:    push {r4, lr}
; CHECK-LIBCALL-VFP-NEXT:    mov r4, r0
; CHECK-LIBCALL-VFP-NEXT:    ldrh r0, [r0]
; CHECK-LIBCALL-VFP-NEXT:    bl __aeabi_h2f
; CHECK-LIBCALL-VFP-NEXT:    vmov s0, r0
; CHECK-LIBCALL-VFP-NEXT:    bl ceilf
; CHECK-LIBCALL-VFP-NEXT:    vmov r0, s0
; CHECK-LIBCALL-VFP-NEXT:    bl __aeabi_f2h
; CHECK-LIBCALL-VFP-NEXT:    strh r0, [r4]
; CHECK-LIBCALL-VFP-NEXT:    pop {r4, pc}
;
; CHECK-NOVFP-LABEL: test_ceil:
; CHECK-NOVFP:         .save {r4, lr}
; CHECK-NOVFP-NEXT:    push {r4, lr}
; CHECK-NOVFP-NEXT:    mov r4, r0
; CHECK-NOVFP-NEXT:    ldrh r0, [r0]
; CHECK-NOVFP-NEXT:    bl __aeabi_h2f
; CHECK-NOVFP-NEXT:    bl ceilf
; CHECK-NOVFP-NEXT:    bl __aeabi_f2h
; CHECK-NOVFP-NEXT:    strh r0, [r4]
; CHECK-NOVFP-NEXT:    pop {r4, pc}
  %a = load half, ptr %p, align 2
  %r = call half @llvm.ceil.f16(half %a)
  store half %r, ptr %p
  ret void
}

define void @test_trunc(ptr %p) {
; CHECK-FP16-LABEL: test_trunc:
; CHECK-FP16:         .save {r4, lr}
; CHECK-FP16-NEXT:    push {r4, lr}
; CHECK-FP16-NEXT:    mov r4, r0
; CHECK-FP16-NEXT:    ldrh r0, [r0]
; CHECK-FP16-NEXT:    vmov s0, r0
; CHECK-FP16-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-FP16-NEXT:    bl truncf
; CHECK-FP16-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-FP16-NEXT:    vmov r0, s0
; CHECK-FP16-NEXT:    strh r0, [r4]
; CHECK-FP16-NEXT:    pop {r4, pc}
;
; CHECK-LIBCALL-VFP-LABEL: test_trunc:
; CHECK-LIBCALL-VFP:         .save {r4, lr}
; CHECK-LIBCALL-VFP-NEXT:    push {r4, lr}
; CHECK-LIBCALL-VFP-NEXT:    mov r4, r0
; CHECK-LIBCALL-VFP-NEXT:    ldrh r0, [r0]
; CHECK-LIBCALL-VFP-NEXT:    bl __aeabi_h2f
; CHECK-LIBCALL-VFP-NEXT:    vmov s0, r0
; CHECK-LIBCALL-VFP-NEXT:    bl truncf
; CHECK-LIBCALL-VFP-NEXT:    vmov r0, s0
; CHECK-LIBCALL-VFP-NEXT:    bl __aeabi_f2h
; CHECK-LIBCALL-VFP-NEXT:    strh r0, [r4]
; CHECK-LIBCALL-VFP-NEXT:    pop {r4, pc}
;
; CHECK-NOVFP-LABEL: test_trunc:
; CHECK-NOVFP:         .save {r4, lr}
; CHECK-NOVFP-NEXT:    push {r4, lr}
; CHECK-NOVFP-NEXT:    mov r4, r0
; CHECK-NOVFP-NEXT:    ldrh r0, [r0]
; CHECK-NOVFP-NEXT:    bl __aeabi_h2f
; CHECK-NOVFP-NEXT:    bl truncf
; CHECK-NOVFP-NEXT:    bl __aeabi_f2h
; CHECK-NOVFP-NEXT:    strh r0, [r4]
; CHECK-NOVFP-NEXT:    pop {r4, pc}
  %a = load half, ptr %p, align 2
  %r = call half @llvm.trunc.f16(half %a)
  store half %r, ptr %p
  ret void
}

define void @test_rint(ptr %p) {
; CHECK-FP16-LABEL: test_rint:
; CHECK-FP16:         .save {r4, lr}
; CHECK-FP16-NEXT:    push {r4, lr}
; CHECK-FP16-NEXT:    mov r4, r0
; CHECK-FP16-NEXT:    ldrh r0, [r0]
; CHECK-FP16-NEXT:    vmov s0, r0
; CHECK-FP16-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-FP16-NEXT:    bl rintf
; CHECK-FP16-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-FP16-NEXT:    vmov r0, s0
; CHECK-FP16-NEXT:    strh r0, [r4]
; CHECK-FP16-NEXT:    pop {r4, pc}
;
; CHECK-LIBCALL-VFP-LABEL: test_rint:
; CHECK-LIBCALL-VFP:         .save {r4, lr}
; CHECK-LIBCALL-VFP-NEXT:    push {r4, lr}
; CHECK-LIBCALL-VFP-NEXT:    mov r4, r0
; CHECK-LIBCALL-VFP-NEXT:    ldrh r0, [r0]
; CHECK-LIBCALL-VFP-NEXT:    bl __aeabi_h2f
; CHECK-LIBCALL-VFP-NEXT:    vmov s0, r0
; CHECK-LIBCALL-VFP-NEXT:    bl rintf
; CHECK-LIBCALL-VFP-NEXT:    vmov r0, s0
; CHECK-LIBCALL-VFP-NEXT:    bl __aeabi_f2h
; CHECK-LIBCALL-VFP-NEXT:    strh r0, [r4]
; CHECK-LIBCALL-VFP-NEXT:    pop {r4, pc}
;
; CHECK-NOVFP-LABEL: test_rint:
; CHECK-NOVFP:         .save {r4, lr}
; CHECK-NOVFP-NEXT:    push {r4, lr}
; CHECK-NOVFP-NEXT:    mov r4, r0
; CHECK-NOVFP-NEXT:    ldrh r0, [r0]
; CHECK-NOVFP-NEXT:    bl __aeabi_h2f
; CHECK-NOVFP-NEXT:    bl rintf
; CHECK-NOVFP-NEXT:    bl __aeabi_f2h
; CHECK-NOVFP-NEXT:    strh r0, [r4]
; CHECK-NOVFP-NEXT:    pop {r4, pc}
  %a = load half, ptr %p, align 2
  %r = call half @llvm.rint.f16(half %a)
  store half %r, ptr %p
  ret void
}

define void @test_nearbyint(ptr %p) {
; CHECK-FP16-LABEL: test_nearbyint:
; CHECK-FP16:         .save {r4, lr}
; CHECK-FP16-NEXT:    push {r4, lr}
; CHECK-FP16-NEXT:    mov r4, r0
; CHECK-FP16-NEXT:    ldrh r0, [r0]
; CHECK-FP16-NEXT:    vmov s0, r0
; CHECK-FP16-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-FP16-NEXT:    bl nearbyintf
; CHECK-FP16-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-FP16-NEXT:    vmov r0, s0
; CHECK-FP16-NEXT:    strh r0, [r4]
; CHECK-FP16-NEXT:    pop {r4, pc}
;
; CHECK-LIBCALL-VFP-LABEL: test_nearbyint:
; CHECK-LIBCALL-VFP:         .save {r4, lr}
; CHECK-LIBCALL-VFP-NEXT:    push {r4, lr}
; CHECK-LIBCALL-VFP-NEXT:    mov r4, r0
; CHECK-LIBCALL-VFP-NEXT:    ldrh r0, [r0]
; CHECK-LIBCALL-VFP-NEXT:    bl __aeabi_h2f
; CHECK-LIBCALL-VFP-NEXT:    vmov s0, r0
; CHECK-LIBCALL-VFP-NEXT:    bl nearbyintf
; CHECK-LIBCALL-VFP-NEXT:    vmov r0, s0
; CHECK-LIBCALL-VFP-NEXT:    bl __aeabi_f2h
; CHECK-LIBCALL-VFP-NEXT:    strh r0, [r4]
; CHECK-LIBCALL-VFP-NEXT:    pop {r4, pc}
;
; CHECK-NOVFP-LABEL: test_nearbyint:
; CHECK-NOVFP:         .save {r4, lr}
; CHECK-NOVFP-NEXT:    push {r4, lr}
; CHECK-NOVFP-NEXT:    mov r4, r0
; CHECK-NOVFP-NEXT:    ldrh r0, [r0]
; CHECK-NOVFP-NEXT:    bl __aeabi_h2f
; CHECK-NOVFP-NEXT:    bl nearbyintf
; CHECK-NOVFP-NEXT:    bl __aeabi_f2h
; CHECK-NOVFP-NEXT:    strh r0, [r4]
; CHECK-NOVFP-NEXT:    pop {r4, pc}
  %a = load half, ptr %p, align 2
  %r = call half @llvm.nearbyint.f16(half %a)
  store half %r, ptr %p
  ret void
}

define void @test_round(ptr %p) {
; CHECK-FP16-LABEL: test_round:
; CHECK-FP16:         .save {r4, lr}
; CHECK-FP16-NEXT:    push {r4, lr}
; CHECK-FP16-NEXT:    mov r4, r0
; CHECK-FP16-NEXT:    ldrh r0, [r0]
; CHECK-FP16-NEXT:    vmov s0, r0
; CHECK-FP16-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-FP16-NEXT:    bl roundf
; CHECK-FP16-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-FP16-NEXT:    vmov r0, s0
; CHECK-FP16-NEXT:    strh r0, [r4]
; CHECK-FP16-NEXT:    pop {r4, pc}
;
; CHECK-LIBCALL-VFP-LABEL: test_round:
; CHECK-LIBCALL-VFP:         .save {r4, lr}
; CHECK-LIBCALL-VFP-NEXT:    push {r4, lr}
; CHECK-LIBCALL-VFP-NEXT:    mov r4, r0
; CHECK-LIBCALL-VFP-NEXT:    ldrh r0, [r0]
; CHECK-LIBCALL-VFP-NEXT:    bl __aeabi_h2f
; CHECK-LIBCALL-VFP-NEXT:    vmov s0, r0
; CHECK-LIBCALL-VFP-NEXT:    bl roundf
; CHECK-LIBCALL-VFP-NEXT:    vmov r0, s0
; CHECK-LIBCALL-VFP-NEXT:    bl __aeabi_f2h
; CHECK-LIBCALL-VFP-NEXT:    strh r0, [r4]
; CHECK-LIBCALL-VFP-NEXT:    pop {r4, pc}
;
; CHECK-NOVFP-LABEL: test_round:
; CHECK-NOVFP:         .save {r4, lr}
; CHECK-NOVFP-NEXT:    push {r4, lr}
; CHECK-NOVFP-NEXT:    mov r4, r0
; CHECK-NOVFP-NEXT:    ldrh r0, [r0]
; CHECK-NOVFP-NEXT:    bl __aeabi_h2f
; CHECK-NOVFP-NEXT:    bl roundf
; CHECK-NOVFP-NEXT:    bl __aeabi_f2h
; CHECK-NOVFP-NEXT:    strh r0, [r4]
; CHECK-NOVFP-NEXT:    pop {r4, pc}
  %a = load half, ptr %p, align 2
  %r = call half @llvm.round.f16(half %a)
  store half %r, ptr %p
  ret void
}

define void @test_roundeven(ptr %p) {
; CHECK-FP16-LABEL: test_roundeven:
; CHECK-FP16:         .save {r4, lr}
; CHECK-FP16-NEXT:    push {r4, lr}
; CHECK-FP16-NEXT:    mov r4, r0
; CHECK-FP16-NEXT:    ldrh r0, [r0]
; CHECK-FP16-NEXT:    vmov s0, r0
; CHECK-FP16-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-FP16-NEXT:    bl roundevenf
; CHECK-FP16-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-FP16-NEXT:    vmov r0, s0
; CHECK-FP16-NEXT:    strh r0, [r4]
; CHECK-FP16-NEXT:    pop {r4, pc}
;
; CHECK-LIBCALL-VFP-LABEL: test_roundeven:
; CHECK-LIBCALL-VFP:         .save {r4, lr}
; CHECK-LIBCALL-VFP-NEXT:    push {r4, lr}
; CHECK-LIBCALL-VFP-NEXT:    mov r4, r0
; CHECK-LIBCALL-VFP-NEXT:    ldrh r0, [r0]
; CHECK-LIBCALL-VFP-NEXT:    bl __aeabi_h2f
; CHECK-LIBCALL-VFP-NEXT:    vmov s0, r0
; CHECK-LIBCALL-VFP-NEXT:    bl roundevenf
; CHECK-LIBCALL-VFP-NEXT:    vmov r0, s0
; CHECK-LIBCALL-VFP-NEXT:    bl __aeabi_f2h
; CHECK-LIBCALL-VFP-NEXT:    strh r0, [r4]
; CHECK-LIBCALL-VFP-NEXT:    pop {r4, pc}
;
; CHECK-NOVFP-LABEL: test_roundeven:
; CHECK-NOVFP:         .save {r4, lr}
; CHECK-NOVFP-NEXT:    push {r4, lr}
; CHECK-NOVFP-NEXT:    mov r4, r0
; CHECK-NOVFP-NEXT:    ldrh r0, [r0]
; CHECK-NOVFP-NEXT:    bl __aeabi_h2f
; CHECK-NOVFP-NEXT:    bl roundevenf
; CHECK-NOVFP-NEXT:    bl __aeabi_f2h
; CHECK-NOVFP-NEXT:    strh r0, [r4]
; CHECK-NOVFP-NEXT:    pop {r4, pc}
  %a = load half, ptr %p, align 2
  %r = call half @llvm.roundeven.f16(half %a)
  store half %r, ptr %p
  ret void
}

define void @test_fmuladd(ptr %p, ptr %q, ptr %r) #0 {
; CHECK-FP16-LABEL: test_fmuladd:
; CHECK-FP16:         ldrh r3, [r0]
; CHECK-FP16-NEXT:    ldrh r1, [r1]
; CHECK-FP16-NEXT:    ldrh r2, [r2]
; CHECK-FP16-NEXT:    vmov s0, r3
; CHECK-FP16-NEXT:    vmov s2, r1
; CHECK-FP16-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-FP16-NEXT:    vcvtb.f32.f16 s2, s2
; CHECK-FP16-NEXT:    vmul.f32 s0, s0, s2
; CHECK-FP16-NEXT:    vmov s2, r2
; CHECK-FP16-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-FP16-NEXT:    vcvtb.f32.f16 s2, s2
; CHECK-FP16-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-FP16-NEXT:    vadd.f32 s0, s0, s2
; CHECK-FP16-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-FP16-NEXT:    vmov r1, s0
; CHECK-FP16-NEXT:    strh r1, [r0]
; CHECK-FP16-NEXT:    bx lr
;
; CHECK-LIBCALL-VFP-LABEL: test_fmuladd:
; CHECK-LIBCALL-VFP:         .save {r4, r5, r6, lr}
; CHECK-LIBCALL-VFP-NEXT:    push {r4, r5, r6, lr}
; CHECK-LIBCALL-VFP-NEXT:    .vsave {d8}
; CHECK-LIBCALL-VFP-NEXT:    vpush {d8}
; CHECK-LIBCALL-VFP-NEXT:    mov r4, r0
; CHECK-LIBCALL-VFP-NEXT:    ldrh r0, [r1]
; CHECK-LIBCALL-VFP-NEXT:    mov r5, r2
; CHECK-LIBCALL-VFP-NEXT:    bl __aeabi_h2f
; CHECK-LIBCALL-VFP-NEXT:    ldrh r1, [r4]
; CHECK-LIBCALL-VFP-NEXT:    vmov s16, r0
; CHECK-LIBCALL-VFP-NEXT:    mov r0, r1
; CHECK-LIBCALL-VFP-NEXT:    bl __aeabi_h2f
; CHECK-LIBCALL-VFP-NEXT:    vmov s0, r0
; CHECK-LIBCALL-VFP-NEXT:    vmul.f32 s0, s0, s16
; CHECK-LIBCALL-VFP-NEXT:    vmov r0, s0
; CHECK-LIBCALL-VFP-NEXT:    bl __aeabi_f2h
; CHECK-LIBCALL-VFP-NEXT:    bl __aeabi_h2f
; CHECK-LIBCALL-VFP-NEXT:    mov r6, r0
; CHECK-LIBCALL-VFP-NEXT:    ldrh r0, [r5]
; CHECK-LIBCALL-VFP-NEXT:    bl __aeabi_h2f
; CHECK-LIBCALL-VFP-NEXT:    vmov s0, r0
; CHECK-LIBCALL-VFP-NEXT:    vmov s2, r6
; CHECK-LIBCALL-VFP-NEXT:    vadd.f32 s0, s2, s0
; CHECK-LIBCALL-VFP-NEXT:    vmov r0, s0
; CHECK-LIBCALL-VFP-NEXT:    bl __aeabi_f2h
; CHECK-LIBCALL-VFP-NEXT:    strh r0, [r4]
; CHECK-LIBCALL-VFP-NEXT:    vpop {d8}
; CHECK-LIBCALL-VFP-NEXT:    pop {r4, r5, r6, pc}
;
; CHECK-NOVFP-LABEL: test_fmuladd:
; CHECK-NOVFP:         .save {r4, r5, r6, lr}
; CHECK-NOVFP-NEXT:    push {r4, r5, r6, lr}
; CHECK-NOVFP-NEXT:    mov r4, r0
; CHECK-NOVFP-NEXT:    ldrh r0, [r1]
; CHECK-NOVFP-NEXT:    mov r5, r2
; CHECK-NOVFP-NEXT:    bl __aeabi_h2f
; CHECK-NOVFP-NEXT:    mov r6, r0
; CHECK-NOVFP-NEXT:    ldrh r0, [r4]
; CHECK-NOVFP-NEXT:    bl __aeabi_h2f
; CHECK-NOVFP-NEXT:    mov r1, r6
; CHECK-NOVFP-NEXT:    bl __aeabi_fmul
; CHECK-NOVFP-NEXT:    bl __aeabi_f2h
; CHECK-NOVFP-NEXT:    mov r6, r0
; CHECK-NOVFP-NEXT:    ldrh r0, [r5]
; CHECK-NOVFP-NEXT:    bl __aeabi_h2f
; CHECK-NOVFP-NEXT:    mov r5, r0
; CHECK-NOVFP-NEXT:    uxth r0, r6
; CHECK-NOVFP-NEXT:    bl __aeabi_h2f
; CHECK-NOVFP-NEXT:    mov r1, r5
; CHECK-NOVFP-NEXT:    bl __aeabi_fadd
; CHECK-NOVFP-NEXT:    bl __aeabi_f2h
; CHECK-NOVFP-NEXT:    strh r0, [r4]
; CHECK-NOVFP-NEXT:    pop {r4, r5, r6, pc}
  %a = load half, ptr %p, align 2
  %b = load half, ptr %q, align 2
  %c = load half, ptr %r, align 2
  %v = call half @llvm.fmuladd.f16(half %a, half %b, half %c)
  store half %v, ptr %p
  ret void
}

; f16 vectors are not legal in the backend.  Vector elements are not assigned
; to the register, but are stored in the stack instead.  Hence insertelement
; and extractelement have these extra loads and stores.
define void @test_insertelement(ptr %p, ptr %q, i32 %i) #0 {
; CHECK-VFP-LABEL: test_insertelement:
; CHECK-VFP:         .save {r4, r5, r11, lr}
; CHECK-VFP-NEXT:    push {r4, r5, r11, lr}
; CHECK-VFP-NEXT:    .pad #8
; CHECK-VFP-NEXT:    sub sp, sp, #8
; CHECK-VFP-NEXT:    and r2, r2, #3
; CHECK-VFP-NEXT:    mov r3, sp
; CHECK-VFP-NEXT:    ldrd r4, r5, [r1]
; CHECK-VFP-NEXT:    orr r2, r3, r2, lsl #1
; CHECK-VFP-NEXT:    ldrh r0, [r0]
; CHECK-VFP-NEXT:    stm sp, {r4, r5}
; CHECK-VFP-NEXT:    strh r0, [r2]
; CHECK-VFP-NEXT:    ldrh r0, [sp, #6]
; CHECK-VFP-NEXT:    ldrh r2, [sp, #4]
; CHECK-VFP-NEXT:    ldrh r3, [sp, #2]
; CHECK-VFP-NEXT:    ldrh r5, [sp]
; CHECK-VFP-NEXT:    strh r0, [r1, #6]
; CHECK-VFP-NEXT:    strh r2, [r1, #4]
; CHECK-VFP-NEXT:    strh r3, [r1, #2]
; CHECK-VFP-NEXT:    strh r5, [r1]
; CHECK-VFP-NEXT:    add sp, sp, #8
; CHECK-VFP-NEXT:    pop {r4, r5, r11, pc}
;
; CHECK-NOVFP-LABEL: test_insertelement:
; CHECK-NOVFP:         .save {r4, r5, r11, lr}
; CHECK-NOVFP-NEXT:    push {r4, r5, r11, lr}
; CHECK-NOVFP-NEXT:    .pad #8
; CHECK-NOVFP-NEXT:    sub sp, sp, #8
; CHECK-NOVFP-NEXT:    ldrd r4, r5, [r1]
; CHECK-NOVFP-NEXT:    and r2, r2, #3
; CHECK-NOVFP-NEXT:    mov r3, sp
; CHECK-NOVFP-NEXT:    stm sp, {r4, r5}
; CHECK-NOVFP-NEXT:    orr r2, r3, r2, lsl #1
; CHECK-NOVFP-NEXT:    ldrh r0, [r0]
; CHECK-NOVFP-NEXT:    strh r0, [r2]
; CHECK-NOVFP-NEXT:    ldrh r0, [sp, #6]
; CHECK-NOVFP-NEXT:    strh r0, [r1, #6]
; CHECK-NOVFP-NEXT:    ldrh r0, [sp, #4]
; CHECK-NOVFP-NEXT:    strh r0, [r1, #4]
; CHECK-NOVFP-NEXT:    ldrh r0, [sp, #2]
; CHECK-NOVFP-NEXT:    strh r0, [r1, #2]
; CHECK-NOVFP-NEXT:    ldrh r0, [sp]
; CHECK-NOVFP-NEXT:    strh r0, [r1]
; CHECK-NOVFP-NEXT:    add sp, sp, #8
; CHECK-NOVFP-NEXT:    pop {r4, r5, r11, pc}


  %a = load half, ptr %p, align 2
  %b = load <4 x half>, ptr %q, align 8
  %c = insertelement <4 x half> %b, half %a, i32 %i
  store volatile <4 x half> %c, ptr %q
  ret void
}

define void @test_extractelement(ptr %p, ptr %q, i32 %i) #0 {
; CHECK-ALL-LABEL: test_extractelement:
; CHECK-ALL:         .save {r4, r5, r11, lr}
; CHECK-ALL-NEXT:    push {r4, r5, r11, lr}
; CHECK-ALL-NEXT:    .pad #8
; CHECK-ALL-NEXT:    sub sp, sp, #8
; CHECK-ALL-NEXT:    ldrd r4, r5, [r1]
; CHECK-ALL-NEXT:    and r1, r2, #3
; CHECK-ALL-NEXT:    mov r2, sp
; CHECK-ALL-NEXT:    orr r1, r2, r1, lsl #1
; CHECK-ALL-NEXT:    stm sp, {r4, r5}
; CHECK-ALL-NEXT:    ldrh r1, [r1]
; CHECK-ALL-NEXT:    strh r1, [r0]
; CHECK-ALL-NEXT:    add sp, sp, #8
; CHECK-ALL-NEXT:    pop {r4, r5, r11, pc}
  %a = load <4 x half>, ptr %q, align 8
  %b = extractelement <4 x half> %a, i32 %i
  store half %b, ptr %p
  ret void
}

; test struct operations

%struct.dummy = type { i32, half }

define void @test_insertvalue(ptr %p, ptr %q) {
; CHECK-ALL-LABEL: test_insertvalue:
; CHECK-ALL:         ldrh r1, [r1]
; CHECK-ALL-NEXT:    strh r1, [r0, #4]
; CHECK-ALL-NEXT:    bx lr
  %a = load %struct.dummy, ptr %p
  %b = load half, ptr %q
  %c = insertvalue %struct.dummy %a, half %b, 1
  store %struct.dummy %c, ptr %p
  ret void
}

define void @test_extractvalue(ptr %p, ptr %q) {
; CHECK-ALL-LABEL: test_extractvalue:
; CHECK-ALL:         ldrh r0, [r0, #4]
; CHECK-ALL-NEXT:    strh r0, [r1]
; CHECK-ALL-NEXT:    bx lr
  %a = load %struct.dummy, ptr %p
  %b = extractvalue %struct.dummy %a, 1
  store half %b, ptr %q
  ret void
}

define %struct.dummy @test_struct_return(ptr %p) {
; CHECK-VFP-LABEL: test_struct_return:
; CHECK-VFP:         ldrh r1, [r0, #4]
; CHECK-VFP-NEXT:    ldr r0, [r0]
; CHECK-VFP-NEXT:    vmov s0, r1
; CHECK-VFP-NEXT:    bx lr
;
; CHECK-NOVFP-LABEL: test_struct_return:
; CHECK-NOVFP:         ldr r2, [r0]
; CHECK-NOVFP-NEXT:    ldrh r1, [r0, #4]
; CHECK-NOVFP-NEXT:    mov r0, r2
; CHECK-NOVFP-NEXT:    bx lr
; CHECK-VFP-LIBCALL: bl __aeabi_h2f
  %a = load %struct.dummy, ptr %p
  ret %struct.dummy %a
}

define half @test_struct_arg(%struct.dummy %p) {
; CHECK-VFP-LABEL: test_struct_arg:
; CHECK-VFP:         bx lr
;
; CHECK-NOVFP-LABEL: test_struct_arg:
; CHECK-NOVFP:         mov r0, r1
; CHECK-NOVFP-NEXT:    bx lr
  %a = extractvalue %struct.dummy %p, 1
  ret half %a
}

define half @test_uitofp_i32_fadd(i32 %a, half %b) #0 {
; CHECK-FP16-LABEL: test_uitofp_i32_fadd:
; CHECK-FP16:         vmov s2, r0
; CHECK-FP16-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-FP16-NEXT:    vcvt.f32.u32 s2, s2
; CHECK-FP16-NEXT:    vcvtb.f16.f32 s2, s2
; CHECK-FP16-NEXT:    vcvtb.f32.f16 s2, s2
; CHECK-FP16-NEXT:    vadd.f32 s0, s0, s2
; CHECK-FP16-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-FP16-NEXT:    bx lr
;
; CHECK-LIBCALL-VFP-LABEL: test_uitofp_i32_fadd:
; CHECK-LIBCALL-VFP:         .save {r4, lr}
; CHECK-LIBCALL-VFP-NEXT:    push {r4, lr}
; CHECK-LIBCALL-VFP-NEXT:    .vsave {d8}
; CHECK-LIBCALL-VFP-NEXT:    vpush {d8}
; CHECK-LIBCALL-VFP-NEXT:    vmov r1, s0
; CHECK-LIBCALL-VFP-NEXT:    vmov s0, r0
; CHECK-LIBCALL-VFP-NEXT:    vcvt.f32.u32 s16, s0
; CHECK-LIBCALL-VFP-NEXT:    mov r0, r1
; CHECK-LIBCALL-VFP-NEXT:    bl __aeabi_h2f
; CHECK-LIBCALL-VFP-NEXT:    mov r4, r0
; CHECK-LIBCALL-VFP-NEXT:    vmov r0, s16
; CHECK-LIBCALL-VFP-NEXT:    bl __aeabi_f2h
; CHECK-LIBCALL-VFP-NEXT:    vmov s16, r4
; CHECK-LIBCALL-VFP-NEXT:    bl __aeabi_h2f
; CHECK-LIBCALL-VFP-NEXT:    vmov s0, r0
; CHECK-LIBCALL-VFP-NEXT:    vadd.f32 s0, s16, s0
; CHECK-LIBCALL-VFP-NEXT:    vmov r0, s0
; CHECK-LIBCALL-VFP-NEXT:    bl __aeabi_f2h
; CHECK-LIBCALL-VFP-NEXT:    vmov s0, r0
; CHECK-LIBCALL-VFP-NEXT:    vpop {d8}
; CHECK-LIBCALL-VFP-NEXT:    pop {r4, pc}
;
; CHECK-NOVFP-LABEL: test_uitofp_i32_fadd:
; CHECK-NOVFP:         .save {r4, r5, r11, lr}
; CHECK-NOVFP-NEXT:    push {r4, r5, r11, lr}
; CHECK-NOVFP-NEXT:    mov r4, r1
; CHECK-NOVFP-NEXT:    bl __aeabi_ui2f
; CHECK-NOVFP-NEXT:    bl __aeabi_f2h
; CHECK-NOVFP-NEXT:    mov r5, r0
; CHECK-NOVFP-NEXT:    uxth r0, r4
; CHECK-NOVFP-NEXT:    bl __aeabi_h2f
; CHECK-NOVFP-NEXT:    mov r4, r0
; CHECK-NOVFP-NEXT:    uxth r0, r5
; CHECK-NOVFP-NEXT:    bl __aeabi_h2f
; CHECK-NOVFP-NEXT:    mov r1, r0
; CHECK-NOVFP-NEXT:    mov r0, r4
; CHECK-NOVFP-NEXT:    bl __aeabi_fadd
; CHECK-NOVFP-NEXT:    bl __aeabi_f2h
; CHECK-NOVFP-NEXT:    pop {r4, r5, r11, pc}



  %c = uitofp i32 %a to half
  %r = fadd half %b, %c
  ret half %r
}

define half @test_sitofp_i32_fadd(i32 %a, half %b) #0 {
; CHECK-FP16-LABEL: test_sitofp_i32_fadd:
; CHECK-FP16:         vmov s2, r0
; CHECK-FP16-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-FP16-NEXT:    vcvt.f32.s32 s2, s2
; CHECK-FP16-NEXT:    vcvtb.f16.f32 s2, s2
; CHECK-FP16-NEXT:    vcvtb.f32.f16 s2, s2
; CHECK-FP16-NEXT:    vadd.f32 s0, s0, s2
; CHECK-FP16-NEXT:    vcvtb.f16.f32 s0, s0
; CHECK-FP16-NEXT:    bx lr
;
; CHECK-LIBCALL-VFP-LABEL: test_sitofp_i32_fadd:
; CHECK-LIBCALL-VFP:         .save {r4, lr}
; CHECK-LIBCALL-VFP-NEXT:    push {r4, lr}
; CHECK-LIBCALL-VFP-NEXT:    .vsave {d8}
; CHECK-LIBCALL-VFP-NEXT:    vpush {d8}
; CHECK-LIBCALL-VFP-NEXT:    vmov r1, s0
; CHECK-LIBCALL-VFP-NEXT:    vmov s0, r0
; CHECK-LIBCALL-VFP-NEXT:    vcvt.f32.s32 s16, s0
; CHECK-LIBCALL-VFP-NEXT:    mov r0, r1
; CHECK-LIBCALL-VFP-NEXT:    bl __aeabi_h2f
; CHECK-LIBCALL-VFP-NEXT:    mov r4, r0
; CHECK-LIBCALL-VFP-NEXT:    vmov r0, s16
; CHECK-LIBCALL-VFP-NEXT:    bl __aeabi_f2h
; CHECK-LIBCALL-VFP-NEXT:    vmov s16, r4
; CHECK-LIBCALL-VFP-NEXT:    bl __aeabi_h2f
; CHECK-LIBCALL-VFP-NEXT:    vmov s0, r0
; CHECK-LIBCALL-VFP-NEXT:    vadd.f32 s0, s16, s0
; CHECK-LIBCALL-VFP-NEXT:    vmov r0, s0
; CHECK-LIBCALL-VFP-NEXT:    bl __aeabi_f2h
; CHECK-LIBCALL-VFP-NEXT:    vmov s0, r0
; CHECK-LIBCALL-VFP-NEXT:    vpop {d8}
; CHECK-LIBCALL-VFP-NEXT:    pop {r4, pc}
;
; CHECK-NOVFP-LABEL: test_sitofp_i32_fadd:
; CHECK-NOVFP:         .save {r4, r5, r11, lr}
; CHECK-NOVFP-NEXT:    push {r4, r5, r11, lr}
; CHECK-NOVFP-NEXT:    mov r4, r1
; CHECK-NOVFP-NEXT:    bl __aeabi_i2f
; CHECK-NOVFP-NEXT:    bl __aeabi_f2h
; CHECK-NOVFP-NEXT:    mov r5, r0
; CHECK-NOVFP-NEXT:    uxth r0, r4
; CHECK-NOVFP-NEXT:    bl __aeabi_h2f
; CHECK-NOVFP-NEXT:    mov r4, r0
; CHECK-NOVFP-NEXT:    uxth r0, r5
; CHECK-NOVFP-NEXT:    bl __aeabi_h2f
; CHECK-NOVFP-NEXT:    mov r1, r0
; CHECK-NOVFP-NEXT:    mov r0, r4
; CHECK-NOVFP-NEXT:    bl __aeabi_fadd
; CHECK-NOVFP-NEXT:    bl __aeabi_f2h
; CHECK-NOVFP-NEXT:    pop {r4, r5, r11, pc}



  %c = sitofp i32 %a to half
  %r = fadd half %b, %c
  ret half %r
}

define void @test_fneg(ptr %p1, ptr %p2) #0 {
; CHECK-ALL-LABEL: test_fneg:
; CHECK-ALL:         ldrh r0, [r0]
; CHECK-ALL-NEXT:    eor r0, r0, #32768
; CHECK-ALL-NEXT:    strh r0, [r1]
; CHECK-ALL-NEXT:    bx lr
  %v = load half, ptr %p1, align 2
  %res = fneg half %v
  store half %res, ptr %p2, align 2
  ret void
}

attributes #0 = { nounwind }
