; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=mips -mcpu=mips32r2 < %s | FileCheck %s

define void @unused_div(float %x, float %y) {
; CHECK-LABEL: unused_div:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    nop
entry:
  %add = fdiv float %x, %y
  ret void
}

define void @unused_div_fpexcept_strict(float %x, float %y) #0 {
; CHECK-LABEL: unused_div_fpexcept_strict:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    div.s $f0, $f12, $f14
entry:
  %add = call float @llvm.experimental.constrained.fdiv.f32(float %x, float %y, metadata !"round.tonearest", metadata !"fpexcept.strict") #0
  ret void
}

define void @unused_div_round_dynamic(float %x, float %y) #0 {
; CHECK-LABEL: unused_div_round_dynamic:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    nop
entry:
  %add = call float @llvm.experimental.constrained.fdiv.f32(float %x, float %y, metadata !"round.dynamic", metadata !"fpexcept.ignore") #0
  ret void
}

define float @add_twice(float %x, float %y, i32 %n) {
; CHECK-LABEL: add_twice:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    beqz $6, $BB3_2
; CHECK-NEXT:    add.s $f0, $f12, $f14
; CHECK-NEXT:  # %bb.1: # %if.then
; CHECK-NEXT:    mul.s $f0, $f0, $f0
; CHECK-NEXT:  $BB3_2: # %if.end
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    nop
entry:
  %add = fadd float %x, %y
  %tobool.not = icmp eq i32 %n, 0
  br i1 %tobool.not, label %if.end, label %if.then

if.then:
  %add1 = fadd float %x, %y
  %mul = fmul float %add, %add1
  br label %if.end

if.end:
  %a.0 = phi float [ %mul, %if.then ], [ %add, %entry ]
  ret float %a.0
}

define float @add_twice_fpexcept_strict(float %x, float %y, i32 %n) #0 {
; CHECK-LABEL: add_twice_fpexcept_strict:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    beqz $6, $BB4_2
; CHECK-NEXT:    add.s $f0, $f12, $f14
; CHECK-NEXT:  # %bb.1: # %if.then
; CHECK-NEXT:    add.s $f1, $f12, $f14
; CHECK-NEXT:    mul.s $f0, $f0, $f1
; CHECK-NEXT:  $BB4_2: # %if.end
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    nop
entry:
  %add = call float @llvm.experimental.constrained.fadd.f32(float %x, float %y, metadata !"round.tonearest", metadata !"fpexcept.strict") #0
  %tobool.not = icmp eq i32 %n, 0
  br i1 %tobool.not, label %if.end, label %if.then

if.then:
  %add1 = call float @llvm.experimental.constrained.fadd.f32(float %x, float %y, metadata !"round.tonearest", metadata !"fpexcept.strict") #0
  %mul = call float @llvm.experimental.constrained.fmul.f32(float %add, float %add1, metadata !"round.tonearest", metadata !"fpexcept.strict") #0
  br label %if.end

if.end:
  %a.0 = phi float [ %mul, %if.then ], [ %add, %entry ]
  ret float %a.0
}

define float @add_twice_round_dynamic(float %x, float %y, i32 %n) #0 {
; CHECK-LABEL: add_twice_round_dynamic:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    beqz $6, $BB5_2
; CHECK-NEXT:    add.s $f0, $f12, $f14
; CHECK-NEXT:  # %bb.1: # %if.then
; CHECK-NEXT:    mul.s $f0, $f0, $f0
; CHECK-NEXT:  $BB5_2: # %if.end
; CHECK-NEXT:    jr $ra
; CHECK-NEXT:    nop
entry:
  %add = call float @llvm.experimental.constrained.fadd.f32(float %x, float %y, metadata !"round.dynamic", metadata !"fpexcept.ignore") #0
  %tobool.not = icmp eq i32 %n, 0
  br i1 %tobool.not, label %if.end, label %if.then

if.then:
  %add1 = call float @llvm.experimental.constrained.fadd.f32(float %x, float %y, metadata !"round.dynamic", metadata !"fpexcept.ignore") #0
  %mul = call float @llvm.experimental.constrained.fmul.f32(float %add, float %add1, metadata !"round.dynamic", metadata !"fpexcept.ignore") #0
  br label %if.end

if.end:
  %a.0 = phi float [ %mul, %if.then ], [ %add, %entry ]
  ret float %a.0
}

attributes #0 = { strictfp }
