TEMPLATE = app
LIBS += -llttng-ust -ldl
CONFIG += -I.

# warnings_are_errors depending on the compiler version, sometimes it doesn't
# add the required flags (for instance for recent clang version on old Qt).
warnings_are_errors:!contains(QMAKE_CXXFLAGS_WARN_ON, -Werror){
    QMAKE_CXXFLAGS_WARN_ON += -Werror
}

HEADERS += app-launch-tracepoints.h
SOURCES += app-launch-tracepoints.c
equals(QT_MAJOR_VERSION, 5) {
    TARGET = lomiri-app-launch-tracepoints
} else {
    TARGET = lomiri-app-launch-tracepoints-qt$$QT_MAJOR_VERSION
}
installPath = $$[QT_INSTALL_PREFIX]/bin/
app-launch-tracepoints.files = $$OUT_PWD/$$TARGET
app-launch-tracepoints.path = $$installPath
app-launch-tracepoints.CONFIG = no_check_exist

app-launch-scripts.path = $$installPath
equals(QT_MAJOR_VERSION, 5) {
    app-launch-scripts.files = lomiri-app-launch-profiler-lttng \
                               lomiri-appstart-profile \
                               lomiri-appstart-test
} else {
    app-launch-scripts.extra += $$QMAKE_COPY $$PWD/lomiri-app-launch-profiler-lttng $(INSTALL_ROOT)/$$installPath/lomiri-app-launch-profiler-lttng-qt$$QT_MAJOR_VERSION;
    app-launch-scripts.extra += $$QMAKE_COPY $$PWD/lomiri-appstart-profile $(INSTALL_ROOT)/$$installPath/lomiri-appstart-profile-qt$$QT_MAJOR_VERSION;
    app-launch-scripts.extra += $$QMAKE_COPY $$PWD/lomiri-appstart-test $(INSTALL_ROOT)/$$installPath/lomiri-appstart-test-qt$$QT_MAJOR_VERSION;
}
INSTALLS += app-launch-tracepoints
INSTALLS += app-launch-scripts
