// Copyright 2019 Google LLC.
// Use of this source code is governed by a BSD-style license that can be found in the LICENSE file.
#include "tools/fiddle/examples.h"
REG_FIDDLE(RRect_radii, 256, 256, true, 0) {
void draw(SkCanvas* canvas) {
    for (SkScalar radiusX : { SK_ScalarNaN, SK_ScalarInfinity, 100.f, 50.f, 25.f} ) {
        SkRRect rrect1 = SkRRect::MakeRectXY({10, 20, 60, 220}, radiusX, 200);
        SkDebugf("left corner: (%g) %g\n", radiusX, rrect1.radii(SkRRect::kUpperLeft_Corner).fX);
    }
}
}  // END FIDDLE
