/* BEGIN software license
 *
 * MsXpertSuite - mass spectrometry software suite
 * -----------------------------------------------
 * Copyright(C) 2009,...,2026 Filippo Rusconi
 *
 * http://www.msxpertsuite.org
 *
 * This file is part of the MsXpertSuite project.
 *
 * The MsXpertSuite project is the successor of the massXpert project. This
 * project now includes various independent modules:
 *
 * - MassXpert, model polymer chemistries and simulate mass spectrometric data;
 * - MineXpert, a powerful TIC chromatogram/mass spectrum viewer/miner;
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * END software license
 */

#pragma once

/////////////////////// stdlib includes


/////////////////////// Qt includes
#include <QRect>
#include <QGraphicsRectItem>
#include <QPointF>


/////////////////////// pappsomspp includes


/////////////////////// libXpertMass includes
#include <MsXpS/libXpertMassCore/IndexRangeCollection.hpp>


/////////////////////// libXpertMassGui includes


/////////////////////// Local includes
#include "RegionSelection.hpp"


namespace MsXpS
{
namespace MassXpert
{


class SequenceEditorGraphicsView;

class SequenceSelection
{
  public:
  SequenceSelection(SequenceEditorGraphicsView * = 0);

  ~SequenceSelection(void);

  void setView(SequenceEditorGraphicsView *view_p);
  SequenceEditorGraphicsView *getView();

  const std::vector<RegionSelectionSPtr> &getRegionSelectionsCstRef() const;
  std::vector<RegionSelectionSPtr> &getRegionSelectionsRef();

  int selectRegion(const QPointF &start_point,
                   const QPointF &stop_point,
                   bool multi_region_selection = true,
                   bool multi_selection_region = false);
  int selectRegion(int start_index,
                   int stop_index,
                   bool multi_region_selection = true,
                   bool multi_selection_region = false);

  int reselectRegions();
  void deselectRegions();
  bool deselectRegion(RegionSelectionSPtr region_selection_sp);
  bool deselectLastRegion();
  bool deselectRegionsButLast();
  int deselectMultiSelectionRegionsButFirstSelection();

  RegionSelectionSPtr regionSelectionEncompassing(const QPointF &start_point,
                                                  const QPointF &stop_point,
                                                  std::size_t &index);
  RegionSelectionSPtr regionSelectionEncompassing(int start_index,
                                                  int stop_index,
                                                  std::size_t &index);

  double manhattanLength();
  bool isManhattanLength(const QPointF &start_point, const QPointF &stop_point);

  int regionSelectionCount();

  bool
  selectionIndices(libXpertMassCore::IndexRangeCollection &index_range_collection);

  protected:
  SequenceEditorGraphicsView *mp_view;
  std::vector<RegionSelectionSPtr> m_regionSelections;
};


} // namespace MassXpert
} // namespace MsXpS
