# Obtain a Collection

@snippet examples/api/mongocxx/examples/collections/obtain.cpp Example

# Collection Operations

## Drop a Collection

@snippet examples/api/mongocxx/examples/collections/drop.cpp Example

## Rename a Collection

@snippet examples/api/mongocxx/examples/collections/rename.cpp Example

## Set a Read Concern

@snippet examples/api/mongocxx/examples/collections/rc.cpp Example

## Set a Write Concern

@snippet examples/api/mongocxx/examples/collections/wc.cpp Example

## Set a Read Preference

@snippet examples/api/mongocxx/examples/collections/rp.cpp Example

# Index Operations

## On a Collection

### List Indexes

@snippet examples/api/mongocxx/examples/collections/list_indexes.cpp Example

### Create an Index

@snippet examples/api/mongocxx/examples/collections/create_index.cpp Example

### Create an Index With Options

@snippet examples/api/mongocxx/examples/collections/create_index_with_options.cpp Example

## With an Index View

### Obtain an Index View

@snippet examples/api/mongocxx/examples/collections/index_views/indexes.cpp Example

### List Indexes

@snippet examples/api/mongocxx/examples/collections/index_views/list.cpp Example

### Create an Index

@snippet examples/api/mongocxx/examples/collections/index_views/create.cpp Example

### Create an Index With Options

@snippet examples/api/mongocxx/examples/collections/index_views/create_with_options.cpp Example

### Create Multiple Indexes

@snippet examples/api/mongocxx/examples/collections/index_views/create_many.cpp Example

### Drop an Index

@snippet examples/api/mongocxx/examples/collections/index_views/drop.cpp Example

### Drop All Indexes

@snippet examples/api/mongocxx/examples/collections/index_views/drop_all.cpp Example

# Document Operations

## Query the Number of Documents

@snippet examples/api/mongocxx/examples/collections/count.cpp Example

## Estimate the Number of Documents

@snippet examples/api/mongocxx/examples/collections/estimate_count.cpp Example

## Find a Document

@snippet examples/api/mongocxx/examples/collections/find_one.cpp Example

## Find Multiple Documents

@snippet examples/api/mongocxx/examples/collections/find.cpp Example

## Delete a Document

@snippet examples/api/mongocxx/examples/collections/delete_one.cpp Example

## Delete Many Documents

@snippet examples/api/mongocxx/examples/collections/delete_many.cpp Example

## Insert a Document

@snippet examples/api/mongocxx/examples/collections/insert_one.cpp Example

## Insert Many Documents

@snippet examples/api/mongocxx/examples/collections/insert_many.cpp Example

## Replace a Document

@snippet examples/api/mongocxx/examples/collections/replace_one.cpp Example

## Update a Document

@snippet examples/api/mongocxx/examples/collections/update_one.cpp Example

## Update Multiple Documents

@snippet examples/api/mongocxx/examples/collections/update_many.cpp Example

## Find and Delete a Document

@snippet examples/api/mongocxx/examples/collections/find_one_and_delete.cpp Example

## Find and Replace a Document

@snippet examples/api/mongocxx/examples/collections/find_one_and_replace.cpp Example

## Find and Update a Document

@snippet examples/api/mongocxx/examples/collections/find_one_and_update.cpp Example

## Find Distinct Values

@snippet examples/api/mongocxx/examples/collections/distinct.cpp Example

## Execute a Single Bulk Write Operation

@snippet examples/api/mongocxx/examples/collections/write.cpp Example

## Execute Multiple Bulk Write Operations

@snippet examples/api/mongocxx/examples/collections/bulk_write.cpp Example

## Execute an Aggregation Operation

@snippet examples/api/mongocxx/examples/collections/aggregate.cpp Example

# Error Handling

## Invalid Collection

@snippet examples/api/mongocxx/examples/collections/incompatible_options.cpp Example

## Invalid Parameter

@snippet examples/api/mongocxx/examples/collections/invalid_parameter.cpp Example

## Incompatible Options

@snippet examples/api/mongocxx/examples/collections/incompatible_options.cpp Example
