// Copyright 2009-present MongoDB, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#pragma push_macro("BSONCXX_PRIVATE_V1_INSIDE_MACRO_GUARD_SCOPE")
#undef BSONCXX_PRIVATE_V1_INSIDE_MACRO_GUARD_SCOPE
#define BSONCXX_PRIVATE_V1_INSIDE_MACRO_GUARD_SCOPE

// bsoncxx/v1/config/config.hpp (generated by CMake)
#pragma push_macro("BSONCXX_V1_CONFIG_CONFIG_HPP")
#if !defined(BSONCXX_V1_CONFIG_CONFIG_HPP)
#pragma push_macro("BSONCXX_POLY_USE_IMPLS")
#undef BSONCXX_POLY_USE_IMPLS
#pragma push_macro("BSONCXX_POLY_USE_STD")
#undef BSONCXX_POLY_USE_STD
#endif

// bsoncxx/v1/config/export.hpp (generated by CMake)
#pragma push_macro("BSONCXX_ABI_EXPORT_H")
#if !defined(BSONCXX_ABI_EXPORT_H)
#pragma push_macro("BSONCXX_ABI_EXPORT")
#undef BSONCXX_ABI_EXPORT
#pragma push_macro("BSONCXX_ABI_NO_EXPORT")
#undef BSONCXX_ABI_NO_EXPORT
#pragma push_macro("BSONCXX_ABI_CDECL")
#undef BSONCXX_ABI_CDECL
#pragma push_macro("BSONCXX_ABI_EXPORT_CDECL")
#undef BSONCXX_ABI_EXPORT_CDECL
#pragma push_macro("BSONCXX_DEPRECATED")
#undef BSONCXX_DEPRECATED
#endif

// bsoncxx/v1/config/version.hpp (generated by CMake)
#pragma push_macro("BSONCXX_V1_CONFIG_VERSION_HPP")
#if !defined(BSONCXX_V1_CONFIG_VERSION_HPP)
#pragma push_macro("BSONCXX_VERSION_STRING")
#undef BSONCXX_VERSION_STRING
#pragma push_macro("BSONCXX_VERSION_MAJOR")
#undef BSONCXX_VERSION_MAJOR
#pragma push_macro("BSONCXX_VERSION_MINOR")
#undef BSONCXX_VERSION_MINOR
#pragma push_macro("BSONCXX_VERSION_PATCH")
#undef BSONCXX_VERSION_PATCH
#pragma push_macro("BSONCXX_VERSION_EXTRA")
#undef BSONCXX_VERSION_EXTRA
#endif

// bsoncxx/v1/detail/macros.hpp
#pragma push_macro("BSONCXX_V1_DETAIL_MACROS_HPP")
#if !defined(BSONCXX_V1_DETAIL_MACROS_HPP)
#pragma push_macro("BSONCXX_PRIVATE_CONCAT")
#undef BSONCXX_PRIVATE_CONCAT
#pragma push_macro("BSONCXX_PRIVATE_CONCAT_IMPL")
#undef BSONCXX_PRIVATE_CONCAT_IMPL
#pragma push_macro("BSONCXX_PRIVATE_CONSTEXPR_CXX14")
#undef BSONCXX_PRIVATE_CONSTEXPR_CXX14
#pragma push_macro("BSONCXX_PRIVATE_FORCE_SEMICOLON")
#undef BSONCXX_PRIVATE_FORCE_SEMICOLON
#pragma push_macro("BSONCXX_PRIVATE_FWD")
#undef BSONCXX_PRIVATE_FWD
#pragma push_macro("BSONCXX_PRIVATE_IF_CLANG")
#undef BSONCXX_PRIVATE_IF_CLANG
#pragma push_macro("BSONCXX_PRIVATE_IF_GCC")
#undef BSONCXX_PRIVATE_IF_GCC
#pragma push_macro("BSONCXX_PRIVATE_IF_GNU_LIKE")
#undef BSONCXX_PRIVATE_IF_GNU_LIKE
#pragma push_macro("BSONCXX_PRIVATE_IF_MSVC")
#undef BSONCXX_PRIVATE_IF_MSVC
#pragma push_macro("BSONCXX_PRIVATE_PRAGMA")
#undef BSONCXX_PRIVATE_PRAGMA
#pragma push_macro("BSONCXX_PRIVATE_PRAGMA_IMPL")
#undef BSONCXX_PRIVATE_PRAGMA_IMPL
#pragma push_macro("BSONCXX_PRIVATE_RETURNS")
#undef BSONCXX_PRIVATE_RETURNS
#pragma push_macro("BSONCXX_PRIVATE_STRINGIFY")
#undef BSONCXX_PRIVATE_STRINGIFY
#pragma push_macro("BSONCXX_PRIVATE_STRINGIFY_IMPL")
#undef BSONCXX_PRIVATE_STRINGIFY_IMPL
#pragma push_macro("BSONCXX_PRIVATE_WARNINGS_DISABLE_IMPL_FOR_Clang")
#undef BSONCXX_PRIVATE_WARNINGS_DISABLE_IMPL_FOR_Clang
#pragma push_macro("BSONCXX_PRIVATE_WARNINGS_DISABLE_IMPL_FOR_GCC")
#undef BSONCXX_PRIVATE_WARNINGS_DISABLE_IMPL_FOR_GCC
#pragma push_macro("BSONCXX_PRIVATE_WARNINGS_DISABLE_IMPL_FOR_GNU")
#undef BSONCXX_PRIVATE_WARNINGS_DISABLE_IMPL_FOR_GNU
#pragma push_macro("BSONCXX_PRIVATE_WARNINGS_DISABLE_IMPL_FOR_MSVC")
#undef BSONCXX_PRIVATE_WARNINGS_DISABLE_IMPL_FOR_MSVC
#pragma push_macro("BSONCXX_PRIVATE_WARNINGS_DISABLE")
#undef BSONCXX_PRIVATE_WARNINGS_DISABLE
#pragma push_macro("BSONCXX_PRIVATE_WARNINGS_POP")
#undef BSONCXX_PRIVATE_WARNINGS_POP
#pragma push_macro("BSONCXX_PRIVATE_WARNINGS_PUSH")
#undef BSONCXX_PRIVATE_WARNINGS_PUSH
#pragma push_macro("BSONCXX_PRIVATE_UNREACHABLE")
#undef BSONCXX_PRIVATE_UNREACHABLE
#pragma push_macro("Clang") // Guard since BSONCXX_PRIVATE_WARNINGS_DISABLE(Clang(...)) assumes Clang is not defined.
#undef Clang
#pragma push_macro("GCC") // Guard since BSONCXX_PRIVATE_WARNINGS_DISABLE(GCC(...)) assumes GCC is not defined.
#undef GCC
#pragma push_macro("GNU") // Guard since BSONCXX_PRIVATE_WARNINGS_DISABLE(GNU(...)) assumes GNU is not defined.
#undef GNU
#pragma push_macro("MSVC") // Guard since BSONCXX_PRIVATE_WARNINGS_DISABLE(MSVC(...)) assumes MSVC is not defined.
#undef MSVC
#endif

///
/// @file
/// The bsoncxx v1 macro guard prelude header.
///
/// @warning For internal use only!
///
/// This header uses macro pragmas to guard macros defined by the bsoncxx library for internal use
/// by "pushing" their prior definition onto the stack before use by bsoncxx headers.
///
/// @see
/// - @ref bsoncxx/v1/detail/postlude.hpp
///
