// Copyright 2024 Mathias Bynens. All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.

/*---
author: Mathias Bynens
description: >
  Test that Unicode property escapes for `RGI_Emoji` (property of strings)
  match Emoji 15.0 strings.
info: |
  Generated by https://github.com/mathiasbynens/caniunicode
esid: sec-static-semantics-unicodematchproperty-p
features: [regexp-unicode-property-escapes, regexp-v-flag]
includes: [regExpUtils.js]
---*/

testPropertyOfStrings({
  regExp: /^\p{RGI_Emoji}+$/v,
  expression: "\\p{RGI_Emoji}",
  matchStrings: [
    "\u{1F426}\u200D\u2B1B",
    "\u{1F6DC}",
    "\u{1FA75}",
    "\u{1FA76}",
    "\u{1FA77}",
    "\u{1FA87}",
    "\u{1FA88}",
    "\u{1FAAD}",
    "\u{1FAAE}",
    "\u{1FAAF}",
    "\u{1FABB}",
    "\u{1FABC}",
    "\u{1FABD}",
    "\u{1FABF}",
    "\u{1FACE}",
    "\u{1FACF}",
    "\u{1FADA}",
    "\u{1FADB}",
    "\u{1FAE8}",
    "\u{1FAF7}",
    "\u{1FAF7}\u{1F3FB}",
    "\u{1FAF7}\u{1F3FC}",
    "\u{1FAF7}\u{1F3FD}",
    "\u{1FAF7}\u{1F3FE}",
    "\u{1FAF7}\u{1F3FF}",
    "\u{1FAF8}",
    "\u{1FAF8}\u{1F3FB}",
    "\u{1FAF8}\u{1F3FC}",
    "\u{1FAF8}\u{1F3FD}",
    "\u{1FAF8}\u{1F3FE}",
    "\u{1FAF8}\u{1F3FF}"
  ],
});

reportCompare(0, 0);
