// |reftest| shell-option(--enable-temporal) skip-if(!this.hasOwnProperty('Temporal')||!xulRuntime.shell) -- Temporal is not enabled unconditionally, requires shell-options
// Copyright (C) 2021 Igalia, S.L. All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.

/*---
esid: sec-temporal.plaindate.from
description: Verify that undefined options are handled correctly.
features: [Temporal]
---*/

const fields = { year: 2000, month: 13, day: 2 };

const explicit = Temporal.PlainDate.from(fields, undefined);
assert.sameValue(explicit.month, 12, "default overflow is constrain");

const implicit = Temporal.PlainDate.from(fields);
assert.sameValue(implicit.month, 12, "default overflow is constrain");

reportCompare(0, 0);
