# security_notus

## NAME

**security_notus** - Reports a severe flaw based on a notus result.

## SYNOPSIS

*void* **security_notus**(result: *json*);

**security_notus** The security_notus take following arguments:
- *result* This is a notus result given as a json like structure. The structure should have one of the following formats:
```json
{
    "oid": "[oid]",
    "vulnerable_packages": [{
        "name": "[package_name]",
        "installed": "[installed_version]",
        "fixed": {
            "start": "[start_version]",
            "end": "[end_version]"
        }
    }]
}
```
The fixed part of the json structure could also be given by a single version and a specifier:
```json
{
    "oid": "[oid]",
    "vulnerable_packages": [{
        "name": "[package_name]",
        "installed": "[installed_version]",
        "fixed": {
            "version": "[version]",
            "specifier": "[specifier]"
        }
    }]
}
```
In case of Skiron results the json structure looks like a dictionary:
```json
{
  "oid": "[oid]",
  "message": "some message"
}

Results for this function are generated by **[notus(3)](../glue-functions/notus.md)**
and should never be created manually.


## DESCRIPTION

This function will report a severe flaw based on a notus result.


## RETURN VALUE

This function returns nothing.

## SEE ALSO

**[notus(3)](../glue-functions/notus.md)**
