// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//                             avtparaDISOptions.C                              //
// ************************************************************************* //

#include <avtparaDISOptions.h>

#include <DBOptionsAttributes.h>
#include <DebugStream.h>

#include <cstdlib>
#include <cstring>

#include <string>
#include <vector>
using namespace std; 

// ****************************************************************************
//  Function: GetparaDISReadOptions
//
//  Purpose:
//      Creates the options for paraDIS readers.
//
//  Important Note:
//      The code below sets up empty options.  If your format 
//      does not require read options, no modifications are 
//      necessary.
//
//  Programmer: rcook -- generated by xml2avt
//  Creation:   Thu Mar 11 15:15:39 PST 2010
//
// ****************************************************************************

DBOptionsAttributes *
GetparaDISReadOptions(void)
{
    DBOptionsAttributes *rv = new DBOptionsAttributes;

    // Allow user to set values by environment variables or by GUI.
    int useMNType = 0; 
    char *cp = getenv("PARADIS_USE_MN_MATERIALS"); 
    if (cp) {
      useMNType = atoi(cp); 
      debug1 << "PARADIS_USE_MN_MATERIALS is " << cp << " and useMNType is " << useMNType << endl; 
    }/*
       else {
      debug1 << "PARADIS_USE_MN_MATERIALS not found" << endl; 
    }
     */
    if (useMNType < 0) useMNType = 0; 
    if (useMNType > 1) useMNType = 1; 
    rv->SetEnum(PARADIS_MATERIAL_SET_CHOICE, useMNType); 
    
    vector<string> msetchoices; 
    msetchoices.push_back("Burgers type"); 
    msetchoices.push_back("MN type"); 
    rv->SetEnumStrings(PARADIS_MATERIAL_SET_CHOICE, msetchoices); 

    double threshold = -1.0; 
    cp = getenv("PARADIS_NN_ARM_THRESHOLD"); 
    if (cp) threshold = atof(cp); 
    rv->SetDouble(PARADIS_NN_ARM_THRESHOLD, threshold); 

    int debug=0;
    cp = getenv("PARADIS_VERBOSITY"); 
    if (cp) debug=atoi(cp); 
    debug1 << "paradis debug set to " << debug << endl;
    rv->SetInt(PARADIS_VERBOSITY, debug);
    
    cp = getenv("PARADIS_DEBUG_FILE");
    if (!cp) cp = (char*)"paradis_debug_output.log";
    rv->SetString(PARADIS_DEBUG_FILE, cp);
    
    debug = 0; 
    cp = getenv("PARADIS_ENABLE_DEBUG_OUTPUT"); 
    if (cp) debug=atoi(cp); 
    rv->SetBool(PARADIS_ENABLE_DEBUG_OUTPUT, debug); 
    
    return rv;

/* EXAMPLE OF OPTIONS
    rv->SetBool("Binary format", true);
    rv->SetBool("Big Endian", false);
    rv->SetEnum("Dimension", 1);
    vector<string> dims;
    dims.push_back("0D");
    dims.push_back("1D");
    dims.push_back("2D");
    dims.push_back("3D");
    rv->SetEnumStrings("Dimension", dims);
    rv->SetInt("Number of variables", 5);
    rv->SetString("Name of auxiliary file", );
    rv->SetDouble("Displacement factor", 1.0);

    // When reading or writing the file, you can get the options out of this object like:
    rv->GetDouble("Displacement factor");
*/
}


// ****************************************************************************
//  Function: GetparaDISWriteOptions
//
//  Purpose:
//      Creates the options for paraDIS writers.
//
//  Important Note:
//      The code below sets up empty options.  If your format 
//      does not require write options, no modifications are 
//      necessary.
//
//  Programmer: rcook -- generated by xml2avt
//  Creation:   Thu Mar 11 15:15:39 PST 2010
//
// ****************************************************************************

DBOptionsAttributes *
GetparaDISWriteOptions(void)
{
    DBOptionsAttributes *rv = new DBOptionsAttributes;
    return rv;
}
