% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covr.R
\docType{package}
\name{covr-package}
\alias{covr}
\alias{covr-package}
\title{covr: Test coverage for packages}
\description{
covr tracks and reports code coverage for your package and (optionally)
upload the results to a coverage service like 'Codecov' \url{https://about.codecov.io} or
'Coveralls' \url{https://coveralls.io}. Code coverage is a measure of the amount of
code being exercised by a set of tests. It is an indirect measure of test
quality and completeness. This package is compatible with any testing
methodology or framework and tracks coverage of both R code and compiled
C/C++/FORTRAN code.
}
\details{
A coverage report can be used to inspect coverage for each line in your
package. Using \code{report()} requires the additional dependencies \code{DT} and \code{htmltools}.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{# If run with no arguments `report()` implicitly calls `package_coverage()`
report()
}\if{html}{\out{</div>}}
}
\section{Package options}{


\code{covr} uses the following \code{\link[=options]{options()}} to configure behaviour:

\itemize{
\item \code{covr.covrignore}: A filename to use as an ignore file,
listing glob-style wildcarded paths of files to ignore for coverage
calculations. Defaults to the value of environment variable
\code{COVR_COVRIGNORE}, or \code{".covrignore"}  if the neither the option nor the
environment variable are set.

\item \code{covr.exclude_end}: Used along with \code{covr.exclude_start}, an optional
regular expression which ends a line-exclusion region. For more
details, see \code{?exclusions}.

\item \code{covr.exclude_pattern}: An optional line-exclusion pattern. Lines
which match the pattern will be excluded from coverage. For more details,
see \code{?exclusions}.

\item \code{covr.exclude_start}: Used along with \code{covr.exclude_end}, an optional
regular expression which starts a line-exclusion region. For more
details, see \code{?exclusions}.

\item \code{covr.filter_non_package}: If \code{TRUE} (the default behavior), coverage
of files outside the target package are filtered from coverage output.

\item \code{covr.fix_parallel_mcexit}:

\item \code{covr.flags}:

\item \code{covr.gcov}: If the appropriate gcov version is not on your path you
can use this option to set the appropriate location. If set to "" it will
turn off coverage of compiled code.

\item \code{covr.gcov_additional_paths}:

\item \code{covr.gcov_args}:

\item \code{covr.icov}:

\item \code{covr.icov_args}:

\item \code{covr.icov_flags}:

\item \code{covr.icov_prof}:

\item \code{covr.rstudio_source_markers}: A logical value. If \code{TRUE} (the
default behavior), source markers are displayed within the RStudio IDE
when using \code{zero_coverage}.

\item \code{covr.record_tests}: If \code{TRUE} (default \code{NULL}), record a listing of
top level test expressions and associate tests with \code{covr} traces
evaluated during the test's execution. For more details, see
\code{?covr.record_tests}.

\item \code{covr.showCfunctions}:
}
}

\seealso{
Useful links:
\itemize{
  \item \url{https://covr.r-lib.org}
  \item \url{https://github.com/r-lib/covr}
  \item Report bugs at \url{https://github.com/r-lib/covr/issues}
}

}
\author{
\strong{Maintainer}: Jim Hester \email{james.f.hester@gmail.com}

Other contributors:
\itemize{
  \item Willem Ligtenberg [contributor]
  \item Kirill Müller [contributor]
  \item Henrik Bengtsson [contributor]
  \item Steve Peak [contributor]
  \item Kirill Sevastyanenko [contributor]
  \item Jon Clayden [contributor]
  \item Robert Flight [contributor]
  \item Eric Brown [contributor]
  \item Brodie Gaslam [contributor]
  \item Will Beasley [contributor]
  \item Robert Krzyzanowski [contributor]
  \item Markus Wamser [contributor]
  \item Karl Forner [contributor]
  \item Gergely Daróczi [contributor]
  \item Jouni Helske [contributor]
  \item Kun Ren [contributor]
  \item Jeroen Ooms [contributor]
  \item Ken Williams [contributor]
  \item Chris Campbell [contributor]
  \item David Hugh-Jones [contributor]
  \item Qin Wang [contributor]
  \item Doug Kelkhoff [contributor]
  \item Ivan Sagalaev (highlight.js library) [contributor, copyright holder]
  \item Mark Otto (Bootstrap library) [contributor]
  \item Jacob Thornton (Bootstrap library) [contributor]
  \item  Bootstrap contributors (Bootstrap library) [contributor]
  \item  Twitter, Inc (Bootstrap library) [copyright holder]
}

}
