% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/record.R
\name{record_print}
\alias{record_print}
\alias{record_print.default}
\alias{record_print.record_asis}
\alias{new_record}
\title{Print methods for \code{record()}}
\usage{
record_print(x, ...)

\method{record_print}{default}(x, ...)

\method{record_print}{record_asis}(x, ...)

new_record(x, class)
}
\arguments{
\item{x}{For \code{record_print()}, the value to be printed. For \code{new_record()}, a
character vector to be included in the printed results.}

\item{...}{Other arguments to be passed to \code{record_print()} methods.}

\item{class}{A class name. Possible values are \code{xfun:::.record_cls}.}
}
\value{
A \code{record_print()} method should return a character vector or a list
of character vectors. The original classes of the vector will be discarded,
and the vector will be treated as console output by default (i.e.,
\code{new_record(class = "output")}). If it should be another type of output,
wrap the vector in \code{\link[=new_record]{new_record()}} and specify a class name.
}
\description{
An S3 generic function to be called to print visible values in code when the
code is recorded by \code{\link[=record]{record()}}. It is similar to \code{\link[knitr:knit_print]{knitr::knit_print()}}. By
default, it captures the normal \code{\link[=print]{print()}} output and returns the result as a
character vector. The \code{knitr_kable} method is for printing \code{\link[knitr:kable]{knitr::kable()}}
output. Users and package authors can define other S3 methods to extend this
function.
}
