# RentalStation

## Properties

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**id** | **String** | Unique identifier of the rental station | 
**provider_id** | **String** | Unique identifier of the rental provider | 
**provider_group_id** | **String** | Unique identifier of the rental provider group | 
**name** | **String** | Public name of the station | 
**lat** | **f64** | latitude | 
**lon** | **f64** | longitude | 
**address** | Option<**String**> | Address where the station is located | [optional]
**cross_street** | Option<**String**> | Cross street or landmark where the station is located | [optional]
**rental_uri_android** | Option<**String**> | Rental URI for Android (deep link to the specific station) | [optional]
**rental_uri_ios** | Option<**String**> | Rental URI for iOS (deep link to the specific station) | [optional]
**rental_uri_web** | Option<**String**> | Rental URI for web (deep link to the specific station) | [optional]
**is_renting** | **bool** | true if vehicles can be rented from this station, false if it is temporarily out of service | 
**is_returning** | **bool** | true if vehicles can be returned to this station, false if it is temporarily out of service | 
**num_vehicles_available** | **i32** | Number of vehicles available for rental at this station | 
**form_factors** | [**Vec<models::RentalFormFactor>**](RentalFormFactor.md) | List of form factors available for rental and/or return at this station | 
**vehicle_types_available** | **std::collections::HashMap<String, i32>** | List of vehicle types currently available at this station (vehicle type ID -> count) | 
**vehicle_docks_available** | **std::collections::HashMap<String, i32>** | List of vehicle docks currently available at this station (vehicle type ID -> count) | 
**station_area** | Option<[**Vec<Vec<models::EncodedPolyline>>**](Vec.md)> | A multi-polygon contains a number of polygons, each containing a number of rings, which are encoded as polylines (with precision 6).  For each polygon, the first ring is the outer ring, all subsequent rings are inner rings (holes).  | [optional]
**bbox** | **Vec<f64>** | Bounding box of the area covered by this station, [west, south, east, north] as [lon, lat, lon, lat]  | 

[[Back to Model list]](../README.md#documentation-for-models) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to README]](../README.md)


