/*
 * MOTIS API
 *
 * This is the MOTIS routing API.  Overview of MOTIS API versions:  MOTIS 0.x - deprecated/discontinued  MOTIS 2.x - current, providing:  * /api/v5/{plan,trip,stoptimes,map/trips} renamed METRO mode to SUBURBAN, AREAL_LIFT to AERIAL_LIFT; since MOTIS 2.5.0 * /api/v4/{plan,trip,stoptimes,map/trips} new displayName property, routeShortName only contains actual route short name from source; since MOTIS 2.2.0 * /api/v3/plan with correct maxTransfers API parameter (transfers actually corresponding to number of changes between transit legs (and not to number of transit legs), i.e. maxTransfers=0 returns direct public transit connections, as expected); since MOTIS 2.0.84  * /api/v2/{plan,trip} returns Google polylines with precision=6; since MOTIS 2.0.60 * /api/v1/{plan,trip} returns Google polylines with precision=7 (not defined for |longitude|>107) * /api/v1/_* all other endpoints  If you use the JS client lib https://www.npmjs.com/package/@motis-project/motis-client, endpoint versions will be taken into account automatically (i.e. the newest one available will be used). 
 *
 * The version of the OpenAPI document: v5
 * Contact: felix@triptix.tech
 * Generated by: https://openapi-generator.tech
 */

use crate::models;
use serde::{Deserialize, Serialize};

#[derive(Clone, Default, Debug, PartialEq, Serialize, Deserialize)]
pub struct Stoptimes200Response {
    /// list of stop times
    #[serde(rename = "stopTimes")]
    pub stop_times: Vec<models::StopTime>,
    /// metadata of the requested stop
    #[serde(rename = "place")]
    pub place: Box<models::Place>,
    /// Use the cursor to get the previous page of results. Insert the cursor into the request and post it to get the previous page. The previous page is a set of stop times BEFORE the first stop time in the result. 
    #[serde(rename = "previousPageCursor")]
    pub previous_page_cursor: String,
    /// Use the cursor to get the next page of results. Insert the cursor into the request and post it to get the next page. The next page is a set of stop times AFTER the last stop time in this result. 
    #[serde(rename = "nextPageCursor")]
    pub next_page_cursor: String,
}

impl Stoptimes200Response {
    pub fn new(stop_times: Vec<models::StopTime>, place: models::Place, previous_page_cursor: String, next_page_cursor: String) -> Stoptimes200Response {
        Stoptimes200Response {
            stop_times,
            place: Box::new(place),
            previous_page_cursor,
            next_page_cursor,
        }
    }
}

