# 2025-01-27 Triage Log

Relatively quiet week, with one large-ish regression that will be reverted.
[#132666](https://github.com/rust-lang/rust/pull/132666) produced a nice perf. win, by skipping
unnecessary work. This PR actually reversed a regression caused by a [previous PR](https://github.com/rust-lang/rust/pull/131984).

Triage done by **@kobzol**.
Revision range: [9a1d156f..f7538506](https://perf.rust-lang.org/?start=9a1d156f38c51441ee51e5a068f1d0caf4bb0f27&end=f753850659bdf5788332525f3fe395685929c682&absolute=false&stat=instructions%3Au)

**Summary**:

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.5%  | [0.2%, 2.2%]   | 42    |
| Regressions ❌ <br /> (secondary)  | 2.1%  | [0.1%, 11.6%]  | 56    |
| Improvements ✅ <br /> (primary)   | -0.8% | [-4.2%, -0.1%] | 107   |
| Improvements ✅ <br /> (secondary) | -1.2% | [-4.0%, -0.1%] | 77    |
| All ❌✅ (primary)                 | -0.5% | [-4.2%, 2.2%]  | 149   |


2 Regressions, 3 Improvements, 2 Mixed; 4 of them in rollups
45 artifact comparisons made in total

#### Regressions

Properly record metavar spans for other expansions other than TT [#134478](https://github.com/rust-lang/rust/pull/134478) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=b2728d5426bab1d8c39709768c7e22b7f66dde5d&end=dee7d0e730a3a3ed98c89dd33c4ac16edc82de8a&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.2%  | [0.1%, 0.4%]   | 31    |
| Regressions ❌ <br /> (secondary)  | 1.0%  | [0.1%, 3.0%]   | 19    |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.1% | [-0.1%, -0.1%] | 1     |
| All ❌✅ (primary)                 | 0.2%  | [0.1%, 0.4%]   | 31    |

- This regression was deemed [justified](https://github.com/rust-lang/rust/pull/134478#issuecomment-2558271305), it was caused by a bugfix.
- Marked as triaged.

Rollup of 7 pull requests [#135947](https://github.com/rust-lang/rust/pull/135947) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=22a220a1a8280a262a277fc24661511f6c4dab51&end=1c9837df1dde9b234229709e89b3672bd3cf04a4&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.7% | [0.1%, 2.2%] | 15    |
| Regressions ❌ <br /> (secondary)  | 1.4% | [0.1%, 2.2%] | 23    |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.7% | [0.1%, 2.2%] | 15    |

- Small regression on doc builds.
- It's unclear which PR  caused the regression, as our automation for unrolling PRs has failed here
for some reason.
- I don't think that it's worth it to manually post PR reverts and perf. test them for this kind of
a doc regression.

#### Improvements

Refactor `fmt::Display` impls in rustdoc [#135494](https://github.com/rust-lang/rust/pull/135494) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=cf577f34c47937ccb9983186eca5f8719da585f4&end=fc0094f8d4eb91637ff540be7d9d87bfcdd2a208&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.2% | [-0.2%, -0.2%] | 2     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -0.2% | [-0.2%, -0.2%] | 2     |


Skip `if-let-rescope` lint unless requested by migration [#132666](https://github.com/rust-lang/rust/pull/132666) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=99768c80a1c094a5cfc3b25a04e7a99de7210eae&end=22a220a1a8280a262a277fc24661511f6c4dab51&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.8% | [-1.9%, -0.2%] | 100   |
| Improvements ✅ <br /> (secondary) | -1.5% | [-4.2%, -0.1%] | 69    |
| All ❌✅ (primary)                 | -0.8% | [-1.9%, -0.2%] | 100   |

- Fixes performance regression from [previous PR](https://github.com/rust-lang/rust/pull/131984).

Rollup of 7 pull requests [#136070](https://github.com/rust-lang/rust/pull/136070) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=6fb03584cf6d915cc5527f45037ca009f4273c4c&end=2f0ad2a71e4a4528bb80bcb24bf8fa4e50cb87c2&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -1.2% | [-4.4%, -0.2%] | 28    |
| Improvements ✅ <br /> (secondary) | -0.2% | [-0.2%, -0.2%] | 1     |
| All ❌✅ (primary)                 | -1.2% | [-4.4%, -0.2%] | 28    |


#### Mixed

Rollup of 7 pull requests [#135789](https://github.com/rust-lang/rust/pull/135789) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=9f4d9dc102fee5c1fe8adce2c4a58254cae510f4&end=f3d1d47fd84dfcf7f513be1dbad356e74c8f3b2b&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 0.1%  | [0.1%, 0.1%]   | 2     |
| Improvements ✅ <br /> (primary)   | -1.1% | [-1.1%, -1.1%] | 2     |
| Improvements ✅ <br /> (secondary) | -0.5% | [-0.6%, -0.5%] | 2     |
| All ❌✅ (primary)                 | -1.1% | [-1.1%, -1.1%] | 2     |

- This rollup was mostly performance neutral, the tiny regression on a single benchmark was noise.
- Marked as triaged.

Rollup of 8 pull requests [#135978](https://github.com/rust-lang/rust/pull/135978) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=48ef38d3503a04e5e18157e664e3e65dc7eca1a5&end=061ee95ce197dc9b276fc5363eddbfc0ecc08584&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4%  | [0.2%, 1.1%]   | 15    |
| Regressions ❌ <br /> (secondary)  | 6.2%  | [0.8%, 11.5%]  | 10    |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.4% | [-0.7%, -0.2%] | 20    |
| All ❌✅ (primary)                 | 0.4%  | [0.2%, 1.1%]   | 15    |

- The performance regression was caused by [#135914](https://github.com/rust-lang/rust/pull/135914),
which will be reverted by [#136011](https://github.com/rust-lang/rust/pull/136011).
- Marked as triaged.
