# GNU Shepherd --- System service manager for GNU
# Copyright © 2025 Hilton Chain <hako@ultrarare.space>
#
# This file is part of GNU Shepherd.
#
# GNU Shepherd is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or (at
# your option) any later version.
#
# GNU Shepherd is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with GNU Shepherd.  If not, see <http://www.gnu.org/licenses/>.

# Fish completion for Shepherd commands.

# FIXME: Fish doesn't support GNU-style long options.
# Completions in this file add ‘=’ suffixes for visual indication, but they
# will complete ‘--group= ’ instead of ‘--group=’, for example.

function __fish_herd_complete_service
    command herd status | string match -rg '^ [+\-*] (.*)'
end

function __fish_herd_disable_completion
    complete -e
end

function __fish_herd_complete_subcommand
    set -l tokens (commandline -opc)
    while true
        set -l index (contains -i -- "--" $tokens)
        if [ -z "$index" ]
            break
        end
        set -e tokens[1..$index]
    end
    complete -C "$tokens $(commandline -ct)"
end

complete -xc herd      -l group=                -d "run the given program as GROUP"                         -a "(__fish_complete_groups)"
complete -xc herd      -l user=                 -d "run the given program as USER"                          -a "(__fish_complete_users)"
complete -xc herd -s E -l environment-variable= -d "pass the environment variable specified by ENVIRONMENT"
complete -xc herd -s d -l working-directory=    -d "run service from DIRECTORY (for transient services)"    -a "(__fish_complete_directories)"
complete -rc herd      -l log-file=             -d "log service output to FILE"
complete -xc herd -s N -l service-name=         -d "register new service under NAME"
complete -xc herd -s n -l log-history=          -d "display up to NUMBER service log lines"
complete -rc herd -s s -l socket=               -d "send commands to FILE"
complete -xc herd      -l help                  -d "display this help and exit"
complete -xc herd      -l usage                 -d "display short usage message and exit"
complete -xc herd      -l version               -d "display version information and exit"

set -l common_actions    configuration disable doc enable restart schedule start status stop trigger
set -l one_arg_actions   detailed-status help log graph
set -l transient_actions spawn
set -l all_actions $common_actions $one_arg_actions $transient_actions

for action in $common_actions
    complete -xc herd -a "$action"                           -n "not __fish_seen_subcommand_from $all_actions"
    complete -xc herd -a "(__fish_herd_complete_service)"    -n "__fish_seen_subcommand_from $action; and not __fish_seen_subcommand_from (__fish_herd_complete_service)"
end

for action in $one_arg_actions
    complete -xc herd -a "$action"                           -n "not __fish_seen_subcommand_from $all_actions"
    complete -xc herd -a "(__fish_herd_disable_completion)"  -n "__fish_seen_subcommand_from $action"
end

for action in $transient_actions
    complete -xc herd -a "$action"                           -n "not __fish_seen_subcommand_from $all_actions"
    complete -xc herd -a "transient"                         -n "__fish_seen_subcommand_from $action; and not __fish_seen_subcommand_from (__fish_herd_complete_service)"
    complete -xc herd -a "--"                                -n "__fish_seen_subcommand_from $action; and __fish_seen_subcommand_from transient; and not __fish_seen_subcommand_from --"
    complete -xc herd -a "(__fish_herd_complete_subcommand)" -n "__fish_seen_subcommand_from $action; and __fish_seen_subcommand_from transient; and __fish_seen_subcommand_from --"
end
