#pragma once
#include "QueryStr.h"

namespace sql {

	class DBConnection;
	class Statement;

	/**
	 * A query that can be cached by a connection.
	 *
	 * Mainly intended for use with the language extension. The idea is that the language extension
	 * generates a CachedQuery instance and passes it to `DBConnection.prepare`. This causes
	 * connection to prepare the query and then cache it for the duration of the connection itself.
	 *
	 * This scheme is also designed to allow supplying different versions of the query based on the
	 * capabilities of the underlying database (e.g. work-arounds for databases that don't support
	 * the RETURNS clause of insert statements for example).
	 */
	class CachedQuery : public Object {
		STORM_ABSTRACT_CLASS;
	public:
		// Create.
		STORM_CTOR CachedQuery() {}

		// Prepare a query for a particular database to produce a statement. The expectation is that
		// the implementation calls `db.prepare(<query>)` and returns the result. However, this
		// scheme also allows returning some more complex statement, e.g. for compatibility.
		virtual Statement *STORM_FN query(DBConnection *db) ABSTRACT;
	};

}
