use core:lang;
use lang:bs:macro;

// Create a suitable C++ scope.
Scope cppScope(NameSet pkg) on Compiler {
	Scope(pkg, CppLookup());
}

/**
 * C++ lookup.
 */
class CppLookup extends ScopeLookup {
	init() {
		init("void") {}
	}

	ScopeLookup clone() : override {
		CppLookup();
	}

	Named? find(Scope in, SimpleName name) : override {
		// TODO: Modify the name to use C++ type conversion rules?

		NameLookup? at = in.top;
		while (now = at) {
			if (found = find(in, now, name))
				return found;

			at = nextCandidate(now);
		}

		// Look in the C++ runtime path.
		if (found = find(in, named{runtime}, name))
			return found;

		null;
	}
}

/**
 * Lookup for when we have actuals.
 */
class CppPart extends SimplePart {
	init(Str name, Expr[] actuals) {
		init(name) { actuals = actuals; }

		for (a in actuals) {
			params << a.result.type;
		}
	}

	Expr[] actuals;

	Int matches(Named candidate, Scope source) {
		Value[] formals = candidate.params;

		// If it is a function that has a result parameter, then we can discard that!
		if (fn = candidate as Function) {
			if (fn.hasResultParam()) {
				formals = formals.clone();
				// It is either the first or the third parameter (this-parameter is two params).
				if (fn.isMember)
					formals.remove(2);
				else
					formals.remove(0);
			}
		}

		if (actuals.count != formals.count)
			return -1;

		Int penalty = 0;
		for (Nat i = 0; i < actuals.count; i++) {
			Expr actual = actuals[i];
			Value formal = formals[i];

			unless (formalType = formal.type)
				return -1;

			Int p = castPenalty(actual, formalType);
			if (p < 0) {
				return -1;
			}

			penalty += p;
		}

		penalty;
	}
}
