use core:io;
use core:net;
use crypto;
use test;

// Test SSL timeout handling.
test SSLTimeoutA {
	var context = crypto:ClientContext:systemDefault();
	unless (socket = connect("storm-lang.org", 443))
		abort;

	socket.input.timeout = 1s;
	var ssl = context.connect(socket, "storm-lang.org");

	// Ask the server to close the connection. This ends the SSL session for us, but OpenSSL will
	// not read "too far" in the stream, and therefore the underlying stream will not signal a
	// timeout.
	Utf8Output out(ssl.output, windowsTextInfo(false));
	out.write("GET /nonexisting HTTP/1.1\nHost: storm-lang.org\nConnection: close\n\n");
	out.flush();

	Utf8Input in(ssl.input);
	check in.readAll() != "";
	check in.more == false;
	check ssl.input.more == false;

	// print("--- all done ---");
	// print("More? ${socket.input.more}");
	// print("More? ${ssl.input.more}");
	// print("--- next request ---");

	out.write("GET /nonexisting HTTP/1.1\nHost: storm-lang.org\nConnection: close\n\n");
	check in.readAll() == "";
	check ssl.input.more == false;

	ssl.close();
	socket.close();

	// print("--- all done ---");
	// print("More? ${socket.input.more}");
	// print("More? ${ssl.input.more}");
}

// Version of the above where we don't ask the server to close the session.
test SSLTimeoutB {
	var context = crypto:ClientContext:systemDefault();
	unless (socket = connect("storm-lang.org", 443))
		abort;

	socket.input.timeout = 1s;
	var ssl = context.connect(socket, "storm-lang.org");

	// Ask the server to keep the connection open. This means that the SSL layer will see a read of
	// zero bytes and will have to handle it correctly.
	Utf8Output out(ssl.output, windowsTextInfo(false));
	out.write("GET /nonexisting HTTP/1.1\nHost: storm-lang.org\nConnection: keep-alive\n\n");
	out.flush();

	Utf8Input in(ssl.input);
	check in.readAll() != "";
	check in.more() == false; // TODO: Perhaps surprising?
	check socket.input.more == true;
	check ssl.input.more == true;

	// print("--- all done ---");
	// print("More? ${socket.input.more}");
	// print("More? ${ssl.input.more}");
	// print("--- next request ---");

	out.write("GET /nonexisting HTTP/1.1\nHost: storm-lang.org\nConnection: close\n\n");
	check in.readAll() != "";
	check ssl.input.more == false;

	ssl.close();
	socket.close();

	// print("--- all done ---");
	// print("More? ${socket.input.more}");
	// print("More? ${ssl.input.more}");
}
