int a;
int b;

int *p;

void thread_fn() {
	// Note: These operations previously confuse the model checker. The reason is twofold:
	// - barrier steps currently appear to stop twice on the second atomic_write operation
	//   since the first line ends with a release barrier that causes execution to stop
	//   at the start of the next operation.
	// - the model checker can not see the temporary value passed to "atomic_write", which
	//   makes it conclude that writing 1 and writing 2 are equivalent.
	// Both of these issues were solved solved by showing the call to the function. For
	// example, by creating a "dummy" stack frame for atomic_read and atomic_write that
	// contain the parameters to them (perhaps only for barrier steps?). This also makes
	// the visualization clearer as well!
	atomic_write(&a, atomic_read(&a) + 1);
	atomic_write(&b, atomic_read(&b) + 1);
	atomic_write(&p, NULL);
}

int main() {
	thread_new(&thread_fn);
	thread_fn();
	return 0;
}
