use core:debug;

void errorOn(Int point, Int now) {
	if (point == now)
		throwError;
}

// Make sure the cleanup runs properly at various points in the function.
void basicException(Int point) {
	errorOn(point, 1);
	DbgVal a(5);
	{
		errorOn(point, 2);
		Dbg d(20);
		errorOn(point, 3);
		DbgVal v(10);
		errorOn(point, 4);
	}
	errorOn(point, 5);
	{
		DbgVal v(6);
		errorOn(point, 6);
	}
	errorOn(point, 7);
}

// How do we do with exceptions in other functions.
void fnException(Int point) {
	errorOn(point, 1);
	DbgVal r = dbgValFn(DbgVal(1), point);
	errorOn(point, 3);
}

DbgVal dbgValFn(DbgVal v, Int point) {
	errorOn(point, 2);
	v.set(3);
	v;
}

// How do we do with exceptions combined with thread switches?
void threadException(Int point) {
	errorOn(point, 1);
	DbgVal r = otherThreadError(DbgVal(1), point);
	errorOn(point, 4);
}

// Thread function for another thread.
DbgVal otherThreadError(DbgVal p, Int point) on Other {
	errorOn(point, 2);
	p.set(2);
	errorOn(point, 3);
	p;
}

// Throw an error during construction.
value ErrorAt {
	init(Int point, Int at) {
		init() {}
		errorOn(point, at);
	}
}

value ErrorBase {
	// Some members to initialize and keep track of. Try to initialize e1, v1, e2, but this order
	// is not neccessarily the initialization order chosen by Storm.
	ErrorAt e1;
	DbgVal v1;
	ErrorAt e2;

	init(Int point) {
		errorOn(point, 2);
		init() {
			e1(point, 3);
			v1(10);
			e2(point, 4);
		}
		errorOn(point, 5);
	}
}

value ErrorTest extends ErrorBase {
	// Some members.
	ErrorAt e4;
	DbgVal v2;
	ErrorAt e5;

	init(Int point) {
		errorOn(point, 1); // Error before initialization of super class.
		init(point) {
			e4(point, 6);
			v2(20);
			e5(point, 7);
		}
		errorOn(point, 8);
	}
}

void ctorError(Int point) {
	ErrorTest e(point);
}
