use progvis:lang:cpp;
use core:asm;

Int strlen(ConstPtr<Byte> src) {
	checkPtr(src.base);

	Bool foundNull = false;
	Nat total = 0;
	Nat offset = src.offset - sPtr.current * 2;
	Nat size = src.base.readSize * src.base.readCount;
	while (offset <= size) {
		if (src.base.readByte(offset) == 0) {
			foundNull = true;
			break;
		}

		offset++;
		total++;
	}

	if (!foundNull)
		throw PtrError("buffer overflow", "Missing 0-byte at the end of the string.");

	total.int;
}

Ptr<Byte> strcpy(ConstPtr<Byte> src) {
	// Old version, for compatibility.
	strdup(src);
}

Ptr<Byte> strdup(ConstPtr<Byte> src) {
	Int len = strlen(src);

	Ptr<Byte> result = Ptr<Byte>:allocArray(len.nat + 1);
	Nat offset = src.offset - sPtr.current * 2;
	for (Int i = 0; i < len; i++) {
		result.base.writeByte(i.nat, src.base.readByte(offset + i.nat));
	}

	result;
}

Int strcmp(ConstPtr<Byte> a, ConstPtr<Byte> b) {
	checkPtr(a.base);
	checkPtr(b.base);

	Nat aOffset = a.offset - sPtr.current * 2;
	Nat bOffset = b.offset - sPtr.current * 2;
	Nat aSize = a.base.readSize * a.base.readCount;
	Nat bSize = b.base.readSize * b.base.readCount;

	while (aOffset < aSize & bOffset < bSize) {
		Byte aCh = a.base.readByte(aOffset);
		Byte bCh = b.base.readByte(bOffset);

		if (aCh != bCh) {
			if (aCh < bCh)
				return -1;
			else
				return 1;
		}

		if (aCh == 0)
			return 0;

		aOffset++;
		bOffset++;
	}

	0;
}

// Convert from c-string to a Storm string.
Str toStorm(ConstPtr<Byte> chars) {
	checkPtr(chars.base);

	Bool foundNull = false;
	Nat offset = chars.offset - sPtr.current * 2;
	Nat size = chars.base.readSize * chars.base.readCount;
	StrBuf buf;
	while (offset < size) {
		Byte b = chars.base.readByte(offset);
		if (b == 0) {
			foundNull = true;
			break;
		}

		buf << Char(b.nat);

		offset++;
	}

	if (!foundNull)
		throw PtrError("buffer overflow", "Missing 0-byte at the end of the string.");

	buf.toS;
}
