/*----- PROTECTED REGION ID(TangoTestClass.h) ENABLED START -----*/
//=============================================================================
//
// file :        TangoTestClass.h
//
// description : Include for the TangoTest root class.
//               This class is the singleton class for
//                the TangoTest device class.
//               It contains all properties and methods which the 
//               TangoTest requires only once e.g. the commands.
//
// project :     TANGO Device Server for testing generic clients
//
// This file is part of Tango device class.
// 
// Tango is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// Tango is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with Tango.  If not, see <http://www.gnu.org/licenses/>.
// 
// $Author$
//
// $Revision$
// $Date$
//
// $HeadURL:  $
//
//=============================================================================
//                This file is generated by POGO
//        (Program Obviously used to Generate tango Object)
//=============================================================================


#ifndef TangoTestClass_H
#define TangoTestClass_H

#include <tango/tango.h>
#include "TangoTest.h"

/*----- PROTECTED REGION END -----*/	//	TangoTestClass.h


namespace TangoTest_ns
{
/*----- PROTECTED REGION ID(TangoTestClass::classes for dynamic creation) ENABLED START -----*/


/*----- PROTECTED REGION END -----*/	//	TangoTestClass::classes for dynamic creation

//=========================================
//	Define classes for attributes
//=========================================
//	Attribute ampli class definition
class ampliAttrib: public Tango::Attr
{
public:
	ampliAttrib():Attr("ampli",
			Tango::DEV_DOUBLE, Tango::WRITE) {}
	~ampliAttrib() {}
	virtual void write(Tango::DeviceImpl *dev,Tango::WAttribute &att)
		{(static_cast<TangoTest *>(dev))->write_ampli(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
		{return (static_cast<TangoTest *>(dev))->is_ampli_allowed(ty);}
};

//	Attribute boolean_scalar class definition
class boolean_scalarAttrib: public Tango::Attr
{
public:
	boolean_scalarAttrib():Attr("boolean_scalar",
			Tango::DEV_BOOLEAN, Tango::READ_WRITE) {}
	~boolean_scalarAttrib() {}
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
		{(static_cast<TangoTest *>(dev))->read_boolean_scalar(att);}
	virtual void write(Tango::DeviceImpl *dev,Tango::WAttribute &att)
		{(static_cast<TangoTest *>(dev))->write_boolean_scalar(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
		{return (static_cast<TangoTest *>(dev))->is_boolean_scalar_allowed(ty);}
};

//	Attribute double_scalar class definition
class double_scalarAttrib: public Tango::Attr
{
public:
	double_scalarAttrib():Attr("double_scalar",
			Tango::DEV_DOUBLE, Tango::READ_WRITE) {}
	~double_scalarAttrib() {}
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
		{(static_cast<TangoTest *>(dev))->read_double_scalar(att);}
	virtual void write(Tango::DeviceImpl *dev,Tango::WAttribute &att)
		{(static_cast<TangoTest *>(dev))->write_double_scalar(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
		{return (static_cast<TangoTest *>(dev))->is_double_scalar_allowed(ty);}
};

//	Attribute double_scalar_rww class definition
class double_scalar_rwwAttrib: public Tango::Attr
{
public:
	double_scalar_rwwAttrib():Attr("double_scalar_rww",
			Tango::DEV_DOUBLE, Tango::READ_WITH_WRITE, "double_scalar_w") {}
	~double_scalar_rwwAttrib() {}
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
		{(static_cast<TangoTest *>(dev))->read_double_scalar_rww(att);}
	virtual void write(Tango::DeviceImpl *dev,Tango::WAttribute &att)
		{(static_cast<TangoTest *>(dev))->write_double_scalar_rww(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
		{return (static_cast<TangoTest *>(dev))->is_double_scalar_rww_allowed(ty);}
};

//	Attribute double_scalar_w class definition
class double_scalar_wAttrib: public Tango::Attr
{
public:
	double_scalar_wAttrib():Attr("double_scalar_w",
			Tango::DEV_DOUBLE, Tango::WRITE) {}
	~double_scalar_wAttrib() {}
	virtual void write(Tango::DeviceImpl *dev,Tango::WAttribute &att)
		{(static_cast<TangoTest *>(dev))->write_double_scalar_w(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
		{return (static_cast<TangoTest *>(dev))->is_double_scalar_w_allowed(ty);}
};

//	Attribute float_scalar class definition
class float_scalarAttrib: public Tango::Attr
{
public:
	float_scalarAttrib():Attr("float_scalar",
			Tango::DEV_FLOAT, Tango::READ_WRITE) {}
	~float_scalarAttrib() {}
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
		{(static_cast<TangoTest *>(dev))->read_float_scalar(att);}
	virtual void write(Tango::DeviceImpl *dev,Tango::WAttribute &att)
		{(static_cast<TangoTest *>(dev))->write_float_scalar(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
		{return (static_cast<TangoTest *>(dev))->is_float_scalar_allowed(ty);}
};

//	Attribute long64_scalar class definition
class long64_scalarAttrib: public Tango::Attr
{
public:
	long64_scalarAttrib():Attr("long64_scalar",
			Tango::DEV_LONG64, Tango::READ_WRITE) {}
	~long64_scalarAttrib() {}
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
		{(static_cast<TangoTest *>(dev))->read_long64_scalar(att);}
	virtual void write(Tango::DeviceImpl *dev,Tango::WAttribute &att)
		{(static_cast<TangoTest *>(dev))->write_long64_scalar(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
		{return (static_cast<TangoTest *>(dev))->is_long64_scalar_allowed(ty);}
};

//	Attribute long_scalar class definition
class long_scalarAttrib: public Tango::Attr
{
public:
	long_scalarAttrib():Attr("long_scalar",
			Tango::DEV_LONG, Tango::READ_WRITE) {}
	~long_scalarAttrib() {}
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
		{(static_cast<TangoTest *>(dev))->read_long_scalar(att);}
	virtual void write(Tango::DeviceImpl *dev,Tango::WAttribute &att)
		{(static_cast<TangoTest *>(dev))->write_long_scalar(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
		{return (static_cast<TangoTest *>(dev))->is_long_scalar_allowed(ty);}
};

//	Attribute long_scalar_rww class definition
class long_scalar_rwwAttrib: public Tango::Attr
{
public:
	long_scalar_rwwAttrib():Attr("long_scalar_rww",
			Tango::DEV_LONG, Tango::READ_WITH_WRITE, "long_scalar_w") {}
	~long_scalar_rwwAttrib() {}
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
		{(static_cast<TangoTest *>(dev))->read_long_scalar_rww(att);}
	virtual void write(Tango::DeviceImpl *dev,Tango::WAttribute &att)
		{(static_cast<TangoTest *>(dev))->write_long_scalar_rww(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
		{return (static_cast<TangoTest *>(dev))->is_long_scalar_rww_allowed(ty);}
};

//	Attribute long_scalar_w class definition
class long_scalar_wAttrib: public Tango::Attr
{
public:
	long_scalar_wAttrib():Attr("long_scalar_w",
			Tango::DEV_LONG, Tango::WRITE) {}
	~long_scalar_wAttrib() {}
	virtual void write(Tango::DeviceImpl *dev,Tango::WAttribute &att)
		{(static_cast<TangoTest *>(dev))->write_long_scalar_w(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
		{return (static_cast<TangoTest *>(dev))->is_long_scalar_w_allowed(ty);}
};

//	Attribute no_value class definition
class no_valueAttrib: public Tango::Attr
{
public:
	no_valueAttrib():Attr("no_value",
			Tango::DEV_LONG, Tango::READ) {}
	~no_valueAttrib() {}
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
		{(static_cast<TangoTest *>(dev))->read_no_value(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
		{return (static_cast<TangoTest *>(dev))->is_no_value_allowed(ty);}
};

//	Attribute short_scalar class definition
class short_scalarAttrib: public Tango::Attr
{
public:
	short_scalarAttrib():Attr("short_scalar",
			Tango::DEV_SHORT, Tango::READ_WRITE) {}
	~short_scalarAttrib() {}
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
		{(static_cast<TangoTest *>(dev))->read_short_scalar(att);}
	virtual void write(Tango::DeviceImpl *dev,Tango::WAttribute &att)
		{(static_cast<TangoTest *>(dev))->write_short_scalar(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
		{return (static_cast<TangoTest *>(dev))->is_short_scalar_allowed(ty);}
};

//	Attribute short_scalar_ro class definition
class short_scalar_roAttrib: public Tango::Attr
{
public:
	short_scalar_roAttrib():Attr("short_scalar_ro",
			Tango::DEV_SHORT, Tango::READ) {}
	~short_scalar_roAttrib() {}
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
		{(static_cast<TangoTest *>(dev))->read_short_scalar_ro(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
		{return (static_cast<TangoTest *>(dev))->is_short_scalar_ro_allowed(ty);}
};

//	Attribute short_scalar_rww class definition
class short_scalar_rwwAttrib: public Tango::Attr
{
public:
	short_scalar_rwwAttrib():Attr("short_scalar_rww",
			Tango::DEV_SHORT, Tango::READ_WITH_WRITE, "short_scalar_w") {}
	~short_scalar_rwwAttrib() {}
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
		{(static_cast<TangoTest *>(dev))->read_short_scalar_rww(att);}
	virtual void write(Tango::DeviceImpl *dev,Tango::WAttribute &att)
		{(static_cast<TangoTest *>(dev))->write_short_scalar_rww(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
		{return (static_cast<TangoTest *>(dev))->is_short_scalar_rww_allowed(ty);}
};

//	Attribute short_scalar_w class definition
class short_scalar_wAttrib: public Tango::Attr
{
public:
	short_scalar_wAttrib():Attr("short_scalar_w",
			Tango::DEV_SHORT, Tango::WRITE) {}
	~short_scalar_wAttrib() {}
	virtual void write(Tango::DeviceImpl *dev,Tango::WAttribute &att)
		{(static_cast<TangoTest *>(dev))->write_short_scalar_w(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
		{return (static_cast<TangoTest *>(dev))->is_short_scalar_w_allowed(ty);}
};

//	Attribute string_scalar class definition
class string_scalarAttrib: public Tango::Attr
{
public:
	string_scalarAttrib():Attr("string_scalar",
			Tango::DEV_STRING, Tango::READ_WRITE) {}
	~string_scalarAttrib() {}
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
		{(static_cast<TangoTest *>(dev))->read_string_scalar(att);}
	virtual void write(Tango::DeviceImpl *dev,Tango::WAttribute &att)
		{(static_cast<TangoTest *>(dev))->write_string_scalar(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
		{return (static_cast<TangoTest *>(dev))->is_string_scalar_allowed(ty);}
};

//	Attribute throw_exception class definition
class throw_exceptionAttrib: public Tango::Attr
{
public:
	throw_exceptionAttrib():Attr("throw_exception",
			Tango::DEV_LONG, Tango::READ) {}
	~throw_exceptionAttrib() {}
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
		{(static_cast<TangoTest *>(dev))->read_throw_exception(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
		{return (static_cast<TangoTest *>(dev))->is_throw_exception_allowed(ty);}
};

//	Attribute uchar_scalar class definition
class uchar_scalarAttrib: public Tango::Attr
{
public:
	uchar_scalarAttrib():Attr("uchar_scalar",
			Tango::DEV_UCHAR, Tango::READ_WRITE) {}
	~uchar_scalarAttrib() {}
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
		{(static_cast<TangoTest *>(dev))->read_uchar_scalar(att);}
	virtual void write(Tango::DeviceImpl *dev,Tango::WAttribute &att)
		{(static_cast<TangoTest *>(dev))->write_uchar_scalar(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
		{return (static_cast<TangoTest *>(dev))->is_uchar_scalar_allowed(ty);}
};

//	Attribute ulong64_scalar class definition
class ulong64_scalarAttrib: public Tango::Attr
{
public:
	ulong64_scalarAttrib():Attr("ulong64_scalar",
			Tango::DEV_ULONG64, Tango::READ_WRITE) {}
	~ulong64_scalarAttrib() {}
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
		{(static_cast<TangoTest *>(dev))->read_ulong64_scalar(att);}
	virtual void write(Tango::DeviceImpl *dev,Tango::WAttribute &att)
		{(static_cast<TangoTest *>(dev))->write_ulong64_scalar(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
		{return (static_cast<TangoTest *>(dev))->is_ulong64_scalar_allowed(ty);}
};

//	Attribute ushort_scalar class definition
class ushort_scalarAttrib: public Tango::Attr
{
public:
	ushort_scalarAttrib():Attr("ushort_scalar",
			Tango::DEV_USHORT, Tango::READ_WRITE) {}
	~ushort_scalarAttrib() {}
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
		{(static_cast<TangoTest *>(dev))->read_ushort_scalar(att);}
	virtual void write(Tango::DeviceImpl *dev,Tango::WAttribute &att)
		{(static_cast<TangoTest *>(dev))->write_ushort_scalar(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
		{return (static_cast<TangoTest *>(dev))->is_ushort_scalar_allowed(ty);}
};

//	Attribute ulong_scalar class definition
class ulong_scalarAttrib: public Tango::Attr
{
public:
	ulong_scalarAttrib():Attr("ulong_scalar",
			Tango::DEV_ULONG, Tango::READ_WRITE) {}
	~ulong_scalarAttrib() {}
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
		{(static_cast<TangoTest *>(dev))->read_ulong_scalar(att);}
	virtual void write(Tango::DeviceImpl *dev,Tango::WAttribute &att)
		{(static_cast<TangoTest *>(dev))->write_ulong_scalar(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
		{return (static_cast<TangoTest *>(dev))->is_ulong_scalar_allowed(ty);}
};

//	Attribute enum_scalar class definition
class enum_scalarAttrib: public Tango::Attr
{
public:
	enum_scalarAttrib():Attr("enum_scalar",
			Tango::DEV_ENUM, Tango::READ_WRITE) {}
	~enum_scalarAttrib() {}
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
		{(static_cast<TangoTest *>(dev))->read_enum_scalar(att);}
	virtual void write(Tango::DeviceImpl *dev,Tango::WAttribute &att)
		{(static_cast<TangoTest *>(dev))->write_enum_scalar(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
		{return (static_cast<TangoTest *>(dev))->is_enum_scalar_allowed(ty);}
	virtual bool same_type(const std::type_info &in_type) {return typeid(enum_scalarEnum) == in_type;}
	virtual std::string get_enum_type() {return std::string("enum_scalarEnum");}
};

//	Attribute freq class definition
class freqAttrib: public Tango::Attr
{
public:
	freqAttrib():Attr("freq",
			Tango::DEV_DOUBLE, Tango::WRITE) {}
	~freqAttrib() {}
	virtual void write(Tango::DeviceImpl *dev,Tango::WAttribute &att)
		{(static_cast<TangoTest *>(dev))->write_freq(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
		{return (static_cast<TangoTest *>(dev))->is_freq_allowed(ty);}
};

//	Attribute enum_scalar_ro class definition
class enum_scalar_roAttrib: public Tango::Attr
{
public:
	enum_scalar_roAttrib():Attr("enum_scalar_ro",
			Tango::DEV_ENUM, Tango::READ) {}
	~enum_scalar_roAttrib() {}
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
		{(static_cast<TangoTest *>(dev))->read_enum_scalar_ro(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
		{return (static_cast<TangoTest *>(dev))->is_enum_scalar_ro_allowed(ty);}
	virtual bool same_type(const std::type_info &in_type) {return typeid(enum_scalar_roEnum) == in_type;}
	virtual std::string get_enum_type() {return std::string("enum_scalar_roEnum");}
};

//	Attribute echo_mode class definition
class echo_modeAttrib: public Tango::Attr
{
public:
	echo_modeAttrib():Attr("echo_mode",
			Tango::DEV_BOOLEAN, Tango::READ_WRITE) {}
	~echo_modeAttrib() {}
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
		{(static_cast<TangoTest *>(dev))->read_echo_mode(att);}
	virtual void write(Tango::DeviceImpl *dev,Tango::WAttribute &att)
		{(static_cast<TangoTest *>(dev))->write_echo_mode(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
		{return (static_cast<TangoTest *>(dev))->is_echo_mode_allowed(ty);}
};

//	Attribute boolean_spectrum class definition
class boolean_spectrumAttrib: public Tango::SpectrumAttr
{
public:
	// Constants for boolean_spectrum attribute
	constexpr static long X_DATA_SIZE = 4096;
	boolean_spectrumAttrib():SpectrumAttr("boolean_spectrum",
			Tango::DEV_BOOLEAN, Tango::READ_WRITE, boolean_spectrumAttrib::X_DATA_SIZE) {}
	~boolean_spectrumAttrib() {}
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
		{(static_cast<TangoTest *>(dev))->read_boolean_spectrum(att);}
	virtual void write(Tango::DeviceImpl *dev,Tango::WAttribute &att)
		{(static_cast<TangoTest *>(dev))->write_boolean_spectrum(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
		{return (static_cast<TangoTest *>(dev))->is_boolean_spectrum_allowed(ty);}
};

//	Attribute boolean_spectrum_ro class definition
class boolean_spectrum_roAttrib: public Tango::SpectrumAttr
{
public:
	// Constants for boolean_spectrum_ro attribute
	constexpr static long X_DATA_SIZE = 4096;
	boolean_spectrum_roAttrib():SpectrumAttr("boolean_spectrum_ro",
			Tango::DEV_BOOLEAN, Tango::READ, boolean_spectrum_roAttrib::X_DATA_SIZE) {}
	~boolean_spectrum_roAttrib() {}
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
		{(static_cast<TangoTest *>(dev))->read_boolean_spectrum_ro(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
		{return (static_cast<TangoTest *>(dev))->is_boolean_spectrum_ro_allowed(ty);}
};

//	Attribute double_spectrum class definition
class double_spectrumAttrib: public Tango::SpectrumAttr
{
public:
	// Constants for double_spectrum attribute
	constexpr static long X_DATA_SIZE = 4096;
	double_spectrumAttrib():SpectrumAttr("double_spectrum",
			Tango::DEV_DOUBLE, Tango::READ_WRITE, double_spectrumAttrib::X_DATA_SIZE) {}
	~double_spectrumAttrib() {}
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
		{(static_cast<TangoTest *>(dev))->read_double_spectrum(att);}
	virtual void write(Tango::DeviceImpl *dev,Tango::WAttribute &att)
		{(static_cast<TangoTest *>(dev))->write_double_spectrum(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
		{return (static_cast<TangoTest *>(dev))->is_double_spectrum_allowed(ty);}
};

//	Attribute double_spectrum_ro class definition
class double_spectrum_roAttrib: public Tango::SpectrumAttr
{
public:
	// Constants for double_spectrum_ro attribute
	constexpr static long X_DATA_SIZE = 4096;
	double_spectrum_roAttrib():SpectrumAttr("double_spectrum_ro",
			Tango::DEV_DOUBLE, Tango::READ, double_spectrum_roAttrib::X_DATA_SIZE) {}
	~double_spectrum_roAttrib() {}
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
		{(static_cast<TangoTest *>(dev))->read_double_spectrum_ro(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
		{return (static_cast<TangoTest *>(dev))->is_double_spectrum_ro_allowed(ty);}
};

//	Attribute float_spectrum class definition
class float_spectrumAttrib: public Tango::SpectrumAttr
{
public:
	// Constants for float_spectrum attribute
	constexpr static long X_DATA_SIZE = 4096;
	float_spectrumAttrib():SpectrumAttr("float_spectrum",
			Tango::DEV_FLOAT, Tango::READ_WRITE, float_spectrumAttrib::X_DATA_SIZE) {}
	~float_spectrumAttrib() {}
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
		{(static_cast<TangoTest *>(dev))->read_float_spectrum(att);}
	virtual void write(Tango::DeviceImpl *dev,Tango::WAttribute &att)
		{(static_cast<TangoTest *>(dev))->write_float_spectrum(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
		{return (static_cast<TangoTest *>(dev))->is_float_spectrum_allowed(ty);}
};

//	Attribute float_spectrum_ro class definition
class float_spectrum_roAttrib: public Tango::SpectrumAttr
{
public:
	// Constants for float_spectrum_ro attribute
	constexpr static long X_DATA_SIZE = 4096;
	float_spectrum_roAttrib():SpectrumAttr("float_spectrum_ro",
			Tango::DEV_FLOAT, Tango::READ, float_spectrum_roAttrib::X_DATA_SIZE) {}
	~float_spectrum_roAttrib() {}
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
		{(static_cast<TangoTest *>(dev))->read_float_spectrum_ro(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
		{return (static_cast<TangoTest *>(dev))->is_float_spectrum_ro_allowed(ty);}
};

//	Attribute long64_spectrum_ro class definition
class long64_spectrum_roAttrib: public Tango::SpectrumAttr
{
public:
	// Constants for long64_spectrum_ro attribute
	constexpr static long X_DATA_SIZE = 4096;
	long64_spectrum_roAttrib():SpectrumAttr("long64_spectrum_ro",
			Tango::DEV_LONG64, Tango::READ, long64_spectrum_roAttrib::X_DATA_SIZE) {}
	~long64_spectrum_roAttrib() {}
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
		{(static_cast<TangoTest *>(dev))->read_long64_spectrum_ro(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
		{return (static_cast<TangoTest *>(dev))->is_long64_spectrum_ro_allowed(ty);}
};

//	Attribute long_spectrum class definition
class long_spectrumAttrib: public Tango::SpectrumAttr
{
public:
	// Constants for long_spectrum attribute
	constexpr static long X_DATA_SIZE = 4096;
	long_spectrumAttrib():SpectrumAttr("long_spectrum",
			Tango::DEV_LONG, Tango::READ_WRITE, long_spectrumAttrib::X_DATA_SIZE) {}
	~long_spectrumAttrib() {}
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
		{(static_cast<TangoTest *>(dev))->read_long_spectrum(att);}
	virtual void write(Tango::DeviceImpl *dev,Tango::WAttribute &att)
		{(static_cast<TangoTest *>(dev))->write_long_spectrum(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
		{return (static_cast<TangoTest *>(dev))->is_long_spectrum_allowed(ty);}
};

//	Attribute long_spectrum_ro class definition
class long_spectrum_roAttrib: public Tango::SpectrumAttr
{
public:
	// Constants for long_spectrum_ro attribute
	constexpr static long X_DATA_SIZE = 4096;
	long_spectrum_roAttrib():SpectrumAttr("long_spectrum_ro",
			Tango::DEV_LONG, Tango::READ, long_spectrum_roAttrib::X_DATA_SIZE) {}
	~long_spectrum_roAttrib() {}
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
		{(static_cast<TangoTest *>(dev))->read_long_spectrum_ro(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
		{return (static_cast<TangoTest *>(dev))->is_long_spectrum_ro_allowed(ty);}
};

//	Attribute short_spectrum class definition
class short_spectrumAttrib: public Tango::SpectrumAttr
{
public:
	// Constants for short_spectrum attribute
	constexpr static long X_DATA_SIZE = 4096;
	short_spectrumAttrib():SpectrumAttr("short_spectrum",
			Tango::DEV_SHORT, Tango::READ_WRITE, short_spectrumAttrib::X_DATA_SIZE) {}
	~short_spectrumAttrib() {}
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
		{(static_cast<TangoTest *>(dev))->read_short_spectrum(att);}
	virtual void write(Tango::DeviceImpl *dev,Tango::WAttribute &att)
		{(static_cast<TangoTest *>(dev))->write_short_spectrum(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
		{return (static_cast<TangoTest *>(dev))->is_short_spectrum_allowed(ty);}
};

//	Attribute short_spectrum_ro class definition
class short_spectrum_roAttrib: public Tango::SpectrumAttr
{
public:
	// Constants for short_spectrum_ro attribute
	constexpr static long X_DATA_SIZE = 4096;
	short_spectrum_roAttrib():SpectrumAttr("short_spectrum_ro",
			Tango::DEV_SHORT, Tango::READ, short_spectrum_roAttrib::X_DATA_SIZE) {}
	~short_spectrum_roAttrib() {}
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
		{(static_cast<TangoTest *>(dev))->read_short_spectrum_ro(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
		{return (static_cast<TangoTest *>(dev))->is_short_spectrum_ro_allowed(ty);}
};

//	Attribute string_spectrum class definition
class string_spectrumAttrib: public Tango::SpectrumAttr
{
public:
	// Constants for string_spectrum attribute
	constexpr static long X_DATA_SIZE = 256;
	string_spectrumAttrib():SpectrumAttr("string_spectrum",
			Tango::DEV_STRING, Tango::READ_WRITE, string_spectrumAttrib::X_DATA_SIZE) {}
	~string_spectrumAttrib() {}
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
		{(static_cast<TangoTest *>(dev))->read_string_spectrum(att);}
	virtual void write(Tango::DeviceImpl *dev,Tango::WAttribute &att)
		{(static_cast<TangoTest *>(dev))->write_string_spectrum(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
		{return (static_cast<TangoTest *>(dev))->is_string_spectrum_allowed(ty);}
};

//	Attribute string_spectrum_ro class definition
class string_spectrum_roAttrib: public Tango::SpectrumAttr
{
public:
	// Constants for string_spectrum_ro attribute
	constexpr static long X_DATA_SIZE = 256;
	string_spectrum_roAttrib():SpectrumAttr("string_spectrum_ro",
			Tango::DEV_STRING, Tango::READ, string_spectrum_roAttrib::X_DATA_SIZE) {}
	~string_spectrum_roAttrib() {}
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
		{(static_cast<TangoTest *>(dev))->read_string_spectrum_ro(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
		{return (static_cast<TangoTest *>(dev))->is_string_spectrum_ro_allowed(ty);}
};

//	Attribute uchar_spectrum class definition
class uchar_spectrumAttrib: public Tango::SpectrumAttr
{
public:
	// Constants for uchar_spectrum attribute
	constexpr static long X_DATA_SIZE = 4096;
	uchar_spectrumAttrib():SpectrumAttr("uchar_spectrum",
			Tango::DEV_UCHAR, Tango::READ_WRITE, uchar_spectrumAttrib::X_DATA_SIZE) {}
	~uchar_spectrumAttrib() {}
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
		{(static_cast<TangoTest *>(dev))->read_uchar_spectrum(att);}
	virtual void write(Tango::DeviceImpl *dev,Tango::WAttribute &att)
		{(static_cast<TangoTest *>(dev))->write_uchar_spectrum(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
		{return (static_cast<TangoTest *>(dev))->is_uchar_spectrum_allowed(ty);}
};

//	Attribute uchar_spectrum_ro class definition
class uchar_spectrum_roAttrib: public Tango::SpectrumAttr
{
public:
	// Constants for uchar_spectrum_ro attribute
	constexpr static long X_DATA_SIZE = 4096;
	uchar_spectrum_roAttrib():SpectrumAttr("uchar_spectrum_ro",
			Tango::DEV_UCHAR, Tango::READ, uchar_spectrum_roAttrib::X_DATA_SIZE) {}
	~uchar_spectrum_roAttrib() {}
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
		{(static_cast<TangoTest *>(dev))->read_uchar_spectrum_ro(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
		{return (static_cast<TangoTest *>(dev))->is_uchar_spectrum_ro_allowed(ty);}
};

//	Attribute ulong64_spectrum_ro class definition
class ulong64_spectrum_roAttrib: public Tango::SpectrumAttr
{
public:
	// Constants for ulong64_spectrum_ro attribute
	constexpr static long X_DATA_SIZE = 4096;
	ulong64_spectrum_roAttrib():SpectrumAttr("ulong64_spectrum_ro",
			Tango::DEV_ULONG64, Tango::READ, ulong64_spectrum_roAttrib::X_DATA_SIZE) {}
	~ulong64_spectrum_roAttrib() {}
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
		{(static_cast<TangoTest *>(dev))->read_ulong64_spectrum_ro(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
		{return (static_cast<TangoTest *>(dev))->is_ulong64_spectrum_ro_allowed(ty);}
};

//	Attribute ulong_spectrum_ro class definition
class ulong_spectrum_roAttrib: public Tango::SpectrumAttr
{
public:
	// Constants for ulong_spectrum_ro attribute
	constexpr static long X_DATA_SIZE = 4096;
	ulong_spectrum_roAttrib():SpectrumAttr("ulong_spectrum_ro",
			Tango::DEV_ULONG, Tango::READ, ulong_spectrum_roAttrib::X_DATA_SIZE) {}
	~ulong_spectrum_roAttrib() {}
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
		{(static_cast<TangoTest *>(dev))->read_ulong_spectrum_ro(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
		{return (static_cast<TangoTest *>(dev))->is_ulong_spectrum_ro_allowed(ty);}
};

//	Attribute ushort_spectrum class definition
class ushort_spectrumAttrib: public Tango::SpectrumAttr
{
public:
	// Constants for ushort_spectrum attribute
	constexpr static long X_DATA_SIZE = 4096;
	ushort_spectrumAttrib():SpectrumAttr("ushort_spectrum",
			Tango::DEV_USHORT, Tango::READ_WRITE, ushort_spectrumAttrib::X_DATA_SIZE) {}
	~ushort_spectrumAttrib() {}
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
		{(static_cast<TangoTest *>(dev))->read_ushort_spectrum(att);}
	virtual void write(Tango::DeviceImpl *dev,Tango::WAttribute &att)
		{(static_cast<TangoTest *>(dev))->write_ushort_spectrum(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
		{return (static_cast<TangoTest *>(dev))->is_ushort_spectrum_allowed(ty);}
};

//	Attribute ushort_spectrum_ro class definition
class ushort_spectrum_roAttrib: public Tango::SpectrumAttr
{
public:
	// Constants for ushort_spectrum_ro attribute
	constexpr static long X_DATA_SIZE = 4096;
	ushort_spectrum_roAttrib():SpectrumAttr("ushort_spectrum_ro",
			Tango::DEV_USHORT, Tango::READ, ushort_spectrum_roAttrib::X_DATA_SIZE) {}
	~ushort_spectrum_roAttrib() {}
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
		{(static_cast<TangoTest *>(dev))->read_ushort_spectrum_ro(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
		{return (static_cast<TangoTest *>(dev))->is_ushort_spectrum_ro_allowed(ty);}
};

//	Attribute wave class definition
class waveAttrib: public Tango::SpectrumAttr
{
public:
	// Constants for wave attribute
	constexpr static long X_DATA_SIZE = 4096;
	waveAttrib():SpectrumAttr("wave",
			Tango::DEV_DOUBLE, Tango::READ, waveAttrib::X_DATA_SIZE) {}
	~waveAttrib() {}
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
		{(static_cast<TangoTest *>(dev))->read_wave(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
		{return (static_cast<TangoTest *>(dev))->is_wave_allowed(ty);}
};

//	Attribute enum_spectrum class definition
class enum_spectrumAttrib: public Tango::SpectrumAttr
{
public:
	// Constants for enum_spectrum attribute
	constexpr static long X_DATA_SIZE = 4096;
	enum_spectrumAttrib():SpectrumAttr("enum_spectrum",
			Tango::DEV_ENUM, Tango::READ_WRITE, enum_spectrumAttrib::X_DATA_SIZE) {}
	~enum_spectrumAttrib() {}
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
		{(static_cast<TangoTest *>(dev))->read_enum_spectrum(att);}
	virtual void write(Tango::DeviceImpl *dev,Tango::WAttribute &att)
		{(static_cast<TangoTest *>(dev))->write_enum_spectrum(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
		{return (static_cast<TangoTest *>(dev))->is_enum_spectrum_allowed(ty);}
	virtual bool same_type(const std::type_info &in_type) {return typeid(enum_spectrumEnum) == in_type;}
	virtual std::string get_enum_type() {return std::string("enum_spectrumEnum");}
};

//	Attribute enum_spectrum_ro class definition
class enum_spectrum_roAttrib: public Tango::SpectrumAttr
{
public:
	// Constants for enum_spectrum_ro attribute
	constexpr static long X_DATA_SIZE = 4096;
	enum_spectrum_roAttrib():SpectrumAttr("enum_spectrum_ro",
			Tango::DEV_ENUM, Tango::READ, enum_spectrum_roAttrib::X_DATA_SIZE) {}
	~enum_spectrum_roAttrib() {}
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
		{(static_cast<TangoTest *>(dev))->read_enum_spectrum_ro(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
		{return (static_cast<TangoTest *>(dev))->is_enum_spectrum_ro_allowed(ty);}
	virtual bool same_type(const std::type_info &in_type) {return typeid(enum_spectrum_roEnum) == in_type;}
	virtual std::string get_enum_type() {return std::string("enum_spectrum_roEnum");}
};

//	Attribute boolean_image class definition
class boolean_imageAttrib: public Tango::ImageAttr
{
public:
	// Constants for boolean_image attribute
	constexpr static long X_DATA_SIZE = 251;
	constexpr static long Y_DATA_SIZE = 251;
	boolean_imageAttrib():ImageAttr("boolean_image",
			Tango::DEV_BOOLEAN, Tango::READ_WRITE, boolean_imageAttrib::X_DATA_SIZE, boolean_imageAttrib::Y_DATA_SIZE) {}
	~boolean_imageAttrib() {}
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
		{(static_cast<TangoTest *>(dev))->read_boolean_image(att);}
	virtual void write(Tango::DeviceImpl *dev,Tango::WAttribute &att)
		{(static_cast<TangoTest *>(dev))->write_boolean_image(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
		{return (static_cast<TangoTest *>(dev))->is_boolean_image_allowed(ty);}
};

//	Attribute boolean_image_ro class definition
class boolean_image_roAttrib: public Tango::ImageAttr
{
public:
	// Constants for boolean_image_ro attribute
	constexpr static long X_DATA_SIZE = 251;
	constexpr static long Y_DATA_SIZE = 251;
	boolean_image_roAttrib():ImageAttr("boolean_image_ro",
			Tango::DEV_BOOLEAN, Tango::READ, boolean_image_roAttrib::X_DATA_SIZE, boolean_image_roAttrib::Y_DATA_SIZE) {}
	~boolean_image_roAttrib() {}
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
		{(static_cast<TangoTest *>(dev))->read_boolean_image_ro(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
		{return (static_cast<TangoTest *>(dev))->is_boolean_image_ro_allowed(ty);}
};

//	Attribute double_image class definition
class double_imageAttrib: public Tango::ImageAttr
{
public:
	// Constants for double_image attribute
	constexpr static long X_DATA_SIZE = 251;
	constexpr static long Y_DATA_SIZE = 251;
	double_imageAttrib():ImageAttr("double_image",
			Tango::DEV_DOUBLE, Tango::READ_WRITE, double_imageAttrib::X_DATA_SIZE, double_imageAttrib::Y_DATA_SIZE) {}
	~double_imageAttrib() {}
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
		{(static_cast<TangoTest *>(dev))->read_double_image(att);}
	virtual void write(Tango::DeviceImpl *dev,Tango::WAttribute &att)
		{(static_cast<TangoTest *>(dev))->write_double_image(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
		{return (static_cast<TangoTest *>(dev))->is_double_image_allowed(ty);}
};

//	Attribute double_image_ro class definition
class double_image_roAttrib: public Tango::ImageAttr
{
public:
	// Constants for double_image_ro attribute
	constexpr static long X_DATA_SIZE = 251;
	constexpr static long Y_DATA_SIZE = 251;
	double_image_roAttrib():ImageAttr("double_image_ro",
			Tango::DEV_DOUBLE, Tango::READ, double_image_roAttrib::X_DATA_SIZE, double_image_roAttrib::Y_DATA_SIZE) {}
	~double_image_roAttrib() {}
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
		{(static_cast<TangoTest *>(dev))->read_double_image_ro(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
		{return (static_cast<TangoTest *>(dev))->is_double_image_ro_allowed(ty);}
};

//	Attribute float_image class definition
class float_imageAttrib: public Tango::ImageAttr
{
public:
	// Constants for float_image attribute
	constexpr static long X_DATA_SIZE = 251;
	constexpr static long Y_DATA_SIZE = 251;
	float_imageAttrib():ImageAttr("float_image",
			Tango::DEV_FLOAT, Tango::READ_WRITE, float_imageAttrib::X_DATA_SIZE, float_imageAttrib::Y_DATA_SIZE) {}
	~float_imageAttrib() {}
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
		{(static_cast<TangoTest *>(dev))->read_float_image(att);}
	virtual void write(Tango::DeviceImpl *dev,Tango::WAttribute &att)
		{(static_cast<TangoTest *>(dev))->write_float_image(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
		{return (static_cast<TangoTest *>(dev))->is_float_image_allowed(ty);}
};

//	Attribute float_image_ro class definition
class float_image_roAttrib: public Tango::ImageAttr
{
public:
	// Constants for float_image_ro attribute
	constexpr static long X_DATA_SIZE = 251;
	constexpr static long Y_DATA_SIZE = 251;
	float_image_roAttrib():ImageAttr("float_image_ro",
			Tango::DEV_FLOAT, Tango::READ, float_image_roAttrib::X_DATA_SIZE, float_image_roAttrib::Y_DATA_SIZE) {}
	~float_image_roAttrib() {}
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
		{(static_cast<TangoTest *>(dev))->read_float_image_ro(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
		{return (static_cast<TangoTest *>(dev))->is_float_image_ro_allowed(ty);}
};

//	Attribute long64_image_ro class definition
class long64_image_roAttrib: public Tango::ImageAttr
{
public:
	// Constants for long64_image_ro attribute
	constexpr static long X_DATA_SIZE = 251;
	constexpr static long Y_DATA_SIZE = 251;
	long64_image_roAttrib():ImageAttr("long64_image_ro",
			Tango::DEV_LONG64, Tango::READ, long64_image_roAttrib::X_DATA_SIZE, long64_image_roAttrib::Y_DATA_SIZE) {}
	~long64_image_roAttrib() {}
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
		{(static_cast<TangoTest *>(dev))->read_long64_image_ro(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
		{return (static_cast<TangoTest *>(dev))->is_long64_image_ro_allowed(ty);}
};

//	Attribute long_image class definition
class long_imageAttrib: public Tango::ImageAttr
{
public:
	// Constants for long_image attribute
	constexpr static long X_DATA_SIZE = 251;
	constexpr static long Y_DATA_SIZE = 251;
	long_imageAttrib():ImageAttr("long_image",
			Tango::DEV_LONG, Tango::READ_WRITE, long_imageAttrib::X_DATA_SIZE, long_imageAttrib::Y_DATA_SIZE) {}
	~long_imageAttrib() {}
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
		{(static_cast<TangoTest *>(dev))->read_long_image(att);}
	virtual void write(Tango::DeviceImpl *dev,Tango::WAttribute &att)
		{(static_cast<TangoTest *>(dev))->write_long_image(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
		{return (static_cast<TangoTest *>(dev))->is_long_image_allowed(ty);}
};

//	Attribute long_image_ro class definition
class long_image_roAttrib: public Tango::ImageAttr
{
public:
	// Constants for long_image_ro attribute
	constexpr static long X_DATA_SIZE = 251;
	constexpr static long Y_DATA_SIZE = 251;
	long_image_roAttrib():ImageAttr("long_image_ro",
			Tango::DEV_LONG, Tango::READ, long_image_roAttrib::X_DATA_SIZE, long_image_roAttrib::Y_DATA_SIZE) {}
	~long_image_roAttrib() {}
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
		{(static_cast<TangoTest *>(dev))->read_long_image_ro(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
		{return (static_cast<TangoTest *>(dev))->is_long_image_ro_allowed(ty);}
};

//	Attribute short_image class definition
class short_imageAttrib: public Tango::ImageAttr
{
public:
	// Constants for short_image attribute
	constexpr static long X_DATA_SIZE = 251;
	constexpr static long Y_DATA_SIZE = 251;
	short_imageAttrib():ImageAttr("short_image",
			Tango::DEV_SHORT, Tango::READ_WRITE, short_imageAttrib::X_DATA_SIZE, short_imageAttrib::Y_DATA_SIZE) {}
	~short_imageAttrib() {}
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
		{(static_cast<TangoTest *>(dev))->read_short_image(att);}
	virtual void write(Tango::DeviceImpl *dev,Tango::WAttribute &att)
		{(static_cast<TangoTest *>(dev))->write_short_image(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
		{return (static_cast<TangoTest *>(dev))->is_short_image_allowed(ty);}
};

//	Attribute short_image_ro class definition
class short_image_roAttrib: public Tango::ImageAttr
{
public:
	// Constants for short_image_ro attribute
	constexpr static long X_DATA_SIZE = 251;
	constexpr static long Y_DATA_SIZE = 251;
	short_image_roAttrib():ImageAttr("short_image_ro",
			Tango::DEV_SHORT, Tango::READ, short_image_roAttrib::X_DATA_SIZE, short_image_roAttrib::Y_DATA_SIZE) {}
	~short_image_roAttrib() {}
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
		{(static_cast<TangoTest *>(dev))->read_short_image_ro(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
		{return (static_cast<TangoTest *>(dev))->is_short_image_ro_allowed(ty);}
};

//	Attribute string_image class definition
class string_imageAttrib: public Tango::ImageAttr
{
public:
	// Constants for string_image attribute
	constexpr static long X_DATA_SIZE = 256;
	constexpr static long Y_DATA_SIZE = 256;
	string_imageAttrib():ImageAttr("string_image",
			Tango::DEV_STRING, Tango::READ_WRITE, string_imageAttrib::X_DATA_SIZE, string_imageAttrib::Y_DATA_SIZE) {}
	~string_imageAttrib() {}
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
		{(static_cast<TangoTest *>(dev))->read_string_image(att);}
	virtual void write(Tango::DeviceImpl *dev,Tango::WAttribute &att)
		{(static_cast<TangoTest *>(dev))->write_string_image(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
		{return (static_cast<TangoTest *>(dev))->is_string_image_allowed(ty);}
};

//	Attribute string_image_ro class definition
class string_image_roAttrib: public Tango::ImageAttr
{
public:
	// Constants for string_image_ro attribute
	constexpr static long X_DATA_SIZE = 256;
	constexpr static long Y_DATA_SIZE = 256;
	string_image_roAttrib():ImageAttr("string_image_ro",
			Tango::DEV_STRING, Tango::READ, string_image_roAttrib::X_DATA_SIZE, string_image_roAttrib::Y_DATA_SIZE) {}
	~string_image_roAttrib() {}
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
		{(static_cast<TangoTest *>(dev))->read_string_image_ro(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
		{return (static_cast<TangoTest *>(dev))->is_string_image_ro_allowed(ty);}
};

//	Attribute uchar_image class definition
class uchar_imageAttrib: public Tango::ImageAttr
{
public:
	// Constants for uchar_image attribute
	constexpr static long X_DATA_SIZE = 251;
	constexpr static long Y_DATA_SIZE = 251;
	uchar_imageAttrib():ImageAttr("uchar_image",
			Tango::DEV_UCHAR, Tango::READ_WRITE, uchar_imageAttrib::X_DATA_SIZE, uchar_imageAttrib::Y_DATA_SIZE) {}
	~uchar_imageAttrib() {}
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
		{(static_cast<TangoTest *>(dev))->read_uchar_image(att);}
	virtual void write(Tango::DeviceImpl *dev,Tango::WAttribute &att)
		{(static_cast<TangoTest *>(dev))->write_uchar_image(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
		{return (static_cast<TangoTest *>(dev))->is_uchar_image_allowed(ty);}
};

//	Attribute uchar_image_ro class definition
class uchar_image_roAttrib: public Tango::ImageAttr
{
public:
	// Constants for uchar_image_ro attribute
	constexpr static long X_DATA_SIZE = 251;
	constexpr static long Y_DATA_SIZE = 251;
	uchar_image_roAttrib():ImageAttr("uchar_image_ro",
			Tango::DEV_UCHAR, Tango::READ, uchar_image_roAttrib::X_DATA_SIZE, uchar_image_roAttrib::Y_DATA_SIZE) {}
	~uchar_image_roAttrib() {}
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
		{(static_cast<TangoTest *>(dev))->read_uchar_image_ro(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
		{return (static_cast<TangoTest *>(dev))->is_uchar_image_ro_allowed(ty);}
};

//	Attribute ulong64_image_ro class definition
class ulong64_image_roAttrib: public Tango::ImageAttr
{
public:
	// Constants for ulong64_image_ro attribute
	constexpr static long X_DATA_SIZE = 251;
	constexpr static long Y_DATA_SIZE = 251;
	ulong64_image_roAttrib():ImageAttr("ulong64_image_ro",
			Tango::DEV_ULONG64, Tango::READ, ulong64_image_roAttrib::X_DATA_SIZE, ulong64_image_roAttrib::Y_DATA_SIZE) {}
	~ulong64_image_roAttrib() {}
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
		{(static_cast<TangoTest *>(dev))->read_ulong64_image_ro(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
		{return (static_cast<TangoTest *>(dev))->is_ulong64_image_ro_allowed(ty);}
};

//	Attribute ulong_image_ro class definition
class ulong_image_roAttrib: public Tango::ImageAttr
{
public:
	// Constants for ulong_image_ro attribute
	constexpr static long X_DATA_SIZE = 251;
	constexpr static long Y_DATA_SIZE = 251;
	ulong_image_roAttrib():ImageAttr("ulong_image_ro",
			Tango::DEV_ULONG, Tango::READ, ulong_image_roAttrib::X_DATA_SIZE, ulong_image_roAttrib::Y_DATA_SIZE) {}
	~ulong_image_roAttrib() {}
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
		{(static_cast<TangoTest *>(dev))->read_ulong_image_ro(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
		{return (static_cast<TangoTest *>(dev))->is_ulong_image_ro_allowed(ty);}
};

//	Attribute ushort_image class definition
class ushort_imageAttrib: public Tango::ImageAttr
{
public:
	// Constants for ushort_image attribute
	constexpr static long X_DATA_SIZE = 251;
	constexpr static long Y_DATA_SIZE = 251;
	ushort_imageAttrib():ImageAttr("ushort_image",
			Tango::DEV_USHORT, Tango::READ_WRITE, ushort_imageAttrib::X_DATA_SIZE, ushort_imageAttrib::Y_DATA_SIZE) {}
	~ushort_imageAttrib() {}
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
		{(static_cast<TangoTest *>(dev))->read_ushort_image(att);}
	virtual void write(Tango::DeviceImpl *dev,Tango::WAttribute &att)
		{(static_cast<TangoTest *>(dev))->write_ushort_image(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
		{return (static_cast<TangoTest *>(dev))->is_ushort_image_allowed(ty);}
};

//	Attribute ushort_image_ro class definition
class ushort_image_roAttrib: public Tango::ImageAttr
{
public:
	// Constants for ushort_image_ro attribute
	constexpr static long X_DATA_SIZE = 8192;
	constexpr static long Y_DATA_SIZE = 8192;
	ushort_image_roAttrib():ImageAttr("ushort_image_ro",
			Tango::DEV_USHORT, Tango::READ, ushort_image_roAttrib::X_DATA_SIZE, ushort_image_roAttrib::Y_DATA_SIZE) {}
	~ushort_image_roAttrib() {}
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
		{(static_cast<TangoTest *>(dev))->read_ushort_image_ro(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
		{return (static_cast<TangoTest *>(dev))->is_ushort_image_ro_allowed(ty);}
};

//	Attribute enum_image_ro class definition
class enum_image_roAttrib: public Tango::ImageAttr
{
public:
	// Constants for enum_image_ro attribute
	constexpr static long X_DATA_SIZE = 251;
	constexpr static long Y_DATA_SIZE = 251;
	enum_image_roAttrib():ImageAttr("enum_image_ro",
			Tango::DEV_ENUM, Tango::READ, enum_image_roAttrib::X_DATA_SIZE, enum_image_roAttrib::Y_DATA_SIZE) {}
	~enum_image_roAttrib() {}
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
		{(static_cast<TangoTest *>(dev))->read_enum_image_ro(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
		{return (static_cast<TangoTest *>(dev))->is_enum_image_ro_allowed(ty);}
	virtual bool same_type(const std::type_info &in_type) {return typeid(enum_image_roEnum) == in_type;}
	virtual std::string get_enum_type() {return std::string("enum_image_roEnum");}
};

//	Attribute enum_image class definition
class enum_imageAttrib: public Tango::ImageAttr
{
public:
	// Constants for enum_image attribute
	constexpr static long X_DATA_SIZE = 251;
	constexpr static long Y_DATA_SIZE = 251;
	enum_imageAttrib():ImageAttr("enum_image",
			Tango::DEV_ENUM, Tango::READ_WRITE, enum_imageAttrib::X_DATA_SIZE, enum_imageAttrib::Y_DATA_SIZE) {}
	~enum_imageAttrib() {}
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
		{(static_cast<TangoTest *>(dev))->read_enum_image(att);}
	virtual void write(Tango::DeviceImpl *dev,Tango::WAttribute &att)
		{(static_cast<TangoTest *>(dev))->write_enum_image(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
		{return (static_cast<TangoTest *>(dev))->is_enum_image_allowed(ty);}
	virtual bool same_type(const std::type_info &in_type) {return typeid(enum_imageEnum) == in_type;}
	virtual std::string get_enum_type() {return std::string("enum_imageEnum");}
};


//=========================================
//	Define classes for pipes
//=========================================
//	Pipe string_long_short_ro class definition
class string_long_short_roClass: public Tango::Pipe
{
public:
	string_long_short_roClass(const std::string &name, Tango::DispLevel level)
		:Pipe(name, level) {}

	~string_long_short_roClass() {}

	virtual bool is_allowed (Tango::DeviceImpl *dev,Tango::PipeReqType _prt)
		{return (static_cast<TangoTest *>(dev))->is_string_long_short_ro_allowed(_prt);}
	virtual void read(Tango::DeviceImpl *dev)
		{(static_cast<TangoTest *>(dev))->read_string_long_short_ro(*this);}
};

//	Pipe generic_blob_rw class definition
class generic_blob_rwClass: public Tango::WPipe
{
public:
	generic_blob_rwClass(const std::string &name, Tango::DispLevel level)
		:WPipe(name, level) {}

	~generic_blob_rwClass() {}

	virtual bool is_allowed (Tango::DeviceImpl *dev,Tango::PipeReqType _prt)
		{return (static_cast<TangoTest *>(dev))->is_generic_blob_rw_allowed(_prt);}
	virtual void read(Tango::DeviceImpl *dev)
		{(static_cast<TangoTest *>(dev))->read_generic_blob_rw(*this);}
	virtual void write(Tango::DeviceImpl *dev)
		{(static_cast<TangoTest *>(dev))->write_generic_blob_rw(*this);}
};


//=========================================
//	Define classes for commands
//=========================================
//	Command CrashFromDevelopperThread class definition
class CrashFromDevelopperThreadClass : public Tango::Command
{
public:
	CrashFromDevelopperThreadClass(const char   *cmd_name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(cmd_name,in,out,in_desc,out_desc, level)	{}

	CrashFromDevelopperThreadClass(const char   *cmd_name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(cmd_name,in,out)	{}
	~CrashFromDevelopperThreadClass() {}

	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<TangoTest *>(dev))->is_CrashFromDevelopperThread_allowed(any);}
};

//	Command CrashFromOmniThread class definition
class CrashFromOmniThreadClass : public Tango::Command
{
public:
	CrashFromOmniThreadClass(const char   *cmd_name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(cmd_name,in,out,in_desc,out_desc, level)	{}

	CrashFromOmniThreadClass(const char   *cmd_name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(cmd_name,in,out)	{}
	~CrashFromOmniThreadClass() {}

	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<TangoTest *>(dev))->is_CrashFromOmniThread_allowed(any);}
};

//	Command DevBoolean class definition
class DevBooleanClass : public Tango::Command
{
public:
	DevBooleanClass(const char   *cmd_name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(cmd_name,in,out,in_desc,out_desc, level)	{}

	DevBooleanClass(const char   *cmd_name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(cmd_name,in,out)	{}
	~DevBooleanClass() {}

	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<TangoTest *>(dev))->is_DevBoolean_allowed(any);}
};

//	Command DevDouble class definition
class DevDoubleClass : public Tango::Command
{
public:
	DevDoubleClass(const char   *cmd_name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(cmd_name,in,out,in_desc,out_desc, level)	{}

	DevDoubleClass(const char   *cmd_name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(cmd_name,in,out)	{}
	~DevDoubleClass() {}

	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<TangoTest *>(dev))->is_DevDouble_allowed(any);}
};

//	Command DevFloat class definition
class DevFloatClass : public Tango::Command
{
public:
	DevFloatClass(const char   *cmd_name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(cmd_name,in,out,in_desc,out_desc, level)	{}

	DevFloatClass(const char   *cmd_name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(cmd_name,in,out)	{}
	~DevFloatClass() {}

	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<TangoTest *>(dev))->is_DevFloat_allowed(any);}
};

//	Command DevLong class definition
class DevLongClass : public Tango::Command
{
public:
	DevLongClass(const char   *cmd_name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(cmd_name,in,out,in_desc,out_desc, level)	{}

	DevLongClass(const char   *cmd_name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(cmd_name,in,out)	{}
	~DevLongClass() {}

	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<TangoTest *>(dev))->is_DevLong_allowed(any);}
};

//	Command DevLong64 class definition
class DevLong64Class : public Tango::Command
{
public:
	DevLong64Class(const char   *cmd_name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(cmd_name,in,out,in_desc,out_desc, level)	{}

	DevLong64Class(const char   *cmd_name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(cmd_name,in,out)	{}
	~DevLong64Class() {}

	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<TangoTest *>(dev))->is_DevLong64_allowed(any);}
};

//	Command DevShort class definition
class DevShortClass : public Tango::Command
{
public:
	DevShortClass(const char   *cmd_name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(cmd_name,in,out,in_desc,out_desc, level)	{}

	DevShortClass(const char   *cmd_name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(cmd_name,in,out)	{}
	~DevShortClass() {}

	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<TangoTest *>(dev))->is_DevShort_allowed(any);}
};

//	Command DevString class definition
class DevStringClass : public Tango::Command
{
public:
	DevStringClass(const char   *cmd_name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(cmd_name,in,out,in_desc,out_desc, level)	{}

	DevStringClass(const char   *cmd_name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(cmd_name,in,out)	{}
	~DevStringClass() {}

	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<TangoTest *>(dev))->is_DevString_allowed(any);}
};

//	Command DevULong class definition
class DevULongClass : public Tango::Command
{
public:
	DevULongClass(const char   *cmd_name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(cmd_name,in,out,in_desc,out_desc, level)	{}

	DevULongClass(const char   *cmd_name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(cmd_name,in,out)	{}
	~DevULongClass() {}

	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<TangoTest *>(dev))->is_DevULong_allowed(any);}
};

//	Command DevULong64 class definition
class DevULong64Class : public Tango::Command
{
public:
	DevULong64Class(const char   *cmd_name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(cmd_name,in,out,in_desc,out_desc, level)	{}

	DevULong64Class(const char   *cmd_name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(cmd_name,in,out)	{}
	~DevULong64Class() {}

	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<TangoTest *>(dev))->is_DevULong64_allowed(any);}
};

//	Command DevUShort class definition
class DevUShortClass : public Tango::Command
{
public:
	DevUShortClass(const char   *cmd_name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(cmd_name,in,out,in_desc,out_desc, level)	{}

	DevUShortClass(const char   *cmd_name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(cmd_name,in,out)	{}
	~DevUShortClass() {}

	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<TangoTest *>(dev))->is_DevUShort_allowed(any);}
};

//	Command DevVarCharArray class definition
class DevVarCharArrayClass : public Tango::Command
{
public:
	DevVarCharArrayClass(const char   *cmd_name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(cmd_name,in,out,in_desc,out_desc, level)	{}

	DevVarCharArrayClass(const char   *cmd_name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(cmd_name,in,out)	{}
	~DevVarCharArrayClass() {}

	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<TangoTest *>(dev))->is_DevVarCharArray_allowed(any);}
};

//	Command DevVarDoubleArray class definition
class DevVarDoubleArrayClass : public Tango::Command
{
public:
	DevVarDoubleArrayClass(const char   *cmd_name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(cmd_name,in,out,in_desc,out_desc, level)	{}

	DevVarDoubleArrayClass(const char   *cmd_name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(cmd_name,in,out)	{}
	~DevVarDoubleArrayClass() {}

	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<TangoTest *>(dev))->is_DevVarDoubleArray_allowed(any);}
};

//	Command DevVarDoubleStringArray class definition
class DevVarDoubleStringArrayClass : public Tango::Command
{
public:
	DevVarDoubleStringArrayClass(const char   *cmd_name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(cmd_name,in,out,in_desc,out_desc, level)	{}

	DevVarDoubleStringArrayClass(const char   *cmd_name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(cmd_name,in,out)	{}
	~DevVarDoubleStringArrayClass() {}

	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<TangoTest *>(dev))->is_DevVarDoubleStringArray_allowed(any);}
};

//	Command DevVarFloatArray class definition
class DevVarFloatArrayClass : public Tango::Command
{
public:
	DevVarFloatArrayClass(const char   *cmd_name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(cmd_name,in,out,in_desc,out_desc, level)	{}

	DevVarFloatArrayClass(const char   *cmd_name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(cmd_name,in,out)	{}
	~DevVarFloatArrayClass() {}

	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<TangoTest *>(dev))->is_DevVarFloatArray_allowed(any);}
};

//	Command DevVarLong64Array class definition
class DevVarLong64ArrayClass : public Tango::Command
{
public:
	DevVarLong64ArrayClass(const char   *cmd_name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(cmd_name,in,out,in_desc,out_desc, level)	{}

	DevVarLong64ArrayClass(const char   *cmd_name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(cmd_name,in,out)	{}
	~DevVarLong64ArrayClass() {}

	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<TangoTest *>(dev))->is_DevVarLong64Array_allowed(any);}
};

//	Command DevVarLongArray class definition
class DevVarLongArrayClass : public Tango::Command
{
public:
	DevVarLongArrayClass(const char   *cmd_name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(cmd_name,in,out,in_desc,out_desc, level)	{}

	DevVarLongArrayClass(const char   *cmd_name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(cmd_name,in,out)	{}
	~DevVarLongArrayClass() {}

	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<TangoTest *>(dev))->is_DevVarLongArray_allowed(any);}
};

//	Command DevVarLongStringArray class definition
class DevVarLongStringArrayClass : public Tango::Command
{
public:
	DevVarLongStringArrayClass(const char   *cmd_name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(cmd_name,in,out,in_desc,out_desc, level)	{}

	DevVarLongStringArrayClass(const char   *cmd_name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(cmd_name,in,out)	{}
	~DevVarLongStringArrayClass() {}

	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<TangoTest *>(dev))->is_DevVarLongStringArray_allowed(any);}
};

//	Command DevVarShortArray class definition
class DevVarShortArrayClass : public Tango::Command
{
public:
	DevVarShortArrayClass(const char   *cmd_name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(cmd_name,in,out,in_desc,out_desc, level)	{}

	DevVarShortArrayClass(const char   *cmd_name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(cmd_name,in,out)	{}
	~DevVarShortArrayClass() {}

	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<TangoTest *>(dev))->is_DevVarShortArray_allowed(any);}
};

//	Command DevVarStringArray class definition
class DevVarStringArrayClass : public Tango::Command
{
public:
	DevVarStringArrayClass(const char   *cmd_name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(cmd_name,in,out,in_desc,out_desc, level)	{}

	DevVarStringArrayClass(const char   *cmd_name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(cmd_name,in,out)	{}
	~DevVarStringArrayClass() {}

	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<TangoTest *>(dev))->is_DevVarStringArray_allowed(any);}
};

//	Command DevVarULong64Array class definition
class DevVarULong64ArrayClass : public Tango::Command
{
public:
	DevVarULong64ArrayClass(const char   *cmd_name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(cmd_name,in,out,in_desc,out_desc, level)	{}

	DevVarULong64ArrayClass(const char   *cmd_name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(cmd_name,in,out)	{}
	~DevVarULong64ArrayClass() {}

	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<TangoTest *>(dev))->is_DevVarULong64Array_allowed(any);}
};

//	Command DevVarULongArray class definition
class DevVarULongArrayClass : public Tango::Command
{
public:
	DevVarULongArrayClass(const char   *cmd_name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(cmd_name,in,out,in_desc,out_desc, level)	{}

	DevVarULongArrayClass(const char   *cmd_name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(cmd_name,in,out)	{}
	~DevVarULongArrayClass() {}

	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<TangoTest *>(dev))->is_DevVarULongArray_allowed(any);}
};

//	Command DevVarUShortArray class definition
class DevVarUShortArrayClass : public Tango::Command
{
public:
	DevVarUShortArrayClass(const char   *cmd_name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(cmd_name,in,out,in_desc,out_desc, level)	{}

	DevVarUShortArrayClass(const char   *cmd_name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(cmd_name,in,out)	{}
	~DevVarUShortArrayClass() {}

	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<TangoTest *>(dev))->is_DevVarUShortArray_allowed(any);}
};

//	Command DevVoid class definition
class DevVoidClass : public Tango::Command
{
public:
	DevVoidClass(const char   *cmd_name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(cmd_name,in,out,in_desc,out_desc, level)	{}

	DevVoidClass(const char   *cmd_name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(cmd_name,in,out)	{}
	~DevVoidClass() {}

	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<TangoTest *>(dev))->is_DevVoid_allowed(any);}
};

//	Command DumpExecutionState class definition
class DumpExecutionStateClass : public Tango::Command
{
public:
	DumpExecutionStateClass(const char   *cmd_name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(cmd_name,in,out,in_desc,out_desc, level)	{}

	DumpExecutionStateClass(const char   *cmd_name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(cmd_name,in,out)	{}
	~DumpExecutionStateClass() {}

	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<TangoTest *>(dev))->is_DumpExecutionState_allowed(any);}
};

//	Command SwitchStates class definition
class SwitchStatesClass : public Tango::Command
{
public:
	SwitchStatesClass(const char   *cmd_name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(cmd_name,in,out,in_desc,out_desc, level)	{}

	SwitchStatesClass(const char   *cmd_name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(cmd_name,in,out)	{}
	~SwitchStatesClass() {}

	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<TangoTest *>(dev))->is_SwitchStates_allowed(any);}
};


/**
 *	The TangoTestClass singleton definition
 */

#ifdef _TG_WINDOWS_
class __declspec(dllexport)  TangoTestClass : public Tango::DeviceClass
#else
class TangoTestClass : public Tango::DeviceClass
#endif
{
	/*----- PROTECTED REGION ID(TangoTestClass::Additional DServer data members) ENABLED START -----*/
	/* clang-format on */
	//	Add your own code
	/* clang-format off */
	/*----- PROTECTED REGION END -----*/	//	TangoTestClass::Additional DServer data members

	public:
		//	write class properties data members
		Tango::DbData	cl_prop;
		Tango::DbData	cl_def_prop;
		Tango::DbData	dev_def_prop;
		//	Method prototypes
		static TangoTestClass *init(const char *);
		static TangoTestClass *instance();
		~TangoTestClass();
		Tango::DbDatum	get_class_property(std::string &);
		Tango::DbDatum	get_default_device_property(std::string &);
		Tango::DbDatum	get_default_class_property(std::string &);

	protected:
		TangoTestClass(std::string &);
		static TangoTestClass *_instance;
		void command_factory();
		void attribute_factory(std::vector<Tango::Attr *> &);
		void pipe_factory();
		void write_class_property();
		void set_default_property();
		void get_class_property();
		std::string get_cvstag();
		std::string get_cvsroot();

	private:
		void device_factory(TANGO_UNUSED(const Tango::DevVarStringArray *));
		void create_static_attribute_list(std::vector<Tango::Attr *> &);
		void erase_dynamic_attributes(const Tango::DevVarStringArray *,std::vector<Tango::Attr *> &);
		std::vector<std::string>	defaultAttList;
		Tango::Attr *get_attr_object_by_name(std::vector<Tango::Attr *> &att_list, std::string attname);
};

}	//	End of namespace

#endif   //	TangoTest_H
