---
myst:
  html_meta:
    keywords: LaTeX, composition, texte, symboles, polices, Unicode, caractère, substitution, 
              remplacement
---

# Comment spécifier une fonte de substitution pour les caractères qui manquent à ma fonte principale ?

::: {todo}
Créer une page sur la configuration des fontes en fonction des langues.
:::

Parfois, il manque quelques caractères à une fonte, qu'il est possible de composer 
dans une autre fonte sans que cela ne dépare le texte : par exemple, 
si les deux fontes se ressemblent beaucoup ou s'il s'agit d'émoticones ou de symboles.
Cette page traite des moyens de spécifier cette fonte de remplacement
une fois pour toute dans le préambule.

Notez que deux cas proches ne sont pas ici évoqués car retenant d'autres solutions :

- l'utilisation d'une fonte secondaire pour une langue autre que la langue principale
  (par exemple pour du texte en caractères cyrilliques).
  Si tel est votre besoin, utilisez la commande `\babelfont` avec <ctanpkg:babel>
  ou voyez la section *Font setup* dans le [manuel](texdoc:polyglossia)
  de <ctanpkg:polyglossia>.
- lorsque le caractère manquant est un caractère avec <wpfr:diacritique>,
  vous pouvez tenter de le configurer sans changer de fonte
  comme le montre la question "[](/3_composition/texte/symboles/polices/ajuster_diacritiques)".


## Avec `newunicodechar`

L'extension <ctanpkg:newunicodechar> permet de déclarer n'importe quel remplacement 
pour un caractère [Unicode](wpfr:Unicode) donné. Un de ses usages possibles 
est de spécifier dans le remplacement le caractère précédé de la commande de fonte 
qui doit être utilisée pour l'afficher. Dans l'exemple suivant, on utilise *FreeSerif* 
et *Garamond Libre* pour compléter la fonte par défaut de LaTeX. 

```
% !TEX engine=lualatex
\documentclass[french]{article}
  \usepackage{fontspec}       % Gestion des polices de caractère
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{newunicodechar}
  \usepackage{hyperref}

  \newfontface\chiffresdansronds{FreeSerif}
  \newunicodechar{❶}{{\chiffresdansronds ❶}}
  \newunicodechar{❷}{{\chiffresdansronds ❷}}

  \newfontface\chiffresgrecs{Garamond Libre}
  \newunicodechar{ϡ}{{\chiffresgrecs ϡ}}

\begin{document}
Il peut être nécessaire d'utiliser une fonte de substitution pour quelques
caractères, notamment : ❶~si vous utilisez des symboles ou des émojis ;
❷~si votre fonte ne supporte pas certains caractères (par exemple si vous
voulez écrire 900 en
\href{https://fr.wikipedia.org/wiki/Numération_grecque}{numération grecque} 
: ϡ).
\end{document}
```

Si vous avez toute une série de caractères à configurer de la sorte,
vous pouvez ajouter à votre préambule le code créant la commande 
`\substituerFonte` ci-dessous :

```
% !TEX engine=lualatex
\documentclass[french]{article}
  \usepackage{fontspec}       % Gestion des polices de caractère
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{newunicodechar}
  \usepackage{hyperref}

  % Code pour gérer la substitution
  \makeatletter
  \newcommand*{\substituerFonte}[2]{%
    \expandafter\newfontface
      \csname fonte@substitution@#1\endcsname
      {#1}%
    \substituer@fonte@char[#1]#2,\relax,
  }
  \def\substituer@fonte@char[#1]#2,{%
    \ifx #2\relax
      \let\todo\relax
    \else
      \newunicodechar{#2}{{%
          \csname fonte@substitution@#1\endcsname
          #2%
        }}%
      \def\todo{\substituer@fonte@char[#1]}%
    \fi
    \todo
  }
  \makeatother

  % Définition des substitutions pour le document
  \substituerFonte{Garamond Libre}{α,β,γ,φ,δ,ε,ζ,γ,θ,η}
  \substituerFonte{FreeSerif}{❶,❷,❸,❹}

\begin{document}
Et voici le résultat : α ❶,β,❷,γ,❸,φ,❹.
\end{document}
```
