
.PHONY : all clean compile link-modules link-clean

THEME_D_COMPILE ?= theme-d-compile
THEME_D_LINK ?= theme-d-link

EXTRA_COMP_OPTIONS ?=
EXTRA_LINK_OPTIONS ?=

ifdef PRETTY_PRINT
	EXTRA_COMP_OPTIONS += --pretty-print
	EXTRA_LINK_OPTIONS += --pretty-print
endif

ifdef NO_LINK_OPTIMIZATION
	EXTRA_LINK_OPTIONS += --no-factorization --no-strip
endif

ifndef INSTALL_DIR
  INSTALL_DIR := /tmp
endif

MODULES := \
  sequence list-as-sequence vector-as-sequence \
  sequence-sgn sequence-sgn-simple \
  sequence-list-impl sequence-vector-impl \
  assoc-sgn assoc-list-impl hash-table \
  module1 module2

PROGRAMS := hello-world sequence-test \
  sequence-sgn-test sequence-sgn-test2 \
  assoc-test assoc-test2 objects1 objects2 module-test1 \
  statprof-demo command-line-demo \
  orientation1 orientation2 \
  iterator-example nonpure-iterator-example \
  bits fold

INTERFACE_SRC := $(patsubst %,%.thi,$(MODULES))
BODY_SRC := $(patsubst %,%.thb,$(MODULES))
PROGRAM_SRC := $(patsubst %,%.thp,$(PROGRAMS))
INTERFACE_TARGET := $(patsubst %,%.tci,$(MODULES))
BODY_TARGET := $(patsubst %,%.tcb,$(MODULES))
COMP_PROGRAM_TARGET := $(patsubst %,%.tcp,$(PROGRAMS))
PROGRAM_TARGET := $(patsubst %,%.go,$(PROGRAMS))
MODULE_TARGET := $(patsubst %,__intf_%.go,$(MODULES))
IMPL_TARGET := $(patsubst %,__impl_%.go,$(MODULES))
PROGRAM_INTERMEDIATE := $(patsubst %,%.tree-il,$(PROGRAMS)) \
  $(patsubst %,%.scm,$(PROGRAMS)) 

PROGRAMS0 := $(filter-out statprof-demo,$(PROGRAMS))
PROGRAM_TARGET0 := $(patsubst %,%.go,$(PROGRAMS0))

MODULEPATH := -m ..:

ifdef LINK_MODULES

GUILE_MODULES := $(MODULES:%=__intf_%.go) $(MODULES:%=__impl_%.go) $(PROGRAMS:%=%.go)

FULLMODULEPATH := -M ..:

all : $(GUILE_MODULES)

$(PROGRAM_TARGET0): %.go : %.tcp
	$(THEME_D_LINK) --module $(FULLMODULEPATH) $(EXTRA_LINK_OPTIONS) -o $@ $<

$(MODULE_TARGET): __intf_%.go : %.tci
	$(THEME_D_LINK) --module $(FULLMODULEPATH) $(EXTRA_LINK_OPTIONS) -o $@ $<

$(IMPL_TARGET): __impl_%.go : %.tcb
	$(THEME_D_LINK) --module $(FULLMODULEPATH) $(EXTRA_LINK_OPTIONS) -o $@ $<

statprof-demo.go : statprof-demo.tcp
	$(THEME_D_LINK) --module $(FULLMODULEPATH) -x "(statprof)" $(EXTRA_LINK_OPTIONS) -o $@ $<

else

all : $(PROGRAM_TARGET) $(COMP_PROGRAM_TARGET) \
  $(INTERFACE_TARGET) $(BODY_TARGET)

$(PROGRAM_TARGET0): %.go : %.tcp
	$(THEME_D_LINK) $(MODULEPATH) $(EXTRA_LINK_OPTIONS) -o $@ $<

statprof-demo.go : statprof-demo.tcp
	$(THEME_D_LINK) $(MODULEPATH) $(EXTRA_LINK_OPTIONS) -x \
	"(statprof)" -o $@ $<

endif

clean :
	-rm -f $(INTERFACE_TARGET)
	-rm -f $(BODY_TARGET)
	-rm -f $(COMP_PROGRAM_TARGET)
	-rm -f $(PROGRAM_TARGET)
	-rm -f $(PROGRAM_RACKET_TARGET)
	-rm -f $(PROGRAM_INTERMEDIATE)
	-rm -f *.go
	-rm -f *.aux
	-rm -f *.scm
	-rm -f *.tree-il

link-clean :
	-rm -f *.go
	-rm -f *.aux
	-rm -f *.scm
	-rm -f *.tree-il

compile : $(COMP_PROGRAM_TARGET) $(INTERFACE_TARGET) $(BODY_TARGET)

link-modules: $(GUILE_MODULES)

%.tcp : %.thp
	$(THEME_D_COMPILE) $(MODULEPATH) $(EXTRA_COMP_OPTIONS) -o $@ $<

%.tci : %.thi
	$(THEME_D_COMPILE) $(MODULEPATH) $(EXTRA_COMP_OPTIONS) -o $@ $<

%.tcb : %.thb
	$(THEME_D_COMPILE) $(MODULEPATH) $(EXTRA_COMP_OPTIONS) -o $@ $<

# Compiled body depends on the compiled interface.
%.tcb : %.tci

include deps.mk

ifdef LINK_MODULES
include module-deps.mk
else
include program-deps.mk
endif
