from typing import Any, Iterator, List, Sequence, TextIO, Tuple, Union

from _typeshed import Incomplete

from .topicargspec import ArgsDocs, ArgSpecGiven, topicArgsFromCallable
from .topicexc import UnrecognizedSourceFormatError as UnrecognizedSourceFormatError
from .topicobj import Topic
from .topictreetraverser import TopicTreeTraverser

class ITopicDefnProvider:
    def getDefn(self, topicNameTuple: Sequence[str]) -> Tuple[str, ArgSpecGiven]: ...
    def topicNames(self) -> Sequence[str]: ...
    def getTreeDoc(self) -> str: ...
    def __iter__(self) -> Iterator[str]: ...

SPEC_METHOD_NAME: str

class ITopicDefnDeserializer:
    class TopicDefn:
        nameTuple: Incomplete
        description: Incomplete
        argsDocs: Incomplete
        required: Incomplete
        def __init__(
            self,
            nameTuple: Sequence[str],
            description: str,
            argsDocs: ArgsDocs,
            required: Sequence[str],
        ) -> None: ...
        def isComplete(self) -> bool: ...

    def getTreeDoc(self) -> str: ...
    def getNextTopic(self) -> TopicDefn: ...
    def doneIter(self) -> None: ...
    def resetIter(self) -> None: ...

class TopicDefnDeserialClass(ITopicDefnDeserializer):
    def __init__(self, pyClassObj: type = ...) -> None: ...
    def getTreeDoc(self) -> str: ...
    def getNextTopic(self) -> ITopicDefnDeserializer.TopicDefn: ...
    def resetIter(self) -> None: ...
    def getDefinedTopics(self) -> List[str]: ...

class TopicDefnDeserialModule(ITopicDefnDeserializer):
    def __init__(self, moduleName: str, searchPath: Sequence[str] = ...) -> None: ...
    def getTreeDoc(self) -> str: ...
    def getNextTopic(self) -> ITopicDefnDeserializer.TopicDefn: ...
    def doneIter(self) -> None: ...
    def resetIter(self) -> None: ...
    def getDefinedTopics(self) -> List[str]: ...

class TopicDefnDeserialString(ITopicDefnDeserializer):
    def __init__(self, source: str) -> None: ...
    def getTreeDoc(self) -> str: ...
    def getNextTopic(self) -> ITopicDefnDeserializer.TopicDefn: ...
    def doneIter(self) -> None: ...
    def resetIter(self) -> None: ...
    def getDefinedTopics(self) -> List[str]: ...

TOPIC_TREE_FROM_MODULE: str
TOPIC_TREE_FROM_STRING: str
TOPIC_TREE_FROM_CLASS: str

class TopicDefnProvider(ITopicDefnProvider):
    def __init__(self, source: Any, format: str, **providerKwargs: Any) -> None: ...
    def getDefn(self, topicNameTuple: Sequence[str]) -> Tuple[str, ArgSpecGiven]: ...
    def topicNames(self) -> Sequence[str]: ...
    def getTreeDoc(self) -> str: ...
    @classmethod
    def registerTypeForImport(cls, typeName: str, providerClassObj: type) -> None: ...
    @classmethod
    def initTypeRegistry(cls) -> None: ...

defaultTopicTreeSpecHeader: str
defaultTopicTreeSpecFooter: str

def exportTopicTreeSpec(
    moduleName: str = ...,
    rootTopic: Union[Topic, str] = ...,
    bak: str = ...,
    moduleDoc: str = ...,
) -> None: ...

class TopicTreeSpecPrinter:
    INDENT_CH: str
    def __init__(
        self,
        rootTopic: Union[str, Topic] = ...,
        fileObj: TextIO = ...,
        width: int = ...,
        indentStep: int = ...,
        treeDoc: str = ...,
        footer: str = ...,
    ): ...
    def getOutput(self) -> str: ...
    def writeAll(self, topicObj: Topic) -> None: ...
