public class Turntable.Utils.Settings : GLib.Settings {
	public bool orientation_horizontal { get; set; }
	public string cover_style { get; set; }
	public string progressscale_style { get; set; }
	public bool component_progressbin { get; set; }
	public bool component_extract_colors { get; set; }
	public string window_style { get; set; }
	public bool component_cover_fit { get; set; }
	public bool component_tonearm { get; set; }
	public bool component_center_text { get; set; }
	public bool component_more_controls { get; set; }
	public bool meta_dim { get; set; }
	public bool mbid_required { get; set; }
	public bool now_playing { get; set; }
	public bool offline_scrobbling { get; set; }
	public bool collapsed_controls { get; set; }
	public bool hide_client_icon_collapsed { get; set; }
	public string cover_size { get; set; }
	public string text_size { get; set; }
	public string cover_scaling { get; set; }
	public string client_icon_style { get; set; }
	public string[] scrobbler_allowlist { get; set; default = {}; }
	public bool autostart { get; set; }
	public bool run_in_background { get; set; }
	public bool start_hidden { get; set; }

	private const string[] KEYS_TO_INIT = {
		"orientation-horizontal",
		"cover-style",
		"progressscale-style",
		"component-progressbin",
		"component-extract-colors",
		"window-style",
		"component-cover-fit",
		"scrobbler-allowlist",
		"meta-dim",
		"cover-size",
		"text-size",
		"cover-scaling",
		"mbid-required",
		"component-tonearm",
		"component-center-text",
		"now-playing",
		"hide-client-icon-collapsed",
		"component-more-controls",
		"offline-scrobbling",
		"collapsed-controls",
		"client-icon-style",
		"autostart",
		"run-in-background",
		"start-hidden"
	};

	public Settings () {
		Object (schema_id: Build.DOMAIN);

		foreach (var key in KEYS_TO_INIT) {
			init (key);
		}
	}

	public void remove_from_allowlist (string client_name) {
		debug ("Removing %s from the allowlist", client_name);
		if (client_name in this.scrobbler_allowlist) {
			string[] new_allowlist = {};

			foreach (var allowed_client in this.scrobbler_allowlist) {
				if (allowed_client != client_name) new_allowlist += allowed_client;
			}

			this.scrobbler_allowlist = new_allowlist;
		}
	}

	public void add_to_allowlist (string client_name) {
		debug ("Adding %s to the allowlist", client_name);

		if (client_name in this.scrobbler_allowlist) return;
		string[] new_allowlist = this.scrobbler_allowlist;
		new_allowlist += client_name;
		this.scrobbler_allowlist = new_allowlist;
	}

	inline void init (string key) {
		bind (key, this, key, SettingsBindFlags.DEFAULT);
	}
}
