//
// Copyright 2025 Ettus Research, A National Instruments Company
//
// SPDX-License-Identifier: LGPL-3.0-or-later
//
// Module: rfdc_regs_regmap_utils.vh
// Description:
// The constants in this file are autogenerated by XmlParse.

//===============================================================================
// A numerically ordered list of registers and their HDL source files
//===============================================================================

  // MMCM                 : 0x0 (x410_rfdc_regs.v)
  // INVERT_DB0_IQ_REG    : 0x10000 (x410_rfdc_regs.v)
  // INVERT_DB1_IQ_REG    : 0x10800 (x410_rfdc_regs.v)
  // MMCM_RESET_REG       : 0x11000 (x410_rfdc_regs.v)
  // RF_RESET_CONTROL_REG : 0x12000 (x410_rfdc_regs.v)
  // RF_RESET_STATUS_REG  : 0x12008 (x410_rfdc_regs.v)
  // RF_AXI_STATUS_REG    : 0x13000 (x410_rfdc_regs.v)
  // FABRIC_DSP_REG       : 0x13008 (x410_rfdc_regs.v)
  // CALIBRATION_DATA     : 0x14000 (x410_rfdc_regs.v)
  // CALIBRATION_ENABLE   : 0x14008 (x410_rfdc_regs.v)
  // THRESHOLD_STATUS     : 0x15000 (x410_rfdc_regs.v)
  // RF_PLL_CONTROL_REG   : 0x16000 (x410_rfdc_regs.v)
  // RF_PLL_STATUS_REG    : 0x16008 (x410_rfdc_regs.v)
  // RFDC_INFO_MEM        : 0x17000 (x410_rfdc_regs.v)
  // RFDC_INFO_REG        : 0x18000 (x410_rfdc_regs.v)

//===============================================================================
// RegTypes
//===============================================================================

  // FABRIC_DSP_REGTYPE Type (from common_regs.v)
  localparam FABRIC_DSP_REGTYPE_SIZE = 32;
  localparam FABRIC_DSP_REGTYPE_MASK = 32'hFFFFFFFF;
  localparam FABRIC_DSP_RX_CNT_SIZE = 4;  //FABRIC_DSP_REGTYPE:FABRIC_DSP_RX_CNT
  localparam FABRIC_DSP_RX_CNT_MSB  = 3;  //FABRIC_DSP_REGTYPE:FABRIC_DSP_RX_CNT
  localparam FABRIC_DSP_RX_CNT      = 0;  //FABRIC_DSP_REGTYPE:FABRIC_DSP_RX_CNT
  localparam FABRIC_DSP_TX_CNT_SIZE = 4;  //FABRIC_DSP_REGTYPE:FABRIC_DSP_TX_CNT
  localparam FABRIC_DSP_TX_CNT_MSB  = 7;  //FABRIC_DSP_REGTYPE:FABRIC_DSP_TX_CNT
  localparam FABRIC_DSP_TX_CNT      = 4;  //FABRIC_DSP_REGTYPE:FABRIC_DSP_TX_CNT
  localparam FABRIC_DSP_RESERVED_SIZE = 2;  //FABRIC_DSP_REGTYPE:FABRIC_DSP_RESERVED
  localparam FABRIC_DSP_RESERVED_MSB  = 9;  //FABRIC_DSP_REGTYPE:FABRIC_DSP_RESERVED
  localparam FABRIC_DSP_RESERVED      = 8;  //FABRIC_DSP_REGTYPE:FABRIC_DSP_RESERVED
  localparam FABRIC_DSP_RX_CNT_DB1_SIZE =  4;  //FABRIC_DSP_REGTYPE:FABRIC_DSP_RX_CNT_DB1
  localparam FABRIC_DSP_RX_CNT_DB1_MSB  = 13;  //FABRIC_DSP_REGTYPE:FABRIC_DSP_RX_CNT_DB1
  localparam FABRIC_DSP_RX_CNT_DB1      = 10;  //FABRIC_DSP_REGTYPE:FABRIC_DSP_RX_CNT_DB1
  localparam FABRIC_DSP_TX_CNT_DB1_SIZE =  4;  //FABRIC_DSP_REGTYPE:FABRIC_DSP_TX_CNT_DB1
  localparam FABRIC_DSP_TX_CNT_DB1_MSB  = 17;  //FABRIC_DSP_REGTYPE:FABRIC_DSP_TX_CNT_DB1
  localparam FABRIC_DSP_TX_CNT_DB1      = 14;  //FABRIC_DSP_REGTYPE:FABRIC_DSP_TX_CNT_DB1
  localparam FABRIC_DSP_RESERVED_DB1_SIZE =  2;  //FABRIC_DSP_REGTYPE:FABRIC_DSP_RESERVED_DB1
  localparam FABRIC_DSP_RESERVED_DB1_MSB  = 19;  //FABRIC_DSP_REGTYPE:FABRIC_DSP_RESERVED_DB1
  localparam FABRIC_DSP_RESERVED_DB1      = 18;  //FABRIC_DSP_REGTYPE:FABRIC_DSP_RESERVED_DB1
  localparam FABRIC_DSP_BW_SIZE = 12;  //FABRIC_DSP_REGTYPE:FABRIC_DSP_BW
  localparam FABRIC_DSP_BW_MSB  = 31;  //FABRIC_DSP_REGTYPE:FABRIC_DSP_BW
  localparam FABRIC_DSP_BW      = 20;  //FABRIC_DSP_REGTYPE:FABRIC_DSP_BW

  // RF_AXI_STATUS_REGTYPE Type (from common_regs.v)
  localparam RF_AXI_STATUS_REGTYPE_SIZE = 32;
  localparam RF_AXI_STATUS_REGTYPE_MASK = 32'hFFFFFFFF;
  localparam RFDC_DAC_TREADY_SIZE = 2;  //RF_AXI_STATUS_REGTYPE:RFDC_DAC_TREADY
  localparam RFDC_DAC_TREADY_MSB  = 1;  //RF_AXI_STATUS_REGTYPE:RFDC_DAC_TREADY
  localparam RFDC_DAC_TREADY      = 0;  //RF_AXI_STATUS_REGTYPE:RFDC_DAC_TREADY
  localparam RFDC_DAC_TVALID_SIZE = 2;  //RF_AXI_STATUS_REGTYPE:RFDC_DAC_TVALID
  localparam RFDC_DAC_TVALID_MSB  = 3;  //RF_AXI_STATUS_REGTYPE:RFDC_DAC_TVALID
  localparam RFDC_DAC_TVALID      = 2;  //RF_AXI_STATUS_REGTYPE:RFDC_DAC_TVALID
  localparam RFDC_ADC_Q_TREADY_SIZE = 2;  //RF_AXI_STATUS_REGTYPE:RFDC_ADC_Q_TREADY
  localparam RFDC_ADC_Q_TREADY_MSB  = 5;  //RF_AXI_STATUS_REGTYPE:RFDC_ADC_Q_TREADY
  localparam RFDC_ADC_Q_TREADY      = 4;  //RF_AXI_STATUS_REGTYPE:RFDC_ADC_Q_TREADY
  localparam RFDC_ADC_I_TREADY_SIZE = 2;  //RF_AXI_STATUS_REGTYPE:RFDC_ADC_I_TREADY
  localparam RFDC_ADC_I_TREADY_MSB  = 7;  //RF_AXI_STATUS_REGTYPE:RFDC_ADC_I_TREADY
  localparam RFDC_ADC_I_TREADY      = 6;  //RF_AXI_STATUS_REGTYPE:RFDC_ADC_I_TREADY
  localparam RFDC_ADC_Q_TVALID_SIZE = 2;  //RF_AXI_STATUS_REGTYPE:RFDC_ADC_Q_TVALID
  localparam RFDC_ADC_Q_TVALID_MSB  = 9;  //RF_AXI_STATUS_REGTYPE:RFDC_ADC_Q_TVALID
  localparam RFDC_ADC_Q_TVALID      = 8;  //RF_AXI_STATUS_REGTYPE:RFDC_ADC_Q_TVALID
  localparam RFDC_ADC_I_TVALID_SIZE =  2;  //RF_AXI_STATUS_REGTYPE:RFDC_ADC_I_TVALID
  localparam RFDC_ADC_I_TVALID_MSB  = 11;  //RF_AXI_STATUS_REGTYPE:RFDC_ADC_I_TVALID
  localparam RFDC_ADC_I_TVALID      = 10;  //RF_AXI_STATUS_REGTYPE:RFDC_ADC_I_TVALID
  localparam USER_ADC_TVALID_SIZE =  2;  //RF_AXI_STATUS_REGTYPE:USER_ADC_TVALID
  localparam USER_ADC_TVALID_MSB  = 13;  //RF_AXI_STATUS_REGTYPE:USER_ADC_TVALID
  localparam USER_ADC_TVALID      = 12;  //RF_AXI_STATUS_REGTYPE:USER_ADC_TVALID
  localparam USER_ADC_TREADY_SIZE =  2;  //RF_AXI_STATUS_REGTYPE:USER_ADC_TREADY
  localparam USER_ADC_TREADY_MSB  = 15;  //RF_AXI_STATUS_REGTYPE:USER_ADC_TREADY
  localparam USER_ADC_TREADY      = 14;  //RF_AXI_STATUS_REGTYPE:USER_ADC_TREADY
  localparam RFDC_DAC_TREADY_DB1_SIZE =  2;  //RF_AXI_STATUS_REGTYPE:RFDC_DAC_TREADY_DB1
  localparam RFDC_DAC_TREADY_DB1_MSB  = 17;  //RF_AXI_STATUS_REGTYPE:RFDC_DAC_TREADY_DB1
  localparam RFDC_DAC_TREADY_DB1      = 16;  //RF_AXI_STATUS_REGTYPE:RFDC_DAC_TREADY_DB1
  localparam RFDC_DAC_TVALID_DB1_SIZE =  2;  //RF_AXI_STATUS_REGTYPE:RFDC_DAC_TVALID_DB1
  localparam RFDC_DAC_TVALID_DB1_MSB  = 19;  //RF_AXI_STATUS_REGTYPE:RFDC_DAC_TVALID_DB1
  localparam RFDC_DAC_TVALID_DB1      = 18;  //RF_AXI_STATUS_REGTYPE:RFDC_DAC_TVALID_DB1
  localparam RFDC_ADC_Q_TREADY_DB1_SIZE =  2;  //RF_AXI_STATUS_REGTYPE:RFDC_ADC_Q_TREADY_DB1
  localparam RFDC_ADC_Q_TREADY_DB1_MSB  = 21;  //RF_AXI_STATUS_REGTYPE:RFDC_ADC_Q_TREADY_DB1
  localparam RFDC_ADC_Q_TREADY_DB1      = 20;  //RF_AXI_STATUS_REGTYPE:RFDC_ADC_Q_TREADY_DB1
  localparam RFDC_ADC_I_TREADY_DB1_SIZE =  2;  //RF_AXI_STATUS_REGTYPE:RFDC_ADC_I_TREADY_DB1
  localparam RFDC_ADC_I_TREADY_DB1_MSB  = 23;  //RF_AXI_STATUS_REGTYPE:RFDC_ADC_I_TREADY_DB1
  localparam RFDC_ADC_I_TREADY_DB1      = 22;  //RF_AXI_STATUS_REGTYPE:RFDC_ADC_I_TREADY_DB1
  localparam RFDC_ADC_Q_TVALID_DB1_SIZE =  2;  //RF_AXI_STATUS_REGTYPE:RFDC_ADC_Q_TVALID_DB1
  localparam RFDC_ADC_Q_TVALID_DB1_MSB  = 25;  //RF_AXI_STATUS_REGTYPE:RFDC_ADC_Q_TVALID_DB1
  localparam RFDC_ADC_Q_TVALID_DB1      = 24;  //RF_AXI_STATUS_REGTYPE:RFDC_ADC_Q_TVALID_DB1
  localparam RFDC_ADC_I_TVALID_DB1_SIZE =  2;  //RF_AXI_STATUS_REGTYPE:RFDC_ADC_I_TVALID_DB1
  localparam RFDC_ADC_I_TVALID_DB1_MSB  = 27;  //RF_AXI_STATUS_REGTYPE:RFDC_ADC_I_TVALID_DB1
  localparam RFDC_ADC_I_TVALID_DB1      = 26;  //RF_AXI_STATUS_REGTYPE:RFDC_ADC_I_TVALID_DB1
  localparam USER_ADC_TVALID_DB1_SIZE =  2;  //RF_AXI_STATUS_REGTYPE:USER_ADC_TVALID_DB1
  localparam USER_ADC_TVALID_DB1_MSB  = 29;  //RF_AXI_STATUS_REGTYPE:USER_ADC_TVALID_DB1
  localparam USER_ADC_TVALID_DB1      = 28;  //RF_AXI_STATUS_REGTYPE:USER_ADC_TVALID_DB1
  localparam USER_ADC_TREADY_DB1_SIZE =  2;  //RF_AXI_STATUS_REGTYPE:USER_ADC_TREADY_DB1
  localparam USER_ADC_TREADY_DB1_MSB  = 31;  //RF_AXI_STATUS_REGTYPE:USER_ADC_TREADY_DB1
  localparam USER_ADC_TREADY_DB1      = 30;  //RF_AXI_STATUS_REGTYPE:USER_ADC_TREADY_DB1

  // RF_RESET_CONTROL_REGTYPE Type (from common_regs.v)
  localparam RF_RESET_CONTROL_REGTYPE_SIZE = 32;
  localparam RF_RESET_CONTROL_REGTYPE_MASK = 32'h771;
  localparam FSM_RESET_SIZE = 1;  //RF_RESET_CONTROL_REGTYPE:FSM_RESET
  localparam FSM_RESET_MSB  = 0;  //RF_RESET_CONTROL_REGTYPE:FSM_RESET
  localparam FSM_RESET      = 0;  //RF_RESET_CONTROL_REGTYPE:FSM_RESET
  localparam ADC_RESET_SIZE = 1;  //RF_RESET_CONTROL_REGTYPE:ADC_RESET
  localparam ADC_RESET_MSB  = 4;  //RF_RESET_CONTROL_REGTYPE:ADC_RESET
  localparam ADC_RESET      = 4;  //RF_RESET_CONTROL_REGTYPE:ADC_RESET
  localparam ADC_ENABLE_SIZE = 1;  //RF_RESET_CONTROL_REGTYPE:ADC_ENABLE
  localparam ADC_ENABLE_MSB  = 5;  //RF_RESET_CONTROL_REGTYPE:ADC_ENABLE
  localparam ADC_ENABLE      = 5;  //RF_RESET_CONTROL_REGTYPE:ADC_ENABLE
  localparam ADC_GEARBOX_RESET_SIZE = 1;  //RF_RESET_CONTROL_REGTYPE:ADC_GEARBOX_RESET
  localparam ADC_GEARBOX_RESET_MSB  = 6;  //RF_RESET_CONTROL_REGTYPE:ADC_GEARBOX_RESET
  localparam ADC_GEARBOX_RESET      = 6;  //RF_RESET_CONTROL_REGTYPE:ADC_GEARBOX_RESET
  localparam DAC_RESET_SIZE = 1;  //RF_RESET_CONTROL_REGTYPE:DAC_RESET
  localparam DAC_RESET_MSB  = 8;  //RF_RESET_CONTROL_REGTYPE:DAC_RESET
  localparam DAC_RESET      = 8;  //RF_RESET_CONTROL_REGTYPE:DAC_RESET
  localparam DAC_ENABLE_SIZE = 1;  //RF_RESET_CONTROL_REGTYPE:DAC_ENABLE
  localparam DAC_ENABLE_MSB  = 9;  //RF_RESET_CONTROL_REGTYPE:DAC_ENABLE
  localparam DAC_ENABLE      = 9;  //RF_RESET_CONTROL_REGTYPE:DAC_ENABLE
  localparam DAC_GEARBOX_RESET_SIZE =  1;  //RF_RESET_CONTROL_REGTYPE:DAC_GEARBOX_RESET
  localparam DAC_GEARBOX_RESET_MSB  = 10;  //RF_RESET_CONTROL_REGTYPE:DAC_GEARBOX_RESET
  localparam DAC_GEARBOX_RESET      = 10;  //RF_RESET_CONTROL_REGTYPE:DAC_GEARBOX_RESET

  // RF_RESET_STATUS_REGTYPE Type (from common_regs.v)
  localparam RF_RESET_STATUS_REGTYPE_SIZE = 32;
  localparam RF_RESET_STATUS_REGTYPE_MASK = 32'h888;
  localparam FSM_RESET_DONE_SIZE = 1;  //RF_RESET_STATUS_REGTYPE:FSM_RESET_DONE
  localparam FSM_RESET_DONE_MSB  = 3;  //RF_RESET_STATUS_REGTYPE:FSM_RESET_DONE
  localparam FSM_RESET_DONE      = 3;  //RF_RESET_STATUS_REGTYPE:FSM_RESET_DONE
  localparam ADC_SEQ_DONE_SIZE = 1;  //RF_RESET_STATUS_REGTYPE:ADC_SEQ_DONE
  localparam ADC_SEQ_DONE_MSB  = 7;  //RF_RESET_STATUS_REGTYPE:ADC_SEQ_DONE
  localparam ADC_SEQ_DONE      = 7;  //RF_RESET_STATUS_REGTYPE:ADC_SEQ_DONE
  localparam DAC_SEQ_DONE_SIZE =  1;  //RF_RESET_STATUS_REGTYPE:DAC_SEQ_DONE
  localparam DAC_SEQ_DONE_MSB  = 11;  //RF_RESET_STATUS_REGTYPE:DAC_SEQ_DONE
  localparam DAC_SEQ_DONE      = 11;  //RF_RESET_STATUS_REGTYPE:DAC_SEQ_DONE

  // RFDC_INFO_MEMTYPE Type (from rfdc_info_pkg.sv)
  localparam RFDC_INFO_MEMTYPE_SIZE = 32;
  localparam RFDC_INFO_MEMTYPE_MASK = 32'hFFF;
  localparam BLOCK_MODE_SIZE = 2;  //RFDC_INFO_MEMTYPE:BLOCK_MODE
  localparam BLOCK_MODE_MSB  = 1;  //RFDC_INFO_MEMTYPE:BLOCK_MODE
  localparam BLOCK_MODE      = 0;  //RFDC_INFO_MEMTYPE:BLOCK_MODE
  localparam BLOCK_SIZE = 2;  //RFDC_INFO_MEMTYPE:BLOCK
  localparam BLOCK_MSB  = 3;  //RFDC_INFO_MEMTYPE:BLOCK
  localparam BLOCK      = 2;  //RFDC_INFO_MEMTYPE:BLOCK
  localparam TILE_SIZE = 2;  //RFDC_INFO_MEMTYPE:TILE
  localparam TILE_MSB  = 5;  //RFDC_INFO_MEMTYPE:TILE
  localparam TILE      = 4;  //RFDC_INFO_MEMTYPE:TILE
  localparam RESERVED2_SIZE = 2;  //RFDC_INFO_MEMTYPE:RESERVED2
  localparam RESERVED2_MSB  = 7;  //RFDC_INFO_MEMTYPE:RESERVED2
  localparam RESERVED2      = 6;  //RFDC_INFO_MEMTYPE:RESERVED2
  localparam CHANNEL_SIZE = 2;  //RFDC_INFO_MEMTYPE:CHANNEL
  localparam CHANNEL_MSB  = 9;  //RFDC_INFO_MEMTYPE:CHANNEL
  localparam CHANNEL      = 8;  //RFDC_INFO_MEMTYPE:CHANNEL
  localparam DB_SIZE =  1;  //RFDC_INFO_MEMTYPE:DB
  localparam DB_MSB  = 10;  //RFDC_INFO_MEMTYPE:DB
  localparam DB      = 10;  //RFDC_INFO_MEMTYPE:DB
  localparam IS_ADC_SIZE =  1;  //RFDC_INFO_MEMTYPE:IS_ADC
  localparam IS_ADC_MSB  = 11;  //RFDC_INFO_MEMTYPE:IS_ADC
  localparam IS_ADC      = 11;  //RFDC_INFO_MEMTYPE:IS_ADC

  // RFDC_INFO_REGTYPE Type (from common_regs.v)
  localparam RFDC_INFO_REGTYPE_SIZE = 32;
  localparam RFDC_INFO_REGTYPE_MASK = 32'h3FF03FF;
  localparam RFDC_INFO_XTRA_RESAMP_SIZE = 4;  //RFDC_INFO_REGTYPE:RFDC_INFO_XTRA_RESAMP
  localparam RFDC_INFO_XTRA_RESAMP_MSB  = 3;  //RFDC_INFO_REGTYPE:RFDC_INFO_XTRA_RESAMP
  localparam RFDC_INFO_XTRA_RESAMP      = 0;  //RFDC_INFO_REGTYPE:RFDC_INFO_XTRA_RESAMP
  localparam RFDC_INFO_SPC_RX_SIZE = 3;  //RFDC_INFO_REGTYPE:RFDC_INFO_SPC_RX
  localparam RFDC_INFO_SPC_RX_MSB  = 6;  //RFDC_INFO_REGTYPE:RFDC_INFO_SPC_RX
  localparam RFDC_INFO_SPC_RX      = 4;  //RFDC_INFO_REGTYPE:RFDC_INFO_SPC_RX
  localparam RFDC_INFO_SPC_TX_SIZE = 3;  //RFDC_INFO_REGTYPE:RFDC_INFO_SPC_TX
  localparam RFDC_INFO_SPC_TX_MSB  = 9;  //RFDC_INFO_REGTYPE:RFDC_INFO_SPC_TX
  localparam RFDC_INFO_SPC_TX      = 7;  //RFDC_INFO_REGTYPE:RFDC_INFO_SPC_TX
  localparam RFDC_INFO_XTRA_RESAMP_DB1_SIZE =  4;  //RFDC_INFO_REGTYPE:RFDC_INFO_XTRA_RESAMP_DB1
  localparam RFDC_INFO_XTRA_RESAMP_DB1_MSB  = 19;  //RFDC_INFO_REGTYPE:RFDC_INFO_XTRA_RESAMP_DB1
  localparam RFDC_INFO_XTRA_RESAMP_DB1      = 16;  //RFDC_INFO_REGTYPE:RFDC_INFO_XTRA_RESAMP_DB1
  localparam RFDC_INFO_SPC_RX_DB1_SIZE =  3;  //RFDC_INFO_REGTYPE:RFDC_INFO_SPC_RX_DB1
  localparam RFDC_INFO_SPC_RX_DB1_MSB  = 22;  //RFDC_INFO_REGTYPE:RFDC_INFO_SPC_RX_DB1
  localparam RFDC_INFO_SPC_RX_DB1      = 20;  //RFDC_INFO_REGTYPE:RFDC_INFO_SPC_RX_DB1
  localparam RFDC_INFO_SPC_TX_DB1_SIZE =  3;  //RFDC_INFO_REGTYPE:RFDC_INFO_SPC_TX_DB1
  localparam RFDC_INFO_SPC_TX_DB1_MSB  = 25;  //RFDC_INFO_REGTYPE:RFDC_INFO_SPC_TX_DB1
  localparam RFDC_INFO_SPC_TX_DB1      = 23;  //RFDC_INFO_REGTYPE:RFDC_INFO_SPC_TX_DB1

//===============================================================================
// Register Group RFDC_REGS
//===============================================================================

  // Enumerated type FABRIC_DSP_BW_ENUM
  localparam FABRIC_DSP_BW_ENUM_SIZE = 5;
  localparam FABRIC_DSP_BW_NONE  = 'h0;  // FABRIC_DSP_BW_ENUM:FABRIC_DSP_BW_NONE
  localparam FABRIC_DSP_BW_100M  = 'h64;  // FABRIC_DSP_BW_ENUM:FABRIC_DSP_BW_100M
  localparam FABRIC_DSP_BW_200M  = 'hC8;  // FABRIC_DSP_BW_ENUM:FABRIC_DSP_BW_200M
  localparam FABRIC_DSP_BW_400M  = 'h190;  // FABRIC_DSP_BW_ENUM:FABRIC_DSP_BW_400M
  localparam FABRIC_DSP_BW_FULL  = 'h3E8;  // FABRIC_DSP_BW_ENUM:FABRIC_DSP_BW_FULL

  // Enumerated type RFDC_BLOCK_INFO_ENUM
  localparam RFDC_BLOCK_INFO_ENUM_SIZE = 2;
  localparam ENABLED   = 'h0;  // RFDC_BLOCK_INFO_ENUM:ENABLED
  localparam DISABLED  = 'h3;  // RFDC_BLOCK_INFO_ENUM:DISABLED

  // MMCM Window (from x410_rfdc_regs.v)
  localparam MMCM = 'h0; // Window Offset
  localparam MMCM_SIZE = 'h10000;  // size in bytes

  // INVERT_DB0_IQ_REG Register (from x410_rfdc_regs.v)
  localparam INVERT_DB0_IQ_REG = 'h10000; // Register Offset
  localparam INVERT_DB0_IQ_REG_SIZE = 32;  // register width in bits
  localparam INVERT_DB0_IQ_REG_MASK = 32'hF0F;
  localparam INVERT_DB0_ADC0_IQ_SIZE = 1;  //INVERT_DB0_IQ_REG:INVERT_DB0_ADC0_IQ
  localparam INVERT_DB0_ADC0_IQ_MSB  = 0;  //INVERT_DB0_IQ_REG:INVERT_DB0_ADC0_IQ
  localparam INVERT_DB0_ADC0_IQ      = 0;  //INVERT_DB0_IQ_REG:INVERT_DB0_ADC0_IQ
  localparam INVERT_DB0_ADC1_IQ_SIZE = 1;  //INVERT_DB0_IQ_REG:INVERT_DB0_ADC1_IQ
  localparam INVERT_DB0_ADC1_IQ_MSB  = 1;  //INVERT_DB0_IQ_REG:INVERT_DB0_ADC1_IQ
  localparam INVERT_DB0_ADC1_IQ      = 1;  //INVERT_DB0_IQ_REG:INVERT_DB0_ADC1_IQ
  localparam INVERT_DB0_ADC2_IQ_SIZE = 1;  //INVERT_DB0_IQ_REG:INVERT_DB0_ADC2_IQ
  localparam INVERT_DB0_ADC2_IQ_MSB  = 2;  //INVERT_DB0_IQ_REG:INVERT_DB0_ADC2_IQ
  localparam INVERT_DB0_ADC2_IQ      = 2;  //INVERT_DB0_IQ_REG:INVERT_DB0_ADC2_IQ
  localparam INVERT_DB0_ADC3_IQ_SIZE = 1;  //INVERT_DB0_IQ_REG:INVERT_DB0_ADC3_IQ
  localparam INVERT_DB0_ADC3_IQ_MSB  = 3;  //INVERT_DB0_IQ_REG:INVERT_DB0_ADC3_IQ
  localparam INVERT_DB0_ADC3_IQ      = 3;  //INVERT_DB0_IQ_REG:INVERT_DB0_ADC3_IQ
  localparam INVERT_DB0_DAC0_IQ_SIZE = 1;  //INVERT_DB0_IQ_REG:INVERT_DB0_DAC0_IQ
  localparam INVERT_DB0_DAC0_IQ_MSB  = 8;  //INVERT_DB0_IQ_REG:INVERT_DB0_DAC0_IQ
  localparam INVERT_DB0_DAC0_IQ      = 8;  //INVERT_DB0_IQ_REG:INVERT_DB0_DAC0_IQ
  localparam INVERT_DB0_DAC1_IQ_SIZE = 1;  //INVERT_DB0_IQ_REG:INVERT_DB0_DAC1_IQ
  localparam INVERT_DB0_DAC1_IQ_MSB  = 9;  //INVERT_DB0_IQ_REG:INVERT_DB0_DAC1_IQ
  localparam INVERT_DB0_DAC1_IQ      = 9;  //INVERT_DB0_IQ_REG:INVERT_DB0_DAC1_IQ
  localparam INVERT_DB0_DAC2_IQ_SIZE =  1;  //INVERT_DB0_IQ_REG:INVERT_DB0_DAC2_IQ
  localparam INVERT_DB0_DAC2_IQ_MSB  = 10;  //INVERT_DB0_IQ_REG:INVERT_DB0_DAC2_IQ
  localparam INVERT_DB0_DAC2_IQ      = 10;  //INVERT_DB0_IQ_REG:INVERT_DB0_DAC2_IQ
  localparam INVERT_DB0_DAC3_IQ_SIZE =  1;  //INVERT_DB0_IQ_REG:INVERT_DB0_DAC3_IQ
  localparam INVERT_DB0_DAC3_IQ_MSB  = 11;  //INVERT_DB0_IQ_REG:INVERT_DB0_DAC3_IQ
  localparam INVERT_DB0_DAC3_IQ      = 11;  //INVERT_DB0_IQ_REG:INVERT_DB0_DAC3_IQ

  // INVERT_DB1_IQ_REG Register (from x410_rfdc_regs.v)
  localparam INVERT_DB1_IQ_REG = 'h10800; // Register Offset
  localparam INVERT_DB1_IQ_REG_SIZE = 32;  // register width in bits
  localparam INVERT_DB1_IQ_REG_MASK = 32'hF0F;
  localparam INVERT_DB1_ADC0_IQ_SIZE = 1;  //INVERT_DB1_IQ_REG:INVERT_DB1_ADC0_IQ
  localparam INVERT_DB1_ADC0_IQ_MSB  = 0;  //INVERT_DB1_IQ_REG:INVERT_DB1_ADC0_IQ
  localparam INVERT_DB1_ADC0_IQ      = 0;  //INVERT_DB1_IQ_REG:INVERT_DB1_ADC0_IQ
  localparam INVERT_DB1_ADC1_IQ_SIZE = 1;  //INVERT_DB1_IQ_REG:INVERT_DB1_ADC1_IQ
  localparam INVERT_DB1_ADC1_IQ_MSB  = 1;  //INVERT_DB1_IQ_REG:INVERT_DB1_ADC1_IQ
  localparam INVERT_DB1_ADC1_IQ      = 1;  //INVERT_DB1_IQ_REG:INVERT_DB1_ADC1_IQ
  localparam INVERT_DB1_ADC2_IQ_SIZE = 1;  //INVERT_DB1_IQ_REG:INVERT_DB1_ADC2_IQ
  localparam INVERT_DB1_ADC2_IQ_MSB  = 2;  //INVERT_DB1_IQ_REG:INVERT_DB1_ADC2_IQ
  localparam INVERT_DB1_ADC2_IQ      = 2;  //INVERT_DB1_IQ_REG:INVERT_DB1_ADC2_IQ
  localparam INVERT_DB1_ADC3_IQ_SIZE = 1;  //INVERT_DB1_IQ_REG:INVERT_DB1_ADC3_IQ
  localparam INVERT_DB1_ADC3_IQ_MSB  = 3;  //INVERT_DB1_IQ_REG:INVERT_DB1_ADC3_IQ
  localparam INVERT_DB1_ADC3_IQ      = 3;  //INVERT_DB1_IQ_REG:INVERT_DB1_ADC3_IQ
  localparam INVERT_DB1_DAC0_IQ_SIZE = 1;  //INVERT_DB1_IQ_REG:INVERT_DB1_DAC0_IQ
  localparam INVERT_DB1_DAC0_IQ_MSB  = 8;  //INVERT_DB1_IQ_REG:INVERT_DB1_DAC0_IQ
  localparam INVERT_DB1_DAC0_IQ      = 8;  //INVERT_DB1_IQ_REG:INVERT_DB1_DAC0_IQ
  localparam INVERT_DB1_DAC1_IQ_SIZE = 1;  //INVERT_DB1_IQ_REG:INVERT_DB1_DAC1_IQ
  localparam INVERT_DB1_DAC1_IQ_MSB  = 9;  //INVERT_DB1_IQ_REG:INVERT_DB1_DAC1_IQ
  localparam INVERT_DB1_DAC1_IQ      = 9;  //INVERT_DB1_IQ_REG:INVERT_DB1_DAC1_IQ
  localparam INVERT_DB1_DAC2_IQ_SIZE =  1;  //INVERT_DB1_IQ_REG:INVERT_DB1_DAC2_IQ
  localparam INVERT_DB1_DAC2_IQ_MSB  = 10;  //INVERT_DB1_IQ_REG:INVERT_DB1_DAC2_IQ
  localparam INVERT_DB1_DAC2_IQ      = 10;  //INVERT_DB1_IQ_REG:INVERT_DB1_DAC2_IQ
  localparam INVERT_DB1_DAC3_IQ_SIZE =  1;  //INVERT_DB1_IQ_REG:INVERT_DB1_DAC3_IQ
  localparam INVERT_DB1_DAC3_IQ_MSB  = 11;  //INVERT_DB1_IQ_REG:INVERT_DB1_DAC3_IQ
  localparam INVERT_DB1_DAC3_IQ      = 11;  //INVERT_DB1_IQ_REG:INVERT_DB1_DAC3_IQ

  // MMCM_RESET_REG Register (from x410_rfdc_regs.v)
  localparam MMCM_RESET_REG = 'h11000; // Register Offset
  localparam MMCM_RESET_REG_SIZE = 32;  // register width in bits
  localparam MMCM_RESET_REG_MASK = 32'h1;
  localparam RESET_MMCM_SIZE = 1;  //MMCM_RESET_REG:RESET_MMCM
  localparam RESET_MMCM_MSB  = 0;  //MMCM_RESET_REG:RESET_MMCM
  localparam RESET_MMCM      = 0;  //MMCM_RESET_REG:RESET_MMCM

  // RF_RESET_CONTROL_REG Register (from x410_rfdc_regs.v)
  localparam RF_RESET_CONTROL_REG = 'h12000; // Register Offset
  localparam RF_RESET_CONTROL_REG_SIZE = 32;  // register width in bits

  // RF_RESET_STATUS_REG Register (from x410_rfdc_regs.v)
  localparam RF_RESET_STATUS_REG = 'h12008; // Register Offset
  localparam RF_RESET_STATUS_REG_SIZE = 32;  // register width in bits

  // RF_AXI_STATUS_REG Register (from x410_rfdc_regs.v)
  localparam RF_AXI_STATUS_REG = 'h13000; // Register Offset
  localparam RF_AXI_STATUS_REG_SIZE = 32;  // register width in bits

  // FABRIC_DSP_REG Register (from x410_rfdc_regs.v)
  localparam FABRIC_DSP_REG = 'h13008; // Register Offset
  localparam FABRIC_DSP_REG_SIZE = 32;  // register width in bits

  // CALIBRATION_DATA Register (from x410_rfdc_regs.v)
  localparam CALIBRATION_DATA = 'h14000; // Register Offset
  localparam CALIBRATION_DATA_SIZE = 32;  // register width in bits
  localparam CALIBRATION_DATA_MASK = 32'hFFFFFFFF;
  localparam I_DATA_SIZE = 16;  //CALIBRATION_DATA:I_DATA
  localparam I_DATA_MSB  = 15;  //CALIBRATION_DATA:I_DATA
  localparam I_DATA      =  0;  //CALIBRATION_DATA:I_DATA
  localparam Q_DATA_SIZE = 16;  //CALIBRATION_DATA:Q_DATA
  localparam Q_DATA_MSB  = 31;  //CALIBRATION_DATA:Q_DATA
  localparam Q_DATA      = 16;  //CALIBRATION_DATA:Q_DATA

  // CALIBRATION_ENABLE Register (from x410_rfdc_regs.v)
  localparam CALIBRATION_ENABLE = 'h14008; // Register Offset
  localparam CALIBRATION_ENABLE_SIZE = 32;  // register width in bits
  localparam CALIBRATION_ENABLE_MASK = 32'h33;
  localparam ENABLE_CALIBRATION_DATA_0_SIZE = 1;  //CALIBRATION_ENABLE:ENABLE_CALIBRATION_DATA_0
  localparam ENABLE_CALIBRATION_DATA_0_MSB  = 0;  //CALIBRATION_ENABLE:ENABLE_CALIBRATION_DATA_0
  localparam ENABLE_CALIBRATION_DATA_0      = 0;  //CALIBRATION_ENABLE:ENABLE_CALIBRATION_DATA_0
  localparam ENABLE_CALIBRATION_DATA_1_SIZE = 1;  //CALIBRATION_ENABLE:ENABLE_CALIBRATION_DATA_1
  localparam ENABLE_CALIBRATION_DATA_1_MSB  = 1;  //CALIBRATION_ENABLE:ENABLE_CALIBRATION_DATA_1
  localparam ENABLE_CALIBRATION_DATA_1      = 1;  //CALIBRATION_ENABLE:ENABLE_CALIBRATION_DATA_1
  localparam ENABLE_CALIBRATION_DATA_2_SIZE = 1;  //CALIBRATION_ENABLE:ENABLE_CALIBRATION_DATA_2
  localparam ENABLE_CALIBRATION_DATA_2_MSB  = 4;  //CALIBRATION_ENABLE:ENABLE_CALIBRATION_DATA_2
  localparam ENABLE_CALIBRATION_DATA_2      = 4;  //CALIBRATION_ENABLE:ENABLE_CALIBRATION_DATA_2
  localparam ENABLE_CALIBRATION_DATA_3_SIZE = 1;  //CALIBRATION_ENABLE:ENABLE_CALIBRATION_DATA_3
  localparam ENABLE_CALIBRATION_DATA_3_MSB  = 5;  //CALIBRATION_ENABLE:ENABLE_CALIBRATION_DATA_3
  localparam ENABLE_CALIBRATION_DATA_3      = 5;  //CALIBRATION_ENABLE:ENABLE_CALIBRATION_DATA_3

  // THRESHOLD_STATUS Register (from x410_rfdc_regs.v)
  localparam THRESHOLD_STATUS = 'h15000; // Register Offset
  localparam THRESHOLD_STATUS_SIZE = 32;  // register width in bits
  localparam THRESHOLD_STATUS_MASK = 32'hF0F;
  localparam ADC0_01_THRESHOLD1_SIZE = 1;  //THRESHOLD_STATUS:ADC0_01_THRESHOLD1
  localparam ADC0_01_THRESHOLD1_MSB  = 0;  //THRESHOLD_STATUS:ADC0_01_THRESHOLD1
  localparam ADC0_01_THRESHOLD1      = 0;  //THRESHOLD_STATUS:ADC0_01_THRESHOLD1
  localparam ADC0_01_THRESHOLD2_SIZE = 1;  //THRESHOLD_STATUS:ADC0_01_THRESHOLD2
  localparam ADC0_01_THRESHOLD2_MSB  = 1;  //THRESHOLD_STATUS:ADC0_01_THRESHOLD2
  localparam ADC0_01_THRESHOLD2      = 1;  //THRESHOLD_STATUS:ADC0_01_THRESHOLD2
  localparam ADC0_23_THRESHOLD1_SIZE = 1;  //THRESHOLD_STATUS:ADC0_23_THRESHOLD1
  localparam ADC0_23_THRESHOLD1_MSB  = 2;  //THRESHOLD_STATUS:ADC0_23_THRESHOLD1
  localparam ADC0_23_THRESHOLD1      = 2;  //THRESHOLD_STATUS:ADC0_23_THRESHOLD1
  localparam ADC0_23_THRESHOLD2_SIZE = 1;  //THRESHOLD_STATUS:ADC0_23_THRESHOLD2
  localparam ADC0_23_THRESHOLD2_MSB  = 3;  //THRESHOLD_STATUS:ADC0_23_THRESHOLD2
  localparam ADC0_23_THRESHOLD2      = 3;  //THRESHOLD_STATUS:ADC0_23_THRESHOLD2
  localparam ADC2_01_THRESHOLD1_SIZE = 1;  //THRESHOLD_STATUS:ADC2_01_THRESHOLD1
  localparam ADC2_01_THRESHOLD1_MSB  = 8;  //THRESHOLD_STATUS:ADC2_01_THRESHOLD1
  localparam ADC2_01_THRESHOLD1      = 8;  //THRESHOLD_STATUS:ADC2_01_THRESHOLD1
  localparam ADC2_01_THRESHOLD2_SIZE = 1;  //THRESHOLD_STATUS:ADC2_01_THRESHOLD2
  localparam ADC2_01_THRESHOLD2_MSB  = 9;  //THRESHOLD_STATUS:ADC2_01_THRESHOLD2
  localparam ADC2_01_THRESHOLD2      = 9;  //THRESHOLD_STATUS:ADC2_01_THRESHOLD2
  localparam ADC2_23_THRESHOLD1_SIZE =  1;  //THRESHOLD_STATUS:ADC2_23_THRESHOLD1
  localparam ADC2_23_THRESHOLD1_MSB  = 10;  //THRESHOLD_STATUS:ADC2_23_THRESHOLD1
  localparam ADC2_23_THRESHOLD1      = 10;  //THRESHOLD_STATUS:ADC2_23_THRESHOLD1
  localparam ADC2_23_THRESHOLD2_SIZE =  1;  //THRESHOLD_STATUS:ADC2_23_THRESHOLD2
  localparam ADC2_23_THRESHOLD2_MSB  = 11;  //THRESHOLD_STATUS:ADC2_23_THRESHOLD2
  localparam ADC2_23_THRESHOLD2      = 11;  //THRESHOLD_STATUS:ADC2_23_THRESHOLD2

  // RF_PLL_CONTROL_REG Register (from x410_rfdc_regs.v)
  localparam RF_PLL_CONTROL_REG = 'h16000; // Register Offset
  localparam RF_PLL_CONTROL_REG_SIZE = 32;  // register width in bits
  localparam RF_PLL_CONTROL_REG_MASK = 32'h11111;
  localparam ENABLE_DATA_CLK_SIZE = 1;  //RF_PLL_CONTROL_REG:ENABLE_DATA_CLK
  localparam ENABLE_DATA_CLK_MSB  = 0;  //RF_PLL_CONTROL_REG:ENABLE_DATA_CLK
  localparam ENABLE_DATA_CLK      = 0;  //RF_PLL_CONTROL_REG:ENABLE_DATA_CLK
  localparam ENABLE_DATA_CLK_2X_SIZE = 1;  //RF_PLL_CONTROL_REG:ENABLE_DATA_CLK_2X
  localparam ENABLE_DATA_CLK_2X_MSB  = 4;  //RF_PLL_CONTROL_REG:ENABLE_DATA_CLK_2X
  localparam ENABLE_DATA_CLK_2X      = 4;  //RF_PLL_CONTROL_REG:ENABLE_DATA_CLK_2X
  localparam ENABLE_RF_CLK_SIZE = 1;  //RF_PLL_CONTROL_REG:ENABLE_RF_CLK
  localparam ENABLE_RF_CLK_MSB  = 8;  //RF_PLL_CONTROL_REG:ENABLE_RF_CLK
  localparam ENABLE_RF_CLK      = 8;  //RF_PLL_CONTROL_REG:ENABLE_RF_CLK
  localparam ENABLE_RF_CLK_2X_SIZE =  1;  //RF_PLL_CONTROL_REG:ENABLE_RF_CLK_2X
  localparam ENABLE_RF_CLK_2X_MSB  = 12;  //RF_PLL_CONTROL_REG:ENABLE_RF_CLK_2X
  localparam ENABLE_RF_CLK_2X      = 12;  //RF_PLL_CONTROL_REG:ENABLE_RF_CLK_2X
  localparam CLEAR_DATA_CLK_UNLOCKED_SIZE =  1;  //RF_PLL_CONTROL_REG:CLEAR_DATA_CLK_UNLOCKED
  localparam CLEAR_DATA_CLK_UNLOCKED_MSB  = 16;  //RF_PLL_CONTROL_REG:CLEAR_DATA_CLK_UNLOCKED
  localparam CLEAR_DATA_CLK_UNLOCKED      = 16;  //RF_PLL_CONTROL_REG:CLEAR_DATA_CLK_UNLOCKED

  // RF_PLL_STATUS_REG Register (from x410_rfdc_regs.v)
  localparam RF_PLL_STATUS_REG = 'h16008; // Register Offset
  localparam RF_PLL_STATUS_REG_SIZE = 32;  // register width in bits
  localparam RF_PLL_STATUS_REG_MASK = 32'h110000;
  localparam DATA_CLK_PLL_UNLOCKED_STICKY_SIZE =  1;  //RF_PLL_STATUS_REG:DATA_CLK_PLL_UNLOCKED_STICKY
  localparam DATA_CLK_PLL_UNLOCKED_STICKY_MSB  = 16;  //RF_PLL_STATUS_REG:DATA_CLK_PLL_UNLOCKED_STICKY
  localparam DATA_CLK_PLL_UNLOCKED_STICKY      = 16;  //RF_PLL_STATUS_REG:DATA_CLK_PLL_UNLOCKED_STICKY
  localparam DATA_CLK_PLL_LOCKED_SIZE =  1;  //RF_PLL_STATUS_REG:DATA_CLK_PLL_LOCKED
  localparam DATA_CLK_PLL_LOCKED_MSB  = 20;  //RF_PLL_STATUS_REG:DATA_CLK_PLL_LOCKED
  localparam DATA_CLK_PLL_LOCKED      = 20;  //RF_PLL_STATUS_REG:DATA_CLK_PLL_LOCKED

  // RFDC_INFO_MEM Register (from x410_rfdc_regs.v)
  localparam RFDC_INFO_MEM_COUNT = 16; // Number of elements in array

  // RFDC_INFO_REG Register (from x410_rfdc_regs.v)
  localparam RFDC_INFO_REG = 'h18000; // Register Offset
  localparam RFDC_INFO_REG_SIZE = 32;  // register width in bits

  // Return the offset of an element of register array RFDC_INFO_MEM
  function automatic integer RFDC_INFO_MEM (input integer i);
  begin
    RFDC_INFO_MEM = (i * 'h4) + 'h17000;
  end
  endfunction
