/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.management.util.jmx;

import com.sun.appserv.management.util.jmx.NotificationListenerInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;

public class NotificationListenerTracking {
    private final List<NotificationListenerInfo> mInfos;

    public NotificationListenerTracking(boolean synchronize) {
        ArrayList infos = new ArrayList();
        this.mInfos = synchronize ? Collections.synchronizedList(infos) : infos;
    }

    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) {
        NotificationListenerInfo info = new NotificationListenerInfo(listener, filter, handback);
        this.mInfos.add(info);
    }

    public int getListenerCount() {
        return this.mInfos.size();
    }

    private final boolean listenersEqual(NotificationListener listener1, NotificationListener listener2) {
        return listener1 == listener2;
    }

    private final boolean handbacksEqual(Object handback1, Object handback2) {
        return handback1 == handback2;
    }

    public List<NotificationListenerInfo> removeNotificationListener(NotificationListener listener) {
        Iterator<NotificationListenerInfo> iter = this.mInfos.iterator();
        ArrayList<NotificationListenerInfo> results = new ArrayList<NotificationListenerInfo>();
        while (iter.hasNext()) {
            NotificationListenerInfo info = iter.next();
            if (!this.listenersEqual(listener, info.getListener())) continue;
            iter.remove();
            results.add(info);
        }
        return results;
    }

    public NotificationListenerInfo removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) {
        Iterator<NotificationListenerInfo> iter = this.mInfos.iterator();
        NotificationListenerInfo result = null;
        while (iter.hasNext()) {
            NotificationListenerInfo info = iter.next();
            if (!this.listenersEqual(listener, info.getListener()) || !this.handbacksEqual(handback, info.getHandback())) continue;
            iter.remove();
            result = info;
            break;
        }
        return result;
    }
}

