/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.os.dtrace;

import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.DefaultPersistenceDelegate;
import java.beans.Encoder;
import java.beans.Expression;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.math.BigInteger;
import org.opensolaris.os.dtrace.AbstractAggregationValue;

public final class StddevValue
extends AbstractAggregationValue {
    static final long serialVersionUID = 6409878160513885375L;
    private final long total;
    private final long count;
    private final BigInteger totalSquares;

    private static long squareRoot128(BigInteger n) {
        long result = 0L;
        BigInteger diff = BigInteger.valueOf(0L);
        BigInteger nextTry = BigInteger.valueOf(0L);
        int bitPairs = n.bitLength() / 2;
        int bitPos = bitPairs * 2 + 1;
        for (int i = 0; i <= bitPairs; ++i) {
            int nextTwoBits = n.testBit(bitPos) ? (n.testBit(bitPos - 1) ? 3 : 2) : (n.testBit(bitPos - 1) ? 1 : 0);
            diff = diff.shiftLeft(2);
            diff = diff.add(BigInteger.valueOf(nextTwoBits));
            nextTry = BigInteger.valueOf(result);
            nextTry = nextTry.shiftLeft(2);
            nextTry = nextTry.setBit(0);
            result <<= 1;
            if (nextTry.compareTo(diff) <= 0) {
                diff = diff.subtract(nextTry);
                ++result;
            }
            bitPos -= 2;
        }
        return result;
    }

    private static long standardDeviation(long stddevCount, long stddevTotal, BigInteger stddevTotalSquares) {
        BigInteger averageOfSquares = stddevTotalSquares.divide(BigInteger.valueOf(stddevCount));
        long avg = stddevTotal / stddevCount;
        if (avg < 0L) {
            avg = -avg;
        }
        BigInteger squareOfAverage = BigInteger.valueOf(avg);
        squareOfAverage = squareOfAverage.pow(2);
        BigInteger stddev = averageOfSquares.subtract(squareOfAverage);
        return StddevValue.squareRoot128(stddev);
    }

    private StddevValue(long stddevCount, long stddevTotal, BigInteger stddevTotalSquares) {
        super(stddevCount == 0L ? 0L : StddevValue.standardDeviation(stddevCount, stddevTotal, stddevTotalSquares));
        this.total = stddevTotal;
        this.count = stddevCount;
        this.totalSquares = stddevTotalSquares;
        if (this.totalSquares == null) {
            throw new NullPointerException("totalSquares is null");
        }
        if (this.count < 0L) {
            throw new IllegalArgumentException("count is negative");
        }
    }

    public StddevValue(long v, long stddevTotal, long stddevCount, String stddevTotalSquaresString) {
        super(v);
        this.total = stddevTotal;
        this.count = stddevCount;
        this.totalSquares = new BigInteger(stddevTotalSquaresString);
        this.validate();
    }

    private final void validate() {
        if (this.count < 0L) {
            throw new IllegalArgumentException("count is negative");
        }
        long stddev = super.getValue().longValue();
        if (this.count == 0L) {
            if (stddev != 0L) {
                throw new IllegalArgumentException("count of values is zero, stddev is non-zero (" + stddev + ")");
            }
        } else if (stddev != StddevValue.standardDeviation(this.count, this.total, this.totalSquares)) {
            throw new IllegalArgumentException(this.getValue().toString() + " is not the expected " + "standard deviation of total " + this.total + ", count " + this.count + ", and total squares " + this.totalSquares);
        }
    }

    public Long getValue() {
        return (Long)super.getValue();
    }

    public long getTotal() {
        return this.total;
    }

    public long getCount() {
        return this.count;
    }

    public BigInteger getTotalSquares() {
        return this.totalSquares;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        try {
            this.validate();
        }
        catch (Exception e) {
            InvalidObjectException x = new InvalidObjectException(e.getMessage());
            x.initCause(e);
            throw x;
        }
    }

    static {
        try {
            BeanInfo info = Introspector.getBeanInfo(StddevValue.class);
            DefaultPersistenceDelegate persistenceDelegate = new DefaultPersistenceDelegate(new String[]{"value", "total", "count", "totalSquares"}){

                protected Expression instantiate(Object oldInstance, Encoder out) {
                    StddevValue stddev = (StddevValue)oldInstance;
                    return new Expression(oldInstance, oldInstance.getClass(), "new", new Object[]{(long)stddev.getValue(), stddev.getTotal(), stddev.getCount(), stddev.getTotalSquares().toString()});
                }
            };
            BeanDescriptor d = info.getBeanDescriptor();
            d.setValue("persistenceDelegate", persistenceDelegate);
        }
        catch (IntrospectionException e) {
            System.out.println(e);
        }
    }
}

