/*
 * Decompiled with CFR 0.152.
 */
package spec.reporter;

import java.text.DecimalFormat;
import spec.reporter.Metrics;
import spec.reporter.ReportProps;
import spec.reporter.Result;
import spec.reporter.Run;
import spec.reporter.TextBlock;

public class TextMetrics
extends Metrics {
    static final String COPYRIGHT = "SPECjbb2005,Copyright (c) 2000-2005 Standard Performance Evaluation Corporation (SPEC),All rights reserved,Copyright (c) 2005 Hewlett-Packard,All rights reserved,Copyright (c) 1997-2005 Sun Microsystems, Inc.All rights reserved,Licensed Materials - Property of SPEC";
    private static int digits = 3;
    private static DecimalFormat memFormat = new DecimalFormat("#0");

    public TextMetrics(ReportProps reportProps, boolean bl) {
        super(reportProps, bl);
    }

    public String wrap(String string) {
        return string + "\n";
    }

    public String detail() {
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.valid) {
            stringBuffer.append("*** Invalid Result\n");
            stringBuffer.append("This result is not valid for the following reason(s):\n");
            stringBuffer.append(this.invalid_buf.toString());
            stringBuffer.append("\n");
        }
        stringBuffer.append("\n* Details of Runs\n\n");
        TextBlock textBlock = new TextBlock(5);
        TextBlock textBlock2 = new TextBlock(8);
        TextBlock textBlock3 = new TextBlock(9);
        TextBlock textBlock4 = new TextBlock(9);
        TextBlock textBlock5 = new TextBlock(8);
        TextBlock textBlock6 = new TextBlock(8);
        TextBlock textBlock7 = new TextBlock(12, "Trans.");
        TextBlock textBlock8 = new TextBlock(10);
        TextBlock textBlock9 = new TextBlock(6, "Resp.");
        TextBlock textBlock10 = new TextBlock(8, "Time (s)");
        textBlock.addRight("Wh.");
        textBlock.add("");
        textBlock2.addRight("Score");
        textBlock2.add("");
        textBlock3.addRight("Tot.");
        textBlock3.addRight("Heap");
        textBlock4.addRight("Used");
        textBlock4.addRight("Heap");
        textBlock5.addRight("Thread");
        textBlock5.addRight("spread");
        textBlock6.addRight("elapsed");
        textBlock6.addRight("> 120s");
        textBlock7.add("Type");
        textBlock8.addRight("Count");
        textBlock8.add("");
        textBlock9.add("total");
        textBlock10.add("max");
        textBlock.add("");
        textBlock2.add("");
        textBlock3.addRight("(MB)");
        textBlock4.addRight("(MB)");
        textBlock5.add("%");
        textBlock6.add("%");
        textBlock7.add("");
        textBlock8.add("");
        textBlock9.add("");
        textBlock10.add("");
        for (int i = 0; i < this.result.length; ++i) {
            Result result = this.result[i];
            if (result.run.length <= 0) {
                textBlock3.add("not run");
                textBlock4.add("");
                textBlock5.add("");
                textBlock6.add("");
                textBlock7.add("");
                textBlock8.add("");
                textBlock9.add("");
                textBlock10.add("");
                continue;
            }
            for (int j = 0; j < result.run.length; ++j) {
                if (j > 0) {
                    textBlock.add("");
                    textBlock2.add("");
                    textBlock3.add("");
                    textBlock4.add("");
                    textBlock5.add("");
                    textBlock6.add("");
                } else {
                    textBlock.addRight("" + result.warehouses());
                    textBlock2.addRight(Metrics.format(result.score()));
                    textBlock3.addRight(memFormat.format(result.heapsize));
                    textBlock4.addRight(memFormat.format(result.heapused));
                    textBlock5.addRight(Metrics.format(100.0 * (result.max_thread_transactions - result.min_thread_transactions) / result.max_thread_transactions));
                    textBlock6.addRight(Metrics.format(0.1 * (result.elapsed - 1000.0 * result.meas_int) / result.meas_int));
                }
                textBlock7.add(Run.transaction[j]);
                textBlock8.addRight(Metrics.format(result.run[j].count));
                textBlock9.add(Metrics.format(result.run[j].totaltime));
                textBlock10.add(Metrics.format(result.run[j].maximumtime));
            }
        }
        stringBuffer.append(textBlock.join(textBlock2, "").join(textBlock3, "").join(textBlock4, "").join(textBlock5, "").join(textBlock6, "").join(textBlock7, " ").join(textBlock8, "").join(textBlock9, " ").join(textBlock10, "").toString());
        return stringBuffer.toString();
    }

    public String ratioTable() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\nValidity\n");
        String string = this.check_all_buf.toString();
        if (string == null) {
            stringBuffer.append("Valid run; no errors");
        } else {
            stringBuffer.append(string);
        }
        TextBlock textBlock = new TextBlock(119);
        TextBlock textBlock2 = new TextBlock(15);
        textBlock2.addRight("Warehouses");
        TextBlock textBlock3 = new TextBlock(20);
        textBlock3.addRight("Thrput");
        textBlock.add("\n                   SPEC scores");
        for (int i = 0; i < this.result.length; ++i) {
            if (this.expectedPeakWh <= this.result[i].warehouses() && this.result[i].warehouses() <= 2 * this.expectedPeakWh) {
                textBlock2.addRight(" * " + this.result[i].warehouses());
            } else {
                textBlock2.addRight("   " + this.result[i].warehouses());
            }
            textBlock3.addRight(Metrics.format(this.result[i].score()));
        }
        textBlock2.add("");
        textBlock3.add("");
        textBlock2.add("Throughput");
        textBlock3.add(this.metric());
        textBlock.add(textBlock2.join(textBlock3, " "));
        stringBuffer.append(textBlock.toString());
        return stringBuffer.toString();
    }
}

